/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code in this file as it was released upon
 * April 1, 2001 and that is NO joke!
 * 
 * The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
 * all Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
 * by Henk-Johan van Rantwijk. All Rights Reserved.
 * 
 * Contributor(s):
 *   Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
 *   David Perry <d.perry@utoronto.ca> (dialog author)
 * 
*/

////////////////////////////////////////////////////////////////////////////////
// Javascript functions used to handle the UI for the multiZilla extension
// Focus of this file is "About" dialog
// Current version : 1.0.1 (1.0.xx versions are my private Alpha releases)
// Written by : (DP) David Perry <d.perry@utoronto.ca>
////////////////////////////////////////////////////////////////////////////////

var seeURL;          // Function to open a new URL --
                     // passed in as window.arguments[ 1 ]
var HJsPicture = false;

// Initialize the About MultiZilla dialog
// Arguments:
//   window.arguments[ 0 ]: current version of Multizilla (FIXME: use pref)
//   window.arguments[ 1 ]: function to use to view a URL
// Modifies:
//   nothing

////////////////////////////////////////////////////////////////////////////////
// this function
////////////////////////////////////////////////////////////////////////////////
function aboutInit()
{
  var verString = null; // Localized string of current version of MultiZilla

  seeURL = window.arguments[ 1 ];
  verString = document.getElementById( 'ver' ).getAttribute( 'value' );
  document.getElementById( 'ver' ).setAttribute( 'value', verString + window.arguments[ 0 ] );
}
////////////////////////////////////////////////////////////////////////////////
// this function cleans up after closing the About MultiZilla dialog
////////////////////////////////////////////////////////////////////////////////
function aboutClose()
{
  window.close();
}
////////////////////////////////////////////////////////////////////////////////
// this changes the aboutGraphic into my picture, just for fun
////////////////////////////////////////////////////////////////////////////////
function toggleImage()
{
  // toggle picture and AboutGraphic
  if ( HJsPicture ) {
    document.getElementById( "aboutGraphic" ).setAttribute( "src", "chrome://multiviews/skin/images/logo.gif" );
    HJsPicture = false;
  }
  else {
    document.getElementById( "aboutGraphic" ).setAttribute( "src", "chrome://multiviews/skin/images/combo.gif" );
    HJsPicture = true;
  }
}
