/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License") you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code in this file was released April 1, 2001
 * 
 * The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
 * all Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
 * by Henk-Johan van Rantwijk. All Rights Reserved.
 * 
 * Contributor(s):
 *   Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
 *   David Perry <d.perry@utoronto.ca>
 *   Neil Pryde <NeilPryde92651@netscape.net> (well I'm just HJ's typewriter)
 * 
 */

////////////////////////////////////////////////////////////////////////////////
// this function initializes the tab contextmenu
////////////////////////////////////////////////////////////////////////////////
function initTabContextMenu()
{
  var popupNode = document.popupNode;

  if (popupNode && popupNode.localName == 'toolbarbutton')
    popupNode = getBrowser().selectedTab;
  else return;

  // var mvLabel = popupNode.getAttribute( "label" );
  ////////////////////////////////////////////////////
  // check if chrome is hidden for the current window
  ////////////////////////////////////////////////////
  if ( chromeEnabled() ) {
    document.getElementById( "enableChromeMenuItem" ).setAttribute( "hidden", "true" );
  }
  else {
    document.getElementById( "enableChromeMenuItem" ).removeAttribute( "hidden" );
    document.getElementById( "showPersonalToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "hidePersonalToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "showToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "hideToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "activateMaxModeMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "deactivateMaxModeMenuItem" ).setAttribute( "hidden", "true" );
  }
  ///////////////////////////////////////////////////
  // check if we currently have a StickyName set
  ///////////////////////////////////////////////////
  if ( popupNode.hasAttribute( "customLabel" ) ) {
    document.getElementById( "setStickyMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "clearStickyMenuItem" ).removeAttribute( "hidden" );
  }
  else {
    document.getElementById( "clearStickyMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "setStickyMenuItem" ).removeAttribute( "hidden" );
  }
  ///////////////////////////////////////////////////
  // select the corresponding Toolbar menu item F10
  ///////////////////////////////////////////////////
  if ( document.getElementById( "cmd_viewpersonaltoolbar" ).getAttribute( "checked" ) == "true" ) {
    // hide 'Show Toolbar F10' and show 'Hide Toolbar F10' menu items in tab menu
    document.getElementById( "showPersonalToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "hidePersonalToolbarMenuItem" ).removeAttribute( "hidden" );
  }
  else {
    // hide 'Hide Toolbar F10' and show 'Hide Toolbar F10' menu items in tab menu
    document.getElementById( "hidePersonalToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "showPersonalToolbarMenuItem" ).removeAttribute( "hidden" );
  }
  ///////////////////////////////////////////////////
  // select the corresponding Toolbar menu item F11
  ///////////////////////////////////////////////////
  if ( document.getElementById( "cmd_viewMultiZillaToolbar" ).getAttribute( "checked" ) == "true" ) {
    // hide 'Show MultiZilla Toolbar F11' and show 'Hide MultiZilla Toolbar F11' menu items in tab menu
    document.getElementById( "showToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "hideToolbarMenuItem" ).removeAttribute( "hidden" );
  }
  else {
    // hide 'Hide MultiZilla Toolbar F11' and show 'Hide MultiZilla Toolbar F11' menu items in tab menu
    document.getElementById( "hideToolbarMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "showToolbarMenuItem" ).removeAttribute( "hidden" );
  }
  /////////////////////////////////////////////////////////
  // select the corresponding MaxBrowserMode menu item F12
  /////////////////////////////////////////////////////////
  if ( window.fullScreen ) {
    // hide 'Show Activate MaxBrowser Mode F12' and show 'Hide Deactivate MaxBrowser Mode F12' menu items in tab menu
    document.getElementById( "activateMaxModeMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "deactivateMaxModeMenuItem" ).removeAttribute( "hidden" );
  }
  else {
    // hide 'Hide Deactivate MaxBrowser Mode F12' and show 'Show Activate MaxBrowser Mode F12' menu items in tab menu
    document.getElementById( "deactivateMaxModeMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "activateMaxModeMenuItem" ).removeAttribute( "hidden" );
  }
  ///////////////////////////////////////////////////
  // check to see if 'Hide From Close All' is active
  ///////////////////////////////////////////////////
  if ( popupNode.hasAttribute( "close" ) )
    document.getElementById( "hideTab" ).setAttribute( "checked", "true" );
  else document.getElementById( "hideTab" ).removeAttribute( "checked" );
  /////////////////////////////////////////////////////////
  // check to see if 'Tab Home' menuitem should be enabled
  /////////////////////////////////////////////////////////
  if (getBrowser().mPanelContainer.childNodes.length > 1)
    document.getElementById("setAsGroup").setAttribute("disabled", "false");
  else document.getElementById("setAsGroup").setAttribute("disabled", "true");
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the state of attribute 'chromehidden'
////////////////////////////////////////////////////////////////////////////////
function chromeEnabled()
{
  return( !document.documentElement.hasAttribute( "chromehidden" ) );
}
////////////////////////////////////////////////////////////////////////////////
// this function removes 'chromehidden' so that the Menu->View->Show/Hide works
////////////////////////////////////////////////////////////////////////////////
function enableChrome()
{
  // alert(document.documentElement.getAttribute("chromehidden"));
  if ( !chromeEnabled() ) {
    document.documentElement.removeAttribute( "chromehidden" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function 'disables' menu items in the context popup menus
////////////////////////////////////////////////////////////////////////////////
function updateTabContextMenu(aPopupMenu)
{
  var disabledValue = "true";
  var menuItems = aPopupMenu.getElementsByAttribute("tbattr", "tabbrowser-multiple");
  
  if ( gBrowser.mTabContainer.childNodes.length > 1 )
    disabledValue = "false";
  for ( var i = 0; i < menuItems.length; i++ )
    menuItems[ i ].setAttribute("disabled", disabledValue);
}

