/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2000.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2000
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -  David Perry <d.perry@utoronto.ca>
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
   - Note to all the lame cloners: Go and Take a Hike You Loser!!
*/

////////////////////////////////////////////////////////////////////////////////
// Javascript functions used to handle the UI for the MultiZilla extension
// Current version : 1.1.15
// Written by : (HJ) Henk-Johan van Rantwijk <bugs4hj@netscape.net>
////////////////////////////////////////////////////////////////////////////////

// WARNING: CHANGE THIS WHEN MOVING FILES - strings localization file!
var multiviewsBundle = "chrome://multiviews/locale/multiviews.properties";

var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                    .getService(Components.interfaces.nsIRDFService);
var RDFC = Components.classes["@mozilla.org/rdf/container-utils;1"]
                     .getService(Components.interfaces.nsIRDFContainerUtils);
var gdLocalStore = RDF.GetDataSource("rdf:local-store");

////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabWidthPrefListener =
{
  domain: "multizilla.tabs.tabwidth",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabWidth = pref.getIntPref(prefName);
    gBrowser.setTabWidthTo(tabWidth);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabLEDstatePrefListener =
{
  domain: "multizilla.tabs.status-leds",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabLEDstate = pref.getBoolPref(prefName);
    gBrowser.setTabLEDstateTo(tabLEDstate);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabLabelPrefListener =
{
  domain: "multizilla.tabs.title",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabLabel = pref.getBoolPref(prefName);
    gBrowser.setTabLabelsTo(tabLabel);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabSwitchPrefListener =
{
  domain: "multizilla.tabs.ontop",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var topTabs = pref.getBoolPref(prefName);
    if (topTabs)
      gBrowser.activateTopTabs()
    else gBrowser.activateBottomTabs();
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTBButtonPrefListener =
{
  domain: "multizilla.showbutton",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;
    var buttonName = prefName.substr(this.domain.length+1);
    var buttonId = buttonName + "-tbbutton";
    var button = document.getElementById(buttonId);

    var show = pref.getBoolPref(prefName);
    button.setAttribute("hidden", (show ? "false" : "true"));
  }
};
////////////////////////////////////////////////////////////////////////////////
//  this is our Tab DND observer
////////////////////////////////////////////////////////////////////////////////
var tabDNDObserver = {

  onDragStart: function (aEvent, aXferData, aDragAction)
    {
      if (navigator.platform != "Win32" || aEvent.target.localName != "tab" || 
          aEvent.target != gBrowser.mCurrentTab )
        return;
      var url = getWebNavigation().currentURI.spec;
      aXferData.data = new TransferData();
      aXferData.data.addDataForFlavour("text/x-moz-url", url);
    },
  onDragOver: function(aEvent, aFlavour, aDragSession)
    {
      getBrowser().selectedTab = aEvent.target;
      aEvent.target.setAttribute("dragover", "true");
      return true;
    },
  onDragExit: function (aEvent, aDragSession)
    {
      aEvent.target.removeAttribute("dragover");
    },
  onDrop: function (aEvent, aXferData, aDragSession)
    {
      var url = retrieveURLFromData(aXferData.data, aXferData.flavour.contentType);
      if (url)
        loadURI(url);
    },
  getSupportedFlavours: function()
    {
      var flavourSet = new FlavourSet();
      flavourSet.appendFlavour("application/x-moz-file", "nsIFile");
      flavourSet.appendFlavour("text/x-moz-url");
      flavourSet.appendFlavour("text/unicode");
      return flavourSet;
    }
}
////////////////////////////////////////////////////////////////////////////////
// this function asks the user to confirm to quit the session
////////////////////////////////////////////////////////////////////////////////
function confirmCloseWS( aConfirm )
{
  var confirmPref = readMyPref( "multizilla.confirm.quit", "int", 0 );
  var closeBundle = srGetStrBundle( "chrome://multiviews/locale/multiviews.properties" );
  var aHeader = closeBundle.GetStringFromName( "closeSession" );
  var aQuestion = closeBundle.GetStringFromName( "closeSessionQuestion" );
  /* ::::
     1 = File Menu 'Close Window' & Ctrl-Shift-W
     2 = File Menu 'Exit' & Ctrl-Q
     4 = Click on [X] on Window
  :::: */
  if ( aConfirm & 1 ) {
    aHeader = closeBundle.GetStringFromName( "closeWindow" );
    aQuestion = closeBundle.GetStringFromName( "closeWindowQuestion" );
  }
  if ( confirmPref && (confirmPref & aConfirm) == aConfirm ) {
    var promptService = Components.classes[ "@mozilla.org/embedcomp/prompt-service;1" ].
                        getService(Components.interfaces.nsIPromptService);

    if ( promptService.confirm( window, aHeader, aQuestion ) ) {
      checkGroupSaving();
      return true;
    }
    else
      return false;
  }
  checkGroupSaving();
  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this function adds pref listenes abd puts the MT in place
////////////////////////////////////////////////////////////////////////////////
function multiZillaInit()
{
  addPrefListener(gTabWidthPrefListener);
  addPrefListener(gTabLEDstatePrefListener);
  addPrefListener(gTabLabelPrefListener);
  addPrefListener(gTabSwitchPrefListener);
  addPrefListener(gTBButtonPrefListener);

  var toolbar = document.getElementById("navigator-toolbox");
  var newElement = document.createElement("tabmodetoolbar");

  toolbar = toolbar.appendChild(newElement);
  toolbar.setAttribute("id", "MultiZillaToolbar");
  initPreferences();
  if (isFirstWindow())
    addConfirmToWindow();
}
////////////////////////////////////////////////////////////////////////////////
// this function sets ID's to the Go Menu and replaces the popup
// I know this is a dirty way to do it, but we need to ;)
////////////////////////////////////////////////////////////////////////////////
function addGoMenuIDs()
{
  var goMenu = document.getElementById("main-menubar").childNodes[3];
  goMenu.setAttribute("id", "menu_Go");
  var goMenuPopup = document.getElementById("menu_GoPopup");
  goMenu.firstChild.setAttribute("id", "menu_GoPopup");
  goMenu.replaceChild(goMenuPopup, goMenu.firstChild);

  var aElement = document.getElementById("menu_close");
  aElement.setAttribute("command", "doCmd_close");
  aElement = document.getElementById("menu_closeWindow");
  aElement.setAttribute("command", "doCmd_closeWindow");

  var wipeDustHBox = document.getElementById("nav-bar-inner");
  var wipeDust = document.createElement("toolbarbutton");
  var locationBar = document.getElementById("urlbar");
  wipeDustHBox.insertBefore(wipeDust, locationBar);
  wipeDust.setAttribute("tooltiptext", "&clearLocButton.tooltip;");
  wipeDust.setAttribute("persist", "hidden");
  wipeDust.setAttribute("class", "clear-loc-button");
  wipeDust.setAttribute("oncommand", "gURLBar.value='';gURLBar.focus();");

  /* 
  XXX: need to be worked on in the next version!
  aElement = document.getElementById("BookmarksMenu");
  var aTemplate = document.getElementById("bookmarksMenuTemplate");
  var aUpdatedTemplate = document.getElementById("tabStartGroupMenuTemplate");
  aElement.firstChild.removeChild(aTemplate); */
  // alert(aElement.localName+'\n'+aTemplate.localName+'\n'+aUpdatedTemplate.localName);
}
////////////////////////////////////////////////////////////////////////////////
// this function adds an attribute to the main-window element
////////////////////////////////////////////////////////////////////////////////
function addConfirmToWindow()
{
  var aElement = document.getElementById("main-window");
  aElement.setAttribute("onclose", "return confirmCloseWS(4)");
}
////////////////////////////////////////////////////////////////////////////////
// this function checks if this is the first open "navigator:browser" window
////////////////////////////////////////////////////////////////////////////////
function isFirstWindow()
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var topWindow = windowManagerInterface.getMostRecentWindow(null);
  var enumerator = windowManagerInterface.getEnumerator("navigator:browser");
  var firstWindow = enumerator.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);

  if (firstWindow != topWindow)
    return(false);
  return true
}
////////////////////////////////////////////////////////////////////////////////
// this function reads group data from localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function loadTabGroup()
{
  var index = 0;
  if (!isFirstWindow())
    return(index);
  var urls = RDFC.MakeSeq(gdLocalStore, RDF.GetResource("nc:group-url")).GetElements();
  var labels = RDFC.MakeSeq(gdLocalStore, RDF.GetResource("nc:group-label")).GetElements();

  if (!urls.hasMoreElements())
    return(index);

  while (urls.hasMoreElements()) {
    var url = urls.getNext();
    var label = labels.getNext();
    if (url && label) {
      try {
        url = url.QueryInterface(Components.interfaces.nsIRDFLiteral);
        label = label.QueryInterface(Components.interfaces.nsIRDFLiteral);
        index++;
      } catch(ex) {
        continue;
      }
      if (index == 1)
        loadURI(url.Value);
      else
        getBrowser().addTab(url.Value);
      var tab = getBrowser().mTabContainer.lastChild;
      if (label.Value != "false") {
        tab.setAttribute("customLabel", "true");
        tab.setAttribute("label", label.Value);
      }
    }
  }
  return(index);
}
////////////////////////////////////////////////////////////////////////////////
// this function checks if it need to save the current group of tabs
////////////////////////////////////////////////////////////////////////////////
function checkGroupSaving()
{
  var shouldSave = readMyPref("multizilla.tabs.saveonexit", "bool", false);
  var tabCount = getBrowser().mPanelContainer.childNodes.length;

  if (!shouldSave || tabCount < 2)
    return;
  else storeGroupData();
}