/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2000.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2000
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
   - Note to all the lame cloners: Go and Take a Hike You Loser!!
*/

////////////////////////////////////////////////////////////////////////////////
// this function reads the preference setting for the given menu identifier
///////////////////////////////////////////////////////////////////////////////
function initGroupPref( menuElement )
{
  var prefGroup    = menuElement.getAttribute( "prefgroup" );
  var prefElements = document.getElementsByAttribute( "prefgroup", prefGroup );

  if ( prefElements.length == 0 )
    return;

  var prefType        = prefElements[ 1 ].getAttribute( "preftype" );
  var prefDefval      = prefElements[ 1 ].getAttribute( "prefdefval" );
  var prefIdentifier  = prefElements[ 1 ].getAttribute( "prefstring" );
  var prefDefaultFlag = true;
  var prefValue       = readMyPref( prefIdentifier, prefType, 0, prefDefaultFlag );

  for( var i = 1; i < prefElements.length; i++ ) {

    if ( prefElements[ i ].getAttribute( "prefvalue" ) == prefValue )
      prefElements[ i ].setAttribute( "checked", "true" );       
    else
      prefElements[ i ].removeAttribute( "checked" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function saves a changed preference setting
////////////////////////////////////////////////////////////////////////////////
function changePref( menuElement, menuGroup, doRefresh )
{

  var prefType        = menuElement.getAttribute( "preftype" );
  var prefIdentifier  = menuElement.getAttribute( "prefstring" );
  var prefDefval      = menuElement.getAttribute( "prefdefval" );
  var prefAttribute   = null;
  var prefDefaultFlag = true;
  var prefArray       = new Array();
  var noAccess        = "noAccess";
  var allAccess       = "allAccess";
	
  if ( prefIdentifier != null ) {
    // retrieve current value
    var prefValue = readMyPref( prefIdentifier, prefType, prefDefval, prefDefaultFlag );

    if ( prefType == "bool" ) // flip flop the pref
      writePref( prefType, prefIdentifier, !prefValue, prefDefaultFlag );
    else {
      if ( menuGroup ) // special case, use this value
        prefValue = menuElement.getAttribute( "prefvalue" );
      else { // used for int and string, other might follow
        prefAttribute = menuElement.getAttribute( "prefattribute" );

        if ( prefAttribute == "checked" ) {
          // setup an array with values to use
          prefValues = eval( menuElement.getAttribute( "prefvalue" ) );
	        prefArray = prefValues;
          // pick the first or second value, based on the "checked" state
          if ( menuElement.getAttribute( prefAttribute ) )
            prefValue = prefArray[ 1 ];
          else prefValue = prefArray[ 0 ];
        }
        else
          prefValue = menuElement.getAttribute( prefAttribute );
      }
      // Ok, lets write this sucker
      writePref( prefType, prefIdentifier, prefValue, prefDefaultFlag );
    }
    if ( doRefresh ) // this pref setting needs a refresh
      getWebNavigation().reload( nsIWebNavigation.LOAD_FLAGS_IS_REFRESH );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes the preferences for the menu
////////////////////////////////////////////////////////////////////////////////
function initQuickPrefs()
{
  var prefDefaultFlag = true;
  var prefElements    = document.getElementsByAttribute( "pref", "true" );

  for ( var i = 0; i < prefElements.length; i++ ) {
    var prefId         = prefElements[ i ].getAttribute( "id" );
    var prefType       = prefElements[ i ].getAttribute( "preftype" );
    var prefIdentifier = prefElements[ i ].getAttribute( "prefstring" );
    var prefDefval     = prefElements[ i ].getAttribute( "prefdefval" );
    var prefAttribute  = prefElements[ i ].getAttribute( "prefattribute" );
    var prefValue;

    prefValue = readMyPref( prefIdentifier, prefType, prefDefval, prefDefaultFlag );

    if ( prefAttribute == "checked" ) {
      if ( prefValue >= 1 )
        prefElements[ i ].setAttribute( prefAttribute, "true" );
      else prefElements[ i ].removeAttribute( prefAttribute );
    }
    else 
      prefElements[ i ].setAttribute( prefAttribute, prefValue );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes the menu items for the Cookie/Image settings
//------------------------------------------------------------------------------
// this code is copied from cookieNavigatorOverlay.xul and changed accordantly
// and will _always_ be available for the end-user. 'Fuck Netscape'
////////////////////////////////////////////////////////////////////////////////
function aCheckForVisibility()
{
  var permissionmanager = Components.classes[ "@mozilla.org/permissionmanager;1" ]
                                    .getService(Components.interfaces.nsIPermissionManager );

  var blocked, enableElement, disableElement;

  blocked = permissionmanager.testForBlocking( window._content.location, COOKIEPERMISSION );

  if ( blocked ) {
    disableElement = document.getElementById( "tasksBlockCookies" );
    enableElement = document.getElementById( "tasksAllowCookies" );
  } else {
    disableElement = document.getElementById( "tasksAllowCookies" );
    enableElement = document.getElementById( "tasksBlockCookies" );
  }
  disableElement.setAttribute( "disabled", "true" );
  enableElement.removeAttribute( "disabled" );
  // update cookiIcons
  enableElement.setAttribute( "class", "menuitem-iconic quickPrefCookieIcon" );
  disableElement.removeAttribute( "class" );

  blocked = permissionmanager.testForBlocking(window._content.location, IMAGEPERMISSION);

  if ( blocked ) {
    disableElement = document.getElementById( "tasksBlockImages" );
    enableElement = document.getElementById( "tasksAllowImages" );
  } else {
    disableElement = document.getElementById( "tasksAllowImages" );
    enableElement = document.getElementById( "tasksBlockImages" );
  }
  disableElement.setAttribute( "disabled", "true" );
  enableElement.removeAttribute( "disabled" );

  var pref;
  pref = Components.classes[ '@mozilla.org/preferences-service;1' ];
  pref = pref.getService();
  pref = pref.QueryInterface( Components.interfaces.nsIPrefBranch );
}
////////////////////////////////////////////////////////////////////////////////
// this function hanldes the menu items for the Cookie/Image settings
//------------------------------------------------------------------------------
// this code is copied from cookieNavigatorOverlay.xul and changed accordantly 
// our copy is 6 lines shorter and even a bit faster!
////////////////////////////////////////////////////////////////////////////////
function aCookieImageAction( element ) {
  var action = element;
  var permissionmanager = Components.classes[ "@mozilla.org/permissionmanager;1" ]
                                    .getService(Components.interfaces.nsIPermissionManager );
  switch ( action.id ) {
    case "tasksAllowCookies":
      permissionmanager.add(window._content.location, true, COOKIEPERMISSION);
      break;
    case "tasksBlockCookies":
      permissionmanager.add(window._content.location, false, COOKIEPERMISSION);
      break;
    case "tasksAllowImages":
      permissionmanager.add(window._content.location, true, IMAGEPERMISSION);
      break;
    case "tasksBlockImages":
      permissionmanager.add(window._content.location, false, IMAGEPERMISSION);
      break;
    default:
  }
  if ( element )
    alert( element.getAttribute("msg") );
}
////////////////////////////////////////////////////////////////////////////////
// this function reads the useragent data from localstore.rdf
////////////////////////////////////////////////////////////////////////////////
//  <RDF:Seq about="nc:useragent-data">
//    <RDF:li>Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.0.0+) Gecko/20020518</RDF:li>
//    <RDF:li>Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.0rc2) Gecko/20020510</RDF:li>
//    <RDF:li>Mozilla/5.0 (Windows; U; Win98; en-US; rv:0.9.9) Gecko/20020311</RDF:li>
//    <RDF:li>Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.0rc2) Gecko/20020513 Netscape/7.0b1</RDF:li>
//    <RDF:li>Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.0rc2) Gecko/20020512 Netscape/7.0b1</RDF:li>
//    <RDF:li>Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:0.9.4) Gecko/20011022 Netscape6/6.2</RDF:li>
//    <RDF:li>Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)</RDF:li>
//    <RDF:li>Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)</RDF:li>
//    <RDF:li>Mozilla/4.0 (compatible; MSIE 5.0; Mac_PowerPC)</RDF:li>
//    <RDF:li>Mozilla/4.78 [en] (Win98; U)</RDF:li>
//    <RDF:li>Mozilla/4.78 (Macintosh; U; PPC)</RDF:li>
//    <RDF:li>Mozilla/4.78 [en] (X11; U; Linux 2.2.19 i686)</RDF:li>
//  </RDF:Seq>
////////////////////////////////////////////////////////////////////////////////
function getUserAgentFromLocalstore(aParent)
{
  var uaOverride = null;
  try { 
    uaOverride = pref.getCharPref("general.useragent.override"); 
  } catch(ex) {}
  document.getElementById("quickpref-defaultUserAgent").setAttribute("disabled", uaOverride ? "false" : "true");
  deleteHistoryItems(aParent);
  var index = 0;
  var userAgents = RDFC.MakeSeq(gdLocalStore, RDF.GetResource("nc:useragent-data")).GetElements();

  if (!userAgents.hasMoreElements())
    return(index);

  while (userAgents.hasMoreElements()) {
    var userAgent = userAgents.getNext();
    if (userAgent) {
      try {
        userAgent = userAgent.QueryInterface(Components.interfaces.nsIRDFLiteral);
        index++;
      } catch(ex) {
        continue;
      }
     createMenuItem(aParent, index, userAgent.Value);
    }
  }
  return(index);
}
////////////////////////////////////////////////////////////////////////////////
// this function stores the selected useragent in 'general.useragent.override'
////////////////////////////////////////////////////////////////////////////////
function setUserAgentOverrideTo(index, aIdentifier)
{
  if (!index) {
    writePref("char", "general.useragent.override", null);
    pref.clearUserPref("general.useragent.override");
  }
  else 
    writePref("char", "general.useragent.override", aIdentifier);
  loadURI("about:");
}
