/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code in this file as it was released upon
 * September 13, 2001.
 * 
 * The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
 * all Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
 * by Henk-Johan van Rantwijk. All Rights Reserved.
 * 
 * Contributor(s):
 *   David Perry <d.perry@utoronto.ca> (original author)
 *   Henk-Johan van Rantwijk <bugs4hj@netscape.net> (changed for tabList)
 * 
*/

////////////////////////////////////////////////////////////////////////////////
// Javascript functions used to handle the UI for tabHistory functionality
////////////////////////////////////////////////////////////////////////////////

var tabList = null; // tabbox element (passed in as window.arguments[0])
var uriList = null; // array of URIs (window.arguments[1])

////////////////////////////////////////////////////////////////////////////////
// this function initializes dialog and populates the tree structure -
// it is triggered by the dialog's onload() event.
////////////////////////////////////////////////////////////////////////////////
function tabListInit()
{
  tabList     = window.arguments[ 0 ];
  uriList     = window.arguments[ 1 ];
  var tabName = null;
  var tabURI  = null;

  for ( var i = 0; i < tabList.childNodes.length; i++ ) {
    tabName = tabList.childNodes[ i ].getAttribute( "label" );
    tabURI  = uriList[ i ];
    createCell( (i+1), tabName, tabURI, i );
  }
  uriList[ 0 ] =-1;  // return value if all else fails
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a cell to the tree
////////////////////////////////////////////////////////////////////////////////
function createCell( tabIndex, tabName, tabURL, tabNumber )
{
  var treeKids  = document.getElementById( "tabList" );
  var row       = document.createElement( "treerow" );
  var indexCell = document.createElement( "treecell" );
  var nameCell  = document.createElement( "treecell" );
  var URIcell   = document.createElement( "treecell" );
  var item      = document.createElement( "treeitem" );

  indexCell.setAttribute( "label", tabIndex );
  nameCell.setAttribute( "label", tabName );
  URIcell.setAttribute( "label", tabURL );

  row.appendChild( indexCell );
  row.appendChild( nameCell );
  row.appendChild( URIcell );

  item.setAttribute( "id", tabNumber );
  item.appendChild( row );

  treeKids.appendChild( item );
}
////////////////////////////////////////////////////////////////////////////////
// this function activates the selected tab
////////////////////////////////////////////////////////////////////////////////
function tabListClick()
{
  uriList[0] = document.getElementById("tabListTree").currentIndex;
  window.close();
}
