/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2000.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2000
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -  David Perry <d.perry@utoronto.ca>
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
   - Note to all the lame cloners: Go and Take a Hike You Loser!!
*/

////////////////////////////////////////////////////////////////////////////////
// this function opens the TabList Dialog where you can activate a selected tab
////////////////////////////////////////////////////////////////////////////////
function openTabListDialog()
{
  var tabId   = null;
  var uriList = new Array();
  gBrowser    = getBrowser();
  var l       = gBrowser.mTabContainer.childNodes.length;

  for ( var i = 0; i < l; i++ )
    uriList[ i ] = gBrowser.mPanelContainer.childNodes[i].webNavigation.currentURI.spec;

  window.openDialog( "chrome://multiviews/content/multiviewsTabList.xul",
                     "multiviewsTabList",
                     "chrome, dependent, modal, dialog, resizable",
                     gBrowser.mTabContainer,
                     uriList );

  if ( uriList[ 0 ] >= 0 )
   gBrowser.selectedTab = gBrowser.mTabContainer.childNodes[uriList[0]];
}
////////////////////////////////////////////////////////////////////////////////
// this function hides the first two menuitems, and removes all bookmark items
////////////////////////////////////////////////////////////////////////////////
function cleanupForTabGroups( aFolder )
{
  var children = aFolder.childNodes;
  var type;
  // itterate over all menu items
  for ( var i = 0; i < children.length; i++ ) {
    if ( children[ i ].getAttribute( "folder" ) ) {
      // we found a bookmark folder so get rid of the bookmark items
      for ( i = 0; i < children.length; i++ ) {
        if ( children[ i ].getAttribute( "item" ) )
          aFolder.removeChild( children[ i ] );
      }
      // hide 'Open This Folder As Group' and the corresponding separator
      if ( !children[ 0 ].getAttribute( "hidden" ) ) {
        children[ 0 ].setAttribute( "hidden", "true" );
        children[ 1 ].setAttribute( "hidden", "true" );
      }
      break;
    }
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function loads the selected Bookmark Folder as group
////////////////////////////////////////////////////////////////////////////////
function loadFolderAsGroup( aFolder )
{
  var children = aFolder.childNodes;
  var tabOpen = readMyPref( "multizilla.newtabfor.groupfolders", "bool", false );
  var tabPanels = getBrowser().mPanelContainer.childNodes;
  var tabCount = tabPanels.length;
  var uri;
  // itterate over all menu items but skip the first two
  for ( var i = 2; i < children.length; i++ ) {
    uri = children[ i ].getAttribute( "url" );
    if ( !tabOpen && ( i - 2 ) < tabCount )
      tabPanels[ i - 2 ].loadURI( uri, null, nsIWebNavigation.LOAD_FLAGS_NONE );
    else
      getBrowser().addTab( uri );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function 'hides' the selected tab for Close All
////////////////////////////////////////////////////////////////////////////////
function hideTab( aTab )
{
  var clsTab =  "close";

  if ( aTab.hasAttribute( clsTab ) )
    aTab.removeAttribute( clsTab );
  else aTab.setAttribute( clsTab, "true" );
}
////////////////////////////////////////////////////////////////////////////////
// this function re-loads 'firstPage' (if it isn't the same as the current URI)
////////////////////////////////////////////////////////////////////////////////
function loadFirstTabPage()
{
  var mTab = gBrowser.selectedTab;
  var mURI =  mTab.getAttribute( "firstPage" );

  if ( mURI != gBrowser.currentURI.spec )
    loadURI( mURI );
}
////////////////////////////////////////////////////////////////////////////////
// this function opens the "Close All - Keep List" dialog
////////////////////////////////////////////////////////////////////////////////
function closeAllTabsDialog()
{
    var tabList = new Array(); // list of tabs to pass to dialog
    gBrowser    = getBrowser();
    var l       = gBrowser.mTabContainer.childNodes.length;

    for ( var i = 0; i < l; i++ ) {
      var tabTab      = new Object();
      tabTab.name     = gBrowser.mTabContainer.childNodes[ i ].getAttribute( "label" );
      tabTab.URI      = gBrowser.mPanelContainer.childNodes[ i ].webNavigation.currentURI.spec;
      tabTab.closable = gBrowser.mTabContainer.childNodes[ i ].getAttribute( "close" ) ? false : true;
      tabTab.closeMe  = "false";
      tabList[ i ]    = tabTab;
    }
    window.openDialog( "chrome://multiviews/content/multiviewsClose.xul",
                       "multiviewsClose", "chrome,dependent,modal,dialog,resizable", tabList );

    try {
      var mvTabArray = new Array();
      var noCurr = false; // set to true if we remove current tab
      for ( var v = 0; v < l; v++ ) {
        mvTabArray[ v ] = gBrowser.mTabContainer.childNodes[ v ];
      }
      v--;
      while ( v >= 0 ) {
        if ( tabList[ v ].closeMe == "true" ) {
          if ( gBrowser.mTabContainer.childNodes.length > 0 ) {
            if ( !noCurr && mvTabArray[ v ] == gBrowser.mTabContainer.selectedItem )
              noCurr = true;
            gBrowser.removeTab( gBrowser.mTabContainer.childNodes[v] );
          }
          else {
            loadFirstBlank();
            break;
          }
        }
        v--;
      }
    } catch( ex ) { dump( ex+"\n" ); }
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a new Preferred Tab
////////////////////////////////////////////////////////////////////////////////
function addNewPreferredTab()
{
  var aPreferredURI = readMyPref( "multizilla.preferred.location", "string", 
                                  "http://multizilla.mozdev.org/index.html" );
  gBrowser.selectedTab = gBrowser.addTab( aPreferredURI );
  return;
}
////////////////////////////////////////////////////////////////////////////////
// this function adds session history to the selected menu
////////////////////////////////////////////////////////////////////////////////
function FillSelectedHistoryMenu(aParent, aMenu)
{
  deleteHistoryItems(aParent);
  var sessionHistory = getWebNavigation().sessionHistory;
  var count = sessionHistory.count;
  var index = sessionHistory.index;
  var end;
  var j;
  var entry;

  switch (aMenu)
    {
      case "go":
        aParent.lastChild.hidden = (count == 0);	
        end = count > MAX_HISTORY_MENU_ITEMS ? count - MAX_HISTORY_MENU_ITEMS : 0;
        for (j = count - 1; j >= end; j--) {
          entry = sessionHistory.getEntryAtIndex(j, false);
          if (entry)
            createRadioMenuItem(aParent, j, entry.title, j==index);
        }
      break;
      case "tab":
        aParent.lastChild.hidden = (count > 0);	
        end = count > MAX_HISTORY_MENU_ITEMS ? count - MAX_HISTORY_MENU_ITEMS : 0;
        for (j = count - 1; j >= end; j--) {
          entry = sessionHistory.getEntryAtIndex(j, false);
          if (entry)
            createRadioMenuItem(aParent, j, entry.title, j==index);
        }
      break;
    }
}
////////////////////////////////////////////////////////////////////////////////
// this function stores the open tabs as group in localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function storeGroupData()
{
  var browser = getBrowser().mPanelContainer.childNodes;
  var tab = getBrowser().mTabContainer.childNodes;
  removeGroupData();

  for (var index = 0; index < browser.length; index++) {
    var url = browser[index].webNavigation.currentURI.spec;
    var customLabel = tab[index].getAttribute("customLabel") ? 
                  tab[index].getAttribute("label") : "false";
    addToGroupData(url, customLabel);
  }
  writePref("string", "browser.startup.homepage", "about:blank");
  writePref("bool", "multizilla.tabs.startgroup", true);
}
////////////////////////////////////////////////////////////////////////////////
// this function removes group data from localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function removeGroupData()
{
  removeData("nc:group-url");
  removeData("nc:group-label");
  writePref("bool", "multizilla.tabs.startgroup", false);
  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this function removes group data from localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function removeData(resource)
{
  var entries = RDFC.MakeSeq(gdLocalStore, RDF.GetResource(resource));

  if (!entries)
    return false;
  if (!entries.GetElements())
    return false;
  var index=entries.GetCount();
  for (index; index > 0; index--) {
    entries.RemoveElementAt(index, true);
  }
  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this function writes group data to localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function addToGroupData(url, customLabel)
{
  addData("nc:group-url", url);
  addData("nc:group-label", customLabel);
}
////////////////////////////////////////////////////////////////////////////////
// this function writes group data to localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function addData(recource, item)
{
  var entries = RDFC.MakeSeq(gdLocalStore, RDF.GetResource(recource));

  if (!entries)
    return false;
  if (!entries.GetElements())
    return false;
  // entries.InsertElementAt(RDF.GetLiteral(item), 1, true);
  entries.AppendElement(RDF.GetLiteral(item), true);
  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this function closes the last tab or window
////////////////////////////////////////////////////////////////////////////////
function closeTabOrWindow() 
{
  var tabs = getBrowser().mTabContainer.childNodes.length;
  if (!getBrowser().mTabbedMode && confirmCloseWS(1))
    BrowserCloseWindow(); 
  else if (tabs == 1 && getBrowser().mCurrentBrowser.currentURI.spec == "about:blank" && 
           confirmCloseWS(1))
    BrowserCloseWindow(); 
  else gBrowser.removeCurrentTab();
}
