/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2000.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2000
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -  David Perry <d.perry@utoronto.ca>
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
   - Note to all the lame cloners: Go and Take a Hike You Loser!!
*/

////////////////////////////////////////////////////////////////////////////////
// this returns a short URL from the given url, used for stickyName
////////////////////////////////////////////////////////////////////////////////
function defineShortURL( aURI )
{
  var i = aURI.indexOf(":");

  if ( i != -1 ) {
    while( !isAlphaNum( aURI[ i ] ) )
      i++;
    return aURI.substring( i, aURI.length );
  }
  return aURI;
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the URL read from the clipboard
////////////////////////////////////////////////////////////////////////////////
function getLocationFromClipboard()
{
  var url;

  try {
    var clipboard = Components.classes[ "@mozilla.org/widget/clipboard;1" ]
                              .getService(Components.interfaces.nsIClipboard);

    var trans = Components.classes[ "@mozilla.org/widget/transferable;1" ]
                          .createInstance(Components.interfaces.nsITransferable);

    trans.addDataFlavor( "text/unicode" );
    clipboard.getData( trans, clipboard.kGlobalClipboard );

    var data = {};
    var dataLen = {};
    trans.getTransferData( "text/unicode", data, dataLen );

    if ( data ) {
      data = data.value.QueryInterface( Components.interfaces.nsISupportsWString );
      url = data.data.substring( 0, dataLen.value / 2 );
    }
    else {
      url = 'about:blank';
      alert('Sorry, Clipboard contains no data');
    }
  } catch ( ex ) {
    alert( 'Warning: Read From Clipboard Error' );
  }
  return url;
}
////////////////////////////////////////////////////////////////////////////////
// this function displays the current software version number
////////////////////////////////////////////////////////////////////////////////
function displayVersion()
{
  var mVersion = getBrowser().mVersion;
  window.openDialog( "chrome://multiviews/content/multiviewsAbout.xul",
                     "multiviewsClose", "chrome, dialog, dependent", 
                      mVersion, loadURI );
}
////////////////////////////////////////////////////////////////////////////////
// this function checks the website for a new update of MultiZilla
////////////////////////////////////////////////////////////////////////////////
function doCheck4Updates()
{
  var mVersion = getBrowser().mVersion;
  getBrowser().addTab( 'http://multizilla.mozdev.org/update.html?version=' + mVersion );
}
////////////////////////////////////////////////////////////////////////////////
// this function handles the ShutDown stuff
////////////////////////////////////////////////////////////////////////////////
function validateThisPage( aURL )
{
  if ( aURL ) {
    var IOService = Components.classes[ "@mozilla.org/network/io-service;1" ].
                               getService( Components.interfaces.nsIIOService );

    if (!IOService)
       return;
    var scheme = "";

    try {
     scheme = IOService.extractScheme( aURL, {schemeStartPos:0}, {schemeEndPos:0});
    } catch ( ex ) { alert('error') }

    if ( scheme == "http" ) {
      var checkURL = "http://validator.w3.org/check?uri=" + aURL + 
                     "&charset=%28detect+automatically%29&doctype=Inline";
      getBrowser().addTab( checkURL );
    }
    else alert( "Can't handle used protocol type "+ scheme +":\nThis validator supports http: only" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this feature is implemented to clear both memory and disk-cache as well as 
// (url) history info, on special request by some anonymous dirty people, haha
// sorry, but I had to add this type of comment, just for the fun part of it :-)
////////////////////////////////////////////////////////////////////////////////
function clearAllBackTraces()
{
  clearGlobalHistory();
  clearUrlBarHistory();
  clearCache("STORE_ON_DISK");
  clearCache("STORE_IN_MEMORY");
}
////////////////////////////////////////////////////////////////////////////////
// this function clears the global history
////////////////////////////////////////////////////////////////////////////////
function clearGlobalHistory()
{
  var globalHistory = Components.classes["@mozilla.org/browser/global-history;1"]
                                .getService(Components.interfaces.nsIBrowserHistory);
  globalHistory.removeAllPages();
}
////////////////////////////////////////////////////////////////////////////////
// this function clears the global history
////////////////////////////////////////////////////////////////////////////////
function clearUrlBarHistory()
{
  var urlBarHistory = Components.classes["@mozilla.org/browser/urlbarhistory;1"]
                                .getService(Components.interfaces.nsIUrlbarHistory);
  urlBarHistory.clearHistory();
}
////////////////////////////////////////////////////////////////////////////////
// this function clears the global history
////////////////////////////////////////////////////////////////////////////////
function clearCache(aCache)
{
  var classID       = Components.classes["@mozilla.org/network/cache-service;1"];
  var cacheService  = classID.getService(Components.interfaces.nsICacheService);

  if (aCache == "STORE_ON_DISK")
    cacheService.evictEntries(Components.interfaces.nsICache.STORE_ON_DISK);
  else if (aCache == "STORE_IN_MEMORY")
    cacheService.evictEntries(Components.interfaces.nsICache.STORE_IN_MEMORY);
}
////////////////////////////////////////////////////////////////////////////////
// this function gets a localized string from chrome:multiviews.properties
////////////////////////////////////////////////////////////////////////////////
function getTextFromBundle(aStr) {
  var multiviewsBundle = "chrome://multiviews/locale/multiviews.properties";
  var aBundle = srGetStrBundle( multiviewsBundle );
  var aLabel = aBundle.GetStringFromName( aStr );
  return aLabel;
}
////////////////////////////////////////////////////////////////////////////////
// this function returns true if a given string is all alphanumeric
// Adapted from chrome/content/communitcator/pref/pref-languages.js
////////////////////////////////////////////////////////////////////////////////
function isAlphaNum(mixedCase) {
  var allCaps = mixedCase.toUpperCase();
  for (var i = allCaps.length - 1; i >= 0; i--) {
    var c = allCaps.charAt(i);
    if ((c < 'A' || c > 'Z') && (c < '0' || c > '9') && (c!='_'))
      return false;
  }
  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this function prevents the opening of duplicate URLs in tabs
////////////////////////////////////////////////////////////////////////////////
function preventDupeTab(href)
{
  var tabHref = null;

  if (readMyPref( "multizilla.prevent.double", "bool", true) && href.substring(0,10) != "javascript") {
    var gBrowser = getBrowser();
    var baseHref = href.replace(/#.*/, "");
    if (baseHref[baseHref.length-1] == '/')
      baseHref = baseHref.substring(0,baseHref.length-1);
    for (var i = 0; i < gBrowser.mTabContainer.childNodes.length; i++) {
      if (!gBrowser.mTabContainer.childNodes[i].getAttribute("busy"))
        tabHref = gBrowser.mPanelContainer.childNodes[i].webNavigation.currentURI.spec;
      else // our last resort to obtain the URL
        tabHref = gBrowser.mTabContainer.childNodes[i].getAttribute("firstPage");
      tabHref = tabHref.replace(/#.*/, "");
      if (tabHref[tabHref.length-1] == '/')
        tabHref = tabHref.substring(0,tabHref.length-1);

      if (baseHref == tabHref) {
        gBrowser.selectedTab = gBrowser.mTabContainer.childNodes[i];
        if (href.indexOf("#") != -1)
          loadURI(href); // accounts for URLs like page.html#anchor
          return true;
      }
    }
  }
  return false;
}
