/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.highlevel.HLAccounts
 *
 *
 */
/**
 * HLAccounts
 *
 * Constructors:
 *   HLAccounts(jabberService)
 *
 * Method:
 *   getAccountInfo(accountName)
 *   setAccountInfo(accountName, username, password, resource, server, port)
 *   removeAccountInfo(accountName)
 *
 */

function HLAccounts(jabberService)
{
    var file = new File(jabberService.settingsDirectory, "accounts.rdf");
    var acc;
    var oldacc, oldrdf;
    var it, a, aold;

    this.jabberService = jabberService;
    this.rdf = new FileRDF(file, JIM_NAMESPACE_URI+"rdf/accounts#", "accounts");
    acc = this.rdf.getContainer("rdf:jim-accounts", "seq");

    if (acc.getCount() == 0) {
        file = new File(jabberService.settingsDirectory, "settings.rdf");
        if (file.exists) {
            oldrdf = new FileRDF(file, JIM_NAMESPACE_URI+"rdf/accounts#", "accounts");
            oldacc = this.rdf.getContainer("rdf:jim-accounts", "seq");
            it = oldacc.getElements();

            while (it.hasNext()) {
                aold = it.getNext();
                a = this.rdf.getResource();
                a.setAssertion("name", aold.getTarget("name").value, true);

                if (aold.getTarget("password"))
                    a.setAssertion("password", aold.getTarget("password").value, true);
                a.setAssertion("username", aold.getTarget("username").value, true);
                a.setAssertion("resource", aold.getTarget("resource").value, true);
                a.setAssertion("server", aold.getTarget("server").value, true);
                a.setAssertion("port", aold.getTarget("port").value, true);
                a.setAssertion("useSSL", aold.getTarget("useSSL").value, true);
                acc.appendElement(a);
            }
        }
    } else {
        file = new File(jabberService.settingsDirectory, "settings.rdf");
        file.remove();
    }
}

HLAccounts.prototype =
{
    getAccountInfo: function(accountName)
    {
        var account, ret, res;
        function vOn(v) { return v ? v.value : null };

        res = this.rdf.getLiteral(accountName);
        account = res.getSource("name");
        
        if (account)
            ret = {
                name:     accountName,
                username: vOn(account.getTarget("username")),
                password: vOn(account.getTarget("password")),
                resource: vOn(account.getTarget("resource")),
                server:   vOn(account.getTarget("server")),
                port:     vOn(account.getTarget("port")),
                useSSL:   vOn(account.getTarget("useSSL")) == "true"
            };
        return ret;
    },

    hasAccountInfo: function(accountName)
    {
        return this.rdf.getLiteral(accountName).getSource("name") != null;
    },

    setAccountInfo: function(accountName, username, password, resource, server, port, useSSL)
    {
        var account, container;

        account = this.rdf.getLiteral(accountName).getSource("name");

        if (!account)
            account = this.rdf.getResource();

        account.setAssertion("name", accountName, true);
        account.setAssertion("resource", resource, true);
        account.setAssertion("username", username, true);

        if (password != null)
            account.setAssertion("password", password, true);
        else
            account.removeAssertion("password");

        account.setAssertion("server", server, true);
        account.setAssertion("port", port, true);
        if (useSSL)
            account.setAssertion("useSSL", "true", true);
        else
            account.removeAssertion("useSSL", null, false, true);

        container = this.rdf.getContainer("rdf:jim-accounts");

        if (container.indexOf(account) == -1)
            container.appendElement(account);

    },

    removeAccountInfo: function(accountName)
    {
        var account;

        account = this.rdf.getLiteral(accountName).getSource("name");
        if (account) {
            this.rdf.getContainer("rdf:jim-accounts").removeElement(account)
            account.remove();
        }
    }
}
