/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.highlevel.HLStatusText
 *
 *
 */
ML.load("utils/observable.js");
ML.load("io/file.js");
ML.load("rdf/filerdf.js");
ML.load("utils/misc.js");

/**
 * HLStatusText
 *   Service which controls information about statusicons
 *
 * Constructors:
 *   HLStatusText(jabberService) - constructor
 *
 */

function HLStatusText(jabberService)
{
    var file = new File(jabberService.settingsDirectory, "statustext.rdf");

    this.jabberService = jabberService;
    this.rdf = new FileRDF(file, JIM_NAMESPACE_URI+"rdf/status-text#", "st");
}

HLStatusText.prototype =
{
    getContainerId: function(type)
    {
        return "rdf:jim-status-text-" + type;
    },

    addStatusText: function(type, val)
    {
        var res = this.rdf.getResource();
        var container = this.rdf.getContainer(this.getContainerId(type), "bag");

        res.setAssertion("text", val, true);
        container.appendElement(res);
    },

    updateStatusText: function(id, type, val)
    {
        var res = this.rdf.getResource(id);

        if (res)
            res.setAssertion("text", val, true);
    },

    removeStatusText: function(id, type)
    {
        var container = this.rdf.getContainer(this.getContainerId(type), "bag");
        var res = this.rdf.getResource(id);

        container.removeElement(res);
        res.remove();
    }
}
