/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Auth
 *
 *
 */
ML.load("crypto/sha1.js");
ML.load("utils/observable.js");

/**
 * IQAuth
 *   jabber:iq:auth protocol handler
 *
 * Constructors:
 *   IQAuth(jabberService)
 *
 * Methods:
 *   authenticate(user, password, resource) - constructor
 *
 * Events:
 *   onIQAuthError(errorCode, errorText)
 *   onIQAuth()
 */

function IQAuth(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
    this.authenticated = false;

//    jabberService.addObserver(this);
}

IQAuth.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:auth",

    authenticate: function(user, password, resource)
    {
        this.user = user;
        this.password = password;
        this.resource = resource;
        this.jabberService.core.uid = user+"@"+this.jabberService.host+"/"+resource;
        this.jabberService.core.uidShort = user+"@"+this.jabberService.host;

        this.__sendAuthentication = true;
        this.authenticated = false;
        if (this.jabberService.connected)
            this.onConnect();
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQAuthError", errTag.getAttribute("code"), domToText(errTag));
        } else if (tag.getAttribute("type")=="result") {
            var query = tag.getElementsByTagName("query");

            if (query.length) {
                var query = DB.createElement("jabber:iq:auth", "query");

                query.addElement("jabber:iq:auth", "username").addText(this.user);
                query.addElement("jabber:iq:auth", "resource").addText(this.resource);
                query.addElement("jabber:iq:auth", "digest").
                    addText(sha1(this.jabberService.core.streamId+this.password));

                this.jabberService.core.iqTag(null, null, null, "set", query, this);
            } else {
                this.fireEvent("onIQAuth");
                this.authenticated = true;
            }
        }
    },

    onConnect: function()
    {
        if (this.__sendAuthentication) {
            var query = DB.createElement("jabber:iq:auth", "query");

            query.addElement("jabber:iq:auth", "username").addText(this.user);

            this.jabberService.core.iqTag(null, null, null, "get", query, this);
        }
        this.__sendAuthentication = false;
    },

    onDisconnect: function()
    {
        this.authenticated = false;
    }
}