/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Private
 *
 *
 */
ML.load("utils/observable.js");
ML.load("utils/misc.js");

/**
 * IQPrivate
 *   jabber:iq:private protocol handler
 *
 * Constructors:
 *   IQPrivate(jabberService) - constructor
 *
 * Methods:
 *   getPrivate(namespaceURI, name)
 *   getPrivateTag(tag)
 *   setPrivate(tag)
 *
 * Events:
 *   onIQPrivateError(errorCode, errorText)
 *   onIQPrivate(tag)
 */

function IQPrivate(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQPrivate.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:private",

    getPrivate: function(ns, name)
    {
        var query = DB.createElement(this.namespaceURI, "query");
        query.addElement(ns, name);

        this.jabberService.core.iqTag(null, null, null, "get", query, this);
            
    },

    getPrivateTag: function(tag)
    {
        var query = DB.createElement(this.namespaceURI, "query");
        query.addDOM(tag);

        this.jabberService.core.iqTag(null, null, null, "get", query, this);
            
    },

    setPrivate: function(tag)
    {
        var query = DB.createElement(this.namespaceURI, "query");
        query.addDOM(tag);

        this.jabberService.core.iqTag(null, null, null, "set", query, this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQPrivateError", errTag.getAttribute("code"),
                domToText(errTag));
        } else if (tag.getAttribute("type")=="result") {
            var tag = tag.getElementsByTagNameNS(this.namespaceURI,
                "query")[0];

            if (tag)
                this.fireEvent("onIQPrivate", tag.firstChild);
        }
    },
}