/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Time
 *
 *
 */
ML.load("utils/observable.js");
ML.load("utils/misc.js");

/**
 * IQTime
 *   jabber:iq:time protocol handler
 *
 * Constructors:
 *   IQTime(jabberService) - constructor
 *
 * Methods:
 *   getTime(from) - gets time from client with uid "from"
 *
 * Events:
 *   onIQTimeError(errorCode, errorText)
 *   onIQTime(from, utc, tz, display)
 */

function IQTime(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQTime.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:time",

    getTime: function(from)
    {
        this.jabberService.core.iqTag(null, from, null, "get", 
            DB.createElement("jabber:iq:time", "query"), this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQTimeError", errTag.getAttribute("code"), domToText(errTag));
        } else if (tag.getAttribute("type")=="result") {
            var utc = tag.getElementsByTagName("utc")[0];
            var tz = tag.getElementsByTagName("tz")[0];
            var display = tag.getElementsByTagName("display")[0];
            
            this.fireEvent("onIQTime", tag.getAttribute("from"),
                utc ? domToText(utc) : null,
                tz ? domToText(tz) : null,
                display ? domToText(display) : null);
        }
    },

    onIQHandler: function(tag)
    {
        var now, query;

        if (tag.getAttribute("type") != "get")
            return;
        
         if (!getBoolPref("proto-time-send")) {
            this.iqError(tag.getAttribute("to"),
                tag.getAttribute("from"),
                tag.getAttribute("id"),
                501,
                "Not Implemented");
            return;
        }
        
        now = new Date();

        query = DB.createElement("jabber:iq:time", "query");
        query.addElement("jabber:iq:time", "utc").
            addText(dateToUTCString(now));
        query.addElement("jabber:iq:time", "display").
            addText(formatDate(now, null, "long", "long"));

        this.jabberService.core.iqTag(this.jabberService.core.uid, tag.getAttribute("from"),
            tag.getAttribute("id"), "result", query);
    },
}