/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.VCard
 *
 *
 */
ML.load("utils/observable.js");
ML.load("utils/misc.js");

/**
 * IQVCard
 *   vcard-temp protocol handler
 *
 * Constructors:
 *   IQVCard(jabberService) - constructor
 *
 * Methods:
 *   getVCard(from)
 *   setVCard(tagsList)
 *
 * Events:
 *   onIQVCardError(errorCode, errorText)
 *   onIQVCard(from, tag)
 */

function IQVCard(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQVCard.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "vcard-temp",

    getVCard: function(from)
    {
        this.jabberService.core.iqTag(null, from, null, "get", 
            DB.createElement("vcard-temp", "vCard"), this);
    },

    setVCard: function(tagsList)
    {
        if (tagsList instanceof Node && tagsList.nodeName == "vCard") {
            this.jabberService.core.iqTag(null, null, null, "set",
                tagsList, this);
        } else {
            this.jabberService.core.iqTag(null, null, null, "set", 
                DB.createElement("vcard-temp", "vCard").
                    addDOM(tagsList), this);
        }
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQVCardError", errTag.getAttribute("code"),
                domToText(errTag));
        } else if (tag.getAttribute("type")=="result") {
            var vCard = tag.getElementsByTagNameNS(this.namespaceURI,
                "vCard")[0];
            
            this.fireEvent("onIQVCard", tag.getAttribute("from"), vCard);
        }
    },
}