/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Version
 *
 *
 */
ML.load("utils/observable.js");

/**
 * IQVersion
 *   jabber:iq:version protocol handler
 *
 * Constructors:
 *   IQVersion(jabberService) - constructor
 *
 * Methods:
 *   getVersion(from) - gets time from client with uid "from"
 *
 * Events:
 *   onIQVersionError(errorCode, errorText)
 *   onIQVersion(from, name, version, os)
 */

function IQVersion(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQVersion.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:version",

    getVersion: function(from)
    {
        this.jabberService.core.iqTag(null, from, null, "get", 
            DB.createElement("jabber:iq:version", "query"), this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQVersionError", errTag.getAttribute("code"), domToText(errTag));
        } else if (tag.getAttribute("type")=="result") {
            var name = tag.getElementsByTagName("name")[0];
            var version = tag.getElementsByTagName("version")[0];
            var os = tag.getElementsByTagName("os")[0];
            
            this.fireEvent("onIQVersion",tag.getAttribute("from"), 
                name ? domToText(name) : null,
                version ? domToText(version) : null,
                os ? domToText(os) : null);
        }
    },

    onIQHandler: function(tag)
    {
        var query;
        var date;

        if (tag.getAttribute("type") != "get")
            return;

        if (!getBoolPref("proto-version-send")) {
            this.iqError(tag.getAttribute("to"),
                tag.getAttribute("from"),
                tag.getAttribute("id"),
                501,
                "Not Implemented");
            return;
        }
        query = DB.createElement("jabber:iq:version", "query");
        query.addElement("jabber:iq:version", "name").addText(this.jabberService.appInfo.name);
        query.addElement("jabber:iq:version", "version").addText(this.jabberService.appInfo.version);
        query.addElement("jabber:iq:version", "os").addText(this.jabberService.appInfo.os);

        this.jabberService.core.iqTag(this.jabberService.core.uid, tag.getAttribute("from"),
            tag.getAttribute("id"), "result", query);
    },
}