/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * utils.Uninstall
 *
 *
 */
ML.load("io/file.js");
ML.load("rdf/filerdf.js");

function removeFromInstalledChrome(packageFile, isJarFile, content)
{
    var chromeDir = Components.classes["@mozilla.org/file/directory_service;1"].
        getService(Components.interfaces.nsIProperties).
            get("AChrom", Components.interfaces.nsIFile).path;
    var file = new File(chromeDir, "installed-chrome.txt");
    var data;

    try {
        file.open(file.MODE_RDONLY);
        data = file.read();
        file.close();
        var re = "^(skin|locale|content),install,url," +
            (isJarFile ? "jar:resource:/chrome/" :"resource:/chrome/") +
            packageFile + (isJarFile ? "!/.*?[\n\r]+" : "/.*?[\\n\\r]+");
        data = data.replace(new RegExp(re, "mg"), "");
        file.open(file.MODE_WRONLY | file.MODE_TRUNCATE);
        file.write(data);
        file.close();

        return re;
    } catch (ex) {
        return false;
    }
}

function removeFromChromeRDF(packageFile, isJarFile, content)
{
    var chromeDir = Components.classes["@mozilla.org/file/directory_service;1"].
        getService(Components.interfaces.nsIProperties).
            get("AChrom", Components.interfaces.nsIFile).path;
    var file = new File(chromeDir, "chrome.rdf");
    var rdf = new FileRDF(file, "http://www.mozilla.org/rdf/chrome#", "a");
    var pRes, res, it;

    if (isJarFile)
        pRes = "jar:resource:/chrome/"+ packageFile+"!/"+content+"/";
    else
        pRes = "resource:/chrome/"+ packageFile+"/"+content+"/";
    pRes = rdf.getLiteral(pRes).getSource("baseURL");

    res = rdf.getContainer("urn:mozilla:package:root");
    res.removeElement(pRes);

    it = pRes.getSources("package");
    while (it.hasNext()) {
        res = it.getNext();
        res.remove();
    }
    pRes.remove();
}

function removeFromOverlayInfo(packageFile, isJarFile, content)
{
    var chromeDir = Components.classes["@mozilla.org/file/directory_service;1"].
        getService(Components.interfaces.nsIProperties).
            get("AChrom", Components.interfaces.nsIFile).path;
    var file = new File(chromeDir, packageFile);
    var rdf, rdf2, res, it, it2;

    if (isJarFile)
        rdf = new FileRDF("jar:"+file.uri.spec+"!/"+content+"/content.rdf",
            "http://www.mozilla.org/rdf/chrome#", "a");
    else
        rdf = new FileRDF(file.uri.spec+content+"/content.rdf",
            "http://www.mozilla.org/rdf/chrome#", "a");

    res = rdf.getContainer("urn:mozilla:overlays");
    it = res.getElements();
    while (it.hasNext()) {
        res = it.getNext();

        file = new File(chromeDir, "overlayinfo");

        rdf2 = new FileRDF(file.uri.spec +
                res.value.replace(/^chrome:\/\/(.+)\/([^\/]+$)/, "$1") +
                "/overlays.rdf",
            "http://www.mozilla.org/rdf/chrome#", "a");

        it2 = res.getElements();
        while (it2.hasNext()) {
            rdf2.getContainer(res.value).
                removeElement(it2.getNext());
        }
    }
}

removeFromChrome(packageFile, isJarFile, content)
{
    var chromeDir = Components.classes["@mozilla.org/file/directory_service;1"].
        getService(Components.interfaces.nsIProperties).
            get("AChrom", Components.interfaces.nsIFile).path;
    var file = new File(chromeDir, packageFile);

    file.remove();
}
