/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * xml.XMLDOMBuilder
 *
 *
 */
ML.load("xml/xmldomutils.js");

Element.prototype.addElement = function()
{
    var tag, i;
    var xmlns;

    tag = this.ownerDocument.createElementNS(arguments[0], arguments[1]);
    tag.type = 0;

    xmlns = "xmlns"+(tag.prefix ? ":"+tag.prefix : "");

    if (tag.prefix != this.prefix || tag.namespaceURI != this.namespaceURI) {
        if (this.getAttribute(xmlns) != tag.namespaceURI)
            tag.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlns, tag.namespaceURI);
        else
            tag.removeAttribute(xmlns);
    } else
        tag.removeAttribute(xmlns);

    for (i = 2;i < arguments.length; i+=2)
        if (arguments[i+1] != null)
            if (arguments[i].search(/^xmlns(?:$|:)/) >= 0)
                tag.setAttributeNS("http://www.w3.org/2000/xmlns/", arguments[i], arguments[i+1]);
            else
                tag.setAttribute(arguments[i], arguments[i+1]);
    this.appendChild(tag);

    return tag;
}

Element.prototype.addDOM = function(tag)
{
    var i;

    if (!tag)
        return;

    if (tag instanceof Array)
        for (i = 0; i < tag.length; i++)
            this.addDOM(tag[i]);
    else if (tag.nodeType == tag.ELEMENT_NODE) {
        this.appendChild(tag);

        var xmlns = "xmlns"+(tag.prefix ? ":"+tag.prefix : "");

        if (tag.prefix != this.prefix || tag.namespaceURI != this.namespaceURI) {
            if (this.getAttribute(xmlns) != tag.namespaceURI)
                tag.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlns, tag.namespaceURI);
            else {
                tag.removeAttribute(xmlns);
            }
        } else
            tag.removeAttribute(xmlns);
    } else
        this.appendChild(tag)

    return this;
}

Element.prototype.addText = function(text)
{
    this.appendChild(this.ownerDocument.createTextNode(text));

    return this;
}

function XMLDOMBuilder(doc) {
    this.doc = doc;
}

XMLDOMBuilder.prototype =
{
    createElement: function(type)
    {
        var idx, tag, doc;

        if (type == 0 || type == 1 || type == 2) {
            tag = this.doc.createElementNS(arguments[1], arguments[2]);
            idx = 3;
            tag.type = type;
        } else {
            tag = this.doc.createElementNS(arguments[0], arguments[1]);
            idx = 2;
            tag.type = 0;
        }

        if (tag.namespaceURI);
            tag.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns"+(tag.prefix ? ":"+tag.prefix : ""), 
tag.namespaceURI);

        for (;idx < arguments.length; idx+=2)
            if (arguments[idx+1] != null)
                if (arguments[idx].search(/^xmlns(?:$|:)/) >= 0)
                    tag.setAttributeNS("http://www.w3.org/2000/xmlns/", arguments[idx], arguments[idx+1]);
                else
                    tag.setAttribute(arguments[idx], arguments[idx+1]);

        return tag;
    },

    createText: function(value)
    {
        return this.doc.createTextNode(value);
    }
}
