/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * xml.XMLDomTraverse
 *
 *
 */
function xmlDOMTraverse(dom, nodeName, actionTree, val, dontCheck)
{
    var el, action;

    if (!dom || !actionTree || 
            (!dontCheck && (!nodeName || dom.localName != nodeName)))
        return;

    if (action = actionTree["__INITIALIZE__"])
        if (typeof(action) == "function")
            action(dom, val);
        else if (action instanceof XMLDOMAction)
            action.handle(dom, val);

    el = dom.firstChild;
    while (el) {
        if (action = actionTree[el.localName])
            if (typeof(action) == "function")
                action(el, val);
            else if (action instanceof XMLDOMAction)
                action.handle(el, val);
            else
                xmlDOMTraverse(el, null, action, val, 1);
        el = el.nextSibling;
    }

    if (action = actionTree["__FINALIZE__"])
        if (typeof(action) == "function")
            action(dom, val);
        else if (action instanceof XMLDOMAction)
            action.handle(dom, val);
}

function XMLDOMAction()
{
}

XMLDOMAction.prototype =
{
    handle: function(dom) { }
}