/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * xml.XMLDOMUtils
 *
 *
 */

Node.prototype.COMPLETE_TAG = 0;
Node.prototype.START_TAG = 1;
Node.prototype.END_TAG = 2;

function domToText(dom)
{
    var i, ret;

    if (dom.nodeType == dom.ELEMENT_NODE) {
        ret = "";
        for (i = 0; i < dom.childNodes.length; i++)
            ret += domToText(dom.childNodes[i]);
        return ret;
    } else
        return dom.nodeValue;
}

function domToString(dom)
{
    if (dom.nodeType == dom.ELEMENT_NODE) {
        var ret, i;

        if (dom.type == 2)
            return "<" + dom.nodeName + ">";

        ret = "<" + dom.nodeName;

        for (i = 0; i < dom.attributes.length; i++) {
            ret += " " + dom.attributes[i].nodeName +
                "='" + encodeEntity(dom.attributes[i].nodeValue) + "'";
        }
        
        if (dom.hasChildNodes()) {
            ret += ">";

            for (i = 0; i < dom.childNodes.length; i++)
                ret += domToString(dom.childNodes[i]);

            if (dom.type != 1)
                ret += "</" + dom.nodeName + ">";
        } else if (dom.type != 1)
            ret += "/>";
        else
            ret += ">";
        return ret;
    } else
        return encodeEntity(dom.nodeValue);
}

function domToHTMLString(dom)
{
    if (dom.nodeType == dom.ELEMENT_NODE) {
        var ret, i;

        if (dom.type == 2)
            return "<div class='tag'>&lt;/<span class='tag-name'>"+dom.nodeName+"</span>&gt;</div>";

        ret = "<div class='tag'>&lt;<span class='tag-name'>"+dom.nodeName+"</span>";

        for (i = 0; i < dom.attributes.length; i++) {
            ret += " <span class='attrib-name'>"+ dom.attributes[i].nodeName +
                "</span>=<span class='attrib-value'>'" +
                encodeEntity(dom.attributes[i].nodeValue) +
                "'</span>";
        }
        
        if (dom.hasChildNodes()) {
            ret += "&gt;";

            for (i = 0; i < dom.childNodes.length; i++)
                ret += domToHTMLString(dom.childNodes[i]);

            if (dom.type != 1)
                ret += "&lt;/<span class='tag-name'>"+dom.nodeName+"</span>&gt;</div>";
        } else if (dom.type != 1)
            ret += "/&gt;</div>";
        else
            ret += "&gt;</div>";
        return ret;
    } else
        return "<div class='text'>"+encodeEntity(normalizeWS(dom.nodeValue))+"</div>";
}

Node.prototype.firstChildElement getter = function()
{
    var i;

    for (i = 0; i < this.childNodes.length; i++)
        if (this.childNodes[i].nodeType == this.ELEMENT_NODE)
            return this.childNodes[i];
    return null;
}

Node.prototype.lastChildElement getter = function()
{
    var i;

    for (i = this.childNodes.length - 1; i >= 0; i--)
        if (this.childNodes[i].nodeType == this.ELEMENT_NODE)
            return this.childNodes[i];
    return null;
}

Node.prototype.nextSiblingElement getter = function()
{
    if (this.parentNode && this.parentNode.__locate) {
        var i = this.parentNode.__locate(this)+1;

        for (; i < this.parentNode.childNodes.length; i++)
            if (this.parentNode.childNodes[i].nodeType == this.ELEMENT_NODE)
                return this.parentNode.childNodes[i];
    }
    return null;
}

Node.prototype.previousSiblingElement getter = function()
{
    if (this.parentNode && this.parentNode.__locate) {
        var i = this.parentNode.__locate(this)-1;

        for (; i >= 0; i--)
            if (this.parentNode.childNodes[i].nodeType == this.ELEMENT_NODE)
                return this.parentNode.childNodes[i];
    }
    return null;
}

