#! /bin/sh
#
# The contents of this file are subject to the Netscape Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/NPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is mozilla.org code.
#
# The Initial Developer of the Original Code is Netscape
# Communications Corporation.  Portions created by Netscape are
# Copyright (C) 1999 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): 
#

# allmakefiles.sh - List of all makefiles. 
#   Appends the list of makefiles to the variable, MAKEFILES.
#   There is no need to rerun autoconf after adding makefiles.
#   You only need to run configure.
#
#   Please keep the modules in this file in sync with those in
#   mozilla/build/unix/modules.mk
#

MAKEFILES=""

# add_makefiles - Shell function to add makefiles to MAKEFILES
add_makefiles() {
    MAKEFILES="$MAKEFILES $*"
}

if [ "$srcdir" = "" ]; then
    srcdir=.
fi

#
# Common makefiles used by everyone
#
add_makefiles "
Makefile
build/Makefile
build/unix/Makefile
config/Makefile
config/autoconf.mk
config/mkdepend/Makefile
config/doxygen.cfg
"

if [ "$MOZ_COMPOSER" ]; then
MAKEFILES_composer="
editor/composer/Makefile
editor/ui/Makefile
editor/ui/composer/content/contents-region.rdf
editor/ui/composer/content/contents.rdf
editor/ui/composer/locale/en-US/contents-region.rdf
editor/ui/composer/locale/en-US/contents.rdf
"
fi

MAKEFILES_db="
db/Makefile
db/mdb/Makefile
db/mdb/public/Makefile
db/mork/Makefile
db/mork/build/Makefile
db/mork/src/Makefile
"

MAKEFILES_dbm="
dbm/Makefile
dbm/include/Makefile
dbm/src/Makefile
dbm/tests/Makefile
"

MAKEFILES_dom="
dom/Makefile
dom/public/Makefile
dom/public/base/Makefile
dom/public/coreEvents/Makefile
dom/public/idl/Makefile
dom/public/idl/base/Makefile
dom/public/idl/core/Makefile
dom/public/idl/css/Makefile
dom/public/idl/events/Makefile
dom/public/idl/html/Makefile
dom/public/idl/range/Makefile
dom/public/idl/stylesheets/Makefile
dom/public/idl/views/Makefile
dom/public/idl/xbl/Makefile
dom/public/idl/xpath/Makefile
dom/public/idl/xul/Makefile
dom/src/Makefile
dom/src/base/Makefile
dom/src/build/Makefile
dom/src/events/Makefile
dom/src/jsurl/Makefile
"

MAKEFILES_editor="
editor/Makefile
editor/public/Makefile
editor/idl/Makefile
editor/txmgr/Makefile
editor/txmgr/idl/Makefile
editor/txmgr/public/Makefile
editor/txmgr/src/Makefile
editor/txmgr/tests/Makefile
editor/txtsvc/Makefile
editor/txtsvc/public/Makefile
editor/txtsvc/src/Makefile
"

MAKEFILES_expat="
expat/Makefile
expat/xmlparse/Makefile
expat/xmltok/Makefile
"

MAKEFILES_extensions="
extensions/Makefile
"

MAKEFILES_gc="
gc/boehm/Makefile
gc/boehm/leaksoup/Makefile
"

MAKEFILES_gfx="
gfx/Makefile
gfx/idl/Makefile
gfx/public/Makefile
gfx/src/Makefile
gfx/src/beos/Makefile
gfx/src/gtk/Makefile
gfx/src/ps/Makefile
gfx/src/photon/Makefile
gfx/src/mac/Makefile
gfx/src/xlib/Makefile
gfx/src/os2/Makefile
gfx/src/xlibrgb/Makefile
gfx/src/windows/Makefile
gfx/tests/Makefile
"

MAKEFILES_htmlparser="
htmlparser/Makefile
htmlparser/robot/Makefile
htmlparser/robot/test/Makefile
htmlparser/public/Makefile
htmlparser/src/Makefile
htmlparser/tests/Makefile
htmlparser/tests/grabpage/Makefile
htmlparser/tests/logparse/Makefile
htmlparser/tests/html/Makefile
htmlparser/tests/outsinks/Makefile
"

MAKEFILES_intl="
intl/Makefile
intl/chardet/Makefile
intl/chardet/public/Makefile
intl/chardet/src/Makefile
intl/uconv/Makefile
intl/uconv/idl/Makefile
intl/uconv/public/Makefile
intl/uconv/src/Makefile
intl/uconv/tests/Makefile
intl/uconv/ucvja/Makefile
intl/uconv/ucvlatin/Makefile
intl/uconv/ucvcn/Makefile
intl/uconv/ucvtw/Makefile
intl/uconv/ucvtw2/Makefile
intl/uconv/ucvko/Makefile
intl/uconv/ucvibm/Makefile
intl/uconv/native/Makefile
intl/locale/Makefile
intl/locale/public/Makefile
intl/locale/idl/Makefile
intl/locale/src/Makefile
intl/locale/src/unix/Makefile
intl/locale/src/os2/Makefile
intl/locale/src/windows/Makefile
intl/locale/tests/Makefile
intl/lwbrk/Makefile
intl/lwbrk/src/Makefile
intl/lwbrk/public/Makefile
intl/lwbrk/tests/Makefile
intl/unicharutil/Makefile
intl/unicharutil/idl/Makefile
intl/unicharutil/src/Makefile
intl/unicharutil/public/Makefile
intl/unicharutil/tables/Makefile
intl/unicharutil/tests/Makefile
intl/unicharutil/tools/Makefile
intl/strres/Makefile
intl/strres/public/Makefile
intl/strres/src/Makefile
intl/strres/tests/Makefile
"

if [ "$SUNCTL" ] ; then
MAKEFILES_intl="$MAKEFILES_intl
intl/ctl/Makefile
intl/ctl/public/Makefile
intl/ctl/src/Makefile
intl/ctl/src/pangoLite/Makefile
intl/ctl/src/thaiShaper/Makefile
intl/ctl/src/hindiShaper/Makefile
"
fi

MAKEFILES_js="
js/Makefile
js/src/Makefile
js/src/fdlibm/Makefile
"

MAKEFILES_liveconnect="
js/src/liveconnect/Makefile
js/src/liveconnect/classes/Makefile
"

MAKEFILES_xpconnect="
js/src/xpconnect/Makefile
js/src/xpconnect/public/Makefile
js/src/xpconnect/idl/Makefile
js/src/xpconnect/shell/Makefile
js/src/xpconnect/src/Makefile
js/src/xpconnect/loader/Makefile
js/src/xpconnect/tests/Makefile
js/src/xpconnect/tests/components/Makefile
js/src/xpconnect/tests/idl/Makefile
js/src/xpconnect/shell/Makefile
js/src/xpconnect/tools/Makefile
js/src/xpconnect/tools/idl/Makefile
js/src/xpconnect/tools/idl/Makefile
"

MAKEFILES_jsdebugger="
js/jsd/Makefile
js/jsd/idl/Makefile
"

MAKEFILES_content="
content/Makefile
content/base/Makefile
content/base/public/Makefile
content/base/src/Makefile
content/events/Makefile
content/events/public/Makefile
content/events/src/Makefile
content/html/Makefile
content/html/content/Makefile
content/html/content/public/Makefile
content/html/content/src/Makefile
content/html/document/Makefile
content/html/document/public/Makefile
content/html/document/src/Makefile
content/html/style/Makefile
content/html/style/public/Makefile
content/html/style/src/Makefile
content/xml/Makefile
content/xml/content/Makefile
content/xml/content/public/Makefile
content/xml/content/src/Makefile
content/xml/document/Makefile
content/xml/document/public/Makefile
content/xml/document/src/Makefile
content/xul/Makefile
content/xul/content/Makefile
content/xul/content/public/Makefile
content/xul/content/src/Makefile
content/xul/document/Makefile
content/xul/document/public/Makefile
content/xul/document/src/Makefile
content/xul/templates/public/Makefile
content/xul/templates/src/Makefile
content/xbl/Makefile
content/xbl/public/Makefile
content/xbl/src/Makefile
content/xbl/builtin/Makefile
content/xbl/builtin/unix/Makefile
content/xbl/builtin/win/Makefile
content/xsl/Makefile
content/xsl/public/Makefile
content/shared/Makefile
content/shared/public/Makefile
content/shared/src/Makefile
"

MAKEFILES_layout="
layout/Makefile
layout/base/Makefile
layout/base/public/Makefile
layout/base/src/Makefile
layout/base/tests/Makefile
layout/build/Makefile
layout/html/Makefile
layout/html/base/Makefile
layout/html/base/src/Makefile
layout/html/document/Makefile
layout/html/document/src/Makefile
layout/html/forms/Makefile
layout/html/forms/public/Makefile
layout/html/forms/src/Makefile
layout/html/forms/resources/locale/en-US/contents.rdf
layout/html/style/Makefile
layout/html/style/src/Makefile
layout/html/table/Makefile
layout/html/table/public/Makefile
layout/html/table/src/Makefile
layout/html/tests/Makefile
layout/tools/Makefile
layout/xul/Makefile
layout/xul/base/Makefile
layout/xul/base/public/Makefile
layout/xul/base/src/Makefile
layout/xul/base/src/tree/Makefile
layout/xul/base/src/tree/src/Makefile
layout/xul/base/src/tree/public/Makefile
"

MAKEFILES_libimg="
modules/libimg/Makefile
"

MAKEFILES_libjar="
modules/libjar/Makefile
modules/libjar/standalone/Makefile
"

MAKEFILES_libreg="
modules/libreg/Makefile
modules/libreg/include/Makefile
modules/libreg/src/Makefile
modules/libreg/standalone/Makefile
"

MAKEFILES_libpref="
modules/libpref/Makefile
modules/libpref/public/Makefile
modules/libpref/src/Makefile
"

MAKEFILES_libutil="
modules/libutil/Makefile
modules/libutil/public/Makefile
modules/libutil/src/Makefile
"

MAKEFILES_oji="
modules/oji/Makefile
modules/oji/public/Makefile
modules/oji/src/Makefile
"

MAKEFILES_plugin="
modules/plugin/Makefile
modules/plugin/base/src/Makefile
modules/plugin/base/public/Makefile
modules/plugin/samples/simple/Makefile
modules/plugin/samples/SanePlugin/Makefile
modules/plugin/samples/default/unix/Makefile
modules/plugin/tools/sdk/Makefile
modules/plugin/tools/sdk/samples/Makefile
modules/plugin/tools/sdk/samples/common/Makefile
modules/plugin/tools/sdk/samples/basic/windows/Makefile
modules/plugin/tools/sdk/samples/scriptable/windows/Makefile
modules/plugin/tools/sdk/samples/simple/Makefile
modules/plugin/tools/sdk/samples/winless/windows/Makefile
"

MAKEFILES_access_builtin="
extensions/access-builtin/Makefile
extensions/access-builtin/accessproxy/Makefile
"

MAKEFILES_netwerk="
netwerk/Makefile
netwerk/base/Makefile
netwerk/base/public/Makefile
netwerk/base/src/Makefile
netwerk/build/Makefile
netwerk/build2/Makefile
netwerk/cache/Makefile
netwerk/cache/public/Makefile
netwerk/cache/src/Makefile
netwerk/cookie/Makefile
netwerk/cookie/public/Makefile
netwerk/cookie/src/Makefile
netwerk/dns/Makefile
netwerk/dns/public/Makefile
netwerk/dns/src/Makefile
netwerk/protocol/Makefile
netwerk/protocol/about/Makefile
netwerk/protocol/about/public/Makefile
netwerk/protocol/about/src/Makefile
netwerk/protocol/data/Makefile
netwerk/protocol/data/public/Makefile
netwerk/protocol/data/src/Makefile
netwerk/protocol/file/Makefile
netwerk/protocol/file/public/Makefile
netwerk/protocol/file/src/Makefile
netwerk/protocol/ftp/Makefile
netwerk/protocol/ftp/public/Makefile
netwerk/protocol/ftp/src/Makefile
netwerk/protocol/gopher/Makefile
netwerk/protocol/gopher/src/Makefile
netwerk/protocol/http/Makefile
netwerk/protocol/http/public/Makefile
netwerk/protocol/http/src/Makefile
netwerk/protocol/jar/Makefile
netwerk/protocol/jar/public/Makefile
netwerk/protocol/jar/src/Makefile
netwerk/protocol/keyword/Makefile
netwerk/protocol/keyword/src/Makefile
netwerk/protocol/res/Makefile
netwerk/protocol/res/public/Makefile
netwerk/protocol/res/src/Makefile
netwerk/mime/Makefile
netwerk/mime/public/Makefile
netwerk/mime/src/Makefile
netwerk/socket/Makefile
netwerk/socket/base/Makefile
netwerk/streamconv/Makefile
netwerk/streamconv/converters/Makefile
netwerk/streamconv/public/Makefile
netwerk/streamconv/src/Makefile
netwerk/streamconv/test/Makefile
netwerk/test/Makefile
netwerk/testserver/Makefile
netwerk/resources/Makefile
netwerk/resources/content/contents.rdf
netwerk/resources/locale/en-US/contents.rdf
uriloader/exthandler/Makefile
intl/strres/public/Makefile
intl/locale/idl/Makefile
$MAKEFILES_js
modules/libpref/public/Makefile
"

MAKEFILES_uriloader="
uriloader/Makefile
uriloader/base/Makefile
uriloader/exthandler/Makefile
"

MAKEFILES_profile="
profile/Makefile
profile/src/Makefile
profile/public/Makefile
profile/resources/Makefile
profile/pref-migrator/Makefile
profile/pref-migrator/public/Makefile
profile/pref-migrator/src/Makefile
profile/pref-migrator/resources/Makefile
profile/defaults/Makefile
profile/dirserviceprovider/Makefile
profile/dirserviceprovider/public/Makefile
profile/dirserviceprovider/src/Makefile
"

MAKEFILES_rdf="
rdf/Makefile
rdf/base/Makefile
rdf/base/idl/Makefile
rdf/base/public/Makefile
rdf/base/src/Makefile
rdf/chrome/Makefile
rdf/chrome/build/Makefile
rdf/chrome/public/Makefile
rdf/chrome/src/Makefile
rdf/chrome/tools/Makefile
rdf/chrome/tools/chromereg/Makefile
rdf/util/Makefile
rdf/util/public/Makefile
rdf/util/src/Makefile
rdf/resources/Makefile
rdf/build/Makefile
rdf/datasource/Makefile
rdf/datasource/public/Makefile
rdf/datasource/src/Makefile
rdf/tests/Makefile
rdf/tests/localfile/Makefile
rdf/tests/rdfsink/Makefile
rdf/tests/rdfcat/Makefile
rdf/tests/rdfpoll/Makefile
"

MAKEFILES_sun_java="
sun-java/Makefile
sun-java/stubs/Makefile
sun-java/stubs/include/Makefile
sun-java/stubs/jri/Makefile
"

MAKEFILES_caps="
caps/Makefile
caps/idl/Makefile
caps/include/Makefile
caps/src/Makefile
"

MAKEFILES_view="
view/Makefile
view/public/Makefile
view/src/Makefile
"

MAKEFILES_docshell="
docshell/Makefile
docshell/base/Makefile
docshell/build/Makefile
"

MAKEFILES_webshell="
webshell/Makefile
webshell/public/Makefile
webshell/tests/Makefile
webshell/tests/viewer/Makefile
webshell/tests/viewer/public/Makefile
webshell/tests/viewer/unix/Makefile
webshell/tests/viewer/unix/gtk/Makefile
webshell/tests/viewer/unix/xlib/Makefile
"

MAKEFILES_widget="
widget/Makefile
widget/public/Makefile
widget/src/Makefile
widget/src/beos/Makefile
widget/src/build/Makefile
widget/src/gtk/Makefile
widget/src/gtksuperwin/Makefile
widget/src/gtkxtbin/Makefile
widget/src/photon/Makefile
widget/src/mac/Makefile
widget/src/cocoa/Makefile
widget/src/xlib/Makefile
widget/src/os2/Makefile
widget/src/windows/Makefile
widget/src/xlibxtbin/Makefile
widget/src/xpwidgets/Makefile
widget/src/support/Makefile
"

MAKEFILES_xpcom="
xpcom/string/Makefile
xpcom/string/obsolete/Makefile
xpcom/string/public/Makefile
xpcom/string/src/Makefile
xpcom/string/embed/Makefile
xpcom/string/embed/standalone/Makefile
xpcom/Makefile
xpcom/base/Makefile
xpcom/build/Makefile
xpcom/components/Makefile
xpcom/ds/Makefile
xpcom/glue/Makefile
xpcom/glue/standalone/Makefile
xpcom/io/Makefile
xpcom/typelib/Makefile
xpcom/reflect/Makefile
xpcom/typelib/xpt/Makefile
xpcom/typelib/xpt/public/Makefile
xpcom/typelib/xpt/src/Makefile
xpcom/typelib/xpt/tests/Makefile
xpcom/typelib/xpt/tools/Makefile
xpcom/typelib/xpidl/Makefile
xpcom/reflect/xptcall/Makefile
xpcom/reflect/xptcall/public/Makefile
xpcom/reflect/xptcall/src/Makefile
xpcom/reflect/xptcall/src/md/Makefile
xpcom/reflect/xptcall/src/md/os2/Makefile
xpcom/reflect/xptcall/src/md/test/Makefile
xpcom/reflect/xptcall/src/md/unix/Makefile
xpcom/reflect/xptcall/src/md/win32/Makefile
xpcom/reflect/xptcall/tests/Makefile
xpcom/reflect/xptinfo/Makefile
xpcom/reflect/xptinfo/public/Makefile
xpcom/reflect/xptinfo/src/Makefile
xpcom/reflect/xptinfo/tests/Makefile
xpcom/proxy/Makefile
xpcom/proxy/public/Makefile
xpcom/proxy/src/Makefile
xpcom/proxy/tests/Makefile
xpcom/sample/Makefile
xpcom/threads/Makefile
xpcom/tools/Makefile
xpcom/tools/registry/Makefile
xpcom/tools/windows/Makefile
xpcom/windbgdlg/Makefile
$MAKEFILES_libreg
$MAKEFILES_libjar
intl/unicharutil/public/Makefile
intl/uconv/public/Makefile
netwerk/base/public/Makefile
netwerk/build/Makefile
"
MAKEFILES_xpcom_obsolete="
xpcom/obsolete/Makefile
xpcom/obsolete/component/Makefile
"

MAKEFILES_xpcom_tests="
xpcom/tests/Makefile
xpcom/tests/dynamic/Makefile
xpcom/tests/services/Makefile
xpcom/tests/windows/Makefile
"

MAKEFILES_string="$MAKEFILES_xpcom"

MAKEFILES_xpinstall="
xpinstall/Makefile
xpinstall/packager/Makefile
xpinstall/packager/unix/Makefile
xpinstall/packager/windows/Makefile
xpinstall/public/Makefile
xpinstall/res/Makefile
xpinstall/src/Makefile
xpinstall/stub/Makefile
xpinstall/wizard/libxpnet/Makefile
xpinstall/wizard/libxpnet/src/Makefile
xpinstall/wizard/libxpnet/test/Makefile
xpinstall/wizard/unix/src2/Makefile
xpinstall/wizard/windows/builder/Makefile
xpinstall/wizard/windows/nsinstall/Makefile
xpinstall/wizard/windows/nsztool/Makefile
xpinstall/wizard/windows/uninstall/Makefile
xpinstall/wizard/windows/setup/Makefile
xpinstall/wizard/windows/setuprsc/Makefile
xpinstall/wizard/windows/ren8dot3/Makefile
xpinstall/wizard/windows/ds32/Makefile
xpinstall/wizard/windows/GetShortPathName/Makefile
"

MAKEFILES_xpfe="
xpfe/Makefile
xpfe/browser/Makefile
xpfe/browser/public/Makefile
xpfe/browser/src/Makefile
xpfe/browser/samples/Makefile
xpfe/browser/samples/sampleimages/Makefile
xpfe/components/Makefile
xpfe/components/shistory/Makefile
xpfe/components/shistory/public/Makefile
xpfe/components/shistory/src/Makefile
xpfe/components/bookmarks/Makefile
xpfe/components/bookmarks/public/Makefile
xpfe/components/bookmarks/src/Makefile
xpfe/components/directory/Makefile
xpfe/components/download-manager/Makefile
xpfe/components/download-manager/src/Makefile
xpfe/components/download-manager/public/Makefile
xpfe/components/download-manager/resources/mac/contents.rdf
xpfe/components/download-manager/resources/win/contents.rdf
xpfe/components/download-manager/resources/unix/contents.rdf
xpfe/components/find/Makefile
xpfe/components/find/public/Makefile
xpfe/components/find/src/Makefile
xpfe/components/filepicker/Makefile
xpfe/components/filepicker/public/Makefile
xpfe/components/filepicker/src/Makefile
xpfe/components/history/Makefile
xpfe/components/history/src/Makefile
xpfe/components/history/public/Makefile
xpfe/components/prefwindow/Makefile
xpfe/components/prefwindow/resources/Makefile
xpfe/components/prefwindow/resources/content/Makefile
xpfe/components/prefwindow/resources/content/unix/Makefile
xpfe/components/prefwindow/resources/content/win/Makefile
xpfe/components/prefwindow/resources/locale/Makefile
xpfe/components/prefwindow/resources/locale/en-US/Makefile
xpfe/components/prefwindow/resources/locale/en-US/mac/contents-platform.rdf
xpfe/components/prefwindow/resources/locale/en-US/unix/Makefile
xpfe/components/prefwindow/resources/locale/en-US/unix/contents-platform.rdf
xpfe/components/prefwindow/resources/locale/en-US/win/Makefile
xpfe/components/prefwindow/resources/locale/en-US/win/contents-platform.rdf
xpfe/components/related/Makefile
xpfe/components/related/src/Makefile
xpfe/components/related/public/Makefile
xpfe/components/search/Makefile
xpfe/components/search/datasets/Makefile
xpfe/components/search/public/Makefile
xpfe/components/search/src/Makefile
xpfe/components/sidebar/Makefile
xpfe/components/sidebar/public/Makefile
xpfe/components/sidebar/src/Makefile
xpfe/components/autocomplete/Makefile
xpfe/components/autocomplete/public/Makefile
xpfe/components/autocomplete/src/Makefile
xpfe/components/autocomplete/resources/locale/en-US/contents.rdf
xpfe/components/urlbarhistory/Makefile
xpfe/components/urlbarhistory/public/Makefile
xpfe/components/urlbarhistory/src/Makefile
xpfe/components/urlwidget/Makefile
xpfe/components/winhooks/Makefile
xpfe/components/alerts/Makefile
xpfe/components/alerts/public/Makefile
xpfe/components/alerts/src/Makefile
xpfe/components/console/Makefile
xpfe/components/resetPref/Makefile
xpfe/components/killAll/Makefile
xpfe/components/build/Makefile
xpfe/components/xremote/Makefile
xpfe/components/xremote/public/Makefile
xpfe/components/xremote/src/Makefile
xpfe/appshell/Makefile
xpfe/appshell/src/Makefile
xpfe/appshell/public/Makefile
xpfe/bootstrap/Makefile
xpfe/bootstrap/appleevents/Makefile
xpfe/browser/Makefile
xpfe/browser/src/Makefile
xpfe/browser/resources/Makefile
xpfe/browser/resources/content/Makefile
xpfe/browser/resources/content/contents-region.rdf
xpfe/browser/resources/content/contents.rdf
xpfe/browser/resources/content/mac/contents-platform.rdf
xpfe/browser/resources/content/unix/Makefile
xpfe/browser/resources/content/unix/contents-platform.rdf
xpfe/browser/resources/content/win/Makefile
xpfe/browser/resources/content/win/contents-platform.rdf
xpfe/browser/resources/locale/Makefile
xpfe/browser/resources/locale/en-US/contents-region.rdf
xpfe/browser/resources/locale/en-US/contents.rdf
xpfe/browser/resources/locale/en-US/Makefile
xpfe/browser/resources/locale/en-US/mac/contents-platform.rdf
xpfe/browser/resources/locale/en-US/unix/Makefile
xpfe/browser/resources/locale/en-US/unix/contents-platform.rdf
xpfe/browser/resources/locale/en-US/win/contents-platform.rdf
xpfe/global/Makefile
xpfe/global/buildconfig.html
xpfe/global/resources/Makefile
xpfe/global/resources/content/Makefile
xpfe/global/resources/content/contents-region.rdf
xpfe/global/resources/content/contents-platform.rdf
xpfe/global/resources/content/contents.rdf
xpfe/global/resources/content/os2/Makefile
xpfe/global/resources/content/unix/Makefile
xpfe/global/resources/locale/Makefile
xpfe/global/resources/locale/en-US/Makefile
xpfe/global/resources/locale/en-US/contents-region.rdf
xpfe/global/resources/locale/en-US/contents.rdf
xpfe/global/resources/locale/en-US/brand.dtd
xpfe/global/resources/locale/en-US/region.dtd
xpfe/global/resources/locale/en-US/mac/Makefile
xpfe/global/resources/locale/en-US/mac/contents-platform.rdf
xpfe/global/resources/locale/en-US/os2/Makefile
xpfe/global/resources/locale/en-US/os2/contents-platform.rdf
xpfe/global/resources/locale/en-US/unix/Makefile
xpfe/global/resources/locale/en-US/unix/contents-platform.rdf
xpfe/global/resources/locale/en-US/win/Makefile
xpfe/global/resources/locale/en-US/win/contents-platform.rdf
xpfe/communicator/Makefile
xpfe/communicator/resources/Makefile
xpfe/communicator/resources/locale/Makefile
xpfe/communicator/resources/locale/en-US/Makefile
xpfe/communicator/resources/locale/en-US/contents-region.rdf
xpfe/communicator/resources/locale/en-US/contents.rdf
xpfe/communicator/resources/locale/en-US/mac/contents-platform.rdf
xpfe/communicator/resources/locale/en-US/win/contents-platform.rdf
xpfe/communicator/resources/locale/en-US/unix/contents-platform.rdf
xpfe/communicator/resources/content/Makefile
xpfe/communicator/resources/content/contents-region.rdf
xpfe/communicator/resources/content/contents-platform.rdf
xpfe/communicator/resources/content/contents.rdf
xpfe/communicator/resources/content/unix/Makefile
xpfe/communicator/resources/content/win/Makefile
"

MAKEFILES_embedding="
embedding/Makefile
embedding/base/Makefile
embedding/browser/Makefile
embedding/browser/activex/src/Makefile
embedding/browser/activex/src/control/Makefile
embedding/browser/activex/src/control_kicker/Makefile
embedding/browser/build/Makefile
embedding/browser/chrome/Makefile
embedding/browser/webBrowser/Makefile
embedding/browser/gtk/Makefile
embedding/browser/gtk/src/Makefile
embedding/browser/gtk/tests/Makefile
embedding/browser/photon/Makefile
embedding/browser/photon/src/Makefile
embedding/browser/photon/tests/Makefile
embedding/browser/cocoa/Makefile
embedding/components/Makefile
embedding/components/build/Makefile
embedding/components/windowwatcher/Makefile
embedding/components/windowwatcher/public/Makefile
embedding/components/windowwatcher/src/Makefile
embedding/components/ui/Makefile
embedding/components/ui/helperAppDlg/Makefile
embedding/components/ui/progressDlg/Makefile
embedding/config/Makefile
embedding/tests/Makefile
embedding/tests/cocoaEmbed/Makefile
embedding/tests/winEmbed/Makefile
embedding/tests/mfcembed/Makefile
embedding/tests/mfcembed/components/Makefile
"

MAKEFILES_minimo="
embedding/minimo/Makefile
embedding/minimo/chromelite/Makefile
"

MAKEFILES_psm2="
security/manager/Makefile
security/manager/boot/Makefile
security/manager/boot/src/Makefile
security/manager/boot/public/Makefile
security/manager/ssl/Makefile
security/manager/ssl/src/Makefile
security/manager/ssl/resources/Makefile
security/manager/ssl/public/Makefile
security/manager/ssl/resources/content/contents.rdf
security/manager/ssl/resources/locale/en-US/contents.rdf
security/manager/pki/Makefile
security/manager/pki/resources/Makefile
security/manager/pki/src/Makefile
security/manager/pki/public/Makefile
security/manager/pki/resources/content/contents.rdf
security/manager/pki/resources/locale/en-US/contents.rdf
netwerk/protocol/http/public/Makefile
netwerk/build/Makefile
netwerk/base/public/Makefile
netwerk/socket/base/Makefile
uriloader/base/Makefile
intl/locale/idl/Makefile
intl/strres/public/Makefile
dom/public/Makefile
dom/public/base/Makefile
rdf/base/idl/Makefile
xpfe/appshell/public/Makefile
caps/idl/Makefile
layout/html/forms/public/Makefile
gfx/public/Makefile
gfx/idl/Makefile
widget/public/Makefile
layout/base/public/Makefile
docshell/base/Makefile
modules/libpref/public/Makefile
content/base/public/Makefile
intl/locale/public/Makefile
"

MAKEFILES_inspector="
extensions/inspector/Makefile
extensions/inspector/base/Makefile
extensions/inspector/base/public/Makefile
extensions/inspector/base/src/Makefile
extensions/inspector/build/Makefile
extensions/inspector/build/src/Makefile
extensions/inspector/resources/Makefile
extensions/inspector/resources/content/contents.rdf
extensions/inspector/resources/locale/en-US/contents.rdf
"

MAKEFILES_transformiix="
extensions/transformiix/source/base/Makefile
extensions/transformiix/source/main/Makefile
extensions/transformiix/source/xml/dom/standalone/Makefile
extensions/transformiix/source/xml/dom/Makefile
extensions/transformiix/source/xml/parser/Makefile
extensions/transformiix/source/xml/Makefile
extensions/transformiix/source/xpath/Makefile
extensions/transformiix/source/xslt/functions/Makefile
extensions/transformiix/source/xslt/util/Makefile
extensions/transformiix/source/xslt/Makefile
extensions/transformiix/source/Makefile
extensions/transformiix/Makefile
extensions/transformiix/resources/Makefile
extensions/transformiix/resources/buster/contents.rdf
"

MAKEFILES_tridentprofile="
extensions/tridentprofile/Makefile
extensions/tridentprofile/public/Makefile
extensions/tridentprofile/resources/Makefile
extensions/tridentprofile/src/Makefile
extensions/tridentprofile/resources/content/contents.rdf
extensions/tridentprofile/resources/locale/en-US/contents.rdf
"

MAKEFILES_typeaheadfind="
extensions/typeaheadfind/public/Makefile
extensions/typeaheadfind/resources/Makefile
extensions/typeaheadfind/src/Makefile
extensions/typeaheadfind/Makefile
"

MAKEFILES_phoenix="
browser/Makefile
browser/app/Makefile
browser/app/profile/Makefile
browser/app/profile/chrome/Makefile
browser/base/Makefile
browser/components/Makefile
browser/components/bookmarks/Makefile
browser/components/bookmarks/public/Makefile
browser/components/bookmarks/src/Makefile
browser/components/build/Makefile
browser/components/cookieviewer/Makefile
browser/components/downloads/Makefile
browser/components/downloads/public/Makefile
browser/components/downloads/src/Makefile
browser/components/history/Makefile
browser/components/prefwindow/Makefile
browser/components/prefwindow/content/Makefile
browser/components/prefwindow/locale/Makefile
browser/components/security/Makefile
browser/components/sidebar/Makefile
browser/components/sidebar/public/Makefile
browser/components/sidebar/src/Makefile
browser/extensions/inspector/content/contents.rdf
"

MAKEFILES_xulapp="
chrome/Makefile
chrome/public/Makefile
chrome/src/Makefile
chrome/tools/Makefile
chrome/tools/chromereg/Makefile
toolkit/Makefile
toolkit/content/Makefile
toolkit/content/buildconfig.html
toolkit/locale/Makefile
toolkit/obsolete/Makefile
toolkit/components/autocomplete/Makefile
toolkit/components/autocomplete/public/Makefile
toolkit/components/autocomplete/src/Makefile
toolkit/components/Makefile
toolkit/components/build/Makefile
toolkit/components/console/Makefile
toolkit/components/filepicker/Makefile
toolkit/components/history/Makefile
toolkit/components/history/public/Makefile
toolkit/components/history/src/Makefile
toolkit/components/passwordmgr/Makefile
toolkit/components/passwordmgr/base/Makefile
toolkit/components/passwordmgr/resources/Makefile
toolkit/components/printing/Makefile
toolkit/components/satchel/Makefile
toolkit/components/satchel/public/Makefile
toolkit/components/satchel/src/Makefile
toolkit/components/viewconfig/Makefile
toolkit/components/viewsource/Makefile
toolkit/mozapps/Makefile
toolkit/mozapps/downloads/Makefile
toolkit/mozapps/installer/Makefile
toolkit/mozapps/installer/windows/Makefile
toolkit/mozapps/installer/windows/wizard/Makefile
toolkit/mozapps/installer/windows/wizard/setup/Makefile
toolkit/mozapps/installer/windows/wizard/setuprsc/Makefile
toolkit/mozapps/installer/windows/wizard/uninstall/Makefile
toolkit/skin/mac/Makefile
toolkit/skin/unix/Makefile
toolkit/skin/win/Makefile
toolkit/xre/Makefile
toolkit/content/contents-platform.rdf
toolkit/content/contents-region.rdf
toolkit/content/contents.rdf
toolkit/locale/contents-platform.rdf
toolkit/locale/contents-region.rdf
toolkit/locale/contents.rdf
toolkit/components/passwordmgr/resources/content/contents.rdf
toolkit/components/passwordmgr/resources/locale/contents.rdf
toolkit/mozapps/contents-content.rdf
toolkit/mozapps/contents-locale.rdf
"


MAKEFILES_thunderbird="
mail/Makefile
mail/app/Makefile
mail/app/profile/Makefile
mail/base/Makefile
mail/components/Makefile
mail/components/compose/Makefile
mail/components/addrbook/Makefile
mail/components/prefwindow/Makefile
mail/extensions/Makefile
mail/extensions/smime/Makefile
mail/extensions/offline/Makefile
mail/extensions/inspector/Makefile
mail/config/Makefile
xpfe/components/build2/Makefile
mail/base/content/contents.rdf
mail/base/content/help.rdf
mail/base/content/messenger-views.rdf
mail/base/content/navigator.rdf
mail/extensions/offline/content/contents.rdf
mail/extensions/offline/locale/contents.rdf
mail/extensions/inspector/content/contents.rdf
"

MAKEFILES_standalone_composer="
composer/Makefile
composer/app/Makefile
composer/app/profile/Makefile
composer/base/Makefile
xpfe/components/build2/Makefile
"

MAKEFILES_sql="
extensions/sql/Makefile
extensions/sql/base/Makefile
extensions/sql/base/public/Makefile
extensions/sql/base/src/Makefile
extensions/sql/base/resources/Makefile
extensions/sql/pgsql/public/Makefile
extensions/sql/pgsql/src/Makefile
extensions/sql/build/Makefile
extensions/sql/build/src/Makefile
extensions/sql/sqltest/Makefile
extensions/sql/tests/Makefile
"

if [ "$MOZ_MAIL_NEWS" ]; then
    if [ -f ${srcdir}/mailnews/makefiles ]; then
        MAKEFILES_mailnews=`cat ${srcdir}/mailnews/makefiles`
    fi
fi

MAKEFILES_ipcd="
ipc/ipcd/Makefile
ipc/ipcd/daemon/public/Makefile
ipc/ipcd/daemon/src/Makefile
ipc/ipcd/client/public/Makefile
ipc/ipcd/client/src/Makefile
ipc/ipcd/shared/src/Makefile
ipc/ipcd/test/Makefile
ipc/ipcd/test/module/Makefile
ipc/ipcd/extensions/Makefile
ipc/ipcd/extensions/lock/Makefile
ipc/ipcd/extensions/lock/public/Makefile
ipc/ipcd/extensions/lock/src/Makefile
ipc/ipcd/extensions/lock/src/module/Makefile
ipc/ipcd/util/Makefile
ipc/ipcd/util/public/Makefile
ipc/ipcd/util/src/Makefile
"

MAKEFILES_transmngr="
ipc/ipcd/extensions/transmngr/Makefile
ipc/ipcd/extensions/transmngr/public/Makefile
ipc/ipcd/extensions/transmngr/src/Makefile
ipc/ipcd/extensions/transmngr/build/Makefile
ipc/ipcd/extensions/transmngr/test/Makefile
ipc/ipcd/extensions/transmngr/common/Makefile
ipc/ipcd/extensions/transmngr/module/Makefile
"

MAKEFILES_profilesharingsetup="
embedding/components/profilesharingsetup/Makefile
embedding/components/profilesharingsetup/public/Makefile
embedding/components/profilesharingsetup/src/Makefile
"

    MAKEFILES_libpr0n="
        modules/libpr0n/Makefile
        modules/libpr0n/public/Makefile
        modules/libpr0n/src/Makefile
        modules/libpr0n/decoders/Makefile
        modules/libpr0n/decoders/gif/Makefile
        modules/libpr0n/decoders/png/Makefile
        modules/libpr0n/decoders/jpeg/Makefile
        modules/libpr0n/decoders/bmp/Makefile
        modules/libpr0n/decoders/icon/Makefile
        modules/libpr0n/decoders/icon/win/Makefile
        modules/libpr0n/decoders/xbm/Makefile
"

    MAKEFILES_accessible="
       accessible/Makefile
       accessible/public/Makefile
       accessible/public/msaa/Makefile
       accessible/src/Makefile
       accessible/src/base/Makefile
       accessible/src/html/Makefile
       accessible/src/xul/Makefile
       accessible/src/msaa/Makefile
       accessible/src/atk/Makefile
       accessible/src/mac/Makefile
       accessible/build/Makefile
"

if [ ! "$SYSTEM_JPEG" ]; then
    MAKEFILES_jpeg="jpeg/Makefile"
fi

if [ ! "$SYSTEM_ZLIB" ]; then
    MAKEFILES_zlib="
	modules/zlib/Makefile
	modules/zlib/src/Makefile
"
fi

MAKEFILES_zlib="
    $MAKEFILES_zlib
    modules/zlib/standalone/Makefile
"


if [ ! "$SYSTEM_PNG" ]; then
    MAKEFILES_libimg="$MAKEFILES_libimg modules/libimg/png/Makefile"
fi

#
# l10n/
#
if [ -f ${srcdir}/l10n/makefiles.all ]; then
    MAKEFILES_langpacks=`cat ${srcdir}/l10n/makefiles.all`
fi

if [ "$MOZ_L10N" ]; then
    MAKEFILES_l10n="l10n/Makefile"

    if [ "$MOZ_L10N_LANG" ]; then
	MAKEFILES_l10n_lang="
		l10n/lang/Makefile
		l10n/lang/addressbook/Makefile
		l10n/lang/bookmarks/Makefile
		l10n/lang/directory/Makefile
		l10n/lang/editor/Makefile
		l10n/lang/global/Makefile
		l10n/lang/history/Makefile
		l10n/lang/messenger/Makefile
		l10n/lang/messengercompose/Makefile
		l10n/lang/navigator/Makefile
		l10n/lang/pref/Makefile
		l10n/lang/related/Makefile
		l10n/lang/sidebar/Makefile
		l10n/lang/addressbook/locale/Makefile
		l10n/lang/bookmarks/locale/Makefile
		l10n/lang/directory/locale/Makefile
		l10n/lang/editor/locale/Makefile
		l10n/lang/global/locale/Makefile
		l10n/lang/history/locale/Makefile
		l10n/lang/messenger/locale/Makefile
		l10n/lang/messengercompose/locale/Makefile
		l10n/lang/navigator/locale/Makefile
		l10n/lang/pref/locale/Makefile
		l10n/lang/related/locale/Makefile
		l10n/lang/sidebar/locale/Makefile
"
	fi
fi

# tools/jprof
if [ "$MOZ_JPROF" ]; then
    MAKEFILES_jprof="tools/jprof/Makefile
        tools/jprof/stub/Makefile"
fi

# tools/leaky
if [ "$MOZ_LEAKY" ]; then
    MAKEFILES_leaky="tools/leaky/Makefile"
fi

# tools/trace-malloc
if [ "$NS_TRACE_MALLOC" ]; then
    MAKEFILES_tracemalloc="tools/trace-malloc/Makefile tools/trace-malloc/lib/Makefile"
fi

# tools/codesighs
if [ "$MOZ_MAPINFO" ]; then
    MAKEFILES_codesighs="tools/codesighs/Makefile"
fi

# MathML
if [ "$MOZ_MATHML" ]; then
    MAKEFILES_intl="$MAKEFILES_intl
	intl/uconv/ucvmath/Makefile
"
    MAKEFILES_layout="$MAKEFILES_layout
	layout/mathml/Makefile
	layout/mathml/base/Makefile
	layout/mathml/base/src/Makefile
	layout/mathml/content/Makefile
	layout/mathml/content/src/Makefile
"
fi

#libart
if [ "$MOZ_INTERNAL_LIBART_LGPL" ]; then
    MAKEFILES_libart="other-licenses/libart_lgpl/Makefile"
fi

# svg
if [ "$MOZ_SVG" ]; then
    MAKEFILES_content="$MAKEFILES_content
	content/svg/Makefile
	content/svg/document/Makefile
	content/svg/document/src/Makefile
	content/svg/content/Makefile
	content/svg/content/src/Makefile
"
    MAKEFILES_dom="$MAKEFILES_dom
	dom/public/idl/svg/Makefile
"
    MAKEFILES_layout="$MAKEFILES_layout
	layout/svg/Makefile
	layout/svg/base/Makefile
	layout/svg/base/src/Makefile
"
fi

# directory/xpcom
if [ "$MOZ_LDAP_XPCOM" ]; then
    MAKEFILES_ldap="
	directory/xpcom/Makefile
	directory/xpcom/base/Makefile
	directory/xpcom/base/public/Makefile
	directory/xpcom/base/src/Makefile
	directory/xpcom/base/resources/content/contents.rdf
	directory/xpcom/base/resources/locale/en-US/contents.rdf
"
fi

# embedding/componentlib

if [ "$MOZ_COMPONENTLIB" ]; then
    MAKEFILES_static_components="$MAKEFILE_static_components
	embedding/componentlib/Makefile
"

else

# modules/staticmod

if [ "$MOZ_STATIC_COMPONENTS" -o "$MOZ_META_COMPONENTS" ]; then
    MAKEFILES_static_components="$MAKEFILES_static_components
	modules/staticmod/Makefile
"
fi
fi

for extension in $MOZ_EXTENSIONS; do
    case "$extension" in
        access-builtin ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/access-builtin/Makefile
            extensions/access-builtin/accessproxy/Makefile
            " ;;
        content-packs ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/content-packs/Makefile
            extensions/content-packs/resources/Makefile
            extensions/content-packs/resources/content/contents.rdf
            extensions/content-packs/resources/locale/en-US/contents.rdf
            " ;;
        cookie ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/cookie/Makefile
            extensions/cookie/resources/content/contents.rdf
            extensions/cookie/resources/locale/en-US/contents.rdf
            " ;;
        cview ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/cview/Makefile
            extensions/cview/resources/Makefile
            " ;;
        datetime ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/datetime/Makefile
            " ;;
        finger ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/finger/Makefile
            " ;;
        help ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/help/Makefile
            extensions/help/resources/Makefile
            extensions/help/resources/content/contents.rdf
            extensions/help/resources/locale/en-US/contents.rdf
            " ;;
        inspector ) MAKEFILES_extensions="$MAKEFILES_extensions
            $MAKEFILES_inspector"
            ;;
        typeaheadfind ) MAKEFILES_extensions="$MAKEFILES_extensions
            $MAKEFILES_typeaheadfind"
            ;;
        irc ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/irc/Makefile
            extensions/irc/xul/content/contents.rdf
            extensions/irc/xul/locale/en-US/contents.rdf
            " ;;
        layout-debug ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/layout-debug/Makefile
            extensions/layout-debug/src/Makefile
            extensions/layout-debug/ui/Makefile
            " ;;
        p3p ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/p3p/Makefile
            extensions/p3p/public/Makefile
            extensions/p3p/src/Makefile
            extensions/p3p/resources/content/contents.rdf
            extensions/p3p/resources/locale/en-US/contents.rdf
            " ;;
        pics ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/pics/Makefile
            extensions/pics/public/Makefile
            extensions/pics/src/Makefile
            extensions/pics/tests/Makefile
            " ;;
        pref ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/pref/Makefile
            extensions/pref/autoconfig/Makefile
            extensions/pref/autoconfig/public/Makefile
            extensions/pref/autoconfig/src/Makefile
            extensions/pref/autoconfig/resources/Makefile
            extensions/pref/autoconfig/resources/content/contents.rdf
            extensions/pref/autoconfig/resources/locale/en-US/contents.rdf
            " ;;
        spellcheck ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/spellcheck/Makefile
            extensions/spellcheck/idl/Makefile
            extensions/spellcheck/myspell/Makefile
            extensions/spellcheck/myspell/dictionaries/Makefile
            extensions/spellcheck/src/Makefile
            " ;;
        tasks ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/tasks/Makefile
            extensions/tasks/resources/content/contents.rdf
            extensions/tasks/resources/locale/en-US/contents.rdf
            " ;;
        transformiix ) MAKEFILES_extensions="$MAKEFILES_extensions
            $MAKEFILES_transformiix"
            ;;
        tridentprofile ) MAKEFILES_extensions="$MAKEFILES_extensions
            $MAKEFILES_tridentprofile"
            ;;
        universalchardet ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/universalchardet/Makefile
            extensions/universalchardet/src/Makefile
            extensions/universalchardet/tests/Makefile
            " ;;
        venkman ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/venkman/Makefile
            extensions/venkman/resources/Makefile
            extensions/venkman/resources/content/contents.rdf
            extensions/venkman/resources/locale/en-US/contents.rdf
            " ;;
        wallet ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/wallet/Makefile
            extensions/wallet/public/Makefile
            extensions/wallet/src/Makefile
            extensions/wallet/editor/Makefile
            extensions/wallet/signonviewer/Makefile
            extensions/wallet/walletpreview/Makefile
            extensions/wallet/build/Makefile
            extensions/wallet/resources/content/contents.rdf
            extensions/wallet/resources/locale/en-US/contents.rdf
            " ;;
        webservices ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/webservices/Makefile
            extensions/webservices/build/Makefile
            extensions/webservices/build/src/Makefile
            extensions/webservices/interfaceinfo/Makefile
            extensions/webservices/interfaceinfo/src/Makefile
            extensions/webservices/proxy/Makefile
            extensions/webservices/proxy/src/Makefile
            extensions/webservices/public/Makefile
            extensions/webservices/security/Makefile
            extensions/webservices/security/src/Makefile
            extensions/webservices/schema/Makefile
            extensions/webservices/schema/src/Makefile
            extensions/webservices/soap/Makefile
            extensions/webservices/soap/src/Makefile
            extensions/webservices/wsdl/Makefile
            extensions/webservices/wsdl/src/Makefile
            " ;;
        xmlextras ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/xmlextras/Makefile
            extensions/xmlextras/base/Makefile
            extensions/xmlextras/base/src/Makefile
            extensions/xmlextras/base/public/Makefile
            extensions/xmlextras/pointers/Makefile
            extensions/xmlextras/pointers/src/Makefile
            extensions/xmlextras/build/Makefile
            extensions/xmlextras/build/src/Makefile
            " ;;
        xml-rpc ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/xml-rpc/Makefile
            extensions/xml-rpc/idl/Makefile
            extensions/xml-rpc/src/Makefile
            " ;;
        xmlterm ) MAKEFILES_extensions="$MAKEFILES_extensions
            extensions/xmlterm/Makefile
            extensions/xmlterm/base/Makefile
            extensions/xmlterm/geckoterm/Makefile
            extensions/xmlterm/linetest/Makefile
            extensions/xmlterm/scripts/Makefile
            extensions/xmlterm/tests/Makefile
            extensions/xmlterm/ui/Makefile
            " ;;
        sql ) MAKEFILES_extensions="$MAKEFILES_extensions
            $MAKEFILES_sql"
            ;;
    esac
done


#
# Translate from BUILD_MODULES into the proper makefiles list
#
if [ "$BUILD_MODULES" = "all" ]; then

MAKEFILES_themes=`cat ${srcdir}/themes/makefiles`

MAKEFILES_calendar="
        calendar/Makefile
        calendar/libxpical/Makefile
        calendar/resources/Makefile
	other-licenses/libical/Makefile
	other-licenses/libical/src/Makefile
	other-licenses/libical/src/libical/Makefile
	other-licenses/libical/src/libicalss/Makefile
       "

add_makefiles "
$MAKEFILES_caps
$MAKEFILES_db
$MAKEFILES_dbm
$MAKEFILES_docshell
$MAKEFILES_dom
$MAKEFILES_editor
$MAKEFILES_codesighs
$MAKEFILES_composer
$MAKEFILES_embedding
$MAKEFILES_expat
$MAKEFILES_extensions
$MAKEFILES_gc
$MAKEFILES_gfx
$MAKEFILES_accessible
$MAKEFILES_htmlparser
$MAKEFILES_intl
$MAKEFILES_java_supplement
$MAKEFILES_ldap
$MAKEFILES_leaky
$MAKEFILES_jpeg
$MAKEFILES_jprof
$MAKEFILES_js
$MAKEFILES_jsdebugger
$MAKEFILES_l10n
$MAKEFILES_l10n_lang
$MAKEFILES_langpacks
$MAKEFILES_content
$MAKEFILES_layout
$MAKEFILES_libart
$MAKEFILES_libreg
$MAKEFILES_libimg
$MAKEFILES_libpr0n
$MAKEFILES_libjar
$MAKEFILES_libpref
$MAKEFILES_libutil
$MAKEFILES_liveconnect
$MAKEFILES_macmorefiles
$MAKEFILES_mailnews
$MAKEFILES_oji
$MAKEFILES_plugin
$MAKEFILES_netwerk
$MAKEFILES_profile
$MAKEFILES_rdf
$MAKEFILES_static_components
$MAKEFILES_sun_java
$MAKEFILES_themes
$MAKEFILES_tracemalloc
$MAKEFILES_uriloader
$MAKEFILES_view
$MAKEFILES_webshell
$MAKEFILES_widget
$MAKEFILES_xft
$MAKEFILES_xpcom
$MAKEFILES_xpcom_obsolete
$MAKEFILES_xpcom_tests
$MAKEFILES_xpconnect
$MAKEFILES_xpinstall
$MAKEFILES_xpfe
$MAKEFILES_zlib
"

if test -n "$MOZ_PSM"; then
    add_makefiles "$MAKEFILES_psm2"
fi

if test -n "$MOZ_CALENDAR"; then
    add_makefiles "$MAKEFILES_calendar"
fi

if test -n "$MOZ_PHOENIX"; then
    add_makefiles "$MAKEFILES_phoenix"
fi

if test -n "$MOZ_XUL_APP"; then
    add_makefiles "$MAKEFILES_xulapp"
fi

if test -n "$MOZ_THUNDERBIRD"; then
    add_makefiles "$MAKEFILES_thunderbird"
fi

if test -n "$MOZ_STANDALONE_COMPOSER"; then
    add_makefiles "$MAKEFILES_standalone_composer"
fi

if test -n "$MOZ_IPCD"; then
    add_makefiles "$MAKEFILES_ipcd"
fi

if test -n "$MOZ_PROFILESHARING"; then
    add_makefiles "$MAKEFILES_transmngr"
    add_makefiles "$MAKEFILES_profilesharingsetup"
fi

if test -n "$MINIMO"; then
    add_makefiles "$MAKEFILES_minimo"
fi

else

# Standalone modules go here

MAKEFILES_TestStreamConv="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile netwerk/streamconv/test/Makefile"

MAKEFILES_TestXPC="js/src/xpconnect/tests/idl/Makefile js/src/fdlibm/Makefile js/src/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile js/src/xpconnect/Makefile js/src/xpconnect/tests/Makefile"

MAKEFILES_TestXPTC="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile xpcom/reflect/xptcall/tests/Makefile"

MAKEFILES_accessibility="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile accessible/Makefile"

MAKEFILES_addrbook="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile"

MAKEFILES_appcomps="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile"

MAKEFILES_apprunner="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile modules/libreg/Makefile xpinstall/Makefile xpfe/bootstrap/Makefile"

MAKEFILES_appshell="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile"

MAKEFILES_autoconfig="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile extensions/pref/autoconfig/Makefile"

MAKEFILES_bayesflt="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/extensions/bayesian-spam-filter/Makefile"

MAKEFILES_browser="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile"

MAKEFILES_calendar="other-licenses/libical/src/libical/Makefile modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile other-licenses/libical/src/libicalss/Makefile calendar/Makefile"

MAKEFILES_caps="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile"

MAKEFILES_chardet="webshell/public/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile intl/unicharutil/Makefile intl/uconv/Makefile intl/locale/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile"

MAKEFILES_chrome="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile"

MAKEFILES_commandhandler="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile intl/unicharutil/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile embedding/components/ui/helperAppDlg/Makefile docshell/Makefile embedding/base/Makefile embedding/components/commandhandler/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile uriloader/exthandler/Makefile content/xul/document/Makefile"

MAKEFILES_composer="editor/composer/public/Makefile"

MAKEFILES_content="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile"

MAKEFILES_cookie="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/cookie/Makefile"

MAKEFILES_dbm="dbm/Makefile"

MAKEFILES_docshell="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile view/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile embedding/components/webbrowserpersist/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile"

MAKEFILES_dom="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile"

MAKEFILES_downloadmanager="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/ui/progressDlg/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/components/download-manager/Makefile"

MAKEFILES_editor="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile editor/composer/public/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile editor/txtsvc/Makefile editor/Makefile"

MAKEFILES_embed_base="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile embedding/base/Makefile"

MAKEFILES_embed_lite="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile embedding/components/find/Makefile rdf/util/Makefile rdf/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/public/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txmgr/Makefile editor/txtsvc/Makefile ipc/ipcd/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/lite/Makefile"

MAKEFILES_embedcomponents="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile"

MAKEFILES_embedstring="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile"

MAKEFILES_expat="expat/Makefile"

MAKEFILES_exthandler="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile intl/unicharutil/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile embedding/components/ui/helperAppDlg/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile uriloader/exthandler/Makefile"

MAKEFILES_filepicker="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile accessible/Makefile layout/Makefile xpfe/components/filepicker/Makefile"

MAKEFILES_find="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile"

MAKEFILES_gfx="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile"

MAKEFILES_gtkembedmoz="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile accessible/Makefile embedding/browser/gtk/Makefile"

MAKEFILES_gtkembedmoz_wrapper="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile accessible/Makefile embedding/browser/gtk/Makefile modules/libpr0n/decoders/png/Makefile modules/libpr0n/decoders/jpeg/Makefile"

MAKEFILES_gtkxtbin="widget/src/gtkxtbin/Makefile"

MAKEFILES_helperAppDlg="embedding/components/ui/helperAppDlg/Makefile"

MAKEFILES_history="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile embedding/components/find/Makefile rdf/util/Makefile rdf/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/public/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txmgr/Makefile editor/txtsvc/Makefile ipc/ipcd/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile"

MAKEFILES_htmlparser="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile gfx/src/xprintutil/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile uriloader/base/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile"

MAKEFILES_i18n="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/build/Makefile"

MAKEFILES_ical="other-licenses/libical/src/libical/Makefile"

MAKEFILES_icalss="other-licenses/libical/src/libical/Makefile other-licenses/libical/src/libicalss/Makefile"

MAKEFILES_imgbmp="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile modules/libpr0n/decoders/bmp/Makefile"

MAKEFILES_imggif="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile modules/libpr0n/decoders/gif/Makefile"

MAKEFILES_imgjpeg="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile modules/libpr0n/decoders/jpeg/Makefile"

MAKEFILES_imglib2="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile"

MAKEFILES_imgpng="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile modules/libpr0n/decoders/png/Makefile"

MAKEFILES_imgxbm="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile modules/libpr0n/decoders/xbm/Makefile"

MAKEFILES_impComm4xMail="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/import/Makefile mailnews/import/comm4x/Makefile"

MAKEFILES_impText="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile modules/zlib/Makefile modules/libimg/png/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/import/text/src/Makefile"

MAKEFILES_import="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/import/Makefile"

MAKEFILES_inspector="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/inspector/Makefile"

MAKEFILES_intl="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile"

MAKEFILES_ipcd="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile ipc/ipcd/Makefile"

MAKEFILES_ipcd_test="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile ipc/ipcd/Makefile ipc/ipcd/test/Makefile"

MAKEFILES_jar="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libjar/Makefile"

MAKEFILES_java="sun-java/Makefile"

MAKEFILES_jpeg="jpeg/Makefile"

MAKEFILES_js="js/src/fdlibm/Makefile js/src/Makefile"

MAKEFILES_jsconsole="embedding/components/jsconsole/public/Makefile"

MAKEFILES_jsdebug="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile js/jsd/Makefile"

MAKEFILES_jsloader="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile js/src/xpconnect/loader/Makefile"

MAKEFILES_jsurl="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/Makefile dom/src/jsurl/Makefile"

MAKEFILES_layout="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile accessible/Makefile layout/Makefile"

MAKEFILES_layout_debug="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/layout-debug/Makefile"

MAKEFILES_libart_lgpl="other-licenses/libart_lgpl/Makefile"

MAKEFILES_libreg="modules/libreg/Makefile"

MAKEFILES_liveconnect="js/src/fdlibm/Makefile js/src/Makefile sun-java/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile modules/libjar/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile js/src/liveconnect/Makefile"

MAKEFILES_locale="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile"

MAKEFILES_lwbrk="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile"

MAKEFILES_macmorefiles="xpcom/MoreFiles/Makefile"

MAKEFILES_mailnews="mailnews/public/Makefile"

MAKEFILES_mailview="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile mailnews/public/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/extensions/mailviews/Makefile"

MAKEFILES_mime="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile intl/unicharutil/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile embedding/components/ui/helperAppDlg/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile uriloader/exthandler/Makefile mailnews/public/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile"

MAKEFILES_mimeemitter="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/mime/emitters/src/Makefile mailnews/mime/emitters/build/Makefile"

MAKEFILES_mimemitter="mailnews/mime/emitters/Makefile"

MAKEFILES_mimetype="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile netwerk/mime/Makefile"

MAKEFILES_mork="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile"

MAKEFILES_mozldap="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile directory/xpcom/base/Makefile"

MAKEFILES_msgbase="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile mailnews/public/Makefile mailnews/compose/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/import/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/Makefile"

MAKEFILES_msgbaseutil="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile"

MAKEFILES_msgcompose="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/compose/Makefile"

MAKEFILES_msgdb="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile netwerk/cache/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/compose/Makefile mailnews/local/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile"

MAKEFILES_msgimap="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/local/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/imap/Makefile"

MAKEFILES_msglocal="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/local/Makefile"

MAKEFILES_msgmdn="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/local/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/imap/Makefile mailnews/extensions/mdn/Makefile"

MAKEFILES_msgnews="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/util/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile"

MAKEFILES_msgsmime="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile security/manager/ssl/Makefile mailnews/public/Makefile mailnews/compose/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/import/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/base/Makefile mailnews/extensions/smime/Makefile"

MAKEFILES_myspell="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/spellcheck/Makefile extensions/spellcheck/myspell/Makefile"

MAKEFILES_necko="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile"

MAKEFILES_necko2="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile"

MAKEFILES_nkcache="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile"

MAKEFILES_nkdatetime="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile extensions/datetime/Makefile"

MAKEFILES_nkfinger="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile extensions/finger/Makefile"

MAKEFILES_npsimple="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile embedding/components/find/Makefile rdf/util/Makefile rdf/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/public/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txmgr/Makefile editor/txtsvc/Makefile ipc/ipcd/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile modules/plugin/samples/simple/Makefile"

MAKEFILES_offlinestartup="xpcom/Makefile netwerk/Makefile intl/strres/Makefile mailnews/extensions/offline-startup/Makefile mailnews/extensions/offline-startup/resources/Makefile"

MAKEFILES_oji="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile modules/libjar/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile js/src/liveconnect/Makefile modules/oji/Makefile"

MAKEFILES_p3p="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/cookie/Makefile extensions/xmlextras/Makefile extensions/p3p/Makefile"

MAKEFILES_plugin="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile embedding/components/find/Makefile rdf/util/Makefile rdf/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/public/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txmgr/Makefile editor/txtsvc/Makefile ipc/ipcd/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile"

MAKEFILES_png="modules/zlib/Makefile modules/libimg/png/Makefile"

MAKEFILES_pref="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile netwerk/cache/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile"

MAKEFILES_prefetch="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile uriloader/prefetch/Makefile"

MAKEFILES_prefmigr="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/pref-migrator/Makefile"

MAKEFILES_profdirserviceprovider="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile ipc/ipcd/Makefile profile/dirserviceprovider/Makefile"

MAKEFILES_profile="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/profilesharingsetup/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile ipc/ipcd/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile profile/dirserviceprovider/Makefile profile/pref-migrator/Makefile profile/Makefile"

MAKEFILES_profilesharingsetup="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile embedding/components/profilesharingsetup/Makefile"

MAKEFILES_progressDlg="embedding/components/ui/progressDlg/Makefile"

MAKEFILES_rdf="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile rdf/util/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile expat/Makefile htmlparser/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile"

MAKEFILES_rdfutil="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile expat/Makefile htmlparser/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile rdf/util/Makefile"

MAKEFILES_shistory="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile xpfe/components/shistory/Makefile"

MAKEFILES_sidebar="xpfe/components/sidebar/public/Makefile"

MAKEFILES_spellchecker="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/spellcheck/Makefile"

MAKEFILES_string="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile"

MAKEFILES_svg_doc="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile content/svg/document/src/Makefile"

MAKEFILES_test_necko="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile modules/libutil/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile netwerk/test/Makefile"

MAKEFILES_tm_test="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/strres/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile ipc/ipcd/Makefile ipc/ipcd/extensions/transmngr/test/Makefile"

MAKEFILES_transformiix="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile extensions/transformiix/Makefile"

MAKEFILES_txmgr="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile editor/txmgr/Makefile"

MAKEFILES_txtsvc="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile editor/txtsvc/Makefile"

MAKEFILES_typeaheadfind="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile extensions/typeaheadfind/Makefile"

MAKEFILES_ucnative="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/Makefile intl/uconv/native/Makefile"

MAKEFILES_uconv="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile"

MAKEFILES_ucvcn="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvcn/Makefile"

MAKEFILES_ucvibm="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvibm/Makefile"

MAKEFILES_ucvja="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvja/Makefile"

MAKEFILES_ucvko="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvko/Makefile"

MAKEFILES_ucvlatin="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvlatin/Makefile"

MAKEFILES_ucvmath="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvmath/Makefile"

MAKEFILES_ucvtw="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvtw/Makefile"

MAKEFILES_ucvtw2="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/unicharutil/Makefile htmlparser/Makefile intl/lwbrk/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/uconv/native/Makefile intl/uconv/Makefile intl/uconv/ucvtw2/Makefile"

MAKEFILES_unicharutil="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile intl/unicharutil/Makefile"

MAKEFILES_universalchardet="webshell/public/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile intl/unicharutil/Makefile intl/uconv/Makefile intl/locale/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile extensions/universalchardet/Makefile"

MAKEFILES_uriloader="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile gfx/src/xprintutil/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile intl/unicharutil/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile embedding/components/ui/helperAppDlg/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile uriloader/exthandler/Makefile uriloader/base/Makefile"

MAKEFILES_util="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile modules/libutil/Makefile"

MAKEFILES_v_imagedecoders="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile modules/libpr0n/decoders/png/Makefile modules/libpr0n/decoders/jpeg/Makefile"

MAKEFILES_vcard="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile editor/composer/public/Makefile expat/Makefile modules/libutil/Makefile intl/uconv/native/Makefile webshell/public/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile intl/unicharutil/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile netwerk/mime/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile uriloader/base/Makefile embedding/components/webbrowserpersist/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/find/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile htmlparser/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile mailnews/public/Makefile security/manager/ssl/Makefile mailnews/extensions/smime/Makefile mailnews/mime/Makefile mailnews/local/Makefile mailnews/imap/Makefile mailnews/db/msgdb/Makefile mailnews/compose/Makefile mailnews/import/Makefile mailnews/base/Makefile mailnews/news/public/Makefile mailnews/news/src/Makefile mailnews/news/build/Makefile mailnews/base/util/Makefile mailnews/addrbook/public/Makefile mailnews/addrbook/src/Makefile mailnews/addrbook/build/Makefile mailnews/mime/cthandlers/vcard/Makefile"

MAKEFILES_view="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile embedding/components/windowwatcher/public/Makefile modules/libutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile view/Makefile"

MAKEFILES_wallet="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile extensions/wallet/public/Makefile extensions/wallet/src/Makefile"

MAKEFILES_walletviewers="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/wallet/public/Makefile extensions/wallet/src/Makefile extensions/wallet/editor/Makefile extensions/wallet/signonviewer/Makefile extensions/wallet/walletpreview/Makefile extensions/wallet/build/Makefile"

MAKEFILES_webbrowserpersist="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile intl/unicharutil/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/shistory/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile embedding/components/ui/helperAppDlg/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile uriloader/exthandler/Makefile embedding/components/webbrowserpersist/Makefile"

MAKEFILES_webbrwsr="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile"

MAKEFILES_webshell="webshell/public/Makefile"

MAKEFILES_webshell_tests="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile webshell/tests/viewer/Makefile"

MAKEFILES_websrvcs="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/xmlextras/Makefile extensions/webservices/Makefile"

MAKEFILES_widget="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile view/Makefile gfx/src/xlibrgb/Makefile embedding/components/windowwatcher/public/Makefile modules/libutil/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile content/xul/content/Makefile content/xul/templates/Makefile uriloader/base/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/txmgr/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile"

MAKEFILES_windowwatcher="embedding/components/windowwatcher/public/Makefile"

MAKEFILES_wsproxytest="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/xmlextras/Makefile extensions/webservices/Makefile extensions/webservices/proxy/tests/Makefile"

MAKEFILES_xlibrgb="gfx/src/xlibrgb/Makefile"

MAKEFILES_xml_rpc="extensions/xml-rpc/idl/Makefile"

MAKEFILES_xmlextras="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/xmlextras/Makefile"

MAKEFILES_xmlterm="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile extensions/xmlterm/Makefile"

MAKEFILES_xpcom="xpcom/Makefile xpcom/string/Makefile xpcom/string/embed/Makefile"

MAKEFILES_xpcom_compat_c="modules/libreg/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile xpcom/obsolete/Makefile xpcom/obsolete/component/Makefile"

MAKEFILES_xpcom_obsolete="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile xpcom/obsolete/Makefile"

MAKEFILES_xpcomsample="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile xpcom/sample/Makefile"

MAKEFILES_xpconnect="js/src/fdlibm/Makefile js/src/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile js/src/xpconnect/Makefile"

MAKEFILES_xpconnect_tests="js/src/xpconnect/tests/idl/Makefile"

MAKEFILES_xpcshell="js/src/fdlibm/Makefile js/src/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile js/src/xpconnect/Makefile js/src/xpconnect/shell/Makefile"

MAKEFILES_xpctest="js/src/xpconnect/tests/idl/Makefile js/src/fdlibm/Makefile js/src/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile js/src/xpconnect/Makefile js/src/xpconnect/tests/components/Makefile"

MAKEFILES_xpinstall="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libreg/Makefile xpinstall/Makefile"

MAKEFILES_xpistub="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile modules/libreg/Makefile xpinstall/Makefile xpinstall/stub/Makefile"

MAKEFILES_xpnet="xpinstall/wizard/libxpnet/src/Makefile"

MAKEFILES_xprintutil="gfx/src/xprintutil/Makefile"

MAKEFILES_xremoteservice="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile modules/libutil/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile intl/lwbrk/Makefile content/xul/content/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile embedding/components/find/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/components/jsconsole/public/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile dom/src/jsurl/Makefile dom/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile"

MAKEFILES_xul="modules/zlib/Makefile modules/libimg/png/Makefile xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile intl/uconv/native/Makefile webshell/public/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile rdf/util/Makefile intl/unicharutil/Makefile gfx/src/xprintutil/Makefile intl/lwbrk/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile xpcom/obsolete/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile modules/libutil/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile content/xul/templates/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile expat/Makefile htmlparser/Makefile rdf/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/components/ui/helperAppDlg/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile content/xul/content/Makefile"

MAKEFILES_xuldoc="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile intl/uconv/native/Makefile webshell/public/Makefile gfx/src/xprintutil/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile intl/unicharutil/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile ipc/ipcd/Makefile embedding/components/profilesharingsetup/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile xpcom/obsolete/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile view/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile intl/locale/Makefile embedding/components/commandhandler/Makefile intl/lwbrk/Makefile editor/composer/public/Makefile editor/txtsvc/Makefile editor/Makefile accessible/Makefile content/xul/content/Makefile content/xul/templates/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile uriloader/prefetch/Makefile content/Makefile embedding/components/find/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile dom/Makefile caps/Makefile embedding/components/ui/helperAppDlg/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile netwerk/mime/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile netwerk/Makefile intl/strres/Makefile modules/libpref/Makefile netwerk/cache/Makefile jpeg/Makefile modules/libpr0n/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile uriloader/exthandler/Makefile content/xul/document/Makefile"

MAKEFILES_xultmpl="xpcom/Makefile xpcom/string/embed/Makefile xpcom/string/Makefile modules/zlib/Makefile modules/libimg/png/Makefile js/src/fdlibm/Makefile js/src/Makefile js/src/xpconnect/Makefile ipc/ipcd/Makefile xpcom/obsolete/Makefile embedding/components/profilesharingsetup/Makefile modules/libpref/Makefile netwerk/cache/Makefile intl/uconv/native/Makefile webshell/public/Makefile intl/unicharutil/Makefile intl/lwbrk/Makefile netwerk/mime/Makefile uriloader/base/Makefile embedding/components/windowwatcher/public/Makefile rdf/util/Makefile expat/Makefile modules/libutil/Makefile htmlparser/Makefile rdf/Makefile profile/dirserviceprovider/Makefile xpfe/components/shistory/Makefile embedding/components/webbrowserpersist/Makefile embedding/browser/webBrowser/Makefile embedding/browser/build/Makefile profile/pref-migrator/Makefile profile/Makefile embedding/components/ui/progressDlg/Makefile xpfe/components/download-manager/Makefile directory/xpcom/base/Makefile editor/txmgr/Makefile db/mdb/public/Makefile db/mork/src/Makefile db/mork/build/Makefile xpfe/components/directory/Makefile xpfe/components/find/public/Makefile xpfe/components/find/src/Makefile xpfe/components/search/public/Makefile xpfe/components/search/src/Makefile xpfe/components/related/public/Makefile xpfe/components/related/src/Makefile xpfe/components/intl/Makefile xpfe/components/windowds/Makefile xpfe/components/autocomplete/public/Makefile xpfe/components/autocomplete/src/Makefile xpfe/components/bookmarks/public/Makefile xpfe/components/bookmarks/src/Makefile xpfe/components/urlbarhistory/public/Makefile xpfe/components/urlbarhistory/src/Makefile xpfe/components/build/Makefile xpfe/browser/public/Makefile xpfe/browser/Makefile xpfe/appshell/Makefile xpfe/components/xremote/public/Makefile xpfe/components/xremote/Makefile widget/src/gtksuperwin/Makefile widget/public/Makefile widget/src/xpwidgets/Makefile widget/src/support/Makefile widget/src/gtk/Makefile widget/src/xremoteclient/Makefile embedding/components/find/Makefile content/xul/content/Makefile content/xul/document/Makefile embedding/components/commandhandler/Makefile embedding/components/jsconsole/public/Makefile dom/src/jsurl/Makefile sun-java/Makefile modules/libjar/Makefile js/src/liveconnect/Makefile modules/oji/Makefile dom/Makefile view/Makefile editor/composer/public/Makefile embedding/components/ui/helperAppDlg/Makefile editor/txtsvc/Makefile editor/Makefile uriloader/prefetch/Makefile docshell/Makefile embedding/base/Makefile embedding/components/windowwatcher/src/Makefile embedding/components/appstartup/src/Makefile embedding/components/jsconsole/src/Makefile embedding/components/printingui/src/unixshared/Makefile embedding/components/build/Makefile intl/chardet/public/Makefile intl/chardet/src/Makefile intl/uconv/Makefile intl/locale/Makefile accessible/Makefile netwerk/protocol/viewsource/Makefile netwerk/protocol/gopher/Makefile netwerk/build2/Makefile layout/Makefile rdf/chrome/public/Makefile rdf/chrome/src/Makefile rdf/chrome/build/Makefile content/Makefile gfx/src/xprintutil/Makefile gfx/src/xlibrgb/Makefile gfx/Makefile jpeg/Makefile modules/libpr0n/Makefile netwerk/Makefile intl/strres/Makefile xpfe/components/history/public/Makefile xpfe/components/history/Makefile uriloader/exthandler/Makefile widget/src/gtkxtbin/Makefile modules/plugin/Makefile caps/Makefile content/xul/templates/Makefile"

MAKEFILES_zlib="modules/zlib/Makefile"

    for mod in $BUILD_MODULES; do
        case $mod in
        TestStreamConv) add_makefiles "$MAKEFILES_TestStreamConv" ;;
        TestXPC) add_makefiles "$MAKEFILES_TestXPC" ;;
        TestXPTC) add_makefiles "$MAKEFILES_TestXPTC" ;;
        accessibility) add_makefiles "$MAKEFILES_accessibility" ;;
        addrbook) add_makefiles "$MAKEFILES_addrbook" ;;
        appcomps) add_makefiles "$MAKEFILES_appcomps" ;;
        apprunner) add_makefiles "$MAKEFILES_apprunner" ;;
        appshell) add_makefiles "$MAKEFILES_appshell" ;;
        autoconfig) add_makefiles "$MAKEFILES_autoconfig" ;;
        bayesflt) add_makefiles "$MAKEFILES_bayesflt" ;;
        browser) add_makefiles "$MAKEFILES_browser" ;;
        calendar) add_makefiles "$MAKEFILES_calendar" ;;
        caps) add_makefiles "$MAKEFILES_caps" ;;
        chardet) add_makefiles "$MAKEFILES_chardet" ;;
        chrome) add_makefiles "$MAKEFILES_chrome" ;;
        commandhandler) add_makefiles "$MAKEFILES_commandhandler" ;;
        composer) add_makefiles "$MAKEFILES_composer" ;;
        content) add_makefiles "$MAKEFILES_content" ;;
        cookie) add_makefiles "$MAKEFILES_cookie" ;;
        dbm) add_makefiles "$MAKEFILES_dbm" ;;
        docshell) add_makefiles "$MAKEFILES_docshell" ;;
        dom) add_makefiles "$MAKEFILES_dom" ;;
        downloadmanager) add_makefiles "$MAKEFILES_downloadmanager" ;;
        editor) add_makefiles "$MAKEFILES_editor" ;;
        embed_base) add_makefiles "$MAKEFILES_embed_base" ;;
        embed_lite) add_makefiles "$MAKEFILES_embed_lite" ;;
        embedcomponents) add_makefiles "$MAKEFILES_embedcomponents" ;;
        embedstring) add_makefiles "$MAKEFILES_embedstring" ;;
        expat) add_makefiles "$MAKEFILES_expat" ;;
        exthandler) add_makefiles "$MAKEFILES_exthandler" ;;
        filepicker) add_makefiles "$MAKEFILES_filepicker" ;;
        find) add_makefiles "$MAKEFILES_find" ;;
        gfx) add_makefiles "$MAKEFILES_gfx" ;;
        gtkembedmoz) add_makefiles "$MAKEFILES_gtkembedmoz" ;;
        gtkembedmoz-wrapper) add_makefiles "$MAKEFILES_gtkembedmoz_wrapper" ;;
        gtkxtbin) add_makefiles "$MAKEFILES_gtkxtbin" ;;
        helperAppDlg) add_makefiles "$MAKEFILES_helperAppDlg" ;;
        history) add_makefiles "$MAKEFILES_history" ;;
        htmlparser) add_makefiles "$MAKEFILES_htmlparser" ;;
        i18n) add_makefiles "$MAKEFILES_i18n" ;;
        ical) add_makefiles "$MAKEFILES_ical" ;;
        icalss) add_makefiles "$MAKEFILES_icalss" ;;
        imgbmp) add_makefiles "$MAKEFILES_imgbmp" ;;
        imggif) add_makefiles "$MAKEFILES_imggif" ;;
        imgjpeg) add_makefiles "$MAKEFILES_imgjpeg" ;;
        imglib2) add_makefiles "$MAKEFILES_imglib2" ;;
        imgpng) add_makefiles "$MAKEFILES_imgpng" ;;
        imgxbm) add_makefiles "$MAKEFILES_imgxbm" ;;
        impComm4xMail) add_makefiles "$MAKEFILES_impComm4xMail" ;;
        impText) add_makefiles "$MAKEFILES_impText" ;;
        import) add_makefiles "$MAKEFILES_import" ;;
        inspector) add_makefiles "$MAKEFILES_inspector" ;;
        intl) add_makefiles "$MAKEFILES_intl" ;;
        ipcd) add_makefiles "$MAKEFILES_ipcd" ;;
        ipcd_test) add_makefiles "$MAKEFILES_ipcd_test" ;;
        jar) add_makefiles "$MAKEFILES_jar" ;;
        java) add_makefiles "$MAKEFILES_java" ;;
        jpeg) add_makefiles "$MAKEFILES_jpeg" ;;
        js) add_makefiles "$MAKEFILES_js" ;;
        jsconsole) add_makefiles "$MAKEFILES_jsconsole" ;;
        jsdebug) add_makefiles "$MAKEFILES_jsdebug" ;;
        jsloader) add_makefiles "$MAKEFILES_jsloader" ;;
        jsurl) add_makefiles "$MAKEFILES_jsurl" ;;
        layout) add_makefiles "$MAKEFILES_layout" ;;
        layout_debug) add_makefiles "$MAKEFILES_layout_debug" ;;
        libart_lgpl) add_makefiles "$MAKEFILES_libart_lgpl" ;;
        libreg) add_makefiles "$MAKEFILES_libreg" ;;
        liveconnect) add_makefiles "$MAKEFILES_liveconnect" ;;
        locale) add_makefiles "$MAKEFILES_locale" ;;
        lwbrk) add_makefiles "$MAKEFILES_lwbrk" ;;
        macmorefiles) add_makefiles "$MAKEFILES_macmorefiles" ;;
        mailnews) add_makefiles "$MAKEFILES_mailnews" ;;
        mailview) add_makefiles "$MAKEFILES_mailview" ;;
        mime) add_makefiles "$MAKEFILES_mime" ;;
        mimeemitter) add_makefiles "$MAKEFILES_mimeemitter" ;;
        mimemitter) add_makefiles "$MAKEFILES_mimemitter" ;;
        mimetype) add_makefiles "$MAKEFILES_mimetype" ;;
        mork) add_makefiles "$MAKEFILES_mork" ;;
        mozldap) add_makefiles "$MAKEFILES_mozldap" ;;
        msgbase) add_makefiles "$MAKEFILES_msgbase" ;;
        msgbaseutil) add_makefiles "$MAKEFILES_msgbaseutil" ;;
        msgcompose) add_makefiles "$MAKEFILES_msgcompose" ;;
        msgdb) add_makefiles "$MAKEFILES_msgdb" ;;
        msgimap) add_makefiles "$MAKEFILES_msgimap" ;;
        msglocal) add_makefiles "$MAKEFILES_msglocal" ;;
        msgmdn) add_makefiles "$MAKEFILES_msgmdn" ;;
        msgnews) add_makefiles "$MAKEFILES_msgnews" ;;
        msgsmime) add_makefiles "$MAKEFILES_msgsmime" ;;
        myspell) add_makefiles "$MAKEFILES_myspell" ;;
        necko) add_makefiles "$MAKEFILES_necko" ;;
        necko2) add_makefiles "$MAKEFILES_necko2" ;;
        nkcache) add_makefiles "$MAKEFILES_nkcache" ;;
        nkdatetime) add_makefiles "$MAKEFILES_nkdatetime" ;;
        nkfinger) add_makefiles "$MAKEFILES_nkfinger" ;;
        npsimple) add_makefiles "$MAKEFILES_npsimple" ;;
        offlinestartup) add_makefiles "$MAKEFILES_offlinestartup" ;;
        oji) add_makefiles "$MAKEFILES_oji" ;;
        p3p) add_makefiles "$MAKEFILES_p3p" ;;
        plugin) add_makefiles "$MAKEFILES_plugin" ;;
        png) add_makefiles "$MAKEFILES_png" ;;
        pref) add_makefiles "$MAKEFILES_pref" ;;
        prefetch) add_makefiles "$MAKEFILES_prefetch" ;;
        prefmigr) add_makefiles "$MAKEFILES_prefmigr" ;;
        profdirserviceprovider) add_makefiles "$MAKEFILES_profdirserviceprovider" ;;
        profile) add_makefiles "$MAKEFILES_profile" ;;
        profilesharingsetup) add_makefiles "$MAKEFILES_profilesharingsetup" ;;
        progressDlg) add_makefiles "$MAKEFILES_progressDlg" ;;
        rdf) add_makefiles "$MAKEFILES_rdf" ;;
        rdfutil) add_makefiles "$MAKEFILES_rdfutil" ;;
        shistory) add_makefiles "$MAKEFILES_shistory" ;;
        sidebar) add_makefiles "$MAKEFILES_sidebar" ;;
        spellchecker) add_makefiles "$MAKEFILES_spellchecker" ;;
        string) add_makefiles "$MAKEFILES_string" ;;
        svg_doc) add_makefiles "$MAKEFILES_svg_doc" ;;
        test_necko) add_makefiles "$MAKEFILES_test_necko" ;;
        tm_test) add_makefiles "$MAKEFILES_tm_test" ;;
        transformiix) add_makefiles "$MAKEFILES_transformiix" ;;
        txmgr) add_makefiles "$MAKEFILES_txmgr" ;;
        txtsvc) add_makefiles "$MAKEFILES_txtsvc" ;;
        typeaheadfind) add_makefiles "$MAKEFILES_typeaheadfind" ;;
        ucnative) add_makefiles "$MAKEFILES_ucnative" ;;
        uconv) add_makefiles "$MAKEFILES_uconv" ;;
        ucvcn) add_makefiles "$MAKEFILES_ucvcn" ;;
        ucvibm) add_makefiles "$MAKEFILES_ucvibm" ;;
        ucvja) add_makefiles "$MAKEFILES_ucvja" ;;
        ucvko) add_makefiles "$MAKEFILES_ucvko" ;;
        ucvlatin) add_makefiles "$MAKEFILES_ucvlatin" ;;
        ucvmath) add_makefiles "$MAKEFILES_ucvmath" ;;
        ucvtw) add_makefiles "$MAKEFILES_ucvtw" ;;
        ucvtw2) add_makefiles "$MAKEFILES_ucvtw2" ;;
        unicharutil) add_makefiles "$MAKEFILES_unicharutil" ;;
        universalchardet) add_makefiles "$MAKEFILES_universalchardet" ;;
        uriloader) add_makefiles "$MAKEFILES_uriloader" ;;
        util) add_makefiles "$MAKEFILES_util" ;;
        v-imagedecoders) add_makefiles "$MAKEFILES_v_imagedecoders" ;;
        vcard) add_makefiles "$MAKEFILES_vcard" ;;
        view) add_makefiles "$MAKEFILES_view" ;;
        wallet) add_makefiles "$MAKEFILES_wallet" ;;
        walletviewers) add_makefiles "$MAKEFILES_walletviewers" ;;
        webbrowserpersist) add_makefiles "$MAKEFILES_webbrowserpersist" ;;
        webbrwsr) add_makefiles "$MAKEFILES_webbrwsr" ;;
        webshell) add_makefiles "$MAKEFILES_webshell" ;;
        webshell_tests) add_makefiles "$MAKEFILES_webshell_tests" ;;
        websrvcs) add_makefiles "$MAKEFILES_websrvcs" ;;
        widget) add_makefiles "$MAKEFILES_widget" ;;
        windowwatcher) add_makefiles "$MAKEFILES_windowwatcher" ;;
        wsproxytest) add_makefiles "$MAKEFILES_wsproxytest" ;;
        xlibrgb) add_makefiles "$MAKEFILES_xlibrgb" ;;
        xml-rpc) add_makefiles "$MAKEFILES_xml_rpc" ;;
        xmlextras) add_makefiles "$MAKEFILES_xmlextras" ;;
        xmlterm) add_makefiles "$MAKEFILES_xmlterm" ;;
        xpcom) add_makefiles "$MAKEFILES_xpcom" ;;
        xpcom_compat_c) add_makefiles "$MAKEFILES_xpcom_compat_c" ;;
        xpcom_obsolete) add_makefiles "$MAKEFILES_xpcom_obsolete" ;;
        xpcomsample) add_makefiles "$MAKEFILES_xpcomsample" ;;
        xpconnect) add_makefiles "$MAKEFILES_xpconnect" ;;
        xpconnect_tests) add_makefiles "$MAKEFILES_xpconnect_tests" ;;
        xpcshell) add_makefiles "$MAKEFILES_xpcshell" ;;
        xpctest) add_makefiles "$MAKEFILES_xpctest" ;;
        xpinstall) add_makefiles "$MAKEFILES_xpinstall" ;;
        xpistub) add_makefiles "$MAKEFILES_xpistub" ;;
        xpnet) add_makefiles "$MAKEFILES_xpnet" ;;
        xprintutil) add_makefiles "$MAKEFILES_xprintutil" ;;
        xremoteservice) add_makefiles "$MAKEFILES_xremoteservice" ;;
        xul) add_makefiles "$MAKEFILES_xul" ;;
        xuldoc) add_makefiles "$MAKEFILES_xuldoc" ;;
        xultmpl) add_makefiles "$MAKEFILES_xultmpl" ;;
        zlib) add_makefiles "$MAKEFILES_zlib" ;;
        esac
    done

fi
