/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.Colorize;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import netscape.plugin.composer.AlertApp;
import netscape.plugin.composer.Colorize.ColorizeBundle;
import netscape.plugin.composer.Document;
import netscape.plugin.composer.Plugin;
import netscape.plugin.composer.TagTrackerStream;
import netscape.plugin.composer.io.Comment;
import netscape.plugin.composer.io.Entity;
import netscape.plugin.composer.io.Tag;
import netscape.plugin.composer.io.Text;
import netscape.plugin.composer.io.Token;
import netscape.test.plugin.composer.Test;

public class Colorize
extends Plugin {
    private static ResourceBundle bundle_;
    private float hue;

    public static void main(String[] stringArray) {
        Test.perform((String[])stringArray, (Plugin)new Colorize());
    }

    public String getName() {
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        return bundle_.getString("name");
    }

    public String getCategory() {
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        return bundle_.getString("category");
    }

    public String getHint() {
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        return bundle_.getString("hint");
    }

    public static ResourceBundle bundle() {
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        return bundle_;
    }

    public boolean perform(Document document) throws IOException {
        Token token;
        PrintWriter printWriter = new PrintWriter(document.getOutput());
        TagTrackerStream tagTrackerStream = new TagTrackerStream(document.getInput(), true, printWriter);
        this.hue = 0.0f;
        boolean bl = false;
        while (true) {
            Text text;
            if ((token = tagTrackerStream.next()) == null || token instanceof Comment && ((Comment)token).isSelectionEnd()) {
                if (bl) break;
                this.showAlert(document);
                break;
            }
            if (token instanceof Text) {
                text = (Text)token;
                this.colorize(text.getText(), printWriter);
                bl = true;
                continue;
            }
            if (token instanceof Entity) {
                text = (Entity)token;
                this.colorize_entity((Entity)text, printWriter);
                bl = true;
                continue;
            }
            if (token instanceof Tag && (text = (Tag)token).getName().equals("FONT") && text.containsAttribute("COLOR")) {
                text.removeAttribute("COLOR");
                bl = true;
            }
            printWriter.print(token);
        }
        if ((token = tagTrackerStream.findTag("FONT")) != null && token.containsAttribute("COLOR")) {
            printWriter.print(token);
        }
        tagTrackerStream.finish();
        printWriter.close();
        return bl;
    }

    private void colorize(String string, PrintWriter printWriter) {
        int n = string.length();
        Tag tag = new Tag("font");
        Tag tag2 = new Tag("font", false);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            int n3 = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
            tag.addAttribute("color", this.formatColor(n3));
            printWriter.print(tag);
            printWriter.print(c);
            printWriter.print(tag2);
            this.hue = (this.hue + 0.005f) % 1.0f;
            ++n2;
        }
    }

    private void colorize_entity(Entity entity, PrintWriter printWriter) {
        Tag tag = new Tag("font");
        Tag tag2 = new Tag("font", false);
        int n = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        tag.addAttribute("color", this.formatColor(n));
        printWriter.print(tag);
        printWriter.print(entity);
        printWriter.print(tag2);
        this.hue = (this.hue + 0.005f) % 1.0f;
    }

    private String formatColor(int n) {
        return "#" + Integer.toHexString(n >> 20 & 0xF) + Integer.toHexString(n >> 16 & 0xF) + Integer.toHexString(n >> 12 & 0xF) + Integer.toHexString(n >> 8 & 0xF) + Integer.toHexString(n >> 4 & 0xF) + Integer.toHexString(n & 0xF);
    }

    private void showAlert(Document document) {
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        String string = bundle_.getString("alertTitle");
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        String string2 = bundle_.getString("alertMessage");
        if (bundle_ == null) {
            bundle_ = new ColorizeBundle();
        }
        AlertApp alertApp = new AlertApp(document, string, string2, bundle_.getString("alertButton"));
        alertApp.run();
    }
}

