// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]",
    [["forwarddelete",""]],
    "foo{}",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
    [["forwarddelete",""]],
    "<span>foo</span>{}",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
    [["forwarddelete",""]],
    "<p>foo{}</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forwarddelete",""]],
    "foo[]ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["forwarddelete",""]],
    "<span>foo</span><span>{}ar</span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
    [["forwarddelete",""]],
    "<span>foo[]</span><span>bar</span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span style=display:none>bar</span>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "foo{}az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span style=display:none>bar</span>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "foo{}az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<script>bar</script>baz",
    [["forwarddelete",""]],
    "foo{}az",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["fo[]&ouml;bar",
    [["forwarddelete",""]],
    "fo[]bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["fo[]o&#x308;bar",
    [["forwarddelete",""]],
    "fo[]bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["fo[]o&#x308;&#x327;bar",
    [["forwarddelete",""]],
    "fo[]bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["[]&ouml;bar",
    [["forwarddelete",""]],
    "{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["[]o&#x308;bar",
    [["forwarddelete",""]],
    "{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["[]o&#x308;&#x327;bar",
    [["forwarddelete",""]],
    "{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["[]&#x5e9;&#x5c1;&#x5b8;&#x5dc;&#x5d5;&#x5b9;&#x5dd;",
    [["forwarddelete",""]],
    "{}לוֹם",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["&#x5e9;&#x5c1;&#x5b8;&#x5dc;[]&#x5d5;&#x5b9;&#x5dd;",
    [["forwarddelete",""]],
    "שָׁל[]ם",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><p>bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><p>bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p>bar",
    [["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p>bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p>bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br></p><p>bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br></p><p>bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>bar",
    [["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><p>bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><p>bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>{}<br></p>foo",
    [["forwarddelete",""]],
    "<p>{}foo</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>{}<span><br></span></p>foo",
    [["forwarddelete",""]],
    "<p>{}foo</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><span><br></span>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><span><br></span>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><span><br></span>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><span><br></span>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><span><br></span>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><span><br></span>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>[]b</table>foo",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>[]<br></td></tr></tbody></table>foo",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>{}</table>foo",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>{}</td></tr></tbody></table>foo",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>{}<br></table>foo",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>{}<br></td></tr></tbody></table>foo",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>{}<span><br></span></table>foo",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>{}<span><br></span></td></tr></tbody></table>foo",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><p>bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><p>bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><div><p>bar</p></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><div><p>bar</p></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><div><p>bar</p></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><div><p>bar</p></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div>bar",
    [["forwarddelete",""]],
    "<div><p>foo{}bar</p></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><p>bar</p></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><p>bar</p></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><div>bar</div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div>foo{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><div>bar</div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div>foo{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>bar",
    [["forwarddelete",""]],
    "<pre>foo{}bar</pre>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br>bar",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[]</b><br>bar",
    [["forwarddelete",""]],
    "<b>foo</b>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<hr>bar",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<hr><p>bar",
    [["forwarddelete",""]],
    "<p>foo{}</p><p>bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><br><p>bar</p>",
    [["forwarddelete",""]],
    "<p>foo{}</p><p>bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><br><br><p>bar</p>",
    [["forwarddelete",""]],
    "<p>foo{}</p><br><p>bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><img src=/img/lion.svg><p>bar",
    [["forwarddelete",""]],
    "<p>foo{}<img src=\"/img/lion.svg\"></p><p>bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<img src=/img/lion.svg>bar",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a>bar</a>",
    [["forwarddelete",""]],
    "foo<a>{}ar</a>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a href=/>bar</a>",
    [["forwarddelete",""]],
    "foo<a href=\"/\">{}ar</a>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a name=abc>bar</a>",
    [["forwarddelete",""]],
    "foo<a name=\"abc\">{}ar</a>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a href=/ name=abc>bar</a>",
    [["forwarddelete",""]],
    "foo<a href=\"/\" name=\"abc\">{}ar</a>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a>bar</a></span>",
    [["forwarddelete",""]],
    "foo<span><a>{}ar</a></span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a href=/>bar</a></span>",
    [["forwarddelete",""]],
    "foo<span><a href=\"/\">{}ar</a></span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a name=abc>bar</a></span>",
    [["forwarddelete",""]],
    "foo<span><a name=\"abc\">{}ar</a></span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a href=/ name=abc>bar</a></span>",
    [["forwarddelete",""]],
    "foo<span><a href=\"/\" name=\"abc\">{}ar</a></span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<a>foo[]</a>bar",
    [["forwarddelete",""]],
    "<a>foo</a>{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<a href=/>foo[]</a>bar",
    [["forwarddelete",""]],
    "<a href=\"/\">foo</a>{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<a name=abc>foo[]</a>bar",
    [["forwarddelete",""]],
    "<a name=\"abc\">foo</a>{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<a href=/ name=abc>foo[]</a>bar",
    [["forwarddelete",""]],
    "<a href=\"/\" name=\"abc\">foo</a>{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo []&nbsp;",
    [["forwarddelete",""]],
    "foo&nbsp;[]",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["[]&nbsp; foo",
    [["forwarddelete",""]],
    "{}&nbsp;foo",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[] &nbsp;bar",
    [["forwarddelete",""]],
    "foo[] bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]&nbsp; bar",
    [["forwarddelete",""]],
    "foo[] bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]&nbsp;&nbsp;bar",
    [["forwarddelete",""]],
    "foo[] bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]  bar",
    [["forwarddelete",""]],
    "foo[]bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[] &nbsp; bar",
    [["forwarddelete",""]],
    "foo[]&nbsp; bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo []&nbsp; bar",
    [["forwarddelete",""]],
    "foo&nbsp;[] bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo &nbsp;[] bar",
    [["forwarddelete",""]],
    "foo&nbsp; []bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[] <span>&nbsp;</span> bar",
    [["forwarddelete",""]],
    "foo[]<span>&nbsp;</span> bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo []<span>&nbsp;</span> bar",
    [["forwarddelete",""]],
    "foo&nbsp;{} bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo <span>&nbsp;</span>[] bar",
    [["forwarddelete",""]],
    "foo&nbsp;<span> </span>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[] </b>&nbsp;bar",
    [["forwarddelete",""]],
    "<b>foo[]</b> bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[]&nbsp;</b> bar",
    [["forwarddelete",""]],
    "<b>foo[]</b> bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[]&nbsp;</b>&nbsp;bar",
    [["forwarddelete",""]],
    "<b>foo[]</b> bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[] </b> bar",
    [["forwarddelete",""]],
    "<b>foo[]</b>bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo []&nbsp;</pre>",
    [["forwarddelete",""]],
    "<pre>foo []</pre>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<pre>[]&nbsp; foo</pre>",
    [["forwarddelete",""]],
    "<pre>{} foo</pre>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[] &nbsp;bar</pre>",
    [["forwarddelete",""]],
    "<pre>foo[]&nbsp;bar</pre>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[]&nbsp; bar</pre>",
    [["forwarddelete",""]],
    "<pre>foo[] bar</pre>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[]  bar</pre>",
    [["forwarddelete",""]],
    "<pre>foo[] bar</pre>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo []&nbsp;</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo []</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>[]&nbsp; foo</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">{} foo</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[] &nbsp;bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo[]&nbsp;bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]&nbsp; bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]  bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo []&nbsp;</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo []</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>[]&nbsp; foo</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">{} foo</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[] &nbsp;bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo[]&nbsp;bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]&nbsp; bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]  bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo []&nbsp;</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo&nbsp;[]</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>[]&nbsp; foo</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">{}&nbsp;foo</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[] &nbsp;bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]&nbsp; bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]  bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo []&nbsp;</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo&nbsp;[]</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>[]&nbsp; foo</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">{}&nbsp;foo</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[] &nbsp;bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]&nbsp; bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]  bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<table><tr><td>bar</table>baz",
    [["forwarddelete",""]],
    "foo{<table><tbody><tr><td>bar</td></tr></tbody></table>}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar[]</table>baz",
    [["forwarddelete",""]],
    "foo<table><tbody><tr><td>bar[]</td></tr></tbody></table>baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<table><tr><td>bar</table><p>baz",
    [["forwarddelete",""]],
    "<p>foo</p>{<table><tbody><tr><td>bar</td></tr></tbody></table>}<p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<td>bar</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo{}</td><td>bar</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<tr><td>bar</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo{}</td></tr><tr><td>bar</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><table><tr><td>bar</table>baz",
    [["forwarddelete",""]],
    "foo{<table><tbody><tr><td>bar</td></tr></tbody></table>}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar[]<br></table>baz",
    [["forwarddelete",""]],
    "foo<table><tbody><tr><td>bar[]</td></tr></tbody></table>baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br><table><tr><td>bar</table><p>baz",
    [["forwarddelete",""]],
    "<p>foo</p>{<table><tbody><tr><td>bar</td></tr></tbody></table>}<p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar[]<br></table><p>baz",
    [["forwarddelete",""]],
    "<p>foo</p><table><tbody><tr><td>bar[]</td></tr></tbody></table><p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<br><td>bar</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo{}</td><td>bar</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<br><tr><td>bar</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo{}</td></tr><tr><td>bar</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar[]</table><br>baz",
    [["forwarddelete",""]],
    "foo<table><tbody><tr><td>bar[]</td></tr></tbody></table><br>baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<table><tr><td><hr>bar</table>baz",
    [["forwarddelete",""]],
    "foo{<table><tbody><tr><td><hr>bar</td></tr></tbody></table>}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<td><hr>bar</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo{}</td><td><hr>bar</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<tr><td><hr>bar</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo{}</td></tr><tr><td><hr>bar</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<ol><li>bar<li>baz</ol>",
    [["forwarddelete",""]],
    "foo{}bar<ol><li>baz</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><ol><li>bar<li>baz</ol>",
    [["forwarddelete",""]],
    "foo{}bar<ol><li>baz</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li>bar<br>baz</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar<br>baz</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]<li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li><p>foo{}bar</p></li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li><p>bar</ol>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li><p>bar</ol>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]<li><p>bar</ol>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li><p>foo{}bar</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]<li><p>bar</ol>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li><p>foo{}bar</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<ul><li>bar</ul></ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<ol><ol><li>bar</ol></ol>",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><ol><li>bar</ol></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><ol><li>bar</ol></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<dl><dt>bar<dd>baz</dl>",
    [["forwarddelete",""]],
    "foo{}bar<dl><dd>baz</dd></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<dl><dd>bar</dl>",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dd>bar</dl>",
    [["forwarddelete",""]],
    "<dl><dt>foo{}bar</dt></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dt>bar<dd>baz</dl>",
    [["forwarddelete",""]],
    "<dl><dt>foo{}bar</dt><dd>baz</dd></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]<dd>baz</dl>",
    [["forwarddelete",""]],
    "<dl><dt>foo</dt><dd>bar{}baz</dd></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol>bar",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol>bar",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol>bar",
    [["forwarddelete",""]],
    "<ol><li>{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>bar",
    [["forwarddelete",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><br>",
    [["forwarddelete",""]],
    "<ol><li>foo{}</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><br>",
    [["forwarddelete",""]],
    "<ol><li>foo{}</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><br>",
    [["forwarddelete",""]],
    "<ol><li>{}<br></li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><br>",
    [["forwarddelete",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p><br>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p><br>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote>bar</blockquote>",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><blockquote>bar</blockquote></blockquote>",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div>bar</div></blockquote>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div>bar</div></blockquote>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\">bar</blockquote>",
    [["stylewithcss","true"],["forwarddelete",""]],
    "foo{}<span style=\"color:rgb(0, 0, 255)\">bar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\">bar</blockquote>",
    [["stylewithcss","false"],["forwarddelete",""]],
    "foo{}<font color=\"#0000ff\">bar</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><blockquote><p>bar<p>baz</blockquote></blockquote>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar<blockquote><blockquote><p>baz</p></blockquote></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><blockquote><p>bar<p>baz</blockquote></blockquote>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar<blockquote><blockquote><p>baz</p></blockquote></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div><p>bar<p>baz</div></blockquote>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar<blockquote><div><p>baz</p></div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div><p>bar<p>baz</div></blockquote>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar<blockquote><div><p>baz</p></div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<span style=\"color:rgb(0, 0, 255)\">bar</span><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<font color=\"#0000ff\">bar</font><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<span style=\"color:rgb(0, 0, 255)\">bar</span><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<font color=\"#0000ff\">bar</font><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><b>bar</b><p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<b>bar</b><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><b>bar</b><p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<b>bar</b><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><strong>bar</strong><p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<strong>bar</strong><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><strong>bar</strong><p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<strong>bar</strong><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><span>bar</span><p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<span>bar</span><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><span>bar</span><p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<span>bar</span><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><ol><li>bar</ol></blockquote><p>extra",
    [["forwarddelete",""]],
    "foo{}bar<p>extra</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote>bar<ol><li>baz</ol>quz</blockquote><p>extra",
    [["forwarddelete",""]],
    "foo{}bar<blockquote><ol><li>baz</li></ol>quz</blockquote><p>extra</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>bar[]</li><ol><li>baz</ol><li>quz</ol></blockquote><p>extra",
    [["forwarddelete",""]],
    "foo<blockquote><ol><li>bar{}baz</li><li>quz</li></ol></blockquote><p>extra</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span></span>bar",
    [["forwarddelete",""]],
    "foo{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><span></span></span>bar",
    [["forwarddelete",""]],
    "foo{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<quasit></quasit>bar",
    [["forwarddelete",""]],
    "foo{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span></span><br>bar",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo[]<span></span></span>bar",
    [["forwarddelete",""]],
    "<span>foo</span>{}ar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span></span><span>bar</span>",
    [["forwarddelete",""]],
    "foo<span>{}ar</span>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p>bar</div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p>bar</div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p><!--abc-->bar</div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p><!--abc-->bar</div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><!--abc--><p>bar</div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><!--abc--><p>bar</div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><!--abc--><div><p>bar</div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><!--abc--><div><p>bar</div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<!--abc--><div><div><p>bar</div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<!--abc--><div><div><p>bar</div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</div></div>bar",
    [["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</div></div><!--abc-->bar",
    [["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</div><!--abc--></div>bar",
    [["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p><!--abc--></div></div>bar",
    [["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]<!--abc--></div></div>bar",
    [["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]<!--abc--></p></div></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]<!--abc--></p></div></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p><!--abc--></div></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p><!--abc--></div></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div><!--abc--></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div><!--abc--></div><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><!--abc--><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><!--abc--><div><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><!--abc--><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><!--abc--><div><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><!--abc--><div>bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><!--abc--><div>bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div><!--abc-->bar</div></div></div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div><!--abc-->bar</div></div></div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><font color=\"#0000ff\">foo{}</font>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><font color=\"#0000ff\">foo{}</font>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><font color=\"blue\">foo</font>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><font color=\"blue\">foo</font>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p><font color=brown>bar</font>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p><font color=brown>bar</font>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><font color=brown>bar</font>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><font color=brown>bar</font>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p><span style=color:brown>bar</font>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p><span style=color:brown>bar</font>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=color:brown>bar</font>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=color:brown>bar</font>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p><span style=background-color:tan>bar</font>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p><span style=background-color:tan>bar</font>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=background-color:tan>bar</font>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=background-color:tan>bar</font>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><u>foo{}</u>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><u>foo{}</u>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><u>foo{}</u><s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><u>foo{}</u><s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p>bar",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><u>foo</u>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p>bar",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><u>foo</u>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p><s>bar</s>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><u>foo</u>{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p><s>bar</s>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><u>foo</u>{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><s>bar</s>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><s>bar</s>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]</p>bar",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]</p>bar",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p><font color=\"#0000ff\">foo{}</font>bar</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<font color=\"#a52a2a\">bar</font>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<font color=\"#a52a2a\">bar</font>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div>bar",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<div><p><span style=\"color:rgb(0, 128, 0)\">foo{}</span>bar</p></div>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div>bar",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<div><p><font color=\"#008000\">foo{}</font>bar</p></div>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["forwarddelete",""]],
    "foo[]baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["stylewithcss","true"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["stylewithcss","false"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<span>[bar]</span>baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<span>{bar}</span>baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo{<span>bar</span>}baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[bar</b><i>baz]quz</i>",
    [["forwarddelete",""]],
    "<b>foo[]</b><i>quz</i>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[bar]</p><p>baz</p>",
    [["forwarddelete",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar}</p><p>baz</p>",
    [["forwarddelete",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar</p>}<p>baz</p>",
    [["forwarddelete",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo</p>{}<br><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo</p>{}<br><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo</p>{}<p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo</p>{}<p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<h1>baz]quz</h1>",
    [["forwarddelete",""]],
    "<p>foo{}quz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div>foo{}quz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div>foo{}quz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote><pre>baz]quz</pre>",
    [["forwarddelete",""]],
    "<blockquote>foo{}quz</blockquote>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p><b>foo</b>{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p><b>foo</b>{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><p>foo{}quz</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><p>foo{}quz</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<font color=\"#0000ff\">quz</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<font color=\"#0000ff\">quz</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}<b>quz</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}<b>quz</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<div><p>foo</p><p>{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<div><p>foo</p><p>{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<br>]bar",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar<br>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar<br>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar<br>baz</p>",
    [["forwarddelete",""]],
    "foo{}bar<p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<p>{bar</p>}baz",
    [["forwarddelete",""]],
    "foo<p>{}baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar",
    [["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo{</p>}bar",
    [["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<br>baz",
    [["forwarddelete",""]],
    "<p>foo{}bar</p>baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<p>baz</p>",
    [["forwarddelete",""]],
    "<p>foo{}bar</p><p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[</p></div>]bar",
    [["forwarddelete",""]],
    "<div><p>foo{}bar</p></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar<div>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar<div>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div>]bar<p>baz</p></div>",
    [["forwarddelete",""]],
    "foo{}bar<div><p>baz</p></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo</p>bar[</div>]baz",
    [["forwarddelete",""]],
    "<div><p>foo</p>bar{}baz</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo<p>bar[</p></div>]baz",
    [["forwarddelete",""]],
    "<div>foo<p>bar{}baz</p></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p>]bar",
    [["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p>]bar",
    [["forwarddelete",""]],
    "<p>foo<br>{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "foo<br>{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "foo<br>{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo<br>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo<br>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>[bar]<th>baz<tr><td>quz<td>qoz<td>qiz</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><th>foo</th><th>{}<br></th><th>baz</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>ba[r<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><th>foo</th><th>ba[]</th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>fo[o<th>bar<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><th>fo[]</th><th><br></th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>bar<th>ba[z<tr><td>q]uz<td>qoz<td>qiz</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><th>foo</th><th>bar</th><th>ba[]</th></tr><tr><td>uz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz]<tr><td>quz<td>qoz<td>qiz</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz]</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td><br></td><td><br></td><td><br></td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["{<table><tbody><tr><th>foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz</table>}",
    [["forwarddelete",""]],
    "{}<br>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>ba[r<tr><td>baz<td>quz<tr><td>q]oz<td>qiz</table>",
    [["forwarddelete",""]],
    "<table><tbody><tr><td>foo</td><td>ba[]</td></tr><tr><td><br></td><td><br></td></tr><tr><td>oz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>b]ar</table><p>baz",
    [["forwarddelete",""]],
    "<p>fo[]</p><table><tbody><tr><td>ar</td></tr></tbody></table><p>baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>ba[r</table><p>b]az",
    [["forwarddelete",""]],
    "<p>foo</p><table><tbody><tr><td>ba[]</td></tr></tbody></table><p>az</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>fo{}az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>fo{}az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>ba[r<li>b]az</ol><p>quz",
    [["forwarddelete",""]],
    "<p>foo</p><ol><li>ba{}az</li></ol><p>quz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>[baz]</ol><p>quz",
    [["forwarddelete",""]],
    "<p>foo</p><ol><li>bar</li><li>{}<br></li></ol><p>quz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>b]ar<li>baz</ol><p>quz",
    [["forwarddelete",""]],
    "<p>fo{}ar</p><ol><li>baz</li></ol><p>quz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>b]az</ol><p>quz",
    [["forwarddelete",""]],
    "<p>fo{}az</p><p>quz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<p>fo{}uz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<p>fo{}uz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ol><li>b]ar</ol>",
    [["forwarddelete",""]],
    "<ol><li>fo{}ar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ul><li>b]ar</ul>",
    [["forwarddelete",""]],
    "<ol><li>fo{}ar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[<ol><li>]bar</ol>",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>]bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[<dl><dt>]bar<dd>baz</dl>",
    [["forwarddelete",""]],
    "foo{}bar<dl><dd>baz</dd></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[<dl><dd>]bar</dl>",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dd>]bar</dl>",
    [["forwarddelete",""]],
    "<dl><dt>foo{}bar</dt></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dt>]bar<dd>baz</dl>",
    [["forwarddelete",""]],
    "<dl><dt>foo{}bar</dt><dd>baz</dd></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[<dd>]baz</dl>",
    [["forwarddelete",""]],
    "<dl><dt>foo</dt><dd>bar{}baz</dd></dl>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol><p>{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</ol><p>{}<br></p><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li><p>foo</p></li></ol><p>{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol id=\"a\"><li>foo</li></ol>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol id=\"a\"><li>foo</li></ol>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol class=a><li>foo</ol>{}<br><ol class=b><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol class=\"a\"><li>foo</li></ol>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo</ol><li>{}<br><ol><li>bar</ol></ol>",
    [["forwarddelete",""]],
    "<ol><ol><li>foo</li></ol><li>{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo</ol><li>{}<br></li><ol><li>bar</ol></ol>",
    [["forwarddelete",""]],
    "<ol><ol><li>foo</li></ol><li>{}bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol>bar]<ol><li>baz</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}</li><li>baz</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo{}</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo{}</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li><p>foo{}</p></li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li><p>foo{}</p></li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>fo[]o</ol><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>fo[]</li></ol><ol><li>bar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar<ol><li>]baz</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol>{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li>]baz</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol><p>{}baz</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
    [["defaultparagraphseparator","div"],["forwarddelete",""]],
    "<ol><li>foo</li></ol><p>{}baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
    [["defaultparagraphseparator","p"],["forwarddelete",""]],
    "<ol><li>foo</li></ol><p>{}baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><ol><li>[]bar</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol><ol><li>{}ar</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo[</ol><li>bar</ol>baz]<ol><li>quz</ol>",
    [["forwarddelete",""]],
    "<ol><ol><li>foo{}</li></ol><li>quz</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ul><li>bar</ul>",
    [["forwarddelete",""]],
    "<ul><li>foo</li></ul>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ul><li>bar</ul>",
    [["forwarddelete",""]],
    "<ul><li>foo</li></ul><p>{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>bar]</ol><ol><li>baz</ol><ol><li>quz</ol>",
    [["forwarddelete",""]],
    "<ol><li>foo{}</li><li>baz</li><li>quz</li></ol>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ul><li>bar</ul>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ul><li>bar</ul>",
    [["forwarddelete",""]],
    "<ol><li>foo</li></ol><p>{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ul><li>foo</li></ul>{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ol><li>bar</ol>",
    [["forwarddelete",""]],
    "<ul><li>foo</li></ul><p>{}bar</p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>[foo]</b>",
    [["forwarddelete",""]],
    "<p>{}<br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><quasit>[foo]</quasit>",
    [["forwarddelete",""]],
    "<p>{}<br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><b><i>[foo]</i></b>",
    [["forwarddelete",""]],
    "<p>{}<br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>{foo}</b>",
    [["forwarddelete",""]],
    "<p>{}<br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p>{<b>foo</b>}",
    [["forwarddelete",""]],
    "<p>{}<br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>[]f</b>",
    [["forwarddelete",""]],
    "<p>{}<br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<b>[foo]</b>",
    [["forwarddelete",""]],
    "{}<br>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><b>[foo]</b></div>",
    [["forwarddelete",""]],
    "<div>{}<br></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div></div><div><div>bar</div></div></div>",
    [["forwarddelete",""]],
    "<div><div><p>foobar</p></div></div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><div></div><div>bar</div>",
    [["forwarddelete",""]],
    "<div>foobar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><span></span><div>bar</div>",
    [["forwarddelete",""]],
    "<div>foobar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><!-- comment --><div>bar</div>",
    [["forwarddelete",""]],
    "<div>foobar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>ab[]c </div>",
    [["forwarddelete",""]],
    "<div>ab</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>ab[]c  </div>",
    [["forwarddelete",""]],
    "<div>ab</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[] </div>",
    [["forwarddelete",""]],
    "<div>abc </div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc [] </div>",
    [["forwarddelete",""]],
    "<div>abc  </div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[] </div><div>def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[]  </div><div>def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc [] </div><div>def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[]</div><div> def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[]</div><div>  def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[] </div><div> def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc [] </div><div>  def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div>abc[]  </div> <div>  def</div>",
    [["forwarddelete",""]],
    "<div>abcdef</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<img contenteditable=false src=/img/lion.svg>bar",
    [["forwarddelete",""]],
    "foo{}bar",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span contenteditable=false>bar</span>baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span contenteditable=false>bar</span><span contenteditable=false>baz</span>qux",
    [["forwarddelete",""]],
    "foo[]<span contenteditable=\"false\">baz</span>qux",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span contenteditable=false><span>b</span><span>a</span><span>r</span></span>baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div contenteditable=false>bar</div>baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span contenteditable=false><b>bar</b></span>baz",
    [["forwarddelete",""]],
    "foo{}baz",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["foo<span>bar[]<span contenteditable=false>baz</span></span>qux",
    [["forwarddelete",""]],
    "foo<span>bar{}</span>qux",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<span>[abc]</span>",
    [["forwarddelete",""]],
    "<br>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<span>[abc]</span><br>",
    [["forwarddelete",""]],
    "<br>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><span>[abc]</span></p>",
    [["forwarddelete",""]],
    "<p><br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p><span>[abc]</span><br></p>",
    [["forwarddelete",""]],
    "<p><br></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
// XXX Perhaps, replacing with <br> element is better, but this is common behavior.
["<p contenteditable=false><span contenteditable=true>[abc]</span></p>",
    [["forwarddelete",""]],
    "<p contenteditable=\"false\"><span contenteditable=\"true\"></span></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div>{}<br></div></div>",
    [["forwarddelete",""]],
    ["", "<br>"],
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div contenteditable=false><div contenteditable><div>{}<br></div></div></div></div>",
    [["forwarddelete",""]],
    ["<div><div contenteditable=\"false\"><div contenteditable=\"\"></div></div></div>",
     "<div><div contenteditable=\"false\"><div contenteditable=\"\"><br></div></div></div>"],
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div><div contenteditable=false><span contenteditable>{}<br></span></div></div>",
    [["forwarddelete",""]],
    ["<div><div contenteditable=\"false\"><span contenteditable=\"\"></span></div></div>",
     "<div><div contenteditable=\"false\"><span contenteditable=\"\"><br></span></div></div>"],
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[] \nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]\n bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]\n\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">foo[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>[]f\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre\">[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[] \nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]\n bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo[] bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]\n\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">foo[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>[]f\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-wrap\">[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[] \nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]\n bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]\n\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">foo[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>[]f\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:pre-line\">[]\nbar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[] \nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]\n bar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]\n\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>[]f\nbar</div>",
    [["forwarddelete",""]],
    "<div style=\"white-space:nowrap\">[]bar</div>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><span contenteditable>a[b]c</span></p>",
    [["forwarddelete",""]],
    "<p contenteditable=\"false\"><span contenteditable=\"\">ac</span></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><unknown-element contenteditable>a[b]c</unknown-element></p>",
    [["forwarddelete",""]],
    "<p contenteditable=\"false\"><unknown-element contenteditable=\"\">ac</unknown-element></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
// Although it seems that browsers should put <br> element to make the inline
// editing host has one-line height, but currently Blink and Firefox do not do
// it.
["<p contenteditable=\"false\"><span contenteditable>[abc]</span></p>",
    [["forwarddelete",""]],
    "<p contenteditable=\"false\"><span contenteditable=\"\"></span></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><span contenteditable>a[bc<br>de]f</span></p>",
    [["forwarddelete",""]],
    ["<p contenteditable=\"false\"><span contenteditable=\"\">af</span></p>",
     "<p contenteditable=\"false\"><span contenteditable=\"\">a<br>f</span></p>"],
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><unknown-element contenteditable>[abc]</unknown-element></p>",
    [["forwarddelete",""]],
    "<p contenteditable=\"false\"><unknown-element contenteditable=\"\"></unknown-element></p>",
    [true],
    {"forwarddelete":[false,false,"",false,false,""]}],
]
