promise_test(async t => {
  const bundle_url = 'https://{{domains[]}}:{{ports[https][0]}}/web-bundle/resources/wbn/dynamic1.wbn?pipe=trickle(d0.5)';
  const script_url = 'https://{{domains[]}}:{{ports[https][0]}}/web-bundle/resources/wbn/dynamic/resource1.js';
  const element = createWebBundleElement(
      '../resources/wbn/dynamic1.wbn?pipe=trickle(d0.5)',
      /*resources=*/[script_url]);
  document.body.appendChild(element);
  var script_entries = 0;
  var web_bundle_entries = 0;
  var web_bundle_entry, script_entry;
  const promise = new Promise(resolve => {
    new PerformanceObserver(t.step_func(entryList => {
      var entries = entryList.getEntriesByType('resource');
      for (var i = 0; i < entries.length; ++i) {
        if (entries[i].name === script_url) {
          script_entry = entries[i];
          script_entries++;
        }

        if (entries[i].name === bundle_url) {
          web_bundle_entry = entries[i];
          web_bundle_entries++;
        }
      }

      if (web_bundle_entries > 0 && script_entries > 0) {
        // Check timestamps.
        assert_greater_than_equal(
            script_entry.responseStart,
            script_entry.requestStart + 500);
        assert_greater_than_equal(
            script_entry.responseStart,
            web_bundle_entry.responseStart);
        assert_greater_than_equal(
            script_entry.responseEnd,
            script_entry.responseStart);
        assert_greater_than_equal(
            script_entry.requestStart,
            script_entry.connectEnd);
        assert_greater_than_equal(
            script_entry.responseEnd,
            script_entry.responseStart);
        // Check sizes.
        assert_greater_than(script_entry.encodedBodySize, 0);
        assert_equals(
            script_entry.transferSize,
            script_entry.encodedBodySize + 300);
        assert_equals(
            script_entry.encodedBodySize,
            script_entry.decodedBodySize);
        resolve();
      }
    })).observe({entryTypes: ['resource']});
  });
  const script = document.createElement('script');
  script.type = 'module';
  script.src = script_url;
  document.body.appendChild(script);
  return promise;
},
'Timestamp attributes filled in resource timing entries should be consistent.');