class MyCustomElement extends HTMLElement {};
customElements.define("custom-element", MyCustomElement);
// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["delete",""]],
    "fo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["delete",""]],
    "<span>fo[]</span><span>bar</span>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
    [["delete",""]],
    "<span>foo[]</span><span>bar</span>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span style=display:none>bar</span>[]baz",
    [["stylewithcss","true"],["delete",""]],
    "fo[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo<span style=display:none>bar</span>[]baz",
    [["stylewithcss","false"],["delete",""]],
    "fo[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<script>bar</script>[]baz",
    [["delete",""]],
    "fo[]baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["fo&ouml;[]bar",
    [["delete",""]],
    "fo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo&#x308;[]bar",
    [["delete",""]],
    "foo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo&#x308;&#x327;[]bar",
    [["delete",""]],
    "foö[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["&ouml;[]bar",
    [["delete",""]],
    "{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["o&#x308;[]bar",
    [["delete",""]],
    "o[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["o&#x308;&#x327;[]bar",
    [["delete",""]],
    "ö[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["&#x5e9;&#x5c1;&#x5b8;[]&#x5dc;&#x5d5;&#x5b9;&#x5dd;",
    [["delete",""]],
    "שׁ[]לוֹם",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["&#x5e9;&#x5c1;&#x5b8;&#x5dc;&#x5d5;&#x5b9;[]&#x5dd;",
    [["delete",""]],
    "שָׁלו[]ם",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>[]bar",
    [["delete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<p>[]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<p>[]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br></p><p>[]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br></p><p>[]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br></p>[]bar",
    [["delete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br><p>[]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><p>[]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br></p><p>[]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo<br>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br></p><p>[]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo<br>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br></p>[]bar",
    [["delete",""]],
    "<p>foo<br>{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br><br><p>[]bar</p>",
    [["delete",""]],
    "foo<br><p>{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><p>[]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><p>[]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><div><p>[]bar</p></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><div><p>[]bar</p></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><div><p>[]bar</p></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><div><p>[]bar</p></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><p>foo{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div>[]bar",
    [["delete",""]],
    "<div><p>foo{}bar</p></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<div><p>[]bar</p></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><p>[]bar</p></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div>foo</div><div>[]bar</div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div>foo{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div>foo</div><div>[]bar</div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div>foo{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<pre>foo</pre>[]bar",
    [["delete",""]],
    "<pre>foo{}bar</pre>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br>[]bar",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br><b>[]bar</b>",
    [["delete",""]],
    "foo{}<b>bar</b>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<hr>[]bar",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<hr><p>[]bar",
    [["delete",""]],
    "<p>foo</p><p>{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><br><p>[]bar</p>",
    [["delete",""]],
    "<p>foo</p><p>{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><br><br><p>[]bar</p>",
    [["delete",""]],
    "<p>foo</p><br><p>{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><img src=/img/lion.svg><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo</p><img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><img src=/img/lion.svg><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo</p><img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<img src=/img/lion.svg>[]bar",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<a>foo</a>[]bar",
    [["delete",""]],
    "foo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<a href=/>foo</a>[]bar",
    [["delete",""]],
    "foo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<a name=abc>foo</a>[]bar",
    [["delete",""]],
    "foo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<a href=/ name=abc>foo</a>[]bar",
    [["delete",""]],
    "foo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span><a>foo</a></span>[]bar",
    [["delete",""]],
    "<span>foo</span>[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span><a href=/>foo</a></span>[]bar",
    [["delete",""]],
    "<span>foo</span>[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span><a name=abc>foo</a></span>[]bar",
    [["delete",""]],
    "<span>foo</span>[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span><a href=/ name=abc>foo</a></span>[]bar",
    [["delete",""]],
    "<span>foo</span>[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<a>[]bar</a>",
    [["delete",""]],
    "fo[]<a>bar</a>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<a href=/>[]bar</a>",
    [["delete",""]],
    "fo[]<a href=\"/\">bar</a>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<a name=abc>[]bar</a>",
    [["delete",""]],
    "fo[]<a name=\"abc\">bar</a>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<a href=/ name=abc>[]bar</a>",
    [["delete",""]],
    "fo[]<a href=\"/\" name=\"abc\">bar</a>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo &nbsp;[]",
    [["delete",""]],
    "foo&nbsp;[]",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["&nbsp;[] foo",
    [["delete",""]],
    "{}&nbsp;foo",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo &nbsp;[]bar",
    [["delete",""]],
    "foo []bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo&nbsp; []bar",
    [["delete",""]],
    "foo []bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]bar",
    [["delete",""]],
    "foo []bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo  []bar",
    [["delete",""]],
    "foo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo []&nbsp; bar",
    [["delete",""]],
    "foo[]&nbsp; bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo &nbsp;[] bar",
    [["delete",""]],
    "foo&nbsp;[] bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo &nbsp; []bar",
    [["delete",""]],
    "foo&nbsp; []bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo []<span>&nbsp;</span> bar",
    [["delete",""]],
    "foo[]<span>&nbsp;</span> bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo <span>&nbsp;</span>[] bar",
    [["delete",""]],
    "foo&nbsp;{} bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo <span>&nbsp;</span> []bar",
    [["delete",""]],
    "foo&nbsp;<span> </span>{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>foo </b>&nbsp;[]bar",
    [["delete",""]],
    "<b>foo </b>{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>foo&nbsp;</b> []bar",
    [["delete",""]],
    "<b>foo </b>{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>foo&nbsp;</b>&nbsp;[]bar",
    [["delete",""]],
    "<b>foo </b>{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>foo </b> []bar",
    [["delete",""]],
    "<b>foo[]</b>bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo </p><p>[] bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo </p><p>[] bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]</pre>",
    [["delete",""]],
    "<pre>foo []</pre>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<pre>&nbsp;[] foo</pre>",
    [["delete",""]],
    "<pre>{} foo</pre>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]bar</pre>",
    [["delete",""]],
    "<pre>foo []bar</pre>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<pre>foo&nbsp; []bar</pre>",
    [["delete",""]],
    "<pre>foo&nbsp;[]bar</pre>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<pre>foo  []bar</pre>",
    [["delete",""]],
    "<pre>foo []bar</pre>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo []</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>&nbsp;[] foo</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">{} foo</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo&nbsp; []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo&nbsp;[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo  []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo []</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>&nbsp;[] foo</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">{} foo</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo&nbsp; []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo&nbsp;[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo  []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo&nbsp;[]</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>&nbsp;[] foo</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">{}&nbsp;foo</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo&nbsp; []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo  []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo&nbsp;[]</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>&nbsp;[] foo</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">{}&nbsp;foo</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo&nbsp; []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo  []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>b[]</table>baz",
    [["delete",""]],
    "foo<table><tbody><tr><td>[]<br></td></tr></tbody></table>baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>[]bar</table>baz",
    [["delete",""]],
    "foo<table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar</table>[]baz",
    [["delete",""]],
    "foo{<table><tbody><tr><td>bar</td></tr></tbody></table>}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>[]bar</table><p>baz",
    [["delete",""]],
    "<p>foo</p><table><tbody><tr><td>[]bar</td></tr></tbody></table><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar</table><p>[]baz",
    [["delete",""]],
    "<p>foo</p>{<table><tbody><tr><td>bar</td></tr></tbody></table>}<p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo</td><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<tr><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo</td></tr><tr><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br><table><tr><td>[]bar</table>baz",
    [["delete",""]],
    "foo<table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar<br></table>[]baz",
    [["delete",""]],
    "foo{<table><tbody><tr><td>bar<br></td></tr></tbody></table>}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<br><table><tr><td>[]bar</table><p>baz",
    [["delete",""]],
    "<p>foo<br></p><table><tbody><tr><td>[]bar</td></tr></tbody></table><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar<br></table><p>[]baz",
    [["delete",""]],
    "<p>foo</p>{<table><tbody><tr><td>bar<br></td></tr></tbody></table>}<p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo</td><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><tr><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo</td></tr><tr><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br><br><table><tr><td>[]bar</table>baz",
    [["delete",""]],
    "foo<br><br><table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar<br><br></table>[]baz",
    [["delete",""]],
    "foo{<table><tbody><tr><td>bar<br><br></td></tr></tbody></table>}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br><table><tr><td>[]bar</table><p>baz",
    [["delete",""]],
    "<p>foo<br><br></p><table><tbody><tr><td>[]bar</td></tr></tbody></table><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar<br><br></table><p>[]baz",
    [["delete",""]],
    "<p>foo</p>{<table><tbody><tr><td>bar<br><br></td></tr></tbody></table>}<p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><br><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo<br><br></td><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><br><tr><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo<br><br></td></tr><tr><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<hr><table><tr><td>[]bar</table>baz",
    [["delete",""]],
    "foo<hr><table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar<hr></table>[]baz",
    [["delete",""]],
    "foo{<table><tbody><tr><td>bar<hr></td></tr></tbody></table>}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<hr><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo<hr></td><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<hr><tr><td>[]bar</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo<hr></td></tr><tr><td>{}bar</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<ol><li>[]bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div>[]bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<ol><li>[]bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<p>[]bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<br><ol><li>[]bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div>[]bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><ol><li>[]bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<p>[]bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<br><br><ol><li>[]bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<br><br><div>[]bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><br><ol><li>[]bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<br><br><p>[]bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[]bar</ol>",
    [["delete",""]],
    "<ol><li>foo<br>[]bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><li>[]bar</ol>",
    [["delete",""]],
    "<ol><li>foo<br>[]bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br><li>[]bar</ol>",
    [["delete",""]],
    "<ol><li>foo<br><br>[]bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[]bar<br>baz</ol>",
    [["delete",""]],
    "<ol><li>foo<br>[]bar<br>baz</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br>bar<li>[]baz</ol>",
    [["delete",""]],
    "<ol><li>foo<br>bar<br>[]baz</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</p>{}bar</ol>",
    [["delete",""]],
    "<ol><li><p>foo{}bar</p></li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo<li>[]bar</ol>",
    [["delete",""]],
    "<ol><li><p>foo</p>[]bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><p>[]bar</ol>",
    [["delete",""]],
    "<ol><li>foo<p>[]bar</p></li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo<li><p>[]bar</ol>",
    [["delete",""]],
    "<ol><li><p>foo</p><p>[]bar</p></li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<ul><li>[]bar</ul></ol>",
    [["delete",""]],
    "<ol><li>foo</li><li>[]bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<ol><ol><li>[]bar</ol></ol>",
    [["delete",""]],
    "foo<ol><li>[]bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<div><ol><li>[]bar</ol></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div><div>[]bar</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><ol><li>[]bar</ol></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<div><p>[]bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dt>[]bar<dd>baz</dl>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div>[]bar</div><dl><dd>baz</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dt>[]bar<dd>baz</dl>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<p>[]bar</p><dl><dd>baz</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dd>[]bar</dl>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div>[]bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dd>[]bar</dl>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<p>[]bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>[]bar</dl>",
    [["delete",""]],
    "<dl><dt>foo<br>[]bar</dt></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dt>[]bar<dd>baz</dl>",
    [["delete",""]],
    "<dl><dt>foo<br>[]bar</dt><dd>baz</dd></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dd>[]baz</dl>",
    [["delete",""]],
    "<dl><dt>foo</dt><dd>bar<br>[]baz</dd></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[]bar",
    [["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol>[]bar",
    [["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol>[]bar",
    [["delete",""]],
    "<ol><li>foo<br>{}bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol>[]bar",
    [["delete",""]],
    "<ol><li>{}bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol>[]bar",
    [["delete",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo<br>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo<br>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br>",
    [["delete",""]],
    "<ol><li>foo{}</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol>{}<br>",
    [["delete",""]],
    "<ol><li>foo{}</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol>{}<br>",
    [["delete",""]],
    "<ol><li>foo<br>{}<br></li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol>{}<br>",
    [["delete",""]],
    "<ol><li>{}<br></li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol>{}<br>",
    [["delete",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>{}<br>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>{}<br>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>{}<br>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo<br>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>{}<br>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo<br>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>{}<br>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>{}<br>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>{}<br>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>{}<br>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote>[]bar</blockquote>",
    [["delete",""]],
    "foo<br>[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote><blockquote>[]bar</blockquote></blockquote>",
    [["delete",""]],
    "foo<blockquote>[]bar</blockquote>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote><div>[]bar</div></blockquote>",
    [["delete",""]],
    "foo<div>[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\">[]bar</blockquote>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\">[]bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\">[]bar</blockquote>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\">[]bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><blockquote><p>[]bar<p>baz</blockquote></blockquote>",
    [["delete",""]],
    "foo<blockquote><p>[]bar</p><blockquote><p>baz</p></blockquote></blockquote>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote><div><p>[]bar<p>baz</div></blockquote>",
    [["delete",""]],
    "foo<div><p>[]bar</p><blockquote><p>baz</p></blockquote></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\"><p>[]bar<p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\"><p>[]bar</p><blockquote><p>baz</p></blockquote></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\"><p>[]bar<p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\"><p>[]bar</p><blockquote><p>baz</p></blockquote></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><p><b>[]bar</b><p>baz</blockquote>",
    [["delete",""]],
    "foo<p><b>[]bar</b></p><blockquote><p>baz</p></blockquote>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote><p><strong>[]bar</strong><p>baz</blockquote>",
    [["delete",""]],
    "foo<p><strong>[]bar</strong></p><blockquote><p>baz</p></blockquote>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote><p><span>[]bar</span><p>baz</blockquote>",
    [["delete",""]],
    "foo<p><span>[]bar</span></p><blockquote><p>baz</p></blockquote>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>[]bar</ol></blockquote><p>extra",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<blockquote><div>[]bar</div></blockquote><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>[]bar</ol></blockquote><p>extra",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<blockquote><p>[]bar</p></blockquote><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote>bar<ol><li>[]baz</ol>quz</blockquote><p>extra",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<blockquote>bar<div>[]baz</div>quz</blockquote><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote>bar<ol><li>[]baz</ol>quz</blockquote><p>extra",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<blockquote>bar<p>[]baz</p>quz</blockquote><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>bar</li><ol><li>[]baz</ol><li>quz</ol></blockquote><p>extra",
    [["delete",""]],
    "foo<blockquote><ol><li>bar</li><li>[]baz</li><li>quz</li></ol></blockquote><p>extra</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span></span>[]bar",
    [["delete",""]],
    "fo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span><span></span></span>[]bar",
    [["delete",""]],
    "fo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<quasit></quasit>[]bar",
    [["delete",""]],
    "fo[]bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br><span></span>[]bar",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span>foo<span></span></span>[]bar",
    [["delete",""]],
    "<span>fo[]</span>bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span></span><span>[]bar</span>",
    [["delete",""]],
    "fo[]<span>bar</span>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<div><div><p>[]bar</div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><p>[]bar</div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><p><!--abc-->[]bar</div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><p><!--abc-->[]bar</div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><!--abc--><p>[]bar</div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><!--abc--><p>[]bar</div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<div><!--abc--><div><p>[]bar</div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><!--abc--><div><p>[]bar</div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<!--abc--><div><div><p>[]bar</div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<!--abc--><div><div><p>[]bar</div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</div></div>[]bar",
    [["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</div></div><!--abc-->[]bar",
    [["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</div><!--abc--></div>[]bar",
    [["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p><!--abc--></div></div>[]bar",
    [["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo<!--abc--></div></div>[]bar",
    [["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo<!--abc--></p></div></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo<!--abc--></p></div></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p><!--abc--></div></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p><!--abc--></div></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div><!--abc--></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div><!--abc--></div><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><!--abc--><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><!--abc--><div><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><!--abc--><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><!--abc--><div><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><!--abc--><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><!--abc--><div>[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div><!--abc-->[]bar</div></div></div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div><!--abc-->[]bar</div></div></div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><div><p>foo{}bar</p></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p><font color=\"#0000ff\">foo{}</font>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p><font color=\"#0000ff\">foo{}</font>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><font color=\"blue\">foo</font>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><font color=\"blue\">foo</font>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p><font color=brown>[]bar</font>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p><font color=brown>[]bar</font>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><font color=brown>[]bar</font>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><font color=brown>[]bar</font>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<font color=\"brown\">bar</font></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p><span style=color:brown>[]bar</font>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p><span style=color:brown>[]bar</font>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=color:brown>[]bar</font>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=color:brown>[]bar</font>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p><span style=background-color:tan>[]bar</font>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p><span style=background-color:tan>[]bar</font>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=background-color:tan>[]bar</font>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=background-color:tan>[]bar</font>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p><u>foo{}</u>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p><u>foo{}</u>bar</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p><u>foo{}</u><s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p><u>foo{}</u><s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p>[]bar",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><u>foo</u>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p>[]bar",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><u>foo</u>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p><s>[]bar</s>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><u>foo</u>{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p><s>[]bar</s>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><u>foo</u>{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><s>[]bar</s>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><s>[]bar</s>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<s>bar</s></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo</p>[]bar",
    [["stylewithcss","true"],["delete",""]],
    "<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo</p>[]bar",
    [["stylewithcss","false"],["delete",""]],
    "<p><font color=\"#0000ff\">foo{}</font>bar</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "foo{}<font color=\"#a52a2a\">bar</font>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "foo{}<font color=\"#a52a2a\">bar</font>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div>[]bar",
    [["stylewithcss","true"],["delete",""]],
    "<div><p><span style=\"color:rgb(0, 128, 0)\">foo{}</span>bar</p></div>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div>[]bar",
    [["stylewithcss","false"],["delete",""]],
    "<div><p><font color=\"#008000\">foo{}</font>bar</p></div>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["delete",""]],
    "foo[]baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","true"],["delete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","false"],["delete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","true"],["delete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","false"],["delete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","true"],["delete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","false"],["delete",""]],
    "<p>foo{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["delete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["delete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["delete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["delete",""]],
    "<p>{}baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","true"],["delete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","false"],["delete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","true"],["delete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","false"],["delete",""]],
    "<p>foo{}</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["delete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["delete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["stylewithcss","true"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["stylewithcss","false"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
    [["stylewithcss","true"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
    [["stylewithcss","false"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["stylewithcss","true"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["stylewithcss","false"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<span>[bar]</span>baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span>{bar}</span>baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo{<span>bar</span>}baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>foo[bar</b><i>baz]quz</i>",
    [["delete",""]],
    "<b>foo[]</b><i>quz</i>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[bar]</p><p>baz</p>",
    [["delete",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar}</p><p>baz</p>",
    [["delete",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar</p>}<p>baz</p>",
    [["delete",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo</p>{}<br><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo</p>{}<br><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo</p>{}<p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo</p>{}<p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<h1>baz]quz</h1>",
    [["delete",""]],
    "<p>foo{}quz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div>foo{}quz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div>foo{}quz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote><pre>baz]quz</pre>",
    [["delete",""]],
    "<blockquote>foo{}quz</blockquote>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p><b>foo</b>{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p><b>foo</b>{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><p>foo{}quz</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><p>foo{}quz</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<font color=\"#0000ff\">quz</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<font color=\"#0000ff\">quz</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}<b>quz</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}<b>quz</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<div><p>foo</p><p>{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<div><p>foo</p><p>{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<br>]bar",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar<br>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar<br>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar<br>baz</p>",
    [["delete",""]],
    "foo{}bar<p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<p>{bar</p>}baz",
    [["delete",""]],
    "foo<p>{}baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar",
    [["delete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo{</p>}bar",
    [["delete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<br>baz",
    [["delete",""]],
    "<p>foo{}bar</p>baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<p>baz</p>",
    [["delete",""]],
    "<p>foo{}bar</p><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo[</p></div>]bar",
    [["delete",""]],
    "<div><p>foo{}bar</p></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar<div>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar<div>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<div>]bar<p>baz</p></div>",
    [["delete",""]],
    "foo{}bar<div><p>baz</p></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p>bar[</div>]baz",
    [["delete",""]],
    "<div><p>foo</p>bar{}baz</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>foo<p>bar[</p></div>]baz",
    [["delete",""]],
    "<div>foo<p>bar{}baz</p></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p>]bar",
    [["delete",""]],
    "<p>foo{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p>]bar",
    [["delete",""]],
    "<p>foo<br>{}bar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "foo<br>{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "foo<br>{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo<br>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo<br>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>[bar]<th>baz<tr><td>quz<td>qoz<td>qiz</table>",
    [["delete",""]],
    "<table><tbody><tr><th>foo</th><th>{}<br></th><th>baz</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>ba[r<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
    [["delete",""]],
    "<table><tbody><tr><th>foo</th><th>ba[]</th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>fo[o<th>bar<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
    [["delete",""]],
    "<table><tbody><tr><th>fo[]</th><th><br></th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>bar<th>ba[z<tr><td>q]uz<td>qoz<td>qiz</table>",
    [["delete",""]],
    "<table><tbody><tr><th>foo</th><th>bar</th><th>ba[]</th></tr><tr><td>uz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz]<tr><td>quz<td>qoz<td>qiz</table>",
    [["delete",""]],
    "<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz]</table>",
    [["delete",""]],
    "<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td><br></td><td><br></td><td><br></td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["{<table><tbody><tr><th>foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz</table>}",
    [["delete",""]],
    "{}<br>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>ba[r<tr><td>baz<td>quz<tr><td>q]oz<td>qiz</table>",
    [["delete",""]],
    "<table><tbody><tr><td>foo</td><td>ba[]</td></tr><tr><td><br></td><td><br></td></tr><tr><td>oz</td><td>qiz</td></tr></tbody></table>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>b]ar</table><p>baz",
    [["delete",""]],
    "<p>fo[]</p><table><tbody><tr><td>ar</td></tr></tbody></table><p>baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>ba[r</table><p>b]az",
    [["delete",""]],
    "<p>foo</p><table><tbody><tr><td>ba[]</td></tr></tbody></table><p>az</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>fo{}az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>fo{}az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>ba[r<li>b]az</ol><p>quz",
    [["delete",""]],
    "<p>foo</p><ol><li>ba{}az</li></ol><p>quz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>[baz]</ol><p>quz",
    [["delete",""]],
    "<p>foo</p><ol><li>bar</li><li>{}<br></li></ol><p>quz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>b]ar<li>baz</ol><p>quz",
    [["delete",""]],
    "<p>fo{}ar</p><ol><li>baz</li></ol><p>quz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>b]az</ol><p>quz",
    [["delete",""]],
    "<p>fo{}az</p><p>quz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<p>fo{}uz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<p>fo{}uz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ol><li>b]ar</ol>",
    [["delete",""]],
    "<ol><li>fo{}ar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ul><li>b]ar</ul>",
    [["delete",""]],
    "<ol><li>fo{}ar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo[<ol><li>]bar</ol>",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>]bar</ol>",
    [["delete",""]],
    "<ol><li>foo{}bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo[<dl><dt>]bar<dd>baz</dl>",
    [["delete",""]],
    "foo{}bar<dl><dd>baz</dd></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo[<dl><dd>]bar</dl>",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dd>]bar</dl>",
    [["delete",""]],
    "<dl><dt>foo{}bar</dt></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dt>]bar<dd>baz</dl>",
    [["delete",""]],
    "<dl><dt>foo{}bar</dt><dd>baz</dd></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[<dd>]baz</dl>",
    [["delete",""]],
    "<dl><dt>foo</dt><dd>bar{}baz</dd></dl>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>foo [&nbsp;</b>bar]",
    [["delete",""]],
    "<b>foo&nbsp;[]</b>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<b> [&nbsp;bar]</b>",
    [["delete",""]],
    "foo<b>&nbsp;[]</b>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>[foo&nbsp;] </b>bar",
    [["delete",""]],
    "<b>{}&nbsp;</b>bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["[foo<b>&nbsp;] bar</b>",
    [["delete",""]],
    "{}<b>&nbsp;bar</b>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p style=display:inline>fo[o<p style=display:inline>b]ar",
    [["delete",""]],
    "<p style=\"display:inline\">fo[]</p><p style=\"display:inline\">ar</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span style=display:block>fo[o</span><span style=display:block>b]ar</span>",
    [["stylewithcss","true"],["delete",""]],
    "<span style=\"display:block\">fo{}ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<span style=display:block>fo[o</span><span style=display:block>b]ar</span>",
    [["stylewithcss","false"],["delete",""]],
    "<span style=\"display:block\">fo{}ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<span style=display:inline-block>fo[o</span><span style=display:inline-block>b]ar</span>",
    [["delete",""]],
    "<span style=\"display:inline-block\">fo[]</span><span style=\"display:inline-block\">ar</span>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span style=display:inline-table>fo[o</span><span style=display:inline-table>b]ar</span>",
    [["delete",""]],
    "<span style=\"display:inline-table\">fo[]</span><span style=\"display:inline-table\">ar</span>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span style=display:none>fo[o</span><span style=display:none>b]ar</span>",
    [["delete",""]],
    "<span style=\"display:none\">fo[]</span><span style=\"display:none\">ar</span>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<quasit style=display:block>fo[o</quasit><quasit style=display:block>b]ar</quasit>",
    [["stylewithcss","true"],["delete",""]],
    "<quasit style=\"display:block\">fo{}ar</quasit>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<quasit style=display:block>fo[o</quasit><quasit style=display:block>b]ar</quasit>",
    [["stylewithcss","false"],["delete",""]],
    "<quasit style=\"display:block\">fo{}ar</quasit>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol><li>bar</ol>",
    [["delete",""]],
    "<ol><li>foo{}</li><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ol><li>bar</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}</li><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ol><li>bar</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}</li><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</ol><p>{}<br></p><ol><li>bar</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li><p>foo{}</p></li><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</ol><p>{}<br></p><ol><li>bar</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li><p>foo{}</p></li><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol><li>bar</ol>",
    [["delete",""]],
    "<ol id=\"a\"><li>foo{}</li><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
    [["delete",""]],
    "<ol><li>foo{}</li><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
    [["delete",""]],
    "<ol id=\"a\"><li>foo{}</li><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol class=a><li>foo</ol>{}<br><ol class=b><li>bar</ol>",
    [["delete",""]],
    "<ol class=\"a\"><li>foo{}</li><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo</ol><li>{}<br></li><ol><li>bar</ol></ol>",
    [["delete",""]],
    "<ol><ol><li>foo{}</li><li>bar</li></ol></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol>bar]<ol><li>baz</ol>",
    [["delete",""]],
    "<ol><li>foo{}</li><li>baz</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li><p>foo{}</p></li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li><p>foo{}</p></li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><ol><li>bar</ol>",
    [["delete",""]],
    "<ol><li>fo[]</li></ol><ol><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar<ol><li>]baz</ol>",
    [["delete",""]],
    "<ol><li>foo</li></ol>{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li>]baz</ol>",
    [["delete",""]],
    "<ol><li>foo</li></ol><p>{}baz</p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo</li></ol><p>{}baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo</li></ol><p>{}baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><ol><li>b[]ar</ol>",
    [["delete",""]],
    "<ol><li>foo</li></ol><ol><li>{}ar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo[</ol><li>bar</ol>baz]<ol><li>quz</ol>",
    [["delete",""]],
    "<ol><ol><li>foo{}</li></ol><li>quz</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ul><li>bar</ul>",
    [["delete",""]],
    "<ul><li>foo{}</li><li>bar</li></ul>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ul><li>bar</ul>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ul><li>foo{}</li><li>bar</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ul><li>bar</ul>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ul><li>foo{}</li><li>bar</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>bar]</ol><ol><li>baz</ol><ol><li>quz</ol>",
    [["delete",""]],
    "<ol><li>foo{}</li><li>baz</li><li>quz</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ul><li>bar</ul>",
    [["delete",""]],
    "<ol><li>foo{}</li></ol><ul><li>bar</li></ul>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ul><li>bar</ul>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ol><li>foo{}</li></ol><ul><li>bar</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ul><li>bar</ul>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ol><li>foo{}</li></ol><ul><li>bar</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ol><li>bar</ol>",
    [["delete",""]],
    "<ul><li>foo{}</li></ul><ol><li>bar</li></ol>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ol><li>bar</ol>",
    [["defaultparagraphseparator","div"],["delete",""]],
    "<ul><li>foo{}</li></ul><ol><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ol><li>bar</ol>",
    [["defaultparagraphseparator","p"],["delete",""]],
    "<ul><li>foo{}</li></ul><ol><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><b>[foo]</b>",
    [["delete",""]],
    "<p>{}<br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><quasit>[foo]</quasit>",
    [["delete",""]],
    "<p>{}<br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><b><i>[foo]</i></b>",
    [["delete",""]],
    "<p>{}<br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><b>{foo}</b>",
    [["delete",""]],
    "<p>{}<br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p>{<b>foo</b>}",
    [["delete",""]],
    "<p>{}<br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><b>f[]</b>",
    [["delete",""]],
    "<p>{}<br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<b>[foo]</b>",
    [["delete",""]],
    "{}<br>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><b>[foo]</b></div>",
    [["delete",""]],
    "<div>{}<br></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div></div><div><div>[]bar</div></div></div>",
    [["delete",""]],
    "<div><div><p>foobar</p></div></div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>foo</div><div></div><div>[]bar</div>",
    [["delete",""]],
    "<div>foobar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>foo</div><span></span><div>[]bar</div>",
    [["delete",""]],
    "<div>foobar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>foo</div><!-- comment --><div>[]bar</div>",
    [["delete",""]],
    "<div>foobar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div> a[]bc</div>",
    [["delete",""]],
    "<div>bc</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>  a[]bc</div>",
    [["delete",""]],
    "<div>bc</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div> []abc</div>",
    [["delete",""]],
    "<div> abc</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div> [] abc</div>",
    [["delete",""]],
    "<div>  abc</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc</div><div> []def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc</div><div> [] def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc</div><div>  []def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc </div><div>[]def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc  </div><div>[]def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc </div><div> []def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc  </div><div> [] def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div>abc  </div> <div>  []def</div>",
    [["delete",""]],
    "<div>abcdef</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<img contenteditable=false src=/img/lion.svg>[]bar",
    [["delete",""]],
    "foo{}bar",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span contenteditable=false>bar</span>[]baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span contenteditable=false>bar</span><span contenteditable=false>baz</span>[]qux",
    [["delete",""]],
    "foo<span contenteditable=\"false\">bar</span>[]qux",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span contenteditable=false><span>b</span><span>a</span><span>r</span></span>[]baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<div contenteditable=false>bar</div>[]baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span contenteditable=false><b>bar</b></span>[]baz",
    [["delete",""]],
    "foo{}baz",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["foo<span>bar<span contenteditable=false>baz</span></span>[]qux",
    [["delete",""]],
    "foo<span>bar{}</span>qux",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span>[abc]</span>",
    [["delete",""]],
    "<br>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<span>[abc]</span><br>",
    [["delete",""]],
    "<br>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><span>[abc]</span></p>",
    [["delete",""]],
    "<p><br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p><span>[abc]</span><br></p>",
    [["delete",""]],
    "<p><br></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
// XXX Perhaps, replacing with <br> element is better, but this is common behavior.
["<p contenteditable=false><span contenteditable=true>[abc]</span></p>",
    [["delete",""]],
    "<p contenteditable=\"false\"><span contenteditable=\"true\"></span></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div>{}<br></div></div>",
    [["delete",""]],
    ["", "<br>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div contenteditable=false><div contenteditable><div>{}<br></div></div></div></div>",
    [["delete",""]],
    ["<div><div contenteditable=\"false\"><div contenteditable=\"\"></div></div></div>",
     "<div><div contenteditable=\"false\"><div contenteditable=\"\"><br></div></div></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div><div contenteditable=false><span contenteditable>{}<br></span></div></div></div>",
    [["delete",""]],
    ["<div><div contenteditable=\"false\"><span contenteditable=\"\"></span></div></div>",
     "<div><div contenteditable=\"false\"><span contenteditable=\"\"><br></span></div></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo \n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo\n []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo\n[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo\n\n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre\">foo\n[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo\nb[]</div>",
    [["delete",""]],
    ["<div style=\"white-space:pre\">foo\n[]\n</div>",
     "<div style=\"white-space:pre\">foo\n[]<br></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo \n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo []bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo\n []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo\n[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo\n\n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-wrap\">foo\n[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo\nb[]</div>",
    [["delete",""]],
    ["<div style=\"white-space:pre-wrap\">foo\n[]\n</div>",
     "<div style=\"white-space:pre-wrap\">foo\n[]<br></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo \n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo\n []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo\n\n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:pre-line\">foo\n[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo\nb[]</div>",
    [["delete",""]],
    ["<div style=\"white-space:pre-line\">foo\n[]\n</div>",
     "<div style=\"white-space:pre-line\">foo\n[]<br></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo \n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo\n []bar</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo\n\n[]bar</div>",
    [["delete",""]],
    "<div style=\"white-space:nowrap\">foo[]bar</div>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo\nb[]</div>",
    [["delete",""]],
    ["<div style=\"white-space:nowrap\">foo[]\n</div>",
     "<div style=\"white-space:nowrap\">foo[]<br></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><span contenteditable>a[b]c</span></p>",
    [["delete",""]],
    "<p contenteditable=\"false\"><span contenteditable=\"\">ac</span></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><unknown-element contenteditable>a[b]c</unknown-element></p>",
    [["delete",""]],
    "<p contenteditable=\"false\"><unknown-element contenteditable=\"\">ac</unknown-element></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
// Although it seems that browsers should put <br> element to make the inline
// editing host has one-line height, but currently Blink and Firefox do not do
// it.
["<p contenteditable=\"false\"><span contenteditable>[abc]</span></p>",
    [["delete",""]],
    "<p contenteditable=\"false\"><span contenteditable=\"\"></span></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><span contenteditable>a[bc<br>de]f</span></p>",
    [["delete",""]],
    ["<p contenteditable=\"false\"><span contenteditable=\"\">af</span></p>",
     "<p contenteditable=\"false\"><span contenteditable=\"\">af<br></span></p>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<p contenteditable=\"false\"><unknown-element contenteditable>[abc]</unknown-element></p>",
    [["delete",""]],
    "<p contenteditable=\"false\"><unknown-element contenteditable=\"\"></unknown-element></p>",
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p>[ab</p><p>c]d</p></custom-element></div>",
    [["delete",""]],
    ["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p>d</p></custom-element></div>",
     "<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p>d<br></p></custom-element></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p>a[b</p><p>cd]</p></custom-element></div>",
    [["delete",""]],
    ["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p>a</p></custom-element></div>",
     "<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p>a<br></p></custom-element></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p><b>[ab</b></p><p><i>c]d</i></p></custom-element></div>",
    [["delete",""]],
    ["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p><i>d</i></p></custom-element></div>",
     "<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p><i>d</i><br></p></custom-element></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p><b>a[b</b></p><p><i>cd]</i></p></custom-element></div>",
    [["delete",""]],
    ["<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p><b>a</b></p></custom-element></div>",
     "<div contenteditable=\"false\"><custom-element contenteditable=\"\"><p><b>a</b><br></p></custom-element></div>"],
    [true],
    {"delete":[false,false,"",false,false,""]}],
]
