#!/usr/bin/env python3
import os
import re

re_testname = re.compile(r"^appearance-.+\d\d\d\.html$")
re_link_match = re.compile(r'<link rel="(mis)?match"')

files = {}

parentdir = os.path.abspath(os.path.join(__file__, os.pardir, os.pardir))
assert parentdir.endswith('/css-ui')

for filename in os.listdir(parentdir):
    path = os.path.join(parentdir, filename)
    if os.path.isfile(path) and re_testname.search(filename) and not filename in files:
        with open(path, "r") as file:
            files[filename] = file.read()

warning = """<!-- DO NOT EDIT THIS FILE.
Edit the appearance-* file instead and then run:
    ./tools/appearance-build-webkit-reftests.py
-->
"""

for filename, text in files.items():
    if re_link_match.search(text):
        with open(os.path.join(parentdir, filename.replace("appearance-", "webkit-appearance-")), "w") as outfile:
            outfile.write(warning + text.replace("appearance:", "-webkit-appearance:"))
