// For documentation of the format, see README in this directory.
var browserTests = [
["foo[bar]baz",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["fo[o<table><tr><td>b]ar</table>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>fo</div><div>{}<br></div><table><tbody><tr><td>ar</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["fo[o<table><tr><td>b]ar</table>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>fo</p><p>{}<br></p><table><tbody><tr><td>ar</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo<td>bar]<tr><td>baz<td>quz</table>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<table><tbody><tr><td><div><br></div><div>{}<br></div></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo<td>bar]<tr><td>baz<td>quz</table>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<table><tbody><tr><td><p><br></p><p>{}<br></p></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<tr><td>baz<td>quz</table>",
    [["insertparagraph",""]],
    "<table><tbody>{}<tr><td><br></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o</table>b]ar",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<table><tbody><tr><td><div>fo</div><div>{}<br></div></td></tr></tbody></table>ar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o</table>b]ar",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<table><tbody><tr><td><p>fo</p><p>{}<br></p></td></tr></tbody></table>ar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o<td>b]ar<td>baz</table>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<table><tbody><tr><td><div>fo</div><div>{}<br></div></td><td>ar</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o<td>b]ar<td>baz</table>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<table><tbody><tr><td><p>fo</p><p>{}<br></p></td><td>ar</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["{<table><tr><td>foo</table>}",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><br></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["{<table><tr><td>foo</table>}",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo]</table>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<table><tbody><tr><td><div><br></div><div>{}<br></div></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo]</table>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<table><tbody><tr><td><p><br></p><p>{}<br></p></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[foo]<li>bar</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>{}<br></div><ol><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[foo]<li>bar</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>{}<br></p><ol><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>f[o]o<li>bar</ol>",
    [["insertparagraph",""]],
    "<ol><li>f</li><li>{}o</li><li>bar</li></ol>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["[]foo",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><br></div><div>{}foo</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["[]foo",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}foo</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><span>foo</span></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><span>foo</span></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]<br>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]<br>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address>[]foo</address>",
    [["insertparagraph",""]],
    "<address><br>{}foo</address>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<address>foo[]</address>",
    [["insertparagraph",""]],
    "<address>foo<br>{}<br></address>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<address>foo[]<br></address>",
    [["insertparagraph",""]],
    "<address>foo<br>{}<br></address>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<address>foo[]bar</address>",
    [["insertparagraph",""]],
    "<address>foo<br>{}bar</address>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>[]foo</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><br></div><div>{}foo</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>[]foo</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><br></div><div>{}foo</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div>foo</div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]<br></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]<br></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div>foo</div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]bar</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]bar</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div>foo</div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>[]foo<dd>bar</dl>",
    [["insertparagraph",""]],
    "<dl><dt><br></dt><dt>{}foo</dt><dd>bar</dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dd>bar</dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>{}<br></dd><dd>bar</dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<br><dd>bar</dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>{}<br></dd><dd>bar</dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo[]bar<dd>baz</dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dt>{}bar</dt><dd>baz</dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>[]bar</dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd><br></dd><dd>{}bar</dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]</dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>bar</dd><dt>{}<br></dt></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]<br></dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>bar</dd><dt>{}<br></dt></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]baz</dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>bar</dd><dd>{}baz</dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h1>[]foo</h1>",
    [["insertparagraph",""]],
    "<h1><br></h1><h1>{}foo</h1>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]</h1>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h1>foo</h1><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]</h1>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h1>foo</h1><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]<br></h1>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h1>foo</h1><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]<br></h1>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h1>foo</h1><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]bar</h1>",
    [["insertparagraph",""]],
    "<h1>foo</h1><h1>{}bar</h1>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[]foo</ol>",
    [["insertparagraph",""]],
    "<ol><li><br></li><li>{}foo</li></ol>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol>",
    [["insertparagraph",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol>",
    [["insertparagraph",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo[]bar</ol>",
    [["insertparagraph",""]],
    "<ol><li>foo</li><li>{}bar</li></ol>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<p>[]foo</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p>{}foo</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[]foo</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}foo</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]bar</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]bar</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<pre>[]foo</pre>",
    [["insertparagraph",""]],
    "<pre><br>{}foo</pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>",
    [["insertparagraph",""]],
    "<pre>foo<br>{}<br></pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]<br></pre>",
    [["insertparagraph",""]],
    "<pre>foo<br>{}<br></pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]bar</pre>",
    [["insertparagraph",""]],
    "<pre>foo<br>{}bar</pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]<br><br></pre>",
    [["insertparagraph",""]],
    "<pre>foo<br>{}<br><br></pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo<br>{}<br></pre>",
    [["insertparagraph",""]],
    "<pre>foo<br><br>{}<br></pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo&#10;[]</pre>",
    [["insertparagraph",""]],
    "<pre>foo\n<br>{}<br></pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]&#10;</pre>",
    [["insertparagraph",""]],
    "<pre>foo<br>{}\n</pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo&#10;[]&#10;</pre>",
    [["insertparagraph",""]],
    "<pre>foo\n<br>{}\n</pre>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<xmp>foo[]bar</xmp>",
    [["insertparagraph",""]],
    "<xmp>foo</xmp><xmp>{}bar</xmp>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<script>foo[]bar</script>baz",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><script>foo</script><br></div><div>{}<script>bar</script>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<script>foo[]bar</script>baz",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><script>foo</script><br></p><p>{}<script>bar</script>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<listing>foo[]bar</listing>",
    [["insertparagraph",""]],
    "<listing>foo<br>{}bar</listing>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<ol><li>{}<br></li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "foo<div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<ol><li>{}<br></li></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "foo<p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>foo",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>{}<br></div>foo",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>foo",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>{}<br></p>foo",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li>foo</li></ol><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li>foo</li></ol><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br><li>bar</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>{}<br></div><ol><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br><li>bar</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>{}<br></p><ol><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ul><li>{}<br></ul></ol>",
    [["insertparagraph",""]],
    "<ol><li>foo</li><li>{}<br></li></ol>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br></dt></dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br></dt></dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>{}<br></dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt>foo</dt></dl><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>{}<br></dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt>foo</dt></dl><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br><dd>bar</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>{}<br></div><dl><dd>bar</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br><dd>bar</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>{}<br></p><dl><dd>bar</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dl><dt>{}<br><dd>baz</dl></dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>bar</dd><dt>{}<br></dt><dd><dl><dd>baz</dd></dl></dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dl><dt>baz<dd>{}<br></dl></dl>",
    [["insertparagraph",""]],
    "<dl><dt>foo</dt><dd>bar<dl><dt>baz</dt></dl></dd><dd>{}<br></dd></dl>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[bar</h1><p>baz]quz</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h1>foo</h1><h1>{}quz</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[bar</h1><p>baz]quz</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h1>foo</h1><h1>{}quz</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[bar</p><h1>baz]quz</h1>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[bar</p><h1>baz]quz</h1>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><div><br></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p><br></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["{}<br><p>foo</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><br></div><div>{}<br></div><p>foo</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["{}<br><p>foo</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}<br></p><p>foo</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br><h1>bar</h1>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><div><br></div><div>{}<br></div><h1>bar</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br><h1>bar</h1>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p><br></p><p>{}<br></p><h1>bar</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><p>bar</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h1>foo</h1><div><br></div><div>{}<br></div><p>bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><p>bar</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h1>foo</h1><p><br></p><p>{}<br></p><p>bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><h2>bar</h2>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h1>foo</h1><div><br></div><div>{}<br></div><h2>bar</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><h2>bar</h2>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h1>foo</h1><p><br></p><p>{}<br></p><h2>bar</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p><h1>[bar]</h1><p>baz</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><h1><br></h1><div>{}<br></div><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p><h1>[bar]</h1><p>baz</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><h1><br></h1><p>{}<br></p><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{<h1>bar</h1>}<p>baz</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><div>{}<br></div><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{<h1>bar</h1>}<p>baz</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]bar</table>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<table><tbody><tr><td><div>foo</div><div>{}bar</div></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]bar</table>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<table><tbody><tr><td><p>foo</p><p>{}bar</p></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td><p>foo[]bar</table>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<table><tbody><tr><td><p>foo</p><p>{}bar</p></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td><p>foo[]bar</table>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<table><tbody><tr><td><p>foo</p><p>{}bar</p></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>[]foo</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><div><br></div><div>{}foo</div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>[]foo</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p><br></p><p>{}foo</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><div>foo</div><div>{}<br></div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}<br></p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]<br></blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><div>foo</div><div>{}<br></div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]<br></blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}<br></p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]bar</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><div>foo</div><div>{}bar</div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]bar</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}bar</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>[]foo</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><p><br></p><p>{}foo</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>[]foo</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p><br></p><p>{}foo</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}<br></p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}<br></p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}bar</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}bar</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]<p>bar</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}<br></p><p>bar</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]<p>bar</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}<br></p><p>bar</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar<p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}bar</p><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar<p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<blockquote><p>foo</p><p>{}bar</p><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><span>foo</span></div><div>{}<span>bar</span></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><span>foo</span></p><p>{}<span>bar</span></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>baz",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><span>foo</span></div><div>{}<span>bar</span>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>baz",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><span>foo</span></p><p>{}<span>bar</span>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b>baz</div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b>baz</div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b>baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b>baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]</b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b>foo</b></p><p><b>{}<br></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]</b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b>foo</b></div><div><b>{}<br></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><i>foo[]</i></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><i>foo</i></b></p><p><b><i>{}<br></i></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><i>foo[]</i></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><i>foo</i></b></div><div><b><i>{}<br></i></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><i><b>foo[]</b></i></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><i><b>foo</b></i></p><p><i><b>{}<br></b></i></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><i><b>foo[]</b></i></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><i><b>foo</b></i></div><div><i><b>{}<br></b></i></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<b>[]bar</b>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}<b>bar</b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<b>[]bar</b>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<b>bar</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>[]foo</b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><br></b></p><p><b>{}foo</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>[]foo</b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><br></b></div><div><b>{}foo</b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><i>[]foo</i></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><i><br></i></b></p><p><b><i>{}foo</i></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><i>[]foo</i></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><i><br></i></b></div><div><b><i>{}foo</i></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><i><b>[]foo</b></i></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><i><b><br></b></i></p><p><i><b>{}foo</b></i></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><i><b>[]foo</b></i></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><i><b><br></b></i></div><div><i><b>{}foo</b></i></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b><i>bar</i>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<i>bar</i></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b><i>bar</i>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<i>bar</i></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b id=\"x\" class=\"y\">foo</b></div><div>{}<b class=\"y\">bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b id=\"x\" class=\"y\">foo</b></div><div>{}<b class=\"y\">bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><i><b>foo</b></i></div><div>{}<i><b>bar</b>baz</i></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><i><b>foo</b></i></div><div>{}<i><b>bar</b>baz</i></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><i><b>foo</b></i></p><p>{}<i><b>bar</b>baz</i></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><i><b>foo</b></i></p><p>{}<i><b>bar</b>baz</i></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b>foo</b></p><p>{}<b>bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b>foo</b></div><div>{}<b>bar</b></div>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo</a></div><div>{}<a href=\"foo\">bar</a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo</a></p><p>{}<a href=\"foo\">bar</a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>baz",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo</a></div><div>{}<a href=\"foo\">bar</a>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>baz",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo</a></p><p>{}<a href=\"foo\">bar</a>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo>foo[]bar</a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo</a></p><p><a href=\"foo\">{}bar</a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>foo[]bar</a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo</a></div><div><a href=\"foo\">{}bar</a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo[]bar</b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo</b></a></p><p><a href=\"foo\"><b>{}bar</b></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo[]bar</b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo</b></a></div><div><a href=\"foo\"><b>{}bar</b></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><a href=foo>foo[]bar</a></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><a href=\"foo\">foo</a></b></p><p><b><a href=\"foo\">{}bar</a></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><a href=foo>foo[]bar</a></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><a href=\"foo\">foo</a></b></div><div><b><a href=\"foo\">{}bar</a></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
// <a href="foo"> shouldn't be duplicated in new paragraph when it's split at
// start or end of it.
["<a href=foo>foo[]</a>bar",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo</a></div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]</a>bar",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo</a></p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<a href=foo>[]bar</a>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>foo</div><div>{}<a href=\"foo\">bar</a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<a href=foo>[]bar</a>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<a href=\"foo\">bar</a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo>foo[]</a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo</a></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>foo[]</a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo</a></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo>[]foo</a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p><a href=\"foo\">{}foo</a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>[]foo</a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><br></div><div><a href=\"foo\">{}foo</a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo[]</b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo</b></a></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo[]</b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo</b></a></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>[]foo</b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p><a href=\"foo\"><b>{}foo</b></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>[]foo</b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><br></div><div><a href=\"foo\"><b>{}foo</b></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><a href=foo>foo[]</a></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><a href=\"foo\">foo</a></b></p><p><b>{}<br></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><a href=foo>foo[]</a></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><a href=\"foo\">foo</a></b></div><div><b>{}<br></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><a href=foo>[]foo</a></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><br></b></p><p><b><a href=\"foo\">{}foo</a></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><a href=foo>[]foo</a></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><br></b></div><div><b><a href=\"foo\">{}foo</a></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
// <br> is usually inserted after an <a href="foo"> element is split next to
// an ASCII whitespace.  So, <br> element should be ignored if it's invisible.
["<p><a href=foo>foo []<br></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo <br></a></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>foo []<br></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo <br></a></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo []<br></b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo <br></b></a></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo []<br></b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo <br></b></a></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><a href=foo>foo []<br></a></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><a href=\"foo\">foo <br></a></b></p><p><b>{}<br></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><a href=foo>foo []<br></a></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><a href=\"foo\">foo <br></a></b></div><div><b>{}<br></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo>foo {}<br></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo <br></a></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>foo {}<br></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo <br></a></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo {}<br></b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo <br></b></a></p><p>{}<br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo {}<br></b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo <br></b></a></div><div>{}<br></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b><a href=foo>foo {}<br></a></b></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><b><a href=\"foo\">foo <br></a></b></p><p><b>{}<br></b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b><a href=foo>foo {}<br></a></b></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><b><a href=\"foo\">foo <br></a></b></div><div><b>{}<br></b></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
// So, if <br> is visible, its any inline containers should be split.
["<p><a href=foo>foo []<br><br></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo <br></a></p><p><a href=\"foo\">{}<br><br></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>foo []<br><br></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo <br></a></div><div><a href=\"foo\">{}<br><br></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo []<br><br></b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo <br></b></a></p><p><a href=\"foo\"><b>{}<br><br></b></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo []<br><br></b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo <br></b><br></a></div><div><a href=\"foo\"><b>{}<br><br></b></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo []<br></b><br></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo <br></b></a></p><p><a href=\"foo\"><b>{}<br></b><br></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo []<br></b><br></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo <br></b></a></div><div><a href=\"foo\"><b>{}<br></b><br></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo>foo {}<br><br></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\">foo <br><br></a></p><p><a href=\"foo\">{}<br></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo>foo {}<br><br></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\">foo <br></a></div><div><a href=\"foo\">{}<br></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo {}<br><br></b></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo <br></b><br></a></p><p><a href=\"foo\"><b>{}<br><br></b></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo {}<br><br></b></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo <br></b><br></a></div><div><a href=\"foo\"><b>{}<br><br></b></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><a href=foo><b>foo {}<br></b><br></a></p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><a href=\"foo\"><b>foo <br></b></a></p><p><a href=\"foo\"><b>{}<br></b><br></a></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><a href=foo><b>foo {}<br></b><br></a></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><a href=\"foo\"><b>foo <br></b></a></div><div><a href=\"foo\"><b>{}<br></b><br></a></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],

["<p>foo[]<!--bar-->",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<!--bar--><br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<!--bar-->",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<!--bar--><br></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><!--foo-->[]bar",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><!--foo--><br></p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><!--foo-->[]bar",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><!--foo--><br></p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p>{}baz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}<br></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}quz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p>foo</p><p>{}quz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}quz</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p>foo</p><p>{}quz</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul contenteditable><li>{}<br></ul>",
    [["insertparagraph",""]],
    "<ul contenteditable=\"\"><li>{}<br></li></ul>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul contenteditable><li>foo[]</ul>",
    [["insertparagraph",""]],
    "<ul contenteditable=\"\"><li>foo</li><li>{}<br></li></ul>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><ul contenteditable><li>{}<br></ul></div>",
    [["insertparagraph",""]],
    "<div contenteditable=\"false\"><ul contenteditable=\"\"><li>{}<br></li></ul></div>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><ul contenteditable><li>foo[]</ul></div>",
    [["insertparagraph",""]],
    "<div contenteditable=\"false\"><ul contenteditable=\"\"><li>foo</li><li>{}<br></li></ul></div>",
    [true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]</address>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<address><p>foo</p><p>{}<br></p></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]</address>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<address><p>foo</p><p>{}<br></p></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt><p>foo</p></dt><dd><p>{}<br></p></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt><p>foo</p></dt><dd><p>{}<br></p></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dd><p>foo</p></dd><dt><p>{}<br></p></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dd><p>foo</p></dd><dt><p>{}<br></p></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li><p>foo</p></li><li><p>{}<br></p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li><p>foo</p></li><li><p>{}<br></p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]</ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><p>foo</p></li><li><p>{}<br></p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]</ul>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ul><li><p>foo</p></li><li><p>{}<br></p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]</address>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<address><div>foo</div><div>{}<br></div></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]</address>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<address><div>foo</div><div>{}<br></div></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt><div>foo</div></dt><dd><div>{}<br></div></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt><div>foo</div></dt><dd><div>{}<br></div></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dd><div>foo</div></dd><dt><div>{}<br></div></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dd><div>foo</div></dd><dt><div>{}<br></div></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li><div>foo</div></li><li><div>{}<br></div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li><div>foo</div></li><li><div>{}<br></div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]</ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><div>foo</div></li><li><div>{}<br></div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]</ul>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ul><li><div>foo</div></li><li><div>{}<br></div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><p>foo</p><p>{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><p>foo</p><p>{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><div>foo</div><div>{}<br></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><div>foo</div><div>{}<br></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>[]foo</address>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<address><p><br></p><p>{}foo</p></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>[]foo</address>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<address><p><br></p><p>{}foo</p></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>[]foo</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt><p><br></p></dt><dt><p>{}foo</p></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>[]foo</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt><p><br></p></dt><dt><p>{}foo</p></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>[]foo</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dd><p><br></p></dd><dd><p>{}foo</p></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>[]foo</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dd><p><br></p></dd><dd><p>{}foo</p></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>[]foo</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li><p><br></p></li><li><p>{}foo</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>[]foo</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li><p><br></p></li><li><p>{}foo</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>[]foo</ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><p><br></p></li><li><p>{}foo</p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>[]foo</ul>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ul><li><p><br></p></li><li><p>{}foo</p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>[]foo</address>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<address><div><br></div><div>{}foo</div></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>[]foo</address>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<address><div><br></div><div>{}foo</div></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>[]foo</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt><div><br></div></dt><dt><div>{}foo</div></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>[]foo</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt><div><br></div></dt><dt><div>{}foo</div></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>[]foo</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dd><div><br></div></dd><dd><div>{}foo</div></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>[]foo</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dd><div><br></div></dd><dd><div>{}foo</div></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>[]foo</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li><div><br></div></li><li><div>{}foo</div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>[]foo</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li><div><br></div></li><li><div>{}foo</div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>[]foo</ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><div><br></div></li><li><div>{}foo</div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>[]foo</ul>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ul><li><div><br></div></li><li><div>{}foo</div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>[]foo</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><p><br></p><p>{}foo</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>[]foo</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><p><br></p><p>{}foo</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>[]foo</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><div><br></div><div>{}foo</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>[]foo</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><div><br></div><div>{}foo</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]bar</address>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<address><p>foo</p><p>{}bar</p></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]bar</address>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<address><p>foo</p><p>{}bar</p></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]bar</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt><p>foo</p></dt><dt><p>{}bar</p></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]bar</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt><p>foo</p></dt><dt><p>{}bar</p></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]bar</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dd><p>foo</p></dd><dd><p>{}bar</p></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]bar</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dd><p>foo</p></dd><dd><p>{}bar</p></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]bar</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li><p>foo</p></li><li><p>{}bar</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]bar</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li><p>foo</p></li><li><p>{}bar</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]bar</ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><p>foo</p></li><li><p>{}bar</p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]bar</ul>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ul><li><p>foo</p></li><li><p>{}bar</p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]bar</address>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<address><div>foo</div><div>{}bar</div></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]bar</address>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<address><div>foo</div><div>{}bar</div></address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]bar</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dt><div>foo</div></dt><dt><div>{}bar</div></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]bar</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dt><div>foo</div></dt><dt><div>{}bar</div></dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]bar</dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<dl><dd><div>foo</div></dd><dd><div>{}bar</div></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]bar</dl>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<dl><dd><div>foo</div></dd><dd><div>{}bar</div></dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]bar</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li><div>foo</div></li><li><div>{}bar</div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]bar</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li><div>foo</div></li><li><div>{}bar</div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]bar</ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><div>foo</div></li><li><div>{}bar</div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]bar</ul>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ul><li><div>foo</div></li><li><div>{}bar</div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]bar</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><p>foo</p><p>{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]bar</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><p>foo</p><p>{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]bar</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><div>foo</div><div>{}bar</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]bar</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div><div>foo</div><div>{}bar</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}<br></p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}<br></p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]</div></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}<br></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]</div></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}<br></div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}<br></p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>[]foo</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p></li><li class=\"a\"><p class=\"b\">{}foo</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>[]foo</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p></li><li class=\"a\"><p class=\"b\">{}foo</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>[]foo</div></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\"><br></div><div class=\"b\">{}foo</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>[]foo</div></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\"><br></div><div class=\"b\">{}foo</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>[]foo</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p><p class=\"b\">{}foo</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>[]foo</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p><p class=\"b\">{}foo</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]bar</ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}bar</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]bar</ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}bar</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]bar</div></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}bar</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]bar</div></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}bar</div></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]bar</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]bar</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}bar</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><foo-bar contenteditable><p>foo[]bar</p></foo-bar></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div contenteditable=\"false\"><foo-bar contenteditable=\"\"><p>foo</p><p>bar</p></foo-bar></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><foo-bar contenteditable><p>foo[]bar</p></foo-bar></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div contenteditable=\"false\"><foo-bar contenteditable=\"\"><p>foo</p><p>bar</p></foo-bar></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><foo-bar contenteditable><div>foo[]bar</div></foo-bar></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div contenteditable=\"false\"><foo-bar contenteditable=\"\"><div>foo</div><div>bar</div></foo-bar></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><foo-bar contenteditable><div>foo[]bar</div></foo-bar></div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div contenteditable=\"false\"><foo-bar contenteditable=\"\"><div>foo</div><div>bar</div></foo-bar></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc[] </div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>abc</div><div><br></div>",
     "<div>abc </div><div><br></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc[]  </div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>abc</div><div><br></div>",
     "<div>abc  </div><div><br></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc [] </div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>abc</div><div><br></div>",
     "<div>abc </div><div><br></div>",
     "<div>abc  </div><div><br></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>[] abc</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><br></div><div>abc</div>",
     "<div><br></div><div> abc</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>[]  abc</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><br></div><div>abc</div>",
     "<div><br></div><div>  abc</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div> [] abc</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><br></div><div>abc</div>",
     "<div><br></div><div> abc</div>",
     "<div><br></div><div>  abc</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>  []abc</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><br></div><div>abc</div>",
     "<div><br></div><div>  abc</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// TODO: Move the following tests into insertparagraph-or-insertlinebreak-in-inline-editing-host.tentative.html
["<h1 contenteditable=false><span contenteditable>ab[]cd</span></h1>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<h1 contenteditable=\"false\"><span contenteditable=\"\">ab<br>cd</span></h1>",
     "<h1 contenteditable=\"false\"><span contenteditable=\"\">ab<br>cd<br></span></h1>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol contenteditable=false><li><span contenteditable>ab[]cd</span></li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ol contenteditable=\"false\"><li><span contenteditable=\"\">ab<br>cd</span></li></ol>",
     "<ol contenteditable=\"false\"><li><span contenteditable=\"\">ab<br>cd<br></span></li></ol>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl contenteditable=false><dt><span contenteditable>ab[]cd</span></dt></dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<dl contenteditable=\"false\"><dt><span contenteditable=\"\">ab<br>cd</span></dt></dl>",
     "<dl contenteditable=\"false\"><dt><span contenteditable=\"\">ab<br>cd<br></span></dt></dl>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl contenteditable=false><dd><span contenteditable>ab[]cd</span></dd></dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<dl contenteditable=\"false\"><dd><span contenteditable=\"\">ab<br>cd</span></dd></dl>",
     "<dl contenteditable=\"false\"><dd><span contenteditable=\"\">ab<br>cd<br></span></dd></dl>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><h1 contenteditable>ab[]cd</h1></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div contenteditable=\"false\"><h1 contenteditable=\"\">ab<br>cd</h1></div>",
     "<div contenteditable=\"false\"><h1 contenteditable=\"\">ab<br>cd<br></h1></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol contenteditable=false><li contenteditable>ab[]cd</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ol contenteditable=\"false\"><li contenteditable=\"\"><div>ab</div><div>cd</div></li></ol>",
     "<ol contenteditable=\"false\"><li contenteditable=\"\"><div>ab</div><div>cd<br></div></li></ol>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl contenteditable=false><dt contenteditable>ab[]cd</dt></dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<dl contenteditable=\"false\"><dt contenteditable=\"\">ab<br>cd</dt></dl>",
     "<dl contenteditable=\"false\"><dt contenteditable=\"\">ab<br>cd<br></dt></dl>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<dl contenteditable=false><dd contenteditable>ab[]cd</dd></dl>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<dl contenteditable=\"false\"><dd contenteditable=\"\"><div>ab</div><div>cd</div></dd></dl>",
     "<dl contenteditable=\"false\"><dd contenteditable=\"\"><div>ab</div><div>cd<br></div>/dd></dl>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// The first white-space of the second paragraph must be &nbsp; for making it
// visible, but the other things do not matter for the following tests.
["<div>a[] b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>a</div><div>&nbsp;b</div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
// And if the first paragraph ends with white-space, the text node should be
// followed by <br> element.
["<div>a []b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a <br></div><div>b</div>",
     "<div>a&nbsp;</div><div>b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a&nbsp;[] b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a <br></div><div>&nbsp;b</div>",
     "<div>a&nbsp;</div><div>&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a []&nbsp;b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a <br></div><div>&nbsp;b</div>",
     "<div>a&nbsp;</div><div>&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
// These tests do not mind about the white-space sequence because it's not
// important here.  That's tested by
// editing/other/white-spaces-after-execCommand-*.tentative.html
["<div>a&nbsp;[]&nbsp; b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;</div><div>&nbsp; b</div>",
     "<div>a <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a&nbsp;[] &nbsp;b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;</div><div>&nbsp; b</div>",
     "<div>a <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a []&nbsp; b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;</div><div>&nbsp; b</div>",
     "<div>a <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a&nbsp;&nbsp;[]&nbsp; b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a&nbsp; <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp; b</div>",
     "<div>a &nbsp;</div><div>&nbsp; b</div>",
     "<div>a&nbsp; <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp;&nbsp;b</div>",
     "<div>a &nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a&nbsp; []&nbsp; b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a&nbsp; <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp; b</div>",
     "<div>a &nbsp;</div><div>&nbsp; b</div>",
     "<div>a&nbsp; <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp;&nbsp;b</div>",
     "<div>a &nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a &nbsp;[]&nbsp; b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a&nbsp; <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp; b</div>",
     "<div>a &nbsp;</div><div>&nbsp; b</div>",
     "<div>a&nbsp; <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp;&nbsp;b</div>",
     "<div>a &nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a&nbsp;&nbsp;[] &nbsp;b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a&nbsp; <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp; b</div>",
     "<div>a &nbsp;</div><div>&nbsp; b</div>",
     "<div>a&nbsp; <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp;&nbsp;b</div>",
     "<div>a &nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>a &nbsp;[] &nbsp;b</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div>a&nbsp; <br></div><div>&nbsp; b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp; b</div>",
     "<div>a &nbsp;</div><div>&nbsp; b</div>",
     "<div>a&nbsp; <br></div><div>&nbsp;&nbsp;b</div>",
     "<div>a&nbsp;&nbsp;</div><div>&nbsp;&nbsp;b</div>",
     "<div>a &nbsp;</div><div>&nbsp;&nbsp;b</div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a <div> which is the only
// block in the editing host.
// In this case, the <div> should be unwrapped and a <br> element should be
// put there, then, new paragraph should be created after it.
["<div>[abc]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<br><div><br></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>[abc]</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<br><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a <p> which is the only block in
// the editing host.
// In this case, the <p> element should become empty but stay here, and new <p>
// element should be created.
["<p>[abc]</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<p><br></p><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<p>[abc]</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a paragraph which is not only
// block in the editing host.
// In this case, new same element should be created rather than respecting the
// default paragraph separator, and caret should be moved to the new paragraph.
["<div>abc</div><div>[def]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>abc</div><div><br></div><div><br></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc</div><p>[def]</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div>abc</div><p><br></p><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc</div><div>[def]</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div>abc</div><div><br></div><div><br></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc</div><p>[def]</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<div>abc</div><p><br></p><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc</div><div>[def]</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","d"]],
    ["<div>abc</div><div><br></div><div>d</div>",
     "<div>abc</div><div><br></div><div>d<br></div>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div>abc</div><p>[def]</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","d"]],
    ["<div>abc</div><p><br></p><p>d</p>",
     "<div>abc</div><p><br></p><p>d<br></p>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a list-item which is only one of
// the list.
// In this case, the list and list-item elements should be unwrapped and create
// a new paragraph whose type conforms to the default paragraph separator.
["<ol><li>[abc]</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><br></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[abc]</li></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[abc]</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","d"]],
    ["<div>d</div>",
     "<div>d<br></div>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a list-item which is the last
// list item in the list.
// In this case, the last list item should be deleted and new paragraph should
// be created after the list element.
["<ol><li>abc</li><li>[def]</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li>abc</li></ol><div><br></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>abc</li><li>[def]</li></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li>abc</li></ol><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>abc</li><li>[def]</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","d"]],
    ["<ol><li>abc</li></ol><div>d</div>",
     "<ol><li>abc</li></ol><div>d<br></div>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a list-item which is not a middle
// list item in the list.
// In this case, the list should be split at the list item, and new paragraph
// should be created between the list elements.
["<ol><li>abc</li><li>[def]</li><li>ghi</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ol><li>abc</li></ol><div><br></div><ol><li>ghi</li></ol>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>abc</li><li>[def]</li><li>ghi</li></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<ol><li>abc</li></ol><p><br></p><ol><li>ghi</li></ol>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>abc</li><li>[def]</li><li>ghi</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","d"]],
    ["<ol><li>abc</li></ol><div>d</div><ol><li>ghi</li></ol>",
     "<ol><li>abc</li></ol><div>d<br></div><ol><li>ghi</li></ol>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a list-item which is the first
// list item in the list.
// In this case, the first list item should be deleted and new paragraph should
// be created before the list element.
["<ol><li>[abc]</li><li>def</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><br></div><ol><li>def</li></ol>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[abc]</li><li>def</li></ol>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<p><br></p><ol><li>def</li></ol>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[abc]</li><li>def</li></ol>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","a"]],
    ["<div>a</div><ol><li>def</li></ol>",
     "<div>a<br></div><ol><li>def</li></ol>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a heading element.
// In this case, the heading element should become empty, but stay there, and
// a new paragraph should be created after it.
["<h3>[abc]</h3>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h3><br></h3><div><br></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h3>[abc]</h3>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h3><br></h3><p><br></p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h3>[abc]</h3>",
    [["defaultparagraphseparator","div"],["insertparagraph",""],["inserttext","a"]],
    ["<h3><br></h3><div>a</div>",
     "<h3><br></h3><div>a<br></div>"],
    [true,true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// insertparagraph with selecting all text in a heading element which is
// followed by a paragraph.
// In this case, the heading element should become empty, but stay there, and
// insert a new paragraph immediately after the heading element.
["<h3>[abc]</h3><div>def</div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h3><br></h3><div><br></div><div>def</div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h3>[abc]</h3><div>def</div>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h3><br></h3><p><br></p><div>def</div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h3>[abc]</h3><p>def</p>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<h3><br></h3><div><br></div><p>def</p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<h3>[abc]</h3><p>def</p>",
    [["defaultparagraphseparator","p"],["insertparagraph",""]],
    "<h3><br></h3><p><br></p><p>def</p>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// Preserve inline elements at splitting the elements at end.  It's out of scope
// of these tests that how to treat the <br> element in the left paragraph.
["<div><span style=\"color:rgb(0, 0, 255)\">foo[]</span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><span style=\"color:rgb(0, 0, 255)\">foo</span></div><div><span style=\"color:rgb(0, 0, 255)\"><br></span></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><span style=\"background-color:rgb(0, 0, 255)\">foo</span></div><div><span style=\"background-color:rgb(0, 0, 255)\"><br></span></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span></span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"color:rgb(0, 0, 255)\">foo[]<br></span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"color:rgb(0, 0, 255)\">foo</span></div><div><span style=\"color:rgb(0, 0, 255)\"><br></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\">foo<br></span></div><div><span style=\"color:rgb(0, 0, 255)\"><br></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\">foo</span><br></div><div><span style=\"color:rgb(0, 0, 255)\"><br></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"background-color:rgb(0, 0, 255)\">foo[]<br></span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"background-color:rgb(0, 0, 255)\">foo</span></div><div><span style=\"background-color:rgb(0, 0, 255)\"><br></span></div>",
     "<div><span style=\"background-color:rgb(0, 0, 255)\">foo<br></span></div><div><span style=\"background-color:rgb(0, 0, 255)\"><br></span></div>",
     "<div><span style=\"background-color:rgb(0, 0, 255)\">foo</span><br></div><div><span style=\"background-color:rgb(0, 0, 255)\"><br></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]<br></span></span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo<br></span></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span><br></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"color:rgb(0, 0, 255)\">foo[]</span><br></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"color:rgb(0, 0, 255)\">foo</span></div><div><span style=\"color:rgb(0, 0, 255)\"><br></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\">foo</span><br></div><div><span style=\"color:rgb(0, 0, 255)\"><br></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span><br></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"background-color:rgb(0, 0, 255)\">foo</span></div><div><span style=\"background-color:rgb(0, 0, 255)\"><br></span></div>",
     "<div><span style=\"background-color:rgb(0, 0, 255)\">foo</span><br></div><div><span style=\"background-color:rgb(0, 0, 255)\"><br></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span></span><br></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span><br></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span><br></span></div>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span><br></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo<br></span></span></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>",
     "<div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span><br></div><div><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></div>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],

// Same things for list-item
["<ul><li><span style=\"color:rgb(0, 0, 255)\">foo[]</span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><span style=\"color:rgb(0, 0, 255)\">foo</span></li><li><span style=\"color:rgb(0, 0, 255)\"><br></span></li></ul>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo</span></li><li><span style=\"background-color:rgb(0, 0, 255)\"><br></span></li></ul>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span></span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"color:rgb(0, 0, 255)\">foo[]<br></span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"color:rgb(0, 0, 255)\">foo</span></li><li><span style=\"color:rgb(0, 0, 255)\"><br></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\">foo<br></span></li><li><span style=\"color:rgb(0, 0, 255)\"><br></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\">foo</span><br></li><li><span style=\"color:rgb(0, 0, 255)\"><br></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo[]<br></span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo</span></li><li><span style=\"background-color:rgb(0, 0, 255)\"><br></span></li></ul>",
     "<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo<br></span></li><li><span style=\"background-color:rgb(0, 0, 255)\"><br></span></li></ul>",
     "<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo</span><br></li><li><span style=\"background-color:rgb(0, 0, 255)\"><br></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]<br></span></span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo<br></span></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span><br></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"color:rgb(0, 0, 255)\">foo[]</span><br></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"color:rgb(0, 0, 255)\">foo</span></li><li><span style=\"color:rgb(0, 0, 255)\"><br></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\">foo</span><br></li><li><span style=\"color:rgb(0, 0, 255)\"><br></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span><br></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo</span></li><li><span style=\"background-color:rgb(0, 0, 255)\"><br></span></li></ul>",
     "<ul><li><span style=\"background-color:rgb(0, 0, 255)\">foo</span><br></li><li><span style=\"background-color:rgb(0, 0, 255)\"><br></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span></span><br></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span><br></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo[]</span><br></span></li></ul>",
    [["defaultparagraphseparator","div"],["insertparagraph",""]],
    ["<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span><br></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo<br></span></span></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>",
     "<ul><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\">foo</span></span><br></li><li><span style=\"color:rgb(0, 0, 255)\"><span style=\"background-color:rgb(0, 0, 255)\"><br></span></span></li></ul>"],
    [true,true],
    {"insertparagraph":[false,false,"",false,false,""]}],
]
