// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.drawing.style.letterSpacing.change.font
// Description:Set letter spacing and word spacing to font dependent value and verify it works after font change.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Set letter spacing and word spacing to font dependent value and verify it works after font change.");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

var canvas = new OffscreenCanvas(100, 50);
var ctx = canvas.getContext('2d');

_assertSame(ctx.letterSpacing, '0px', "ctx.letterSpacing", "'0px'");
_assertSame(ctx.wordSpacing, '0px', "ctx.wordSpacing", "'0px'");
// Get the width for 'Hello World' at default size, 10px.
var width_normal = ctx.measureText('Hello World').width;

ctx.letterSpacing = '1em';
_assertSame(ctx.letterSpacing, '1em', "ctx.letterSpacing", "'1em'");
// 1em = 10px. Add 10px after each letter in "Hello World",
// makes it 110px longer.
var width_with_spacing = ctx.measureText('Hello World').width;
_assertSame(width_with_spacing, width_normal + 110, "width_with_spacing", "width_normal + 110");

// Changing font to 20px. Without resetting the spacing, 1em letterSpacing
// is now 20px, so it's suppose to be 220px longer without any letterSpacing set.
ctx.font = '20px serif';
width_with_spacing = ctx.measureText('Hello World').width;
// Now calculate the reference spacing for "Hello World" with no spacing.
ctx.letterSpacing = '0em';
width_normal = ctx.measureText('Hello World').width;
_assertSame(width_with_spacing, width_normal + 220, "width_with_spacing", "width_normal + 220");
t.done();

});
done();
