/*
 * Decompiled with CFR 0.152.
 */
package jep;

import apple.awt.CColorPaint;
import apple.awt.MyEventQueue;
import apple.laf.CColorPaintUIResource;
import apple.laf.FixAquaImageFactory;
import java.applet.Applet;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SimpleLayout;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.swing.UIManager;
import jep.AppletHolder;
import jep.AppletHolderFactory;
import sun.applet.AppletClassLoader;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.plugin.AppletViewer;

public class AppletHolderPanel
extends AppletViewer {
    private static boolean showDebugInfo = false;
    protected HashMap atts = null;
    protected AppletHolder holder = null;
    Hashtable fixedDefaultsTable = new Hashtable();
    Object[] fixedDefaultsArray = null;

    public AppletHolderPanel(URL docbase, HashMap attributes, AppletHolder holder) {
        if (showDebugInfo) {
            System.err.println("Calling AppletHolderPanel(): docbase (" + (docbase == null ? "null" : docbase.toString()) + ") " + "attributes (" + (attributes == null ? "null" : attributes.toString()) + ")");
        }
        this.setDocumentBase(docbase.toString());
        this.atts = attributes;
        this.holder = holder;
        this.setBackground((Color)new CColorPaint(AppletHolderFactory.getNSColor(255, 255, 255), 255, 255, 255));
        this.status = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Applet createApplet(AppletClassLoader loader) throws ClassNotFoundException, IllegalAccessException, IOException, InstantiationException, InterruptedException {
        Applet newApplet = super.createApplet(loader);
        if (newApplet == null) {
            return null;
        }
        this.holder.changeFrameAppContext(SunToolkit.targetToAppContext(newApplet));
        this.holder.setSimpleLayout();
        if (this.holder.destroying) {
            return newApplet;
        }
        if (!AppletHolderFactory.isJava142Update1()) {
            Hashtable hashtable = this.fixedDefaultsTable;
            synchronized (hashtable) {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(newApplet), new PeerEvent(newApplet, new FixStuff(this, this.holder), 1L));
                Thread.sleep(100L);
                if (this.holder.destroying) {
                    return newApplet;
                }
                if (this.holder.isCarbonApp && AppletHolderFactory.isJava142()) {
                    this.fixLafColorDefaults();
                }
            }
        }
        String appletInfo = null;
        try {
            appletInfo = newApplet.getAppletInfo();
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = newApplet.getClass().getName();
        String info = "JEP creating applet " + name + " (" + this.getCodeBase().toString() + ")" + (appletInfo != null ? "\n" + appletInfo : "");
        this.tellAppletCreated(this.holder.getCocoaParentViewLong(), newApplet, info, name);
        System.out.println(new Date() + " " + info);
        return newApplet;
    }

    protected native void tellAppletCreated(long var1, Applet var3, String var4, String var5);

    protected void fixLafColorDefaults() {
        if (this.holder.destroying) {
            return;
        }
        FixAquaImageFactory.fix();
        try {
            UIManager.setLookAndFeel(UIManager.getLookAndFeel());
        }
        catch (Throwable e) {
            // empty catch block
        }
        Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof Color) || value instanceof CColorPaintUIResource) continue;
            CColorPaint color = new CColorPaint(AppletHolderFactory.getNSColor(((Color)value).getRed(), ((Color)value).getGreen(), ((Color)value).getBlue()), ((Color)value).getRed(), ((Color)value).getGreen(), ((Color)value).getBlue());
            this.fixedDefaultsTable.put(key, color);
        }
        Object[] entries = this.fixedDefaultsTable.entrySet().toArray();
        this.fixedDefaultsArray = new Object[entries.length * 2];
        for (int i = 1; i <= entries.length; ++i) {
            this.fixedDefaultsArray[2 * (i - 1)] = ((Map.Entry)entries[i - 1]).getKey();
            this.fixedDefaultsArray[2 * (i - 1) + 1] = ((Map.Entry)entries[i - 1]).getValue();
        }
        if (showDebugInfo) {
            System.err.println("AppletHolderPanel fixLafColorDefaults(): " + this.fixedDefaultsTable.toString());
        }
    }

    public void validate() {
        if (this.holder.destroying || AppletHolderFactory.isMainThread()) {
            return;
        }
        super.validate();
    }

    public void invalidate() {
        if (this.holder.destroying || AppletHolderFactory.isMainThread()) {
            return;
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        if (this.atts == null) {
            return null;
        }
        name = name.toLowerCase(Locale.ENGLISH);
        HashMap hashMap = this.atts;
        synchronized (hashMap) {
            String value = (String)this.atts.get(name);
            if (value != null) {
                value = this.trimWhiteSpaces(value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String name, Object value) {
        if (this.atts == null) {
            return;
        }
        name = name.toLowerCase(Locale.ENGLISH);
        HashMap hashMap = this.atts;
        synchronized (hashMap) {
            this.atts.put(name, this.trimWhiteSpaces(value.toString()));
        }
    }

    public void appletResize(int width, int height) {
        if (this.holder.destroying) {
            return;
        }
        if (!this.holder.clipLock.lock(1000L)) {
            System.err.println("AppletHolderPanel.appletResize(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        if (width == this.getWidth() && height == this.getHeight()) {
            this.holder.clipLock.unlock();
            return;
        }
        this.setParameter("width", Integer.toString(width));
        this.setParameter("height", Integer.toString(height));
        LayoutManager layout = this.holder.getLayout();
        if (layout instanceof SimpleLayout) {
            ((SimpleLayout)layout).resetSize(width, height);
        }
        if ((layout = this.getLayout()) instanceof SimpleLayout) {
            ((SimpleLayout)layout).resetSize(width, height);
        }
        this.holder.setBounds(0, 0, width, height);
        this.setBounds(0, 0, width, height);
        this.holder.resetInitialAppletBounds(new Rectangle(0, 0, width, height));
        AppletHolderFactory.resizeCocoaClip(this.holder.getCocoaParentViewLong(), width, height);
        this.holder.invalidate();
        this.holder.validate();
        this.holder.clipLock.unlock();
        super.appletResize(width, height);
    }

    private String trimWhiteSpaces(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n' || c == '\f' || c == '\r' || c == '\t') continue;
            buffer.append(c);
        }
        return buffer.toString().trim();
    }

    public String toString() {
        return super.toString() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }

    private class FixStuff
    implements Runnable {
        private final AppletHolderPanel panel;
        private final AppletHolder holder;

        FixStuff(AppletHolderPanel panel, AppletHolder holder) {
            this.panel = panel;
            this.holder = holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.holder.destroying) {
                return;
            }
            AppContext appContext = AppContext.getAppContext();
            EventQueue currentQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
            if (!(currentQueue instanceof MyEventQueue)) {
                MyEventQueue newQueue = new MyEventQueue();
                currentQueue.push(newQueue);
                appContext.put(AppContext.EVENT_QUEUE_KEY, newQueue);
            }
            Hashtable hashtable = this.panel.fixedDefaultsTable;
            synchronized (hashtable) {
                if (this.holder.destroying) {
                    return;
                }
                if (this.panel.fixedDefaultsArray != null) {
                    UIManager.getDefaults().putDefaults(this.panel.fixedDefaultsArray);
                }
            }
        }
    }
}

