//@line 38 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"

//@line 41 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
var helpFileURI;

//@line 46 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
function openHelp(topic, contentPack)
{
//@line 50 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
  helpFileURI = contentPack || helpFileURI;

//@line 53 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
  var topWindow = locateHelpWindow(helpFileURI);

  if ( topWindow ) {
//@line 57 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
    topWindow.focus();
    topWindow.displayTopic(topic);
  } else {
//@line 61 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
    const params = Components.classes["@mozilla.org/embedcomp/dialogparam;1"]
                             .createInstance(Components.interfaces.nsIDialogParamBlock);
    params.SetNumberStrings(2);
    params.SetString(0, helpFileURI);
    params.SetString(1, topic);
    const ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                         .getService(Components.interfaces.nsIWindowWatcher);
//@line 74 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
    ww.openWindow(null, "chrome://help/content/help.xul", "_blank", "chrome,all,dialog=no", params);
//@line 76 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
  }
}

//@line 80 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
function setHelpFileURI(rdfURI)
{
  helpFileURI = rdfURI;
}

//@line 86 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
function locateHelpWindow(contentPack) {
    const windowManagerInterface = Components
        .classes['@mozilla.org/appshell/window-mediator;1'].getService()
        .QueryInterface(Components.interfaces.nsIWindowMediator);
    const iterator = windowManagerInterface.getEnumerator("mozilla:help");
    var topWindow = null;
    var aWindow;

//@line 96 "/home/ulink/src/comm-1.9.1/mozilla/toolkit/components/help/content/contextHelp.js"
    while (iterator.hasMoreElements()) {
        aWindow = iterator.getNext();
        if (aWindow.getHelpFileURI() == contentPack) {
            topWindow = aWindow;
        }
    }
    return topWindow;
}
