/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
#ifndef _nsMimePlainEmitter_h_
#define _nsMimePlainEmitter_h_

#include "prtypes.h"
#include "prio.h"
#include "nsMimeBaseEmitter.h"
#include "nsMimeRebuffer.h"
#include "nsIStreamListener.h"
#include "nsIOutputStream.h"
#include "nsIURI.h"
#include "nsIChannel.h"

class nsMimePlainEmitter : public nsMimeBaseEmitter {
public: 
    nsMimePlainEmitter ();
    virtual       ~nsMimePlainEmitter (void);

    // Header handling routines.
    NS_IMETHOD    StartHeader(bool rootMailHeader, bool headerOnly, const char *msgID,
                              const char *outCharset);
    NS_IMETHOD    AddHeaderField(const char *field, const char *value);
    NS_IMETHOD    EndHeader();

    NS_IMETHOD    WriteBody(const nsACString &buf, PRUint32 *amountWritten);
};

#endif /* _nsMimePlainEmitter_h_ */
