/*
 *  Copyright (c) 2011 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#include "codec_timer.h"

#include <assert.h>

namespace webrtc
{

VCMCodecTimer::VCMCodecTimer()
:
_filteredMax(0),
_firstDecodeTime(true),
_shortMax(0),
_history()
{
    Reset();
}

int32_t VCMCodecTimer::StopTimer(int64_t startTimeMs, int64_t nowMs)
{
    const int32_t timeDiff = static_cast<int32_t>(nowMs - startTimeMs);
    MaxFilter(timeDiff, nowMs);
    return timeDiff;
}

void VCMCodecTimer::Reset()
{
    _filteredMax = 0;
    _firstDecodeTime = true;
    _shortMax = 0;
    for (int i=0; i < MAX_HISTORY_SIZE; i++)
    {
        _history[i].shortMax = 0;
        _history[i].timeMs = -1;
    }
}

