/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Netscape Portable Runtime (NSPR).
 * 
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are 
 * Copyright (C) 1998-2000 Netscape Communications Corporation.  All
 * Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

/*
 * OS/2-specific semaphore handling code.
 *
 */

#include "primpl.h"


PR_IMPLEMENT(void) 
_PR_MD_NEW_SEM(_MDSemaphore *md, PRUintn value)
{
   int rv;

    /* Our Sems don't support a value > 1 */
    PR_ASSERT(value <= 1);

    rv = DosCreateEventSem(NULL, &md->sem, 0, 0);
    PR_ASSERT(rv == NO_ERROR);
}

PR_IMPLEMENT(void) 
_PR_MD_DESTROY_SEM(_MDSemaphore *md)
{
   int rv;
   rv = DosCloseEventSem(md->sem);
   PR_ASSERT(rv == NO_ERROR);

}

PR_IMPLEMENT(PRStatus) 
_PR_MD_TIMED_WAIT_SEM(_MDSemaphore *md, PRIntervalTime ticks)
{
    int rv;
    rv = DosWaitEventSem(md->sem, PR_IntervalToMilliseconds(ticks));

    if (rv == NO_ERROR)
        return PR_SUCCESS;
    else
        return PR_FAILURE;
}

PR_IMPLEMENT(PRStatus) 
_PR_MD_WAIT_SEM(_MDSemaphore *md)
{
    return _PR_MD_TIMED_WAIT_SEM(md, PR_INTERVAL_NO_TIMEOUT);
}

PR_IMPLEMENT(void) 
_PR_MD_POST_SEM(_MDSemaphore *md)
{
   int rv;
   rv = DosPostEventSem(md->sem);
   PR_ASSERT(rv == NO_ERROR); 
}


