# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
from __future__ import absolute_import

import os

from logger.logger import RaptorLogger


here = os.path.abspath(os.path.dirname(__file__))
webext_dir = os.path.join(os.path.dirname(here), "webext", "raptor")
LOG = RaptorLogger(component="raptor-gen-test-config")

FILE_CONTENTS = """// this file is auto-generated by raptor, do not edit directly
function getTestConfig() {{
  return {{
    "cs_port": "{control_server_port}",
    "test_name": "{test}",
    "test_settings_url": "http://{host}:{control_server_port}/json/{test}.json",
    "post_startup_delay": "{post_startup_delay}",
    "benchmark_port": "{benchmark_port}",
    "host": "{host}",
    "debug_mode": "{debug_mode}",
    "browser_cycle": "{browser_cycle}"
  }};
}}

"""


def gen_test_config(
    test,
    cs_port,
    post_startup_delay,
    host="127.0.0.1",
    b_port=0,
    debug_mode=0,
    browser_cycle=1,
):
    LOG.info("writing test settings into background js, so webext can get it")

    if host is None or cs_port is None:
        raise ValueError(
            "Invalid URL for control server: http://{}:{}".format(host, cs_port)
        )

    config = FILE_CONTENTS.format(
        benchmark_port=b_port,
        browser_cycle=browser_cycle,
        control_server_port=cs_port,
        debug_mode=debug_mode,
        host=host,
        post_startup_delay=post_startup_delay,
        test=test,
    )

    webext_background_script = os.path.join(webext_dir, "auto_gen_test_config.js")
    with open(webext_background_script, "w") as f:
        f.write(config)

    LOG.info("finished writing test config to %s" % webext_background_script)
