/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4:
 */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef nsGtkUtils_h__
#define nsGtkUtils_h__

#include <glib.h>

// Some gobject functions expect functions for gpointer arguments.
// gpointer is void* but C++ doesn't like casting functions to void*.
template <class T>
static inline gpointer FuncToGpointer(T aFunction) {
  return reinterpret_cast<gpointer>(
      reinterpret_cast<uintptr_t>
      // This cast just provides a warning if T is not a function.
      (reinterpret_cast<void (*)()>(aFunction)));
}

#endif  // nsGtkUtils_h__
