/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
ChromeUtils.import("resource://gre/modules/AppConstants.jsm");
const {XPCOMUtils} = ChromeUtils.import("resource://gre/modules/XPCOMUtils.jsm");
const {Services} = ChromeUtils.import("resource://gre/modules/Services.jsm");

var modules = {
  fennec: {
    uri: "chrome://browser/content/about.xhtml",
    privileged: true,
    hide: true,
  },

  // about:firefox is an alias for about:fennec, but not hidden from about:about
  get firefox() {
    return Object.assign({}, this.fennec, {hide: false});
  },

  // about:blank has some bad loading behavior we can avoid, if we use an alias
  empty: {
    uri: "about:blank",
    privileged: false,
    hide: true,
  },

  rights: {
    uri: "chrome://browser/content/aboutRights.xhtml",
    privileged: false,
  },
  blocked: {
    uri: "chrome://browser/content/blockedSite.xhtml",
    privileged: false,
    hide: true,
  },
  certerror: {
    uri: "chrome://browser/content/aboutCertError.xhtml",
    privileged: false,
    hide: true,
  },
  home: {
    uri: "chrome://browser/content/aboutHome.xhtml",
    privileged: false,
  },
  downloads: {
    uri: "chrome://browser/content/aboutDownloads.xhtml",
    privileged: true,
  },
  reader: {
    uri: "chrome://global/content/reader/aboutReader.html",
    privileged: false,
    hide: true,
  },
  feedback: {
    uri: "chrome://browser/content/aboutFeedback.xhtml",
    privileged: true,
  },
  privatebrowsing: {
    uri: "chrome://browser/content/aboutPrivateBrowsing.xhtml",
    privileged: true,
  },
  logins: {
    uri: "chrome://browser/content/aboutLogins.xhtml",
    privileged: true,
  },
  accounts: {
    uri: "chrome://browser/content/aboutAccounts.xhtml",
    privileged: true,
  },
  experiments: {
    uri: "chrome://browser/content/aboutExperiments.xhtml",
    privileged: true,
    hide: true,
  },
};

function AboutRedirector() {}
AboutRedirector.prototype = {
  QueryInterface: ChromeUtils.generateQI([Ci.nsIAboutModule]),
  classID: Components.ID("{322ba47e-7047-4f71-aebf-cb7d69325cd9}"),

  _getModuleInfo: function(aURI) {
    let moduleName = aURI.pathQueryRef.replace(/[?#].*/, "").toLowerCase();
    return modules[moduleName];
  },

  // nsIAboutModule
  getURIFlags: function(aURI) {
    let flags;
    let moduleInfo = this._getModuleInfo(aURI);
    if (moduleInfo.hide)
      flags = Ci.nsIAboutModule.HIDE_FROM_ABOUTABOUT;

    return flags | Ci.nsIAboutModule.ALLOW_SCRIPT;
  },

  newChannel: function(aURI, aLoadInfo) {
    let moduleInfo = this._getModuleInfo(aURI);

    var newURI = Services.io.newURI(moduleInfo.uri);

    var channel = Services.io.newChannelFromURIWithLoadInfo(newURI, aLoadInfo);

    if (!moduleInfo.privileged) {
      // Setting the owner to null means that we'll go through the normal
      // path in GetChannelPrincipal and create a codebase principal based
      // on the channel's originalURI
      channel.owner = null;
    }

    channel.originalURI = aURI;

    return channel;
  },
};

const components = [AboutRedirector];
this.NSGetFactory = XPCOMUtils.generateNSGetFactory(components);
