/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`ReferenceError: asdf is not defined`, {
  "pageError": {
    "errorMessage": "ReferenceError: asdf is not defined",
    "errorMessageName": "JSMSG_NOT_DEFINED",
    "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Not_defined?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child1/source22",
    "lineText": "",
    "lineNumber": 3,
    "columnNumber": 5,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 3,
        "columnNumber": 5,
        "functionName": "bar"
      },
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 6,
        "columnNumber": 5,
        "functionName": "foo"
      },
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 9,
        "columnNumber": 3,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "cssSelectors": ""
  },
  "type": "pageError"
});

rawPackets.set(`SyntaxError: redeclaration of let a`, {
  "pageError": {
    "errorMessage": "SyntaxError: redeclaration of let a",
    "errorMessageName": "JSMSG_REDECLARED_VAR",
    "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Redeclared_parameter?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "  let a, a;",
    "lineNumber": 2,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": [
      {
        "messageBody": "Previously declared at line 2, column 6",
        "frame": {
          "source": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "sourceId": null,
          "line": 2,
          "column": 6
        }
      }
    ],
    "chromeContext": false,
    "cssSelectors": ""
  },
  "type": "pageError"
});

rawPackets.set(`TypeError longString message`, {
  "pageError": {
    "errorMessage": {
      "_grip": {
        "type": "longString",
        "actor": "server0.conn0.child1/longstractor24",
        "length": 110007,
        "initial": "Error: Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Lon"
      },
      "actorID": "server0.conn0.child1/longstractor24"
    },
    "errorMessageName": "",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child1/source23",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 7,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source23",
        "lineNumber": 1,
        "columnNumber": 7,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "cssSelectors": ""
  },
  "type": "pageError"
});

rawPackets.set(`throw ""`, {
  "pageError": {
    "errorMessage": "uncaught exception: ",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source25",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "cssSelectors": ""
  },
  "type": "pageError"
});

rawPackets.set(`throw "tomato"`, {
  "pageError": {
    "errorMessage": "uncaught exception: tomato",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source25",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "cssSelectors": ""
  },
  "type": "pageError"
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
