/* -*- Mode: rust; rust-indent-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// This was originally generated by rust-bindgen at build time. Later in
// development it became clear that using bindgen for this library as part of
// mozilla-central would be difficult (if not impossible). So, this was
// converted to a static file and unused declarations were removed. Also,
// intermediate types added by rust-bindgen were removed for clarity.

pub type OSStatus = i32;
pub const errSecSuccess: OSStatus = 0;

pub type SecKeyAlgorithm = CFStringRef;

extern "C" {
    // Available starting macOS 10.3
    pub fn SecCertificateGetTypeID() -> CFTypeID;
    pub fn SecIdentityGetTypeID() -> CFTypeID;
    pub fn SecIdentityCopyCertificate(
        identityRef: SecIdentityRef,
        certificateRef: *mut SecCertificateRef,
    ) -> OSStatus;
    pub fn SecIdentityCopyPrivateKey(
        identityRef: SecIdentityRef,
        privateKeyRef: *mut SecKeyRef,
    ) -> OSStatus;
    pub fn SecKeyGetTypeID() -> CFTypeID;

    // Available starting macOS 10.6
    pub fn SecCertificateCopyData(certificate: SecCertificateRef) -> CFDataRef;
    pub fn SecCertificateCopySubjectSummary(certificate: SecCertificateRef) -> CFStringRef;
    pub fn SecItemCopyMatching(query: CFDictionaryRef, result: *mut CFTypeRef) -> OSStatus;
    pub static kSecClass: CFStringRef;
    pub static kSecAttrKeyType: CFStringRef;
    pub static kSecAttrKeySizeInBits: CFStringRef;
    pub static kSecMatchLimit: CFStringRef;
    pub static kSecMatchLimitAll: CFStringRef;
    pub static kSecReturnRef: CFStringRef;

    // Available starting macOS 10.7
    pub static kSecClassIdentity: CFStringRef;
    pub static kSecAttrKeyTypeRSA: CFStringRef;
}
