/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`ReferenceError: asdf is not defined`, {
  "pageError": {
    "errorMessage": "ReferenceError: asdf is not defined",
    "errorMessageName": "JSMSG_NOT_DEFINED",
    "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Not_defined?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child1/source22",
    "lineText": "",
    "lineNumber": 3,
    "columnNumber": 5,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 3,
        "columnNumber": 5,
        "functionName": "bar"
      },
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 6,
        "columnNumber": 5,
        "functionName": "foo"
      },
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 9,
        "columnNumber": 3,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj25",
        "class": "ReferenceError",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "ReferenceError",
          "message": "asdf is not defined",
          "stack": "bar@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:3:5\nfoo@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:6:5\n@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:9:3\n",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 3,
          "columnNumber": 5
        }
      },
      "actorID": "server0.conn4.child2/obj25"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`SyntaxError: redeclaration of let a`, {
  "pageError": {
    "errorMessage": "SyntaxError: redeclaration of let a",
    "errorMessageName": "JSMSG_REDECLARED_VAR",
    "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Redeclared_parameter?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "  let a, a;",
    "lineNumber": 2,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": [
      {
        "messageBody": "Previously declared at line 2, column 6",
        "frame": {
          "source": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "sourceId": null,
          "line": 2,
          "column": 6
        }
      }
    ],
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj26",
        "class": "SyntaxError",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "SyntaxError",
          "message": "redeclaration of let a",
          "stack": "",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 2,
          "columnNumber": 9
        }
      },
      "actorID": "server0.conn4.child2/obj26"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`TypeError longString message`, {
  "pageError": {
    "errorMessage": {
      "_grip": {
        "type": "longString",
        "actor": "server0.conn0.child1/longstractor24",
        "length": 110007,
        "initial": "Error: Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Lon"
      },
      "actorID": "server0.conn0.child1/longstractor24"
    },
    "errorMessageName": "",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child1/source23",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 7,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source23",
        "lineNumber": 1,
        "columnNumber": 7,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj29",
        "class": "Error",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "Error",
          "message": {
            "_grip": {
              "type": "longString",
              "actor": "server0.conn4.child2/longstractor30",
              "length": 110000,
              "initial": "Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error"
            },
            "actorID": "server0.conn4.child2/longstractor30"
          },
          "stack": "@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:1:7\n",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 1,
          "columnNumber": 7
        }
      },
      "actorID": "server0.conn4.child2/obj29"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw string with URL`, {
  "pageError": {
    "errorMessage": "uncaught exception: “https://evil.com/?aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa“ is evil and “https://not-so-evil.com/?aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa“ is not good either",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child2/source31",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 10737418241,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child2/source31",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": "“https://evil.com/?aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa“ is evil and “https://not-so-evil.com/?aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa“ is not good either",
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw ""`, {
  "pageError": {
    "errorMessage": "uncaught exception: ",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source25",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": "",
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw "tomato"`, {
  "pageError": {
    "errorMessage": "uncaught exception: tomato",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source25",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": "tomato",
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw false`, {
  "pageError": {
    "errorMessage": "uncaught exception: false",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source31",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source31",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": false,
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw 0`, {
  "pageError": {
    "errorMessage": "uncaught exception: 0",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source31",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source31",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": 0,
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw null`, {
  "pageError": {
    "errorMessage": "uncaught exception: null",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source31",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source31",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "type": "null"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw undefined`, {
  "pageError": {
    "errorMessage": "uncaught exception: undefined",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source31",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source31",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "type": "undefined"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw Symbol`, {
  "pageError": {
    "errorMessage": "uncaught exception: Symbol(potato)",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source27",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 7,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source27",
        "lineNumber": 1,
        "columnNumber": 7,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "type": "symbol",
      "actor": "server0.conn4.child2/symbol38",
      "name": "potato"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw Object`, {
  "pageError": {
    "errorMessage": "uncaught exception: [object Object]",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source31",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 1,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source31",
        "lineNumber": 1,
        "columnNumber": 1,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj40",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "vegetable": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "cucumber"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      },
      "actorID": "server0.conn4.child2/obj40"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw Error Object`, {
  "pageError": {
    "errorMessage": "Error: pumpkin",
    "errorMessageName": "",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source41",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 7,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source27",
        "lineNumber": 1,
        "columnNumber": 7,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj42",
        "class": "Error",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "Error",
          "message": "pumpkin",
          "stack": "@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:1:7\n",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 1,
          "columnNumber": 7
        }
      },
      "actorID": "server0.conn4.child2/obj42"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`throw Error Object with custom name`, {
  "pageError": {
    "errorMessage": "JuicyError: pineapple",
    "errorMessageName": "",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source43",
    "lineText": "",
    "lineNumber": 2,
    "columnNumber": 15,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn4.child2/source43",
        "lineNumber": 2,
        "columnNumber": 15,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj44",
        "class": "Error",
        "ownPropertyLength": 6,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "JuicyError",
          "message": "pineapple",
          "stack": "@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:2:15\n",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 2,
          "columnNumber": 15
        }
      },
      "actorID": "server0.conn4.child2/obj44"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject ""`, {
  "pageError": {
    "errorMessage": "uncaught exception: ",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": "",
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject "tomato"`, {
  "pageError": {
    "errorMessage": "uncaught exception: tomato",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": "tomato",
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject false`, {
  "pageError": {
    "errorMessage": "uncaught exception: false",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": false,
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject 0`, {
  "pageError": {
    "errorMessage": "uncaught exception: 0",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": 0,
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject null`, {
  "pageError": {
    "errorMessage": "uncaught exception: null",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": {
      "type": "null"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject undefined`, {
  "pageError": {
    "errorMessage": "uncaught exception: undefined",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": {
      "type": "undefined"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject Symbol`, {
  "pageError": {
    "errorMessage": "uncaught exception: Symbol(potato)",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": {
      "type": "symbol",
      "actor": "server0.conn4.child2/symbol52",
      "name": "potato"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject Object`, {
  "pageError": {
    "errorMessage": "uncaught exception: Object",
    "errorMessageName": "JSMSG_UNCAUGHT_EXCEPTION",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": null,
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 9,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj54",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "vegetable": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "cucumber"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      },
      "actorID": "server0.conn4.child2/obj54"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject Error Object`, {
  "pageError": {
    "errorMessage": "Error: pumpkin",
    "errorMessageName": "",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source55",
    "lineText": "",
    "lineNumber": 1,
    "columnNumber": 16,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 1,
        "columnNumber": 9,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj56",
        "class": "Error",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "Error",
          "message": "pumpkin",
          "stack": "@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:1:16\n",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 1,
          "columnNumber": 16
        }
      },
      "actorID": "server0.conn4.child2/obj56"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Promise reject Error Object with custom name`, {
  "pageError": {
    "errorMessage": "JuicyError: pineapple",
    "errorMessageName": "",
    "sourceName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn4.child2/source57",
    "lineText": "",
    "lineNumber": 2,
    "columnNumber": 15,
    "category": "content javascript",
    "innerWindowID": 6442450946,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": null,
        "lineNumber": 5,
        "columnNumber": 13,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 110 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 111,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 64,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": true,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn4.child2/obj58",
        "class": "Error",
        "ownPropertyLength": 6,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "JuicyError",
          "message": "pineapple",
          "stack": "@http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:2:15\n",
          "fileName": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 2,
          "columnNumber": 15
        }
      },
      "actorID": "server0.conn4.child2/obj58"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
