/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_f32x4_arith.wast

// ./test/core/simd/simd_f32x4_arith.wast:4
let $0 = instantiate(`(module
  (func (export "f32x4.add") (param v128 v128) (result v128) (f32x4.add (local.get 0) (local.get 1)))
  (func (export "f32x4.sub") (param v128 v128) (result v128) (f32x4.sub (local.get 0) (local.get 1)))
  (func (export "f32x4.mul") (param v128 v128) (result v128) (f32x4.mul (local.get 0) (local.get 1)))
  (func (export "f32x4.div") (param v128 v128) (result v128) (f32x4.div (local.get 0) (local.get 1)))
  (func (export "f32x4.neg") (param v128) (result v128) (f32x4.neg (local.get 0)))
  (func (export "f32x4.sqrt") (param v128) (result v128) (f32x4.sqrt (local.get 0)))
)`);

// ./test/core/simd/simd_f32x4_arith.wast:13
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:16
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:19
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:22
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:25
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:28
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:31
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:34
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:37
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:40
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:43
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:46
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:49
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:52
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:55
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:58
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:61
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:64
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:67
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:70
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:73
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:76
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:79
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:82
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:85
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:88
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:91
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:94
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:97
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:100
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:103
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:106
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:109
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:112
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:115
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:118
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:121
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:124
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:127
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:130
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:133
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:136
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:139
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:142
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:145
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:148
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:151
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:154
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:157
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:160
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:163
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:166
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:169
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:172
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:175
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:178
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:181
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:184
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:187
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:190
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:193
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:196
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:199
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:202
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:205
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:208
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:211
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:214
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:217
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:220
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:223
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:226
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:229
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:232
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:235
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:238
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:241
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:244
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:247
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:250
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:253
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:256
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:259
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:262
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:265
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:268
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:271
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:274
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:277
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:280
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:283
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:286
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:289
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:292
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:295
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:298
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:301
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:304
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:307
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:310
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:313
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:316
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:319
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:322
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:325
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:328
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:331
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:334
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:337
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:340
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:343
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:346
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:349
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:352
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:355
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:358
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:361
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:364
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:367
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:370
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:373
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:376
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:379
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:382
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:385
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:388
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:391
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:394
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:397
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:400
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:403
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:406
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:409
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:412
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:415
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:418
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:421
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:424
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:427
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:430
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:433
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:436
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:439
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:442
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:445
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:448
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:451
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:454
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:457
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:460
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:463
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:466
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:469
assert_return(
  () => invoke($0, `f32x4.add`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:472
assert_return(
  () =>
    invoke($0, `f32x4.add`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:475
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:478
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:481
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:484
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:487
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:490
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:493
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:496
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:499
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:502
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:505
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:508
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:511
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:514
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:517
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:520
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:523
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:526
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:529
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:532
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:535
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:538
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:541
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:544
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:547
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:550
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:553
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:556
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:559
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:562
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:565
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:568
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:571
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:574
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:577
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:580
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:583
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:586
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:589
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:592
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:595
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:598
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:601
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:604
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:607
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:610
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:613
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:616
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:619
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:622
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:625
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:628
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:631
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:634
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:637
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:640
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:643
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:646
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:649
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:652
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:655
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:658
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:661
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:664
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:667
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:670
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:673
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:676
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:679
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:682
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:685
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:688
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:691
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:694
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:697
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:700
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:703
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:706
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:709
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:712
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:715
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:718
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:721
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:724
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:727
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:730
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:733
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:736
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:739
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:742
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:745
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:748
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:751
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:754
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:757
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:760
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:763
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:766
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:769
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:772
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:775
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:778
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:781
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:784
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:787
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:790
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:793
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:796
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:799
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:802
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:805
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:808
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:811
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:814
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:817
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:820
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:823
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:826
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:829
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:832
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:835
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:838
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:841
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:844
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:847
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:850
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:853
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:856
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:859
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:862
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:865
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:868
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:871
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:874
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:877
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:880
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:883
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:886
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:889
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:892
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:895
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:898
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:901
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:904
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:907
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:910
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:913
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:916
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:919
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:922
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:925
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:928
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:931
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:934
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:937
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:940
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:943
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:946
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:949
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:952
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:955
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:958
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:961
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:964
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:967
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:970
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:973
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:976
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:979
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:982
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:985
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:988
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:991
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:994
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:997
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1000
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1003
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1006
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1009
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1012
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1015
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1018
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1021
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1024
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1027
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1030
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1033
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1036
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1039
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1042
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1045
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1048
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1051
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1054
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1057
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1060
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1063
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1066
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1069
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1072
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1075
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1078
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1081
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1084
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1087
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1090
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1093
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1096
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1099
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1102
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1105
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1108
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1111
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1114
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1117
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1120
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1123
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1126
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1129
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1132
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1135
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1138
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1141
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1144
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1147
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1150
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1153
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1156
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1159
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1162
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1165
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1168
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1171
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1174
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1177
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1180
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1183
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1186
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1189
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1192
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1195
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1198
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1201
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1204
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1207
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1210
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1213
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 246913580),
      value("f32", 246913580),
      value("f32", 246913580),
      value("f32", 246913580),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1216
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1219
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1222
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1225
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 246913580),
      value("f32", 246913580),
      value("f32", 246913580),
      value("f32", 246913580),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1228
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1231
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1234
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1237
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 246913580),
      value("f32", 246913580),
      value("f32", 246913580),
      value("f32", 246913580),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1240
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1243
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
      value("f32", 2469135800000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1246
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
      value("f32", 0.000000000024691358),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1249
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1252
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1255
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1258
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 312749980000),
      value("f32", 312749980000),
      value("f32", 312749980000),
      value("f32", 312749980000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1261
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1264
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1267
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1270
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 312749980000),
      value("f32", 312749980000),
      value("f32", 312749980000),
      value("f32", 312749980000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1273
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
      value("f32", 163971060000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1276
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1279
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
      value("f32", 85968060000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1282
assert_return(
  () =>
    invoke($0, `f32x4.add`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 312749980000),
      value("f32", 312749980000),
      value("f32", 312749980000),
      value("f32", 312749980000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1285
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1288
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1291
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1294
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1297
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1300
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1303
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1306
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1309
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1312
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1315
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1318
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1321
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1324
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1327
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1330
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1333
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1336
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1339
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1342
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1345
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1348
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1351
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1354
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1357
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1360
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1363
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1366
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1369
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1372
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1375
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1378
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1381
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1384
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1387
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1390
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1393
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1396
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1399
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1402
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1405
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1408
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1411
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1414
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1417
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1420
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1423
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1426
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1429
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1432
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1435
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1438
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1441
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1444
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1447
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1450
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1453
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1456
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1459
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1462
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1465
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1468
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1471
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1474
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1477
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1480
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1483
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
      value("f32", 0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1486
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
      value("f32", 0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1489
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1492
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1495
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1498
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1501
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1504
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1507
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1510
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1513
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1516
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1519
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1522
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1525
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1528
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1531
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
      value("f32", -0.000000000000000000000000000000000000011754945),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1534
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
      value("f32", -0.000000000000000000000000000000000000011754942),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1537
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1540
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1543
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1546
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1549
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1552
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1555
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1558
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1561
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1564
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1567
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1570
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1573
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1576
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1579
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1582
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1585
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1588
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1591
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1594
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1597
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1600
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1603
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1606
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1609
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1612
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1615
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1618
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1621
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1624
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1627
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1630
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1633
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1636
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1639
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1642
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1645
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1648
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1651
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1654
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1657
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1660
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1663
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1666
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1669
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1672
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1675
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1678
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1681
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1684
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1687
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1690
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
      value("f32", 1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1693
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1696
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1699
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1702
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1705
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1708
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1711
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1714
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1717
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1720
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1723
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1726
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1729
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1732
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1735
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
      value("f32", -1.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1738
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1741
assert_return(
  () => invoke($0, `f32x4.sub`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1744
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1747
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1750
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1753
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1756
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1759
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1762
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1765
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1768
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1771
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1774
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1777
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1780
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1783
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
      value("f32", 5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1786
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
      value("f32", 6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1789
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
      value("f32", 5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1792
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
      value("f32", 7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1795
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1798
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1801
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1804
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1807
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1810
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1813
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1816
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1819
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1822
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1825
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1828
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1831
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
      value("f32", -6.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1834
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
      value("f32", -5.7831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1837
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
      value("f32", -7.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1840
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
      value("f32", -5.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1843
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1846
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1849
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1852
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1855
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1858
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1861
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1864
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1867
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1870
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1873
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1876
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1879
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1882
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1885
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1888
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1891
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1894
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1897
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1900
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1903
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1906
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1909
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1912
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1915
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1918
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1921
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1924
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1927
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1930
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1933
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1936
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1939
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1942
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1945
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1948
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1951
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1954
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1957
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1960
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1963
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1966
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1969
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1972
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1975
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1978
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1981
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1984
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1987
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1990
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1993
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1996
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:1999
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2002
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2005
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2008
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2011
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2014
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2017
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2020
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2023
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2026
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2029
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2032
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2035
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2038
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2041
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2044
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2047
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2050
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2053
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2056
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2059
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2062
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2065
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2068
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2071
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2074
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2077
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2080
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2083
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2086
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2089
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2092
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2095
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2098
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2101
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2104
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2107
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2110
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2113
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2116
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2119
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2122
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2125
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2128
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2131
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2134
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2137
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2140
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2143
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2146
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2149
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2152
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2155
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2158
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2161
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2164
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2167
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2170
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2173
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2176
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2179
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2182
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2185
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2188
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2191
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2194
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2197
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2200
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2203
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2206
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2209
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2212
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2215
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2218
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2221
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2224
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2227
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2230
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2233
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2236
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2239
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2242
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2245
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2248
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2251
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2254
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2257
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2260
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2263
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2266
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2269
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2272
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2275
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2278
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2281
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2284
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2287
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2290
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2293
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2296
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2299
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2302
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2305
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2308
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2311
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2314
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2317
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2320
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2323
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2326
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2329
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2332
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2335
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2338
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2341
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2344
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2347
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2350
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2353
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2356
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2359
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2362
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2365
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2368
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2371
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2374
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2377
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2380
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2383
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2386
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2389
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2392
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2395
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2398
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2401
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2404
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2407
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2410
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2413
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2416
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2419
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2422
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2425
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2428
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2431
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2434
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2437
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2440
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2443
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2446
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2449
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2452
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2455
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2458
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2461
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2464
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2467
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2470
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2473
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2476
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2479
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2482
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2485
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2488
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2491
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2494
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2497
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2500
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2503
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2506
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2509
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2512
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2515
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2518
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2521
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2524
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2527
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2530
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2533
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2536
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2539
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2542
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2545
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2548
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2551
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2554
assert_return(
  () =>
    invoke($0, `f32x4.sub`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2557
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2560
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2563
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2566
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2569
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2572
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2575
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2578
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2581
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2584
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2587
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2590
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2593
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2596
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2599
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2602
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2605
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2608
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2611
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2614
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2617
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2620
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2623
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2626
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2629
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2632
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2635
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2638
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2641
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2644
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2647
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2650
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2653
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2656
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2659
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2662
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2665
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2668
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2671
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2674
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2677
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2680
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2683
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2686
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2689
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2692
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2695
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2698
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2701
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2704
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2707
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2710
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2713
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2716
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2719
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2722
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2725
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2728
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2731
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2734
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2737
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2740
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2743
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2746
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2749
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2752
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2755
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2758
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2761
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2764
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2767
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2770
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2773
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2776
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2779
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2782
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2785
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2788
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2791
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2794
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2797
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2800
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2803
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2806
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2809
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2812
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2815
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2818
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2821
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2824
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2827
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2830
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2833
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2836
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2839
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2842
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2845
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2848
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2851
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2854
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2857
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2860
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2863
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.25),
      value("f32", 0.25),
      value("f32", 0.25),
      value("f32", 0.25),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2866
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.25),
      value("f32", -0.25),
      value("f32", -0.25),
      value("f32", -0.25),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2869
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2872
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2875
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2878
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2881
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2884
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2887
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2890
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2893
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2896
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2899
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2902
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2905
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
      value("f32", -0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2908
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
      value("f32", 0.000000000000000000000000000000000000005877472),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2911
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.25),
      value("f32", -0.25),
      value("f32", -0.25),
      value("f32", -0.25),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2914
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.25),
      value("f32", 0.25),
      value("f32", 0.25),
      value("f32", 0.25),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2917
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2920
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2923
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2926
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2929
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2932
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2935
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2938
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2941
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2944
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2947
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2950
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2953
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2956
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2959
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2962
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2965
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2968
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2971
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2974
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2977
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2980
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2983
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2986
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2989
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2992
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2995
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:2998
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3001
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3004
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3007
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3010
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3013
assert_return(
  () => invoke($0, `f32x4.mul`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3016
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3019
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3022
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3025
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3028
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3031
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3034
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3037
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3040
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3043
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3046
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3049
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3052
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3055
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3058
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3061
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3064
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3067
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 39.47842),
      value("f32", 39.47842),
      value("f32", 39.47842),
      value("f32", 39.47842),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3070
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -39.47842),
      value("f32", -39.47842),
      value("f32", -39.47842),
      value("f32", -39.47842),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3073
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3076
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3079
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3082
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3085
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3088
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3091
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
      value("f32", -0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3094
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
      value("f32", 0.000000000000000000000000000000000000000000008),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3097
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
      value("f32", -0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3100
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
      value("f32", 0.00000000000000000000000000000000000007385849),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3103
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
      value("f32", -3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3106
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
      value("f32", 3.1415927),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3109
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3112
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3115
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -39.47842),
      value("f32", -39.47842),
      value("f32", -39.47842),
      value("f32", -39.47842),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3118
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 39.47842),
      value("f32", 39.47842),
      value("f32", 39.47842),
      value("f32", 39.47842),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3121
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3124
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3127
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3130
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3133
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3136
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3139
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3142
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3145
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3148
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3151
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3154
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3157
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3160
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3163
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3166
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3169
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3172
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3175
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3178
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3181
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3184
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3187
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
      value("f32", -0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3190
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
      value("f32", 0.00000047683713),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3193
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
      value("f32", -3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3196
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
      value("f32", 3.9999998),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3199
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
      value("f32", -170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3202
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
      value("f32", 170141170000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3205
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3208
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3211
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3214
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3217
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3220
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3223
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3226
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3229
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3232
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3235
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3238
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3241
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3244
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3247
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3250
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3253
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3256
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3259
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3262
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3265
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3268
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3271
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3274
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3277
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3280
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3283
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3286
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3289
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3292
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3295
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3298
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3301
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3304
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3307
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3310
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3313
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3316
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3319
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3322
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3325
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3328
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3331
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3334
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3337
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3340
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3343
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3346
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3349
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3352
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3355
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3358
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3361
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3364
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3367
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3370
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3373
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3376
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3379
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3382
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3385
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3388
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3391
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3394
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3397
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3400
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3403
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3406
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3409
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3412
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3415
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3418
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3421
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3424
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3427
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3430
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3433
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3436
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3439
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3442
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3445
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3448
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3451
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3454
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3457
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3460
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3463
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3466
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3469
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3472
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3475
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3478
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3481
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3484
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3487
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3490
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3493
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3496
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3499
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3502
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3505
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3508
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3511
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3514
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3517
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3520
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3523
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3526
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3529
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3532
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3535
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3538
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3541
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3544
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3547
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3550
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3553
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3556
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3559
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3562
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3565
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3568
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3571
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3574
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3577
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3580
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3583
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3586
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3589
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3592
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3595
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3598
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3601
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3604
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3607
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3610
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3613
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3616
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3619
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3622
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3625
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3628
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3631
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3634
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3637
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3640
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3643
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3646
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3649
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3652
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3655
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3658
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3661
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3664
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3667
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3670
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3673
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3676
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3679
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3682
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3685
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3688
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3691
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3694
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3697
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3700
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3703
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3706
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3709
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3712
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3715
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3718
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3721
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3724
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3727
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3730
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3733
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3736
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3739
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3742
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3745
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3748
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3751
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3754
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3757
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3760
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3763
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3766
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3769
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3772
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3775
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3778
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3781
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
      value("f32", 15241579000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3784
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3787
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3790
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
      value("f32", 0.00000000000000000000015241579),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3793
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3796
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3799
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3802
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3805
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3808
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3811
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3814
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3817
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
      value("f32", 6721627600000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3820
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3823
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3826
assert_return(
  () =>
    invoke($0, `f32x4.mul`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
      value("f32", 24453139000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3829
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3832
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3835
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3838
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3841
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3844
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3847
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3850
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3853
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3856
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3859
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3862
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3865
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3868
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3871
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3874
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3877
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3880
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3883
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3886
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3889
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3892
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3895
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3898
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3901
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3904
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3907
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3910
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3913
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3916
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3919
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3922
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3925
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3928
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3931
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3934
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3937
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000011920929),
      value("f32", 0.00000011920929),
      value("f32", 0.00000011920929),
      value("f32", 0.00000011920929),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3940
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000011920929),
      value("f32", -0.00000011920929),
      value("f32", -0.00000011920929),
      value("f32", -0.00000011920929),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3943
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3946
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3949
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3952
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3955
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3958
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3961
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3964
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3967
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3970
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3973
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3976
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3979
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3982
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3985
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.00000011920929),
      value("f32", -0.00000011920929),
      value("f32", -0.00000011920929),
      value("f32", -0.00000011920929),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3988
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000011920929),
      value("f32", 0.00000011920929),
      value("f32", 0.00000011920929),
      value("f32", 0.00000011920929),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3991
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
      value("f32", -0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3994
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
      value("f32", 0.000000000000000000000000000000000000000000003),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:3997
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4000
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4003
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4006
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4009
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4012
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4015
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4018
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4021
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4024
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4027
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 8388608),
      value("f32", 8388608),
      value("f32", 8388608),
      value("f32", 8388608),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4030
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -8388608),
      value("f32", -8388608),
      value("f32", -8388608),
      value("f32", -8388608),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4033
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4036
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4039
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4042
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4045
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4048
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4051
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000001870857),
      value("f32", 0.000000000000000000000000000000000000001870857),
      value("f32", 0.000000000000000000000000000000000000001870857),
      value("f32", 0.000000000000000000000000000000000000001870857),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4054
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000001870857),
      value("f32", -0.000000000000000000000000000000000000001870857),
      value("f32", -0.000000000000000000000000000000000000001870857),
      value("f32", -0.000000000000000000000000000000000000001870857),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4057
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4060
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4063
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4066
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4069
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4072
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4075
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -8388608),
      value("f32", -8388608),
      value("f32", -8388608),
      value("f32", -8388608),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4078
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 8388608),
      value("f32", 8388608),
      value("f32", 8388608),
      value("f32", 8388608),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4081
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4084
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4087
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
      value("f32", -0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4090
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
      value("f32", 0.000000000000000000000000000000000000023509887),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4093
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4096
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4099
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000001870857),
      value("f32", -0.000000000000000000000000000000000000001870857),
      value("f32", -0.000000000000000000000000000000000000001870857),
      value("f32", -0.000000000000000000000000000000000000001870857),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4102
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000001870857),
      value("f32", 0.000000000000000000000000000000000000001870857),
      value("f32", 0.000000000000000000000000000000000000001870857),
      value("f32", 0.000000000000000000000000000000000000001870857),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4105
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4108
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4111
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4114
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4117
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4120
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4123
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4126
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4129
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 42535296000000000000000000000000000000),
      value("f32", 42535296000000000000000000000000000000),
      value("f32", 42535296000000000000000000000000000000),
      value("f32", 42535296000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4132
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42535296000000000000000000000000000000),
      value("f32", -42535296000000000000000000000000000000),
      value("f32", -42535296000000000000000000000000000000),
      value("f32", -42535296000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4135
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4138
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4141
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4144
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4147
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.07957747),
      value("f32", 0.07957747),
      value("f32", 0.07957747),
      value("f32", 0.07957747),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4150
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.07957747),
      value("f32", -0.07957747),
      value("f32", -0.07957747),
      value("f32", -0.07957747),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4153
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000001469368),
      value("f32", 0.000000000000000000000000000000000000001469368),
      value("f32", 0.000000000000000000000000000000000000001469368),
      value("f32", 0.000000000000000000000000000000000000001469368),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4156
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000001469368),
      value("f32", -0.000000000000000000000000000000000000001469368),
      value("f32", -0.000000000000000000000000000000000000001469368),
      value("f32", -0.000000000000000000000000000000000000001469368),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4159
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4162
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4165
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4168
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4171
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4174
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4177
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42535296000000000000000000000000000000),
      value("f32", -42535296000000000000000000000000000000),
      value("f32", -42535296000000000000000000000000000000),
      value("f32", -42535296000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4180
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 42535296000000000000000000000000000000),
      value("f32", 42535296000000000000000000000000000000),
      value("f32", 42535296000000000000000000000000000000),
      value("f32", 42535296000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4183
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4186
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4189
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
      value("f32", -0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4192
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4195
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.07957747),
      value("f32", -0.07957747),
      value("f32", -0.07957747),
      value("f32", -0.07957747),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4198
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.07957747),
      value("f32", 0.07957747),
      value("f32", 0.07957747),
      value("f32", 0.07957747),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4201
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000001469368),
      value("f32", -0.000000000000000000000000000000000000001469368),
      value("f32", -0.000000000000000000000000000000000000001469368),
      value("f32", -0.000000000000000000000000000000000000001469368),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4204
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000001469368),
      value("f32", 0.000000000000000000000000000000000000001469368),
      value("f32", 0.000000000000000000000000000000000000001469368),
      value("f32", 0.000000000000000000000000000000000000001469368),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4207
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4210
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4213
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4216
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4219
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4222
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4225
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85070590000000000000000000000000000000),
      value("f32", 85070590000000000000000000000000000000),
      value("f32", 85070590000000000000000000000000000000),
      value("f32", 85070590000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4228
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -85070590000000000000000000000000000000),
      value("f32", -85070590000000000000000000000000000000),
      value("f32", -85070590000000000000000000000000000000),
      value("f32", -85070590000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4231
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [
    new F32x4Pattern(
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4234
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4237
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4240
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4243
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.15915494),
      value("f32", 0.15915494),
      value("f32", 0.15915494),
      value("f32", 0.15915494),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4246
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.15915494),
      value("f32", -0.15915494),
      value("f32", -0.15915494),
      value("f32", -0.15915494),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4249
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000002938736),
      value("f32", 0.000000000000000000000000000000000000002938736),
      value("f32", 0.000000000000000000000000000000000000002938736),
      value("f32", 0.000000000000000000000000000000000000002938736),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4252
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000002938736),
      value("f32", -0.000000000000000000000000000000000000002938736),
      value("f32", -0.000000000000000000000000000000000000002938736),
      value("f32", -0.000000000000000000000000000000000000002938736),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4255
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4258
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4261
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4264
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4267
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4270
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4273
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -85070590000000000000000000000000000000),
      value("f32", -85070590000000000000000000000000000000),
      value("f32", -85070590000000000000000000000000000000),
      value("f32", -85070590000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4276
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 85070590000000000000000000000000000000),
      value("f32", 85070590000000000000000000000000000000),
      value("f32", 85070590000000000000000000000000000000),
      value("f32", 85070590000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4279
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
      value("f32", -2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4282
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
      value("f32", 2),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4285
assert_return(
  () => invoke($0, `f32x4.div`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4288
assert_return(
  () =>
    invoke($0, `f32x4.div`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4291
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.15915494),
      value("f32", -0.15915494),
      value("f32", -0.15915494),
      value("f32", -0.15915494),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4294
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.15915494),
      value("f32", 0.15915494),
      value("f32", 0.15915494),
      value("f32", 0.15915494),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4297
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000002938736),
      value("f32", -0.000000000000000000000000000000000000002938736),
      value("f32", -0.000000000000000000000000000000000000002938736),
      value("f32", -0.000000000000000000000000000000000000002938736),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4300
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000002938736),
      value("f32", 0.000000000000000000000000000000000000002938736),
      value("f32", 0.000000000000000000000000000000000000002938736),
      value("f32", 0.000000000000000000000000000000000000002938736),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4303
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4306
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4309
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4312
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4315
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4318
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4321
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4324
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4327
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4330
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4333
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4336
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4339
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4342
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4345
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000018464624),
      value("f32", 0.000000000000000000000000000000000000018464624),
      value("f32", 0.000000000000000000000000000000000000018464624),
      value("f32", 0.000000000000000000000000000000000000018464624),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4348
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000018464624),
      value("f32", -0.000000000000000000000000000000000000018464624),
      value("f32", -0.000000000000000000000000000000000000018464624),
      value("f32", -0.000000000000000000000000000000000000018464624),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4351
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4354
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4357
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4360
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4363
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4366
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4369
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4372
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4375
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
      value("f32", -12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4378
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
      value("f32", 12.566371),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4381
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4384
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4387
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4390
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4393
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000018464624),
      value("f32", -0.000000000000000000000000000000000000018464624),
      value("f32", -0.000000000000000000000000000000000000018464624),
      value("f32", -0.000000000000000000000000000000000000018464624),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4396
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000018464624),
      value("f32", 0.000000000000000000000000000000000000018464624),
      value("f32", 0.000000000000000000000000000000000000018464624),
      value("f32", 0.000000000000000000000000000000000000018464624),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4399
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4402
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4405
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4408
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4411
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4414
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4417
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4420
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4423
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4426
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4429
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4432
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4435
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 54157613000000000000000000000000000000),
      value("f32", 54157613000000000000000000000000000000),
      value("f32", 54157613000000000000000000000000000000),
      value("f32", 54157613000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4438
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -54157613000000000000000000000000000000),
      value("f32", -54157613000000000000000000000000000000),
      value("f32", -54157613000000000000000000000000000000),
      value("f32", -54157613000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4441
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4444
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4447
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4450
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4453
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4456
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4459
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4462
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4465
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4468
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4471
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4474
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4477
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4480
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4483
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -54157613000000000000000000000000000000),
      value("f32", -54157613000000000000000000000000000000),
      value("f32", -54157613000000000000000000000000000000),
      value("f32", -54157613000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4486
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 54157613000000000000000000000000000000),
      value("f32", 54157613000000000000000000000000000000),
      value("f32", 54157613000000000000000000000000000000),
      value("f32", 54157613000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4489
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
      value("f32", -1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4492
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4495
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
      value("f32", -0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4498
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
      value("f32", 0),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4501
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4504
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4507
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4510
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4513
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4516
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4519
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4522
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4525
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4528
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4531
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4534
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4537
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4540
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4543
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4546
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4549
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4552
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4555
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4558
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4561
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4564
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4567
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4570
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4573
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4576
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4579
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4582
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4585
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4588
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4591
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4594
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4597
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4600
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4603
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4606
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4609
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4612
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4615
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4618
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4621
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4624
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4627
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4630
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4633
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4636
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4639
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4642
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4645
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4648
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4651
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4654
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4657
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4660
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4663
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4666
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4669
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4672
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4675
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4678
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4681
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4684
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4687
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4690
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4693
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4696
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4699
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4702
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4705
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4708
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4711
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4714
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4717
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4720
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4723
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4726
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4729
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4732
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4735
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4738
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4741
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4744
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4747
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4750
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4753
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4756
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4759
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4762
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4765
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4768
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4771
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4774
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4777
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4780
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4783
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4786
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4789
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4792
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4795
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4798
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4801
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4804
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4807
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4810
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4813
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4816
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4819
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4822
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4825
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4828
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4831
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4834
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4837
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4840
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4843
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4846
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4849
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4852
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4855
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4858
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4861
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4864
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4867
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4870
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4873
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4876
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4879
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4882
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4885
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4888
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4891
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4894
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4897
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4900
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4903
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4906
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4909
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4912
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4915
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4918
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4921
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4924
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4927
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4930
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4933
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4936
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4939
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4942
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4945
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4948
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4951
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4954
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4957
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4960
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4963
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4966
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4969
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4972
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4975
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4978
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4981
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4984
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4987
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4990
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4993
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4996
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:4999
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5002
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5005
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5008
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5011
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5014
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5017
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5020
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5023
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5026
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5029
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5032
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5035
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5038
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5041
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5044
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5047
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5050
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5053
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5056
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5059
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5062
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5065
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5068
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5071
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5074
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5077
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5080
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5083
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5086
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5089
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5092
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5095
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5098
assert_return(
  () =>
    invoke($0, `f32x4.div`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
      value("f32", 1),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5101
assert_return(() => invoke($0, `f32x4.sqrt`, [f32x4([0, 0, 0, 0])]), [
  new F32x4Pattern(
    value("f32", 0),
    value("f32", 0),
    value("f32", 0),
    value("f32", 0),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5103
assert_return(() => invoke($0, `f32x4.sqrt`, [f32x4([-0, -0, -0, -0])]), [
  new F32x4Pattern(
    value("f32", -0),
    value("f32", -0),
    value("f32", -0),
    value("f32", -0),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5105
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000000003743392),
      value("f32", 0.00000000000000000000003743392),
      value("f32", 0.00000000000000000000003743392),
      value("f32", 0.00000000000000000000003743392),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5107
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5109
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.00000000000000000010842022),
      value("f32", 0.00000000000000000010842022),
      value("f32", 0.00000000000000000010842022),
      value("f32", 0.00000000000000000010842022),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5111
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5113
assert_return(() => invoke($0, `f32x4.sqrt`, [f32x4([0.5, 0.5, 0.5, 0.5])]), [
  new F32x4Pattern(
    value("f32", 0.70710677),
    value("f32", 0.70710677),
    value("f32", 0.70710677),
    value("f32", 0.70710677),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5115
assert_return(
  () => invoke($0, `f32x4.sqrt`, [f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5117
assert_return(() => invoke($0, `f32x4.sqrt`, [f32x4([1, 1, 1, 1])]), [
  new F32x4Pattern(
    value("f32", 1),
    value("f32", 1),
    value("f32", 1),
    value("f32", 1),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5119
assert_return(() => invoke($0, `f32x4.sqrt`, [f32x4([-1, -1, -1, -1])]), [
  new F32x4Pattern(
    `canonical_nan`,
    `canonical_nan`,
    `canonical_nan`,
    `canonical_nan`,
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5121
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 2.5066283),
      value("f32", 2.5066283),
      value("f32", 2.5066283),
      value("f32", 2.5066283),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5123
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5125
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 18446743000000000000),
      value("f32", 18446743000000000000),
      value("f32", 18446743000000000000),
      value("f32", 18446743000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5127
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5129
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [f32x4([Infinity, Infinity, Infinity, Infinity])]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5131
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5133
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5135
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
      `canonical_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5137
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5139
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
      `arithmetic_nan`,
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5141
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 11111.111),
      value("f32", 11111.111),
      value("f32", 11111.111),
      value("f32", 11111.111),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5143
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5145
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5147
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5149
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 11111.111),
      value("f32", 11111.111),
      value("f32", 11111.111),
      value("f32", 11111.111),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5151
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5153
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5155
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5157
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 11111.111),
      value("f32", 11111.111),
      value("f32", 11111.111),
      value("f32", 11111.111),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5159
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5161
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
      value("f32", 35136419000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5163
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
      value("f32", 0.0000035136418),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5165
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 286331170),
      value("f32", 286331170),
      value("f32", 286331170),
      value("f32", 286331170),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5167
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5169
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5171
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 395442.78),
      value("f32", 395442.78),
      value("f32", 395442.78),
      value("f32", 395442.78),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5173
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 286331170),
      value("f32", 286331170),
      value("f32", 286331170),
      value("f32", 286331170),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5175
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5177
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5179
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 395442.78),
      value("f32", 395442.78),
      value("f32", 395442.78),
      value("f32", 395442.78),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5181
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 286331170),
      value("f32", 286331170),
      value("f32", 286331170),
      value("f32", 286331170),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5183
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5185
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
      value("f32", 207325900000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5187
assert_return(
  () =>
    invoke($0, `f32x4.sqrt`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 395442.78),
      value("f32", 395442.78),
      value("f32", 395442.78),
      value("f32", 395442.78),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5189
assert_return(() => invoke($0, `f32x4.neg`, [f32x4([0, 0, 0, 0])]), [
  new F32x4Pattern(
    value("f32", -0),
    value("f32", -0),
    value("f32", -0),
    value("f32", -0),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5191
assert_return(() => invoke($0, `f32x4.neg`, [f32x4([-0, -0, -0, -0])]), [
  new F32x4Pattern(
    value("f32", 0),
    value("f32", 0),
    value("f32", 0),
    value("f32", 0),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5193
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
      value("f32", -0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5195
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
      value("f32", 0.000000000000000000000000000000000000000000001),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5197
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
      value("f32", -0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5199
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
      value("f32", 0.000000000000000000000000000000000000011754944),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5201
assert_return(() => invoke($0, `f32x4.neg`, [f32x4([0.5, 0.5, 0.5, 0.5])]), [
  new F32x4Pattern(
    value("f32", -0.5),
    value("f32", -0.5),
    value("f32", -0.5),
    value("f32", -0.5),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5203
assert_return(
  () => invoke($0, `f32x4.neg`, [f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [
    new F32x4Pattern(
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
      value("f32", 0.5),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5205
assert_return(() => invoke($0, `f32x4.neg`, [f32x4([1, 1, 1, 1])]), [
  new F32x4Pattern(
    value("f32", -1),
    value("f32", -1),
    value("f32", -1),
    value("f32", -1),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5207
assert_return(() => invoke($0, `f32x4.neg`, [f32x4([-1, -1, -1, -1])]), [
  new F32x4Pattern(
    value("f32", 1),
    value("f32", 1),
    value("f32", 1),
    value("f32", 1),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5209
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
      value("f32", -6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5211
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
      value("f32", 6.2831855),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5213
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
      value("f32", -340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5215
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
      value("f32", 340282350000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5217
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [f32x4([Infinity, Infinity, Infinity, Infinity])]),
  [
    new F32x4Pattern(
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
      value("f32", -Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5219
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [
    new F32x4Pattern(
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
      value("f32", Infinity),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5221
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      bytes("f32", [0x0, 0x0, 0xc0, 0xff]),
      bytes("f32", [0x0, 0x0, 0xc0, 0xff]),
      bytes("f32", [0x0, 0x0, 0xc0, 0xff]),
      bytes("f32", [0x0, 0x0, 0xc0, 0xff]),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5223
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      bytes("f32", [0x0, 0x0, 0xc0, 0x7f]),
      bytes("f32", [0x0, 0x0, 0xc0, 0x7f]),
      bytes("f32", [0x0, 0x0, 0xc0, 0x7f]),
      bytes("f32", [0x0, 0x0, 0xc0, 0x7f]),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5225
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [
    new F32x4Pattern(
      bytes("f32", [0x0, 0x0, 0xa0, 0xff]),
      bytes("f32", [0x0, 0x0, 0xa0, 0xff]),
      bytes("f32", [0x0, 0x0, 0xa0, 0xff]),
      bytes("f32", [0x0, 0x0, 0xa0, 0xff]),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5227
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [
    new F32x4Pattern(
      bytes("f32", [0x0, 0x0, 0xa0, 0x7f]),
      bytes("f32", [0x0, 0x0, 0xa0, 0x7f]),
      bytes("f32", [0x0, 0x0, 0xa0, 0x7f]),
      bytes("f32", [0x0, 0x0, 0xa0, 0x7f]),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5229
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -123456790),
      value("f32", -123456790),
      value("f32", -123456790),
      value("f32", -123456790),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5231
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5233
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5235
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5237
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -123456790),
      value("f32", -123456790),
      value("f32", -123456790),
      value("f32", -123456790),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5239
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5241
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5243
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5245
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -123456790),
      value("f32", -123456790),
      value("f32", -123456790),
      value("f32", -123456790),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5247
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5249
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
      value("f32", -1234567900000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5251
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
      value("f32", -0.000000000012345679),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5253
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5255
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5257
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5259
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -156374990000),
      value("f32", -156374990000),
      value("f32", -156374990000),
      value("f32", -156374990000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5261
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5263
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5265
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5267
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -156374990000),
      value("f32", -156374990000),
      value("f32", -156374990000),
      value("f32", -156374990000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5269
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        81985530000000000,
        81985530000000000,
        81985530000000000,
        81985530000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
      value("f32", -81985530000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5271
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5273
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
        42984030000000000000000,
      ]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
      value("f32", -42984030000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5275
assert_return(
  () =>
    invoke($0, `f32x4.neg`, [
      f32x4([156374990000, 156374990000, 156374990000, 156374990000]),
    ]),
  [
    new F32x4Pattern(
      value("f32", -156374990000),
      value("f32", -156374990000),
      value("f32", -156374990000),
      value("f32", -156374990000),
    ),
  ],
);

// ./test/core/simd/simd_f32x4_arith.wast:5280
let $1 = instantiate(`(module

  (func (export "f32x4_sqrt_arith") (result v128)
    (f32x4.sqrt (v128.const f32x4 nan:0x200000 -nan:0x200000 16.0 25.0)))
  (func (export "f32x4_sqrt_canon") (result v128)
    (f32x4.sqrt (v128.const f32x4 -1.0 nan 4.0 9.0)))
  (func (export "f32x4_sqrt_mixed") (result v128)
    (f32x4.sqrt (v128.const f32x4 -inf nan:0x200000 36.0 49.0)))
)`);

// ./test/core/simd/simd_f32x4_arith.wast:5290
assert_return(() => invoke($1, `f32x4_sqrt_arith`, []), [
  new F32x4Pattern(
    `arithmetic_nan`,
    `arithmetic_nan`,
    value("f32", 4),
    value("f32", 5),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5291
assert_return(() => invoke($1, `f32x4_sqrt_canon`, []), [
  new F32x4Pattern(
    `canonical_nan`,
    `canonical_nan`,
    value("f32", 2),
    value("f32", 3),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5292
assert_return(() => invoke($1, `f32x4_sqrt_mixed`, []), [
  new F32x4Pattern(
    `canonical_nan`,
    `arithmetic_nan`,
    value("f32", 6),
    value("f32", 7),
  ),
]);

// ./test/core/simd/simd_f32x4_arith.wast:5295
assert_invalid(
  () => instantiate(`(module (func (result v128) (f32x4.neg (i32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_f32x4_arith.wast:5296
assert_invalid(
  () => instantiate(`(module (func (result v128) (f32x4.sqrt (i32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_f32x4_arith.wast:5297
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (f32x4.add (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_f32x4_arith.wast:5298
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (f32x4.sub (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_f32x4_arith.wast:5299
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (f32x4.mul (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_f32x4_arith.wast:5300
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (f32x4.div (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_f32x4_arith.wast:5304
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.neg-arg-empty (result v128)
      (f32x4.neg)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5312
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.sqrt-arg-empty (result v128)
      (f32x4.sqrt)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5320
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.add-1st-arg-empty (result v128)
      (f32x4.add (v128.const f32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5328
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.add-arg-empty (result v128)
      (f32x4.add)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5336
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.sub-1st-arg-empty (result v128)
      (f32x4.sub (v128.const f32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5344
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.sub-arg-empty (result v128)
      (f32x4.sub)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5352
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.mul-1st-arg-empty (result v128)
      (f32x4.mul (v128.const f32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_f32x4_arith.wast:5360
assert_invalid(() =>
  instantiate(`(module
    (func $$f32x4.mul-arg-em