/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* RootCertificateTelemetryUtils.cpp, you shouldn't be #including it.        */
/*****************************************************************************/

#define HASH_LEN 32
struct CertAuthorityHash {
  // See bug 1338873 about making these fields const.
  uint8_t hash[HASH_LEN];
  int32_t binNumber;
};

static const struct CertAuthorityHash ROOT_TABLE[] = {
  {
    /* Entrust_Root_Certification_Authority___EC1 */
    { 0x02, 0xED, 0x0E, 0xB2, 0x8C, 0x14, 0xDA, 0x45, 0x16, 0x5C, 0x56, 0x67, 0x91, 0x70, 0x0D, 0x64,
      0x51, 0xD7, 0xFB, 0x56, 0xF0, 0xB2, 0xAB, 0x1D, 0x3B, 0x8E, 0xB0, 0x70, 0xE5, 0x6E, 0xDF, 0xF5 },
      164 /* Bin Number */
  },
  {
    /* AffirmTrust_Commercial */
    { 0x03, 0x76, 0xAB, 0x1D, 0x54, 0xC5, 0xF9, 0x80, 0x3C, 0xE4, 0xB2, 0xE2, 0x01, 0xA0, 0xEE, 0x7E,
      0xEF, 0x7B, 0x57, 0xB6, 0x36, 0xE8, 0xA9, 0x3C, 0x9B, 0x8D, 0x48, 0x60, 0xC9, 0x6F, 0x5F, 0xA7 },
      109 /* Bin Number */
  },
  {
    /* ACEDICOM_Root */
    { 0x03, 0x95, 0x0F, 0xB4, 0x9A, 0x53, 0x1F, 0x3E, 0x19, 0x91, 0x94, 0x23, 0x98, 0xDF, 0xA9, 0xE0,
      0xEA, 0x32, 0xD7, 0xBA, 0x1C, 0xDD, 0x9B, 0xC8, 0x5D, 0xB5, 0x7E, 0xD9, 0x40, 0x0B, 0x43, 0x4A },
      98 /* Bin Number */
  },
  {
    /* Autoridad_de_Certificacion_Firmaprofesional_CIF_A62634068 */
    { 0x04, 0x04, 0x80, 0x28, 0xBF, 0x1F, 0x28, 0x64, 0xD4, 0x8F, 0x9A, 0xD4, 0xD8, 0x32, 0x94, 0x36,
      0x6A, 0x82, 0x88, 0x56, 0x55, 0x3F, 0x3B, 0x14, 0x30, 0x3F, 0x90, 0x14, 0x7F, 0x5D, 0x40, 0xEF },
      102 /* Bin Number */
  },
  {
    /* Chambers_of_Commerce_Root___2008 */
    { 0x06, 0x3E, 0x4A, 0xFA, 0xC4, 0x91, 0xDF, 0xD3, 0x32, 0xF3, 0x08, 0x9B, 0x85, 0x42, 0xE9, 0x46,
      0x17, 0xD8, 0x93, 0xD7, 0xFE, 0x94, 0x4E, 0x10, 0xA7, 0x93, 0x7E, 0xE2, 0x9D, 0x96, 0x93, 0xC0 },
      104 /* Bin Number */
  },
  {
    /* DST_Root_CA_X3 */
    { 0x06, 0x87, 0x26, 0x03, 0x31, 0xA7, 0x24, 0x03, 0xD9, 0x09, 0xF1, 0x05, 0xE6, 0x9B, 0xCF, 0x0D,
      0x32, 0xE1, 0xBD, 0x24, 0x93, 0xFF, 0xC6, 0xD9, 0x20, 0x6D, 0x11, 0xBC, 0xD6, 0x77, 0x07, 0x39 },
      52 /* Bin Number */
  },
  {
    /* TrustCor_RootCert_CA_2 */
    { 0x07, 0x53, 0xE9, 0x40, 0x37, 0x8C, 0x1B, 0xD5, 0xE3, 0x83, 0x6E, 0x39, 0x5D, 0xAE, 0xA5, 0xCB,
      0x83, 0x9E, 0x50, 0x46, 0xF1, 0xBD, 0x0E, 0xAE, 0x19, 0x51, 0xCF, 0x10, 0xFE, 0xC7, 0xC9, 0x65 },
      191 /* Bin Number */
  },
  {
    /* AddTrust_Public_CA_Root */
    { 0x07, 0x91, 0xCA, 0x07, 0x49, 0xB2, 0x07, 0x82, 0xAA, 0xD3, 0xC7, 0xD7, 0xBD, 0x0C, 0xDF, 0xC9,
      0x48, 0x58, 0x35, 0x84, 0x3E, 0xB2, 0xD7, 0x99, 0x60, 0x09, 0xCE, 0x43, 0xAB, 0x6C, 0x69, 0x27 },
      16 /* Bin Number */
  },
  {
    /* OU_Equifax_Secure_Certificate_Authority_O_Equifax_C_US */
    { 0x08, 0x29, 0x7A, 0x40, 0x47, 0xDB, 0xA2, 0x36, 0x80, 0xC7, 0x31, 0xDB, 0x6E, 0x31, 0x76, 0x53,
      0xCA, 0x78, 0x48, 0xE1, 0xBE, 0xBD, 0x3A, 0x0B, 0x01, 0x79, 0xA7, 0x07, 0xF9, 0x2C, 0xF1, 0x78 },
      4 /* Bin Number */
  },
  {
    /* AffirmTrust_Networking */
    { 0x0A, 0x81, 0xEC, 0x5A, 0x92, 0x97, 0x77, 0xF1, 0x45, 0x90, 0x4A, 0xF3, 0x8D, 0x5D, 0x50, 0x9F,
      0x66, 0xB5, 0xE2, 0xC5, 0x8F, 0xCD, 0xB5, 0x31, 0x05, 0x8B, 0x0E, 0x17, 0xF3, 0xF0, 0xB4, 0x1B },
      110 /* Bin Number */
  },
  {
    /* Chambers_of_Commerce_Root */
    { 0x0C, 0x25, 0x8A, 0x12, 0xA5, 0x67, 0x4A, 0xEF, 0x25, 0xF2, 0x8B, 0xA7, 0xDC, 0xFA, 0xEC, 0xEE,
      0xA3, 0x48, 0xE5, 0x41, 0xE6, 0xF5, 0xCC, 0x4E, 0xE6, 0x3B, 0x71, 0xB3, 0x61, 0x60, 0x6A, 0xC3 },
      39 /* Bin Number */
  },
  {
    /* COMODO_Certification_Authority */
    { 0x0C, 0x2C, 0xD6, 0x3D, 0xF7, 0x80, 0x6F, 0xA3, 0x99, 0xED, 0xE8, 0x09, 0x11, 0x6B, 0x57, 0x5B,
      0xF8, 0x79, 0x89, 0xF0, 0x65, 0x18, 0xF9, 0x80, 0x8C, 0x86, 0x05, 0x03, 0x17, 0x8B, 0xAF, 0x66 },
      63 /* Bin Number */
  },
  {
    /* Buypass_Class_2_CA_1 */
    { 0x0F, 0x4E, 0x9C, 0xDD, 0x26, 0x4B, 0x02, 0x55, 0x50, 0xD1, 0x70, 0x80, 0x63, 0x40, 0x21, 0x4F,
      0xE9, 0x44, 0x34, 0xC9, 0xB0, 0x2F, 0x69, 0x7E, 0xC7, 0x10, 0xFC, 0x5F, 0xEA, 0xFB, 0x5E, 0x38 },
      80 /* Bin Number */
  },
  {
    /* Class_2_Primary_CA */
    { 0x0F, 0x99, 0x3C, 0x8A, 0xEF, 0x97, 0xBA, 0xAF, 0x56, 0x87, 0x14, 0x0E, 0xD5, 0x9A, 0xD1, 0x82,
      0x1B, 0xB4, 0xAF, 0xAC, 0xF0, 0xAA, 0x9A, 0x58, 0xB5, 0xD5, 0x7A, 0x33, 0x8A, 0x3A, 0xFB, 0xCB },
      51 /* Bin Number */
  },
  {
    /* emSign_Root_CA___C1 */
    { 0x12, 0x56, 0x09, 0xAA, 0x30, 0x1D, 0xA0, 0xA2, 0x49, 0xB9, 0x7A, 0x82, 0x39, 0xCB, 0x6A, 0x34,
      0x21, 0x6F, 0x44, 0xDC, 0xAC, 0x9F, 0x39, 0x54, 0xB1, 0x42, 0x92, 0xF2, 0xE8, 0xC8, 0x60, 0x8F },
      208 /* Bin Number */
  },
  {
    /* Global_Chambersign_Root___2008 */
    { 0x13, 0x63, 0x35, 0x43, 0x93, 0x34, 0xA7, 0x69, 0x80, 0x16, 0xA0, 0xD3, 0x24, 0xDE, 0x72, 0x28,
      0x4E, 0x07, 0x9D, 0x7B, 0x52, 0x20, 0xBB, 0x8F, 0xBD, 0x74, 0x78, 0x16, 0xEE, 0xBE, 0xBA, 0xCA },
      105 /* Bin Number */
  },
  {
    /* OU_Starfield_Class_2_Certification_Authority_O__Starfield_Technologies__Inc___C_US */
    { 0x14, 0x65, 0xFA, 0x20, 0x53, 0x97, 0xB8, 0x76, 0xFA, 0xA6, 0xF0, 0xA9, 0x95, 0x8E, 0x55, 0x90,
      0xE4, 0x0F, 0xCC, 0x7F, 0xAA, 0x4F, 0xB7, 0xC2, 0xC8, 0x67, 0x75, 0x21, 0xFB, 0x5F, 0xB6, 0x58 },
      44 /* Bin Number */
  },
  {
    /* Certplus_Root_CA_G1 */
    { 0x15, 0x2A, 0x40, 0x2B, 0xFC, 0xDF, 0x2C, 0xD5, 0x48, 0x05, 0x4D, 0x22, 0x75, 0xB3, 0x9C, 0x7F,
      0xCA, 0x3E, 0xC0, 0x97, 0x80, 0x78, 0xB0, 0xF0, 0xEA, 0x76, 0xE5, 0x61, 0xA6, 0xC7, 0x43, 0x3E },
      176 /* Bin Number */
  },
  {
    /* GTS_Root_R3 */
    { 0x15, 0xD5, 0xB8, 0x77, 0x46, 0x19, 0xEA, 0x7D, 0x54, 0xCE, 0x1C, 0xA6, 0xD0, 0xB0, 0xC4, 0x03,
      0xE0, 0x37, 0xA9, 0x17, 0xF1, 0x31, 0xE8, 0xA0, 0x4E, 0x1E, 0x6B, 0x7A, 0x71, 0xBA, 0xBC, 0xE5 },
      201 /* Bin Number */
  },
  {
    /* Network_Solutions_Certificate_Authority */
    { 0x15, 0xF0, 0xBA, 0x00, 0xA3, 0xAC, 0x7A, 0xF3, 0xAC, 0x88, 0x4C, 0x07, 0x2B, 0x10, 0x11, 0xA0,
      0x77, 0xBD, 0x77, 0xC0, 0x97, 0xF4, 0x01, 0x64, 0xB2, 0xF8, 0x59, 0x8A, 0xBD, 0x83, 0x86, 0x0C },
      64 /* Bin Number */
  },
  {
    /* Baltimore_CyberTrust_Root */
    { 0x16, 0xAF, 0x57, 0xA9, 0xF6, 0x76, 0xB0, 0xAB, 0x12, 0x60, 0x95, 0xAA, 0x5E, 0xBA, 0xDE, 0xF2,
      0x2A, 0xB3, 0x11, 0x19, 0xD6, 0x44, 0xAC, 0x95, 0xCD, 0x4B, 0x93, 0xDB, 0xF3, 0xF2, 0x6A, 0xEB },
      11 /* Bin Number */
  },
  {
    /* COMODO_ECC_Certification_Authority */
    { 0x17, 0x93, 0x92, 0x7A, 0x06, 0x14, 0x54, 0x97, 0x89, 0xAD, 0xCE, 0x2F, 0x8F, 0x34, 0xF7, 0xF0,
      0xB6, 0x6D, 0x0F, 0x3A, 0xE3, 0xA3, 0xB8, 0x4D, 0x21, 0xEC, 0x15, 0xDB, 0xBA, 0x4F, 0xAD, 0xC7 },
      66 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0x17, 0x9F, 0xBC, 0x14, 0x8A, 0x3D, 0xD0, 0x0F, 0xD2, 0x4E, 0xA1, 0x34, 0x58, 0xCC, 0x43, 0xBF,
      0xA7, 0xF5, 0x9C, 0x81, 0x82, 0xD7, 0x83, 0xA5, 0x13, 0xF6, 0xEB, 0xEC, 0x10, 0x0C, 0x89, 0x24 },
      158 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_3 */
    { 0x18, 0xCE, 0x6C, 0xFE, 0x7B, 0xF1, 0x4E, 0x60, 0xB2, 0xE3, 0x47, 0xB8, 0xDF, 0xE8, 0x68, 0xCB,
      0x31, 0xD0, 0x2E, 0xBB, 0x3A, 0xDA, 0x27, 0x15, 0x69, 0xF5, 0x03, 0x43, 0xB4, 0x6D, 0xB3, 0xA4 },
      185 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_3 */
    { 0x18, 0xF1, 0xFC, 0x7F, 0x20, 0x5D, 0xF8, 0xAD, 0xDD, 0xEB, 0x7F, 0xE0, 0x07, 0xDD, 0x57, 0xE3,
      0xAF, 0x37, 0x5A, 0x9C, 0x4D, 0x8D, 0x73, 0x54, 0x6B, 0xF4, 0xF1, 0xFE, 0xD1, 0xE1, 0x8D, 0x35 },
      33 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_2 */
    { 0x1B, 0xA5, 0xB2, 0xAA, 0x8C, 0x65, 0x40, 0x1A, 0x82, 0x96, 0x01, 0x18, 0xF8, 0x0B, 0xEC, 0x4F,
      0x62, 0x30, 0x4D, 0x83, 0xCE, 0xC4, 0x71, 0x3A, 0x19, 0xC3, 0x9C, 0x01, 0x1E, 0xA4, 0x6D, 0xB4 },
      184 /* Bin Number */
  },
  {
    /* China_Internet_Network_Information_Center_EV_Certificates_Root */
    { 0x1C, 0x01, 0xC6, 0xF4, 0xDB, 0xB2, 0xFE, 0xFC, 0x22, 0x55, 0x8B, 0x2B, 0xCA, 0x32, 0x56, 0x3F,
      0x49, 0x84, 0x4A, 0xCF, 0xC3, 0x2B, 0x7B, 0xE4, 0xB0, 0xFF, 0x59, 0x9F, 0x9E, 0x8C, 0x7A, 0xF7 },
      133 /* Bin Number */
  },
  {
    /* Swisscom_Root_CA_1 */
    { 0x21, 0xDB, 0x20, 0x12, 0x36, 0x60, 0xBB, 0x2E, 0xD4, 0x18, 0x20, 0x5D, 0xA1, 0x1E, 0xE7, 0xA8,
      0x5A, 0x65, 0xE2, 0xBC, 0x6E, 0x55, 0xB5, 0xAF, 0x7E, 0x78, 0x99, 0xC8, 0xA2, 0x66, 0xD9, 0x2E },
      47 /* Bin Number */
  },
  {
    /* SSL_com_EV_Root_Certification_Authority_ECC */
    { 0x22, 0xA2, 0xC1, 0xF7, 0xBD, 0xED, 0x70, 0x4C, 0xC1, 0xE7, 0x01, 0xB5, 0xF4, 0x08, 0xC3, 0x10,
      0x88, 0x0F, 0xE9, 0x56, 0xB5, 0xDE, 0x2A, 0x4A, 0x44, 0xF9, 0x9C, 0x87, 0x3A, 0x25, 0xA7, 0xC8 },
      196 /* Bin Number */
  },
  {
    /* VeriSign_Universal_Root_Certification_Authority */
    { 0x23, 0x99, 0x56, 0x11, 0x27, 0xA5, 0x71, 0x25, 0xDE, 0x8C, 0xEF, 0xEA, 0x61, 0x0D, 0xDF, 0x2F,
      0xA0, 0x78, 0xB5, 0xC8, 0x06, 0x7F, 0x4E, 0x82, 0x82, 0x90, 0xBF, 0xB8, 0x60, 0xE8, 0x4B, 0x3C },
      90 /* Bin Number */
  },
  {
    /* Izenpe_com */
    { 0x25, 0x30, 0xCC, 0x8E, 0x98, 0x32, 0x15, 0x02, 0xBA, 0xD9, 0x6F, 0x9B, 0x1F, 0xBA, 0x1B, 0x09,
      0x9E, 0x2D, 0x29, 0x9E, 0x0F, 0x45, 0x48, 0xBB, 0x91, 0x4F, 0x36, 0x3B, 0xC0, 0xD4, 0x53, 0x1F },
      103 /* Bin Number */
  },
  {
    /* OpenTrust_Root_CA_G2 */
    { 0x27, 0x99, 0x58, 0x29, 0xFE, 0x6A, 0x75, 0x15, 0xC1, 0xBF, 0xE8, 0x48, 0xF9, 0xC4, 0x76, 0x1D,
      0xB1, 0x6C, 0x22, 0x59, 0x29, 0x25, 0x7B, 0xF4, 0x0D, 0x08, 0x94, 0xF2, 0x9E, 0xA8, 0xBA, 0xF2 },
      179 /* Bin Number */
  },
  {
    /* GTS_Root_R1 */
    { 0x2A, 0x57, 0x54, 0x71, 0xE3, 0x13, 0x40, 0xBC, 0x21, 0x58, 0x1C, 0xBD, 0x2C, 0xF1, 0x3E, 0x15,
      0x84, 0x63, 0x20, 0x3E, 0xCE, 0x94, 0xBC, 0xF9, 0xD3, 0xCC, 0x19, 0x6B, 0xF0, 0x9A, 0x54, 0x72 },
      199 /* Bin Number */
  },
  {
    /* Certinomis___Root_CA */
    { 0x2A, 0x99, 0xF5, 0xBC, 0x11, 0x74, 0xB7, 0x3C, 0xBB, 0x1D, 0x62, 0x08, 0x84, 0xE0, 0x1C, 0x34,
      0xE5, 0x1C, 0xCB, 0x39, 0x78, 0xDA, 0x12, 0x5F, 0x0E, 0x33, 0x26, 0x88, 0x83, 0xBF, 0x41, 0x58 },
      168 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0x2C, 0xAB, 0xEA, 0xFE, 0x37, 0xD0, 0x6C, 0xA2, 0x2A, 0xBA, 0x73, 0x91, 0xC0, 0x03, 0x3D, 0x25,
      0x98, 0x29, 0x52, 0xC4, 0x53, 0x64, 0x73, 0x49, 0x76, 0x3A, 0x3A, 0xB5, 0xAD, 0x6C, 0xCF, 0x69 },
      197 /* Bin Number */
  },
  {
    /* Starfield_Root_Certificate_Authority___G2 */
    { 0x2C, 0xE1, 0xCB, 0x0B, 0xF9, 0xD2, 0xF9, 0xE1, 0x02, 0x99, 0x3F, 0xBE, 0x21, 0x51, 0x52, 0xC3,
      0xB2, 0xDD, 0x0C, 0xAB, 0xDE, 0x1C, 0x68, 0xE5, 0x31, 0x9B, 0x83, 0x91, 0x54, 0xDB, 0xB7, 0xF5 },
      107 /* Bin Number */
  },
  {
    /* OU_ApplicationCA_O_Japanese_Government_C_JP */
    { 0x2D, 0x47, 0x43, 0x7D, 0xE1, 0x79, 0x51, 0x21, 0x5A, 0x12, 0xF3, 0xC5, 0x8E, 0x51, 0xC7, 0x29,
      0xA5, 0x80, 0x26, 0xEF, 0x1F, 0xCC, 0x0A, 0x5F, 0xB3, 0xD9, 0xDC, 0x01, 0x2F, 0x60, 0x0D, 0x19 },
      85 /* Bin Number */
  },
  {
    /* TunTrust_Root_CA */
    { 0x2E, 0x44, 0x10, 0x2A, 0xB5, 0x8C, 0xB8, 0x54, 0x19, 0x45, 0x1C, 0x8E, 0x19, 0xD9, 0xAC, 0xF3,
      0x66, 0x2C, 0xAF, 0xBC, 0x61, 0x4B, 0x6A, 0x53, 0x96, 0x0A, 0x30, 0xF7, 0xD0, 0xE2, 0xEB, 0x41 },
      227 /* Bin Number */
  },
  {
    /* SSL_com_EV_Root_Certification_Authority_RSA_R2 */
    { 0x2E, 0x7B, 0xF1, 0x6C, 0xC2, 0x24, 0x85, 0xA7, 0xBB, 0xE2, 0xAA, 0x86, 0x96, 0x75, 0x07, 0x61,
      0xB0, 0xAE, 0x39, 0xBE, 0x3B, 0x2F, 0xE9, 0xD0, 0xCC, 0x6D, 0x4E, 0xF7, 0x34, 0x91, 0x42, 0x5C },
      195 /* Bin Number */
  },
  {
    /* IdenTrust_Public_Sector_Root_CA_1 */
    { 0x30, 0xD0, 0x89, 0x5A, 0x9A, 0x44, 0x8A, 0x26, 0x20, 0x91, 0x63, 0x55, 0x22, 0xD1, 0xF5, 0x20,
      0x10, 0xB5, 0x86, 0x7A, 0xCA, 0xE1, 0x2C, 0x78, 0xEF, 0x95, 0x8F, 0xD4, 0xF4, 0x38, 0x9F, 0x2F },
      162 /* Bin Number */
  },
  {
    /* vTrus_ECC_Root_CA */
    { 0x30, 0xFB, 0xBA, 0x2C, 0x32, 0x23, 0x8E, 0x2A, 0x98, 0x54, 0x7A, 0xF9, 0x79, 0x31, 0xE5, 0x50,
      0x42, 0x8B, 0x9B, 0x3F, 0x1C, 0x8E, 0xEB, 0x66, 0x33, 0xDC, 0xFA, 0x86, 0xC5, 0xB2, 0x7D, 0xD3 },
      231 /* Bin Number */
  },
  {
    /* DigiCert_Global_Root_G3 */
    { 0x31, 0xAD, 0x66, 0x48, 0xF8, 0x10, 0x41, 0x38, 0xC7, 0x38, 0xF3, 0x9E, 0xA4, 0x32, 0x01, 0x33,
      0x39, 0x3E, 0x3A, 0x18, 0xCC, 0x02, 0x29, 0x6E, 0xF9, 0x7C, 0x2A, 0xC9, 0xEF, 0x67, 0x31, 0xD0 },
      150 /* Bin Number */
  },
  {
    /* Microsec_e_Szigno_Root_CA */
    { 0x32, 0x7A, 0x3D, 0x76, 0x1A, 0xBA, 0xDE, 0xA0, 0x34, 0xEB, 0x99, 0x84, 0x06, 0x27, 0x5C, 0xB1,
      0xA4, 0x77, 0x6E, 0xFD, 0xAE, 0x2F, 0xDF, 0x6D, 0x01, 0x68, 0xEA, 0x1C, 0x4F, 0x55, 0x67, 0xD0 },
      70 /* Bin Number */
  },
  {
    /* SSL_com_Root_Certification_Authority_ECC */
    { 0x34, 0x17, 0xBB, 0x06, 0xCC, 0x60, 0x07, 0xDA, 0x1B, 0x96, 0x1C, 0x92, 0x0B, 0x8A, 0xB4, 0xCE,
      0x3F, 0xAD, 0x82, 0x0E, 0x4A, 0xA3, 0x0B, 0x9A, 0xCB, 0xC4, 0xA7, 0x4E, 0xBD, 0xCE, 0xBC, 0x65 },
      194 /* Bin Number */
  },
  {
    /* GTS_Root_R4 */
    { 0x34, 0x9D, 0xFA, 0x40, 0x58, 0xC5, 0xE2, 0x63, 0x12, 0x3B, 0x39, 0x8A, 0xE7, 0x95, 0x57, 0x3C,
      0x4E, 0x13, 0x13, 0xC8, 0x3F, 0xE6, 0x8F, 0x93, 0x55, 0x6C, 0xD5, 0xE8, 0x03, 0x1B, 0x3C, 0x7D },
      239 /* Bin Number */
  },
  {
    /* GTS_Root_R3 */
    { 0x34, 0xD8, 0xA7, 0x3E, 0xE2, 0x08, 0xD9, 0xBC, 0xDB, 0x0D, 0x95, 0x65, 0x20, 0x93, 0x4B, 0x4E,
      0x40, 0xE6, 0x94, 0x82, 0x59, 0x6E, 0x8B, 0x6F, 0x73, 0xC8, 0x42, 0x6B, 0x01, 0x0A, 0x6F, 0x48 },
      238 /* Bin Number */
  },
  {
    /* Microsoft_ECC_Root_Certificate_Authority_2017 */
    { 0x35, 0x8D, 0xF3, 0x9D, 0x76, 0x4A, 0xF9, 0xE1, 0xB7, 0x66, 0xE9, 0xC9, 0x72, 0xDF, 0x35, 0x2E,
      0xE1, 0x5C, 0xFA, 0xC2, 0x27, 0xAF, 0x6A, 0xD1, 0xD7, 0x0E, 0x8E, 0x4A, 0x6E, 0xDC, 0xBA, 0x02 },
      212 /* Bin Number */
  },
  {
    /* EBG_Elektronik_Sertifika_Hizmet_Sa_lay_c_s_ */
    { 0x35, 0xAE, 0x5B, 0xDD, 0xD8, 0xF7, 0xAE, 0x63, 0x5C, 0xFF, 0xBA, 0x56, 0x82, 0xA8, 0xF0, 0x0B,
      0x95, 0xF4, 0x84, 0x62, 0xC7, 0x10, 0x8E, 0xE9, 0xA0, 0xE5, 0x29, 0x2B, 0x07, 0x4A, 0xAF, 0xB2 },
      82 /* Bin Number */
  },
  {
    /* GeoTrust_Primary_Certification_Authority */
    { 0x37, 0xD5, 0x10, 0x06, 0xC5, 0x12, 0xEA, 0xAB, 0x62, 0x64, 0x21, 0xF1, 0xEC, 0x8C, 0x92, 0x01,
      0x3F, 0xC5, 0xF8, 0x2A, 0xE9, 0x8E, 0xE5, 0x33, 0xEB, 0x46, 0x19, 0xB8, 0xDE, 0xB4, 0xD0, 0x6C },
      58 /* Bin Number */
  },
  {
    /* Staat_der_Nederlanden_Root_CA___G3 */
    { 0x3C, 0x4F, 0xB0, 0xB9, 0x5A, 0xB8, 0xB3, 0x00, 0x32, 0xF4, 0x32, 0xB8, 0x6F, 0x53, 0x5F, 0xE1,
      0x72, 0xC1, 0x85, 0xD0, 0xFD, 0x39, 0x86, 0x58, 0x37, 0xCF, 0x36, 0x18, 0x7F, 0xA6, 0xF4, 0x28 },
      159 /* Bin Number */
  },
  {
    /* Microsec_e_Szigno_Root_CA_2009 */
    { 0x3C, 0x5F, 0x81, 0xFE, 0xA5, 0xFA, 0xB8, 0x2C, 0x64, 0xBF, 0xA2, 0xEA, 0xEC, 0xAF, 0xCD, 0xE8,
      0xE0, 0x77, 0xFC, 0x86, 0x20, 0xA7, 0xCA, 0xE5, 0x37, 0x16, 0x3D, 0xF3, 0x6E, 0xDB, 0xF3, 0x78 },
      99 /* Bin Number */
  },
  {
    /* PSCProcert */
    { 0x3C, 0xFC, 0x3C, 0x14, 0xD1, 0xF6, 0x84, 0xFF, 0x17, 0xE3, 0x8C, 0x43, 0xCA, 0x44, 0x0C, 0x00,
      0xB9, 0x67, 0xEC, 0x93, 0x3E, 0x8B, 0xFE, 0x06, 0x4C, 0xA1, 0xD7, 0x2C, 0x90, 0xF2, 0xAD, 0xB0 },
      132 /* Bin Number */
  },
  {
    /* EE_Certification_Centre_Root_CA */
    { 0x3E, 0x84, 0xBA, 0x43, 0x42, 0x90, 0x85, 0x16, 0xE7, 0x75, 0x73, 0xC0, 0x99, 0x2F, 0x09, 0x79,
      0xCA, 0x08, 0x4E, 0x46, 0x85, 0x68, 0x1F, 0xF1, 0x95, 0xCC, 0xBA, 0x8A, 0x22, 0x9B, 0x8A, 0x76 },
      128 /* Bin Number */
  },
  {
    /* DigiCert_Assured_ID_Root_CA */
    { 0x3E, 0x90, 0x99, 0xB5, 0x01, 0x5E, 0x8F, 0x48, 0x6C, 0x00, 0xBC, 0xEA, 0x9D, 0x11, 0x1E, 0xE7,
      0x21, 0xFA, 0xBA, 0x35, 0x5A, 0x89, 0xBC, 0xF1, 0xDF, 0x69, 0x56, 0x1E, 0x3D, 0xC6, 0x32, 0x5C },
      48 /* Bin Number */
  },
  {
    /* Trusted_Certificate_Services */
    { 0x3F, 0x06, 0xE5, 0x56, 0x81, 0xD4, 0x96, 0xF5, 0xBE, 0x16, 0x9E, 0xB5, 0x38, 0x9F, 0x9F, 0x2B,
      0x8F, 0xF6, 0x1E, 0x17, 0x08, 0xDF, 0x68, 0x81, 0x72, 0x48, 0x49, 0xCD, 0x5D, 0x27, 0xCB, 0x69 },
      30 /* Bin Number */
  },
  {
    /* HARICA_TLS_ECC_Root_CA_2021 */
    { 0x3F, 0x99, 0xCC, 0x47, 0x4A, 0xCF, 0xCE, 0x4D, 0xFE, 0xD5, 0x87, 0x94, 0x66, 0x5E, 0x47, 0x8D,
      0x15, 0x47, 0x73, 0x9F, 0x2E, 0x78, 0x0F, 0x1B, 0xB4, 0xCA, 0x9B, 0x13, 0x30, 0x97, 0xD4, 0x01 },
      229 /* Bin Number */
  },
  {
    /* emSign_Root_CA___G1 */
    { 0x40, 0xF6, 0xAF, 0x03, 0x46, 0xA9, 0x9A, 0xA1, 0xCD, 0x1D, 0x55, 0x5A, 0x4E, 0x9C, 0xCE, 0x62,
      0xC7, 0xF9, 0x63, 0x46, 0x03, 0xEE, 0x40, 0x66, 0x15, 0x83, 0x3D, 0xC8, 0xC8, 0xD0, 0x03, 0x67 },
      206 /* Bin Number */
  },
  {
    /* OISTE_WISeKey_Global_Root_GA_CA */
    { 0x41, 0xC9, 0x23, 0x86, 0x6A, 0xB4, 0xCA, 0xD6, 0xB7, 0xAD, 0x57, 0x80, 0x81, 0x58, 0x2E, 0x02,
      0x07, 0x97, 0xA6, 0xCB, 0xDF, 0x4F, 0xFF, 0x78, 0xCE, 0x83, 0x96, 0xB3, 0x89, 0x37, 0xD7, 0xF5 },
      69 /* Bin Number */
  },
  {
    /* Secure_Global_CA */
    { 0x42, 0x00, 0xF5, 0x04, 0x3A, 0xC8, 0x59, 0x0E, 0xBB, 0x52, 0x7D, 0x20, 0x9E, 0xD1, 0x50, 0x30,
      0x29, 0xFB, 0xCB, 0xD4, 0x1C, 0xA1, 0xB5, 0x06, 0xEC, 0x27, 0xF1, 0x5A, 0xDE, 0x7D, 0xAC, 0x69 },
      62 /* Bin Number */
  },
  {
    /* DigiCert_Global_Root_CA */
    { 0x43, 0x48, 0xA0, 0xE9, 0x44, 0x4C, 0x78, 0xCB, 0x26, 0x5E, 0x05, 0x8D, 0x5E, 0x89, 0x44, 0xB4,
      0xD8, 0x4F, 0x96, 0x62, 0xBD, 0x26, 0xDB, 0x25, 0x7F, 0x89, 0x34, 0xA4, 0x43, 0xC7, 0x01, 0x61 },
      49 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority___G2 */
    { 0x43, 0xDF, 0x57, 0x74, 0xB0, 0x3E, 0x7F, 0xEF, 0x5F, 0xE4, 0x0D, 0x93, 0x1A, 0x7B, 0xED, 0xF1,
      0xBB, 0x2E, 0x6B, 0x42, 0x73, 0x8C, 0x4E, 0x6D, 0x38, 0x41, 0x10, 0x3D, 0x3A, 0xA7, 0xF3, 0x39 },
      163 /* Bin Number */
  },
  {
    /* T_RKTRUST_Elektronik_Sertifika_Hizmet_Sa_lay_c_s_ */
    { 0x44, 0x04, 0xE3, 0x3B, 0x5E, 0x14, 0x0D, 0xCF, 0x99, 0x80, 0x51, 0xFD, 0xFC, 0x80, 0x28, 0xC7,
      0xC8, 0x16, 0x15, 0xC5, 0xEE, 0x73, 0x7B, 0x11, 0x1B, 0x58, 0x82, 0x33, 0xA9, 0xB5, 0x35, 0xA0 },
      54 /* Bin Number */
  },
  {
    /* Hellenic_Academic_and_Research_Institutions_ECC_RootCA_2015 */
    { 0x44, 0xB5, 0x45, 0xAA, 0x8A, 0x25, 0xE6, 0x5A, 0x73, 0xCA, 0x15, 0xDC, 0x27, 0xFC, 0x36, 0xD2,
      0x4C, 0x1C, 0xB9, 0x95, 0x3A, 0x06, 0x65, 0x39, 0xB1, 0x15, 0x82, 0xDC, 0x48, 0x7B, 0x48, 0x33 },
      175 /* Bin Number */
  },
  {
    /* Go_Daddy_Root_Certificate_Authority___G2 */
    { 0x45, 0x14, 0x0B, 0x32, 0x47, 0xEB, 0x9C, 0xC8, 0xC5, 0xB4, 0xF0, 0xD7, 0xB5, 0x30, 0x91, 0xF7,
      0x32, 0x92, 0x08, 0x9E, 0x6E, 0x5A, 0x63, 0xE2, 0x74, 0x9D, 0xD3, 0xAC, 0xA9, 0x19, 0x8E, 0xDA },
      106 /* Bin Number */
  },
  {
    /* TUBITAK_Kamu_SM_SSL_Kok_Sertifikasi___Surum_1 */
    { 0x46, 0xED, 0xC3, 0x68, 0x90, 0x46, 0xD5, 0x3A, 0x45, 0x3F, 0xB3, 0x10, 0x4A, 0xB8, 0x0D, 0xCA,
      0xEC, 0x65, 0x8B, 0x26, 0x60, 0xEA, 0x16, 0x29, 0xDD, 0x7E, 0x86, 0x79, 0x90, 0x64, 0x87, 0x16 },
      188 /* Bin Number */
  },
  {
    /* T_RKTRUST_Elektronik_Sertifika_Hizmet_Sa_lay_c_s__H5 */
    { 0x49, 0x35, 0x1B, 0x90, 0x34, 0x44, 0xC1, 0x85, 0xCC, 0xDC, 0x5C, 0x69, 0x3D, 0x24, 0xD8, 0x55,
      0x5C, 0xB2, 0x08, 0xD6, 0xA8, 0x14, 0x13, 0x07, 0x69, 0x9F, 0x4A, 0xF0, 0x63, 0x19, 0x9D, 0x78 },
      166 /* Bin Number */
  },
  {
    /* D_TRUST_Root_Class_3_CA_2_2009 */
    { 0x49, 0xE7, 0xA4, 0x42, 0xAC, 0xF0, 0xEA, 0x62, 0x87, 0x05, 0x00, 0x54, 0xB5, 0x25, 0x64, 0xB6,
      0x50, 0xE4, 0xF4, 0x9E, 0x42, 0xE3, 0x48, 0xD6, 0xAA, 0x38, 0xE0, 0x39, 0xE9, 0x57, 0xB1, 0xC1 },
      130 /* Bin Number */
  },
  {
    /* thawte_Primary_Root_CA___G3 */
    { 0x4B, 0x03, 0xF4, 0x58, 0x07, 0xAD, 0x70, 0xF2, 0x1B, 0xFC, 0x2C, 0xAE, 0x71, 0xC9, 0xFD, 0xE4,
      0x60, 0x4C, 0x06, 0x4C, 0xF5, 0xFF, 0xB6, 0x86, 0xBA, 0xE5, 0xDB, 0xAA, 0xD7, 0xFD, 0xD3, 0x4C },
      88 /* Bin Number */
  },
  {
    /* Certification_Authority_of_WoSign */
    { 0x4B, 0x22, 0xD5, 0xA6, 0xAE, 0xC9, 0x9F, 0x3C, 0xDB, 0x79, 0xAA, 0x5E, 0xC0, 0x68, 0x38, 0x47,
      0x9C, 0xD5, 0xEC, 0xBA, 0x71, 0x64, 0xF7, 0xF2, 0x2D, 0xC1, 0xD6, 0x5F, 0x63, 0xD8, 0x57, 0x08 },
      152 /* Bin Number */
  },
  {
    /* Staat_der_Nederlanden_EV_Root_CA */
    { 0x4D, 0x24, 0x91, 0x41, 0x4C, 0xFE, 0x95, 0x67, 0x46, 0xEC, 0x4C, 0xEF, 0xA6, 0xCF, 0x6F, 0x72,
      0xE2, 0x8A, 0x13, 0x29, 0x43, 0x2F, 0x9D, 0x8A, 0x90, 0x7A, 0xC4, 0xCB, 0x5D, 0xAD, 0xC1, 0x5A },
      160 /* Bin Number */
  },
  {
    /* GlobalSign_Root_R46 */
    { 0x4F, 0xA3, 0x12, 0x6D, 0x8D, 0x3A, 0x11, 0xD1, 0xC4, 0x85, 0x5A, 0x4F, 0x80, 0x7C, 0xBA, 0xD6,
      0xCF, 0x91, 0x9D, 0x3A, 0x5A, 0x88, 0xB0, 0x3B, 0xEA, 0x2C, 0x63, 0x72, 0xD9, 0x3C, 0x40, 0xC9 },
      221 /* Bin Number */
  },
  {
    /* USERTrust_ECC_Certification_Authority */
    { 0x4F, 0xF4, 0x60, 0xD5, 0x4B, 0x9C, 0x86, 0xDA, 0xBF, 0xBC, 0xFC, 0x57, 0x12, 0xE0, 0x40, 0x0D,
      0x2B, 0xED, 0x3F, 0xBC, 0x4D, 0x4F, 0xBD, 0xAA, 0x86, 0xE0, 0x6A, 0xDC, 0xD2, 0xA9, 0xAD, 0x7A },
      156 /* Bin Number */
  },
  {
    /* ComSign_Secured_CA */
    { 0x50, 0x79, 0x41, 0xC7, 0x44, 0x60, 0xA0, 0xB4, 0x70, 0x86, 0x22, 0x0D, 0x4E, 0x99, 0x32, 0x57,
      0x2A, 0xB5, 0xD1, 0xB5, 0xBB, 0xCB, 0x89, 0x80, 0xAB, 0x1C, 0xB1, 0x76, 0x51, 0xA8, 0x44, 0xD2 },
      76 /* Bin Number */
  },
  {
    /* OU_Security_Communication_RootCA2_O__SECOM_Trust_Systems_CO__LTD___C_JP */
    { 0x51, 0x3B, 0x2C, 0xEC, 0xB8, 0x10, 0xD4, 0xCD, 0xE5, 0xDD, 0x85, 0x39, 0x1A, 0xDF, 0xC6, 0xC2,
      0xDD, 0x60, 0xD8, 0x7B, 0xB7, 0x36, 0xD2, 0xB5, 0x21, 0x48, 0x4A, 0xA4, 0x7A, 0x0E, 0xBE, 0xF6 },
      118 /* Bin Number */
  },
  {
    /* COMODO_RSA_Certification_Authority */
    { 0x52, 0xF0, 0xE1, 0xC4, 0xE5, 0x8E, 0xC6, 0x29, 0x29, 0x1B, 0x60, 0x31, 0x7F, 0x07, 0x46, 0x71,
      0xB8, 0x5D, 0x7E, 0xA8, 0x0D, 0x5B, 0x07, 0x27, 0x34, 0x63, 0x53, 0x4B, 0x32, 0xB4, 0x02, 0x34 },
      154 /* Bin Number */
  },
  {
    /* LuxTrust_Global_Root_2 */
    { 0x54, 0x45, 0x5F, 0x71, 0x29, 0xC2, 0x0B, 0x14, 0x47, 0xC4, 0x18, 0xF9, 0x97, 0x16, 0x8F, 0x24,
      0xC5, 0x8F, 0xC5, 0x02, 0x3B, 0xF5, 0xDA, 0x5B, 0xE2, 0xEB, 0x6E, 0x1D, 0xD8, 0x90, 0x2E, 0xD5 },
      187 /* Bin Number */
  },
  {
    /* DigiCert_Trusted_Root_G4 */
    { 0x55, 0x2F, 0x7B, 0xDC, 0xF1, 0xA7, 0xAF, 0x9E, 0x6C, 0xE6, 0x72, 0x01, 0x7F, 0x4F, 0x12, 0xAB,
      0xF7, 0x72, 0x40, 0xC7, 0x8E, 0x76, 0x1A, 0xC2, 0x03, 0xD1, 0xD9, 0xD2, 0x0A, 0xC8, 0x99, 0x88 },
      151 /* Bin Number */
  },
  {
    /* AC_RAIZ_FNMT_RCM_SERVIDORES_SEGUROS */
    { 0x55, 0x41, 0x53, 0xB1, 0x3D, 0x2C, 0xF9, 0xDD, 0xB7, 0x53, 0xBF, 0xBE, 0x1A, 0x4E, 0x0A, 0xE0,
      0x8D, 0x0A, 0xA4, 0x18, 0x70, 0x58, 0xFE, 0x60, 0xA2, 0xB8, 0x62, 0xB2, 0xE4, 0xB8, 0x7B, 0xCB },
      220 /* Bin Number */
  },
  {
    /* Trustwave_Global_ECC_P384_Certification_Authority */
    { 0x55, 0x90, 0x38, 0x59, 0xC8, 0xC0, 0xC3, 0xEB, 0xB8, 0x75, 0x9E, 0xCE, 0x4E, 0x25, 0x57, 0x22,
      0x5F, 0xF5, 0x75, 0x8B, 0xBD, 0x38, 0xEB, 0xD4, 0x82, 0x76, 0x60, 0x1E, 0x1B, 0xD5, 0x80, 0x97 },
      218 /* Bin Number */
  },
  {
    /* Actalis_Authentication_Root_CA */
    { 0x55, 0x92, 0x60, 0x84, 0xEC, 0x96, 0x3A, 0x64, 0xB9, 0x6E, 0x2A, 0xBE, 0x01, 0xCE, 0x0B, 0xA8,
      0x6A, 0x64, 0xFB, 0xFE, 0xBC, 0xC7, 0xAA, 0xB5, 0xAF, 0xC1, 0x55, 0xB3, 0x7F, 0xD7, 0x60, 0x66 },
      121 /* Bin Number */
  },
  {
    /* Starfield_Services_Root_Certificate_Authority___G2 */
    { 0x56, 0x8D, 0x69, 0x05, 0xA2, 0xC8, 0x87, 0x08, 0xA4, 0xB3, 0x02, 0x51, 0x90, 0xED, 0xCF, 0xED,
      0xB1, 0x97, 0x4A, 0x60, 0x6A, 0x13, 0xC6, 0xE5, 0x29, 0x0F, 0xCB, 0x2A, 0xE6, 0x3E, 0xDA, 0xB5 },
      108 /* Bin Number */
  },
  {
    /* OpenTrust_Root_CA_G1 */
    { 0x56, 0xC7, 0x71, 0x28, 0xD9, 0x8C, 0x18, 0xD9, 0x1B, 0x4C, 0xFD, 0xFF, 0xBC, 0x25, 0xEE, 0x91,
      0x03, 0xD4, 0x75, 0x8E, 0xA2, 0xAB, 0xAD, 0x82, 0x6A, 0x90, 0xF3, 0x45, 0x7D, 0x46, 0x0E, 0xB4 },
      178 /* Bin Number */
  },
  {
    /* Autoridad_de_Certificacion_Firmaprofesional_CIF_A62634068 */
    { 0x57, 0xDE, 0x05, 0x83, 0xEF, 0xD2, 0xB2, 0x6E, 0x03, 0x61, 0xDA, 0x99, 0xDA, 0x9D, 0xF4, 0x64,
      0x8D, 0xEF, 0x7E, 0xE8, 0x44, 0x1C, 0x3B, 0x72, 0x8A, 0xFA, 0x9B, 0xCD, 0xE0, 0xF9, 0xB2, 0x6A },
      230 /* Bin Number */
  },
  {
    /* TWCA_Global_Root_CA */
    { 0x59, 0x76, 0x90, 0x07, 0xF7, 0x68, 0x5D, 0x0F, 0xCD, 0x50, 0x87, 0x2F, 0x9F, 0x95, 0xD5, 0x75,
      0x5A, 0x5B, 0x2B, 0x45, 0x7D, 0x81, 0xF3, 0x69, 0x2B, 0x61, 0x0A, 0x98, 0x67, 0x2F, 0x0E, 0x1B },
      139 /* Bin Number */
  },
  {
    /* Hongkong_Post_Root_CA_3 */
    { 0x5A, 0x2F, 0xC0, 0x3F, 0x0C, 0x83, 0xB0, 0x90, 0xBB, 0xFA, 0x40, 0x60, 0x4B, 0x09, 0x88, 0x44,
      0x6C, 0x76, 0x36, 0x18, 0x3D, 0xF9, 0x84, 0x6E, 0x17, 0x10, 0x1A, 0x44, 0x7F, 0xB8, 0xEF, 0xD6 },
      210 /* Bin Number */
  },
  {
    /* TrustCor_ECA_1 */
    { 0x5A, 0x88, 0x5D, 0xB1, 0x9C, 0x01, 0xD9, 0x12, 0xC5, 0x75, 0x93, 0x88, 0x93, 0x8C, 0xAF, 0xBB,
      0xDF, 0x03, 0x1A, 0xB2, 0xD4, 0x8E, 0x91, 0xEE, 0x15, 0x58, 0x9B, 0x42, 0x97, 0x1D, 0x03, 0x9C },
      192 /* Bin Number */
  },
  {
    /* Certum_Trusted_Network_CA */
    { 0x5C, 0x58, 0x46, 0x8D, 0x55, 0xF5, 0x8E, 0x49, 0x7E, 0x74, 0x39, 0x82, 0xD2, 0xB5, 0x00, 0x10,
      0xB6, 0xD1, 0x65, 0x37, 0x4A, 0xCF, 0x83, 0xA7, 0xD4, 0xA3, 0x2D, 0xB7, 0x68, 0xC4, 0x40, 0x8E },
      113 /* Bin Number */
  },
  {
    /* CFCA_EV_ROOT */
    { 0x5C, 0xC3, 0xD7, 0x8E, 0x4E, 0x1D, 0x5E, 0x45, 0x54, 0x7A, 0x04, 0xE6, 0x87, 0x3E, 0x64, 0xF9,
      0x0C, 0xF9, 0x53, 0x6D, 0x1C, 0xCC, 0x2E, 0xF8, 0x00, 0xF3, 0x55, 0xC4, 0xC5, 0xFD, 0x70, 0xFD },
      165 /* Bin Number */
  },
  {
    /* IdenTrust_Commercial_Root_CA_1 */
    { 0x5D, 0x56, 0x49, 0x9B, 0xE4, 0xD2, 0xE0, 0x8B, 0xCF, 0xCA, 0xD0, 0x8A, 0x3E, 0x38, 0x72, 0x3D,
      0x50, 0x50, 0x3B, 0xDE, 0x70, 0x69, 0x48, 0xE4, 0x2F, 0x55, 0x60, 0x30, 0x19, 0xE5, 0x28, 0xAE },
      161 /* Bin Number */
  },
  {
    /* GeoTrust_Primary_Certification_Authority___G2 */
    { 0x5E, 0xDB, 0x7A, 0xC4, 0x3B, 0x82, 0xA0, 0x6A, 0x87, 0x61, 0xE8, 0xD7, 0xBE, 0x49, 0x79, 0xEB,
      0xF2, 0x61, 0x1F, 0x7D, 0xD7, 0x9B, 0xF9, 0x1C, 0x1C, 0x6B, 0x56, 0x6A, 0x21, 0x9E, 0xD7, 0x66 },
      89 /* Bin Number */
  },
  {
    /* Equifax_Secure_Global_eBusiness_CA_1 */
    { 0x5F, 0x0B, 0x62, 0xEA, 0xB5, 0xE3, 0x53, 0xEA, 0x65, 0x21, 0x65, 0x16, 0x58, 0xFB, 0xB6, 0x53,
      0x59, 0xF4, 0x43, 0x28, 0x0A, 0x4A, 0xFB, 0xD1, 0x04, 0xD7, 0x7D, 0x10, 0xF9, 0xF0, 0x4C, 0x07 },
      12 /* Bin Number */
  },
  {
    /* SwissSign_Gold_CA___G2 */
    { 0x62, 0xDD, 0x0B, 0xE9, 0xB9, 0xF5, 0x0A, 0x16, 0x3E, 0xA0, 0xF8, 0xE7, 0x5C, 0x05, 0x3B, 0x1E,
      0xCA, 0x57, 0xEA, 0x55, 0xC8, 0x68, 0x8F, 0x64, 0x7C, 0x68, 0x81, 0xF2, 0xC8, 0x35, 0x7B, 0x95 },
      56 /* Bin Number */
  },
  {
    /* OU_certSIGN_ROOT_CA_G2_O_CERTSIGN_SA_C_RO */
    { 0x65, 0x7C, 0xFE, 0x2F, 0xA7, 0x3F, 0xAA, 0x38, 0x46, 0x25, 0x71, 0xF3, 0x32, 0xA2, 0x36, 0x3A,
      0x46, 0xFC, 0xE7, 0x02, 0x09, 0x51, 0x71, 0x07, 0x02, 0xCD, 0xFB, 0xB6, 0xEE, 0xDA, 0x33, 0x05 },
      215 /* Bin Number */
  },
  {
    /* Staat_der_Nederlanden_Root_CA___G2 */
    { 0x66, 0x8C, 0x83, 0x94, 0x7D, 0xA6, 0x3B, 0x72, 0x4B, 0xEC, 0xE1, 0x74, 0x3C, 0x31, 0xA0, 0xE6,
      0xAE, 0xD0, 0xDB, 0x8E, 0xC5, 0xB3, 0x1B, 0xE3, 0x77, 0xBB, 0x78, 0x4F, 0x91, 0xB6, 0x71, 0x6F },
      93 /* Bin Number */
  },
  {
    /* AddTrust_External_CA_Root */
    { 0x68, 0x7F, 0xA4, 0x51, 0x38, 0x22, 0x78, 0xFF, 0xF0, 0xC8, 0xB1, 0x1F, 0x8D, 0x43, 0xD5, 0x76,
      0x67, 0x1C, 0x6E, 0xB2, 0xBC, 0xEA, 0xB4, 0x13, 0xFB, 0x83, 0xD9, 0x65, 0xD0, 0x6D, 0x2F, 0xF2 },
      15 /* Bin Number */
  },
  {
    /* ISRG_Root_X2 */
    { 0x69, 0x72, 0x9B, 0x8E, 0x15, 0xA8, 0x6E, 0xFC, 0x17, 0x7A, 0x57, 0xAF, 0xB7, 0x17, 0x1D, 0xFC,
      0x64, 0xAD, 0xD2, 0x8C, 0x2F, 0xCA, 0x8C, 0xF1, 0x50, 0x7E, 0x34, 0x45, 0x3C, 0xCB, 0x14, 0x70 },
      233 /* Bin Number */
  },
  {
    /* VeriSign_Class_3_Public_Primary_Certification_Authority___G4 */
    { 0x69, 0xDD, 0xD7, 0xEA, 0x90, 0xBB, 0x57, 0xC9, 0x3E, 0x13, 0x5D, 0xC8, 0x5E, 0xA6, 0xFC, 0xD5,
      0x48, 0x0B, 0x60, 0x32, 0x39, 0xBD, 0xC4, 0x54, 0xFC, 0x75, 0x8B, 0x2A, 0x26, 0xCF, 0x7F, 0x79 },
      91 /* Bin Number */
  },
  {
    /* Visa_eCommerce_Root */
    { 0x69, 0xFA, 0xC9, 0xBD, 0x55, 0xFB, 0x0A, 0xC7, 0x8D, 0x53, 0xBB, 0xEE, 0x5C, 0xF1, 0xD5, 0x97,
      0x98, 0x9F, 0xD0, 0xAA, 0xAB, 0x20, 0xA2, 0x51, 0x51, 0xBD, 0xF1, 0x73, 0x3E, 0xE7, 0xD1, 0x22 },
      26 /* Bin Number */
  },
  {
    /* Certum_EC_384_CA */
    { 0x6B, 0x32, 0x80, 0x85, 0x62, 0x53, 0x18, 0xAA, 0x50, 0xD1, 0x73, 0xC9, 0x8D, 0x8B, 0xDA, 0x09,
      0xD5, 0x7E, 0x27, 0x41, 0x3D, 0x11, 0x4C, 0xF7, 0x87, 0xA0, 0xF5, 0xD0, 0x6C, 0x03, 0x0C, 0xF6 },
      225 /* Bin Number */
  },
  {
    /* OISTE_WISeKey_Global_Root_GB_CA */
    { 0x6B, 0x9C, 0x08, 0xE8, 0x6E, 0xB0, 0xF7, 0x67, 0xCF, 0xAD, 0x65, 0xCD, 0x98, 0xB6, 0x21, 0x49,
      0xE5, 0x49, 0x4A, 0x67, 0xF5, 0x84, 0x5E, 0x7B, 0xD1, 0xED, 0x01, 0x9F, 0x27, 0xB8, 0x6B, 0xD6 },
      169 /* Bin Number */
  },
  {
    /* NetLock_Arany__Class_Gold__F_tan_s_tv_ny */
    { 0x6C, 0x61, 0xDA, 0xC3, 0xA2, 0xDE, 0xF0, 0x31, 0x50, 0x6B, 0xE0, 0x36, 0xD2, 0xA6, 0xFE, 0x40,
      0x19, 0x94, 0xFB, 0xD1, 0x3D, 0xF9, 0xC8, 0xD4, 0x66, 0x59, 0x92, 0x74, 0xC4, 0x46, 0xEC, 0x98 },
      92 /* Bin Number */
  },
  {
    /* Certplus_Root_CA_G2 */
    { 0x6C, 0xC0, 0x50, 0x41, 0xE6, 0x44, 0x5E, 0x74, 0x69, 0x6C, 0x4C, 0xFB, 0xC9, 0xF8, 0x0F, 0x54,
      0x3B, 0x7E, 0xAB, 0xBB, 0x44, 0xB4, 0xCE, 0x6F, 0x78, 0x7C, 0x6A, 0x99, 0x71, 0xC4, 0x2F, 0x17 },
      177 /* Bin Number */
  },
  {
    /* Entrust_net_Certification_Authority__2048_ */
    { 0x6D, 0xC4, 0x71, 0x72, 0xE0, 0x1C, 0xBC, 0xB0, 0xBF, 0x62, 0x58, 0x0D, 0x89, 0x5F, 0xE2, 0xB8,
      0xAC, 0x9A, 0xD4, 0xF8, 0x73, 0x80, 0x1E, 0x0C, 0x10, 0xB9, 0xC8, 0x37, 0xD2, 0x1E, 0xB1, 0x77 },
      10 /* Bin Number */
  },
  {
    /* UTN_USERFirst_Hardware */
    { 0x6E, 0xA5, 0x47, 0x41, 0xD0, 0x04, 0x66, 0x7E, 0xED, 0x1B, 0x48, 0x16, 0x63, 0x4A, 0xA3, 0xA7,
      0x9E, 0x6E, 0x4B, 0x96, 0x95, 0x0F, 0x82, 0x79, 0xDA, 0xFC, 0x8D, 0x9B, 0xD8, 0x81, 0x21, 0x37 },
      38 /* Bin Number */
  },
  {
    /* AffirmTrust_Premium */
    { 0x70, 0xA7, 0x3F, 0x7F, 0x37, 0x6B, 0x60, 0x07, 0x42, 0x48, 0x90, 0x45, 0x34, 0xB1, 0x14, 0x82,
      0xD5, 0xBF, 0x0E, 0x69, 0x8E, 0xCC, 0x49, 0x8D, 0xF5, 0x25, 0x77, 0xEB, 0xF2, 0xE9, 0x3B, 0x9A },
      111 /* Bin Number */
  },
  {
    /* GTS_Root_R4 */
    { 0x71, 0xCC, 0xA5, 0x39, 0x1F, 0x9E, 0x79, 0x4B, 0x04, 0x80, 0x25, 0x30, 0xB3, 0x63, 0xE1, 0x21,
      0xDA, 0x8A, 0x30, 0x43, 0xBB, 0x26, 0x66, 0x2F, 0xEA, 0x4D, 0xCA, 0x7F, 0xC9, 0x51, 0xA4, 0xBD },
      202 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority */
    { 0x73, 0xC1, 0x76, 0x43, 0x4F, 0x1B, 0xC6, 0xD5, 0xAD, 0xF4, 0x5B, 0x0E, 0x76, 0xE7, 0x27, 0x28,
      0x7C, 0x8D, 0xE5, 0x76, 0x16, 0xC1, 0xE6, 0xE6, 0x14, 0x1A, 0x2B, 0x2C, 0xBC, 0x7D, 0x8E, 0x4C },
      18 /* Bin Number */
  },
  {
    /* DigiCert_High_Assurance_EV_Root_CA */
    { 0x74, 0x31, 0xE5, 0xF4, 0xC3, 0xC1, 0xCE, 0x46, 0x90, 0x77, 0x4F, 0x0B, 0x61, 0xE0, 0x54, 0x40,
      0x88, 0x3B, 0xA9, 0xA0, 0x1E, 0xD0, 0x0B, 0xA6, 0xAB, 0xD7, 0x80, 0x6E, 0xD3, 0xB1, 0x18, 0xCF },
      50 /* Bin Number */
  },
  {
    /* O_Government_Root_Certification_Authority_C_TW */
    { 0x76, 0x00, 0x29, 0x5E, 0xEF, 0xE8, 0x5B, 0x9E, 0x1F, 0xD6, 0x24, 0xDB, 0x76, 0x06, 0x2A, 0xAA,
      0xAE, 0x59, 0x81, 0x8A, 0x54, 0xD2, 0x77, 0x4C, 0xD4, 0xC0, 0xB2, 0xC0, 0x11, 0x31, 0xE1, 0xB3 },
      46 /* Bin Number */
  },
  {
    /* DST_ACES_CA_X6 */
    { 0x76, 0x7C, 0x95, 0x5A, 0x76, 0x41, 0x2C, 0x89, 0xAF, 0x68, 0x8E, 0x90, 0xA1, 0xC7, 0x0F, 0x55,
      0x6C, 0xFD, 0x6B, 0x60, 0x25, 0xDB, 0xEA, 0x10, 0x41, 0x6D, 0x7E, 0xB6, 0x83, 0x1F, 0x8C, 0x40 },
      53 /* Bin Number */
  },
  {
    /* America_Online_Root_Certification_Authority_1 */
    { 0x77, 0x40, 0x73, 0x12, 0xC6, 0x3A, 0x15, 0x3D, 0x5B, 0xC0, 0x0B, 0x4E, 0x51, 0x75, 0x9C, 0xDF,
      0xDA, 0xC2, 0x37, 0xDC, 0x2A, 0x33, 0xB6, 0x79, 0x46, 0xE9, 0x8E, 0x9B, 0xFA, 0x68, 0x0A, 0xE3 },
      24 /* Bin Number */
  },
  {
    /* Sonera_Class2_CA */
    { 0x79, 0x08, 0xB4, 0x03, 0x14, 0xC1, 0x38, 0x10, 0x0B, 0x51, 0x8D, 0x07, 0x35, 0x80, 0x7F, 0xFB,
      0xFC, 0xF8, 0x51, 0x8A, 0x00, 0x95, 0x33, 0x71, 0x05, 0xBA, 0x38, 0x6B, 0x15, 0x3D, 0xD9, 0x27 },
      35 /* Bin Number */
  },
  {
    /* A_Trust_nQual_03 */
    { 0x79, 0x3C, 0xBF, 0x45, 0x59, 0xB9, 0xFD, 0xE3, 0x8A, 0xB2, 0x2D, 0xF1, 0x68, 0x69, 0xF6, 0x98,
      0x81, 0xAE, 0x14, 0xC4, 0xB0, 0x13, 0x9A, 0xC7, 0x88, 0xA7, 0x8A, 0x1A, 0xFC, 0xCA, 0x02, 0xFB },
      116 /* Bin Number */
  },
  {
    /* DigiCert_Assured_ID_Root_G2 */
    { 0x7D, 0x05, 0xEB, 0xB6, 0x82, 0x33, 0x9F, 0x8C, 0x94, 0x51, 0xEE, 0x09, 0x4E, 0xEB, 0xFE, 0xFA,
      0x79, 0x53, 0xA1, 0x14, 0xED, 0xB2, 0xF4, 0x49, 0x49, 0x45, 0x2F, 0xAB, 0x7D, 0x2F, 0xC1, 0x85 },
      147 /* Bin Number */
  },
  {
    /* America_Online_Root_Certification_Authority_2 */
    { 0x7D, 0x3B, 0x46, 0x5A, 0x60, 0x14, 0xE5, 0x26, 0xC0, 0xAF, 0xFC, 0xEE, 0x21, 0x27, 0xD2, 0x31,
      0x17, 0x27, 0xAD, 0x81, 0x1C, 0x26, 0x84, 0x2D, 0x00, 0x6A, 0xF3, 0x73, 0x06, 0xCC, 0x80, 0xBD },
      25 /* Bin Number */
  },
  {
    /* DigiCert_Assured_ID_Root_G3 */
    { 0x7E, 0x37, 0xCB, 0x8B, 0x4C, 0x47, 0x09, 0x0C, 0xAB, 0x36, 0x55, 0x1B, 0xA6, 0xF4, 0x5D, 0xB8,
      0x40, 0x68, 0x0F, 0xBA, 0x16, 0x6A, 0x95, 0x2D, 0xB1, 0x00, 0x71, 0x7F, 0x43, 0x05, 0x3F, 0xC2 },
      148 /* Bin Number */
  },
  {
    /* NetLock_Kozjegyzoi__Class_A__Tanusitvanykiado */
    { 0x7F, 0x12, 0xCD, 0x5F, 0x7E, 0x5E, 0x29, 0x0E, 0xC7, 0xD8, 0x51, 0x79, 0xD5, 0xB7, 0x2C, 0x20,
      0xA5, 0xBE, 0x75, 0x08, 0xFF, 0xDB, 0x5B, 0xF8, 0x1A, 0xB9, 0x68, 0x4A, 0x7F, 0xC9, 0xF6, 0x67 },
      41 /* Bin Number */
  },
  {
    /* AddTrust_Qualified_CA_Root */
    { 0x80, 0x95, 0x21, 0x08, 0x05, 0xDB, 0x4B, 0xBC, 0x35, 0x5E, 0x44, 0x28, 0xD8, 0xFD, 0x6E, 0xC2,
      0xCD, 0xE3, 0xAB, 0x5F, 0xB9, 0x7A, 0x99, 0x42, 0x98, 0x8E, 0xB8, 0xF4, 0xDC, 0xD0, 0x60, 0x16 },
      17 /* Bin Number */
  },
  {
    /* OU_VeriSign_Trust_Network_OU___c__1998_VeriSign__Inc____For_authorized_use_only__OU_Class_3_Public_Primary_Certification_Authority___G2_O__VeriSign__Inc___C_US */
    { 0x83, 0xCE, 0x3C, 0x12, 0x29, 0x68, 0x8A, 0x59, 0x3D, 0x48, 0x5F, 0x81, 0x97, 0x3C, 0x0F, 0x91,
      0x95, 0x43, 0x1E, 0xDA, 0x37, 0xCC, 0x5E, 0x36, 0x43, 0x0E, 0x79, 0xC7, 0xA8, 0x88, 0x63, 0x8B },
      5 /* Bin Number */
  },
  {
    /* OISTE_WISeKey_Global_Root_GC_CA */
    { 0x85, 0x60, 0xF9, 0x1C, 0x36, 0x24, 0xDA, 0xBA, 0x95, 0x70, 0xB5, 0xFE, 0xA0, 0xDB, 0xE3, 0x6F,
      0xF1, 0x1A, 0x83, 0x23, 0xBE, 0x94, 0x86, 0x85, 0x4F, 0xB3, 0xF3, 0x4A, 0x55, 0x71, 0x19, 0x8D },
      198 /* Bin Number */
  },
  {
    /* SSL_com_Root_Certification_Authority_RSA */
    { 0x85, 0x66, 0x6A, 0x56, 0x2E, 0xE0, 0xBE, 0x5C, 0xE9, 0x25, 0xC1, 0xD8, 0x89, 0x0A, 0x6F, 0x76,
      0xA8, 0x7E, 0xC1, 0x6D, 0x4D, 0x7D, 0x5F, 0x29, 0xEA, 0x74, 0x19, 0xCF, 0x20, 0x12, 0x3B, 0x69 },
      193 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_2 */
    { 0x85, 0xA0, 0xDD, 0x7D, 0xD7, 0x20, 0xAD, 0xB7, 0xFF, 0x05, 0xF8, 0x3D, 0x54, 0x2B, 0x20, 0x9D,
      0xC7, 0xFF, 0x45, 0x28, 0xF7, 0xD6, 0x77, 0xB1, 0x83, 0x89, 0xFE, 0xA5, 0xE5, 0xC4, 0x9E, 0x86 },
      32 /* Bin Number */
  },
  {
    /* UTN___DATACorp_SGC */
    { 0x85, 0xFB, 0x2F, 0x91, 0xDD, 0x12, 0x27, 0x5A, 0x01, 0x45, 0xB6, 0x36, 0x53, 0x4F, 0x84, 0x02,
      0x4A, 0xD6, 0x8B, 0x69, 0xB8, 0xEE, 0x88, 0x68, 0x4F, 0xF7, 0x11, 0x37, 0x58, 0x05, 0xB3, 0x48 },
      37 /* Bin Number */
  },
  {
    /* emSign_ECC_Root_CA___G3 */
    { 0x86, 0xA1, 0xEC, 0xBA, 0x08, 0x9C, 0x4A, 0x8D, 0x3B, 0xBE, 0x27, 0x34, 0xC6, 0x12, 0xBA, 0x34,
      0x1D, 0x81, 0x3E, 0x04, 0x3C, 0xF9, 0xE8, 0xA8, 0x62, 0xCD, 0x5C, 0x57, 0xA3, 0x6B, 0xBE, 0x6B },
      207 /* Bin Number */
  },
  {
    /* EC_ACC */
    { 0x88, 0x49, 0x7F, 0x01, 0x60, 0x2F, 0x31, 0x54, 0x24, 0x6A, 0xE2, 0x8C, 0x4D, 0x5A, 0xEF, 0x10,
      0xF1, 0xD8, 0x7E, 0xBB, 0x76, 0x62, 0x6F, 0x4A, 0xE0, 0xB7, 0xF9, 0x5B, 0xA7, 0x96, 0x87, 0x99 },
      119 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_3_G3 */
    { 0x88, 0xEF, 0x81, 0xDE, 0x20, 0x2E, 0xB0, 0x18, 0x45, 0x2E, 0x43, 0xF8, 0x64, 0x72, 0x5C, 0xEA,
      0x5F, 0xBD, 0x1F, 0xC2, 0xD9, 0xD2, 0x05, 0x73, 0x07, 0x09, 0xC5, 0xD8, 0xB8, 0x69, 0x0F, 0x46 },
      146 /* Bin Number */
  },
  {
    /* NAVER_Global_Root_Certification_Authority */
    { 0x88, 0xF4, 0x38, 0xDC, 0xF8, 0xFF, 0xD1, 0xFA, 0x8F, 0x42, 0x91, 0x15, 0xFF, 0xE5, 0xF8, 0x2A,
      0xE1, 0xE0, 0x6E, 0x0C, 0x70, 0xC3, 0x75, 0xFA, 0xAD, 0x71, 0x7B, 0x34, 0xA4, 0x9E, 0x72, 0x65 },
      219 /* Bin Number */
  },
  {
    /* vTrus_Root_CA */
    { 0x8A, 0x71, 0xDE, 0x65, 0x59, 0x33, 0x6F, 0x42, 0x6C, 0x26, 0xE5, 0x38, 0x80, 0xD0, 0x0D, 0x88,
      0xA1, 0x8D, 0xA4, 0xC6, 0xA9, 0x1F, 0x0D, 0xCB, 0x61, 0x94, 0xE2, 0x06, 0xC5, 0xC9, 0x63, 0x87 },
      232 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_1_G3 */
    { 0x8A, 0x86, 0x6F, 0xD1, 0xB2, 0x76, 0xB5, 0x7E, 0x57, 0x8E, 0x92, 0x1C, 0x65, 0x82, 0x8A, 0x2B,
      0xED, 0x58, 0xE9, 0xF2, 0xF2, 0x88, 0x05, 0x41, 0x34, 0xB7, 0xF1, 0xF4, 0xBF, 0xC9, 0xCC, 0x74 },
      144 /* Bin Number */
  },
  {
    /* CA_WoSign_ECC_Root */
    { 0x8B, 0x45, 0xDA, 0x1C, 0x06, 0xF7, 0x91, 0xEB, 0x0C, 0xAB, 0xF2, 0x6B, 0xE5, 0x88, 0xF5, 0xFB,
      0x23, 0x16, 0x5C, 0x2E, 0x61, 0x4B, 0xF8, 0x85, 0x56, 0x2D, 0x0D, 0xCE, 0x50, 0xB2, 0x9B, 0x02 },
      171 /* Bin Number */
  },
  {
    /* Root_CA_Generalitat_Valenciana */
    { 0x8C, 0x4E, 0xDF, 0xD0, 0x43, 0x48, 0xF3, 0x22, 0x96, 0x9E, 0x7E, 0x29, 0xA4, 0xCD, 0x4D, 0xCA,
      0x00, 0x46, 0x55, 0x06, 0x1C, 0x16, 0xE1, 0xB0, 0x76, 0x42, 0x2E, 0xF3, 0x42, 0xAD, 0x63, 0x0E },
      115 /* Bin Number */
  },
  {
    /* AddTrust_Class_1_CA_Root */
    { 0x8C, 0x72, 0x09, 0x27, 0x9A, 0xC0, 0x4E, 0x27, 0x5E, 0x16, 0xD0, 0x7F, 0xD3, 0xB7, 0x75, 0xE8,
      0x01, 0x54, 0xB5, 0x96, 0x80, 0x46, 0xE3, 0x1F, 0x52, 0xDD, 0x25, 0x76, 0x63, 0x24, 0xE9, 0xA7 },
      14 /* Bin Number */
  },
  {
    /* GTS_Root_R2 */
    { 0x8D, 0x25, 0xCD, 0x97, 0x22, 0x9D, 0xBF, 0x70, 0x35, 0x6B, 0xDA, 0x4E, 0xB3, 0xCC, 0x73, 0x40,
      0x31, 0xE2, 0x4C, 0xF0, 0x0F, 0xAF, 0xCF, 0xD3, 0x2D, 0xC7, 0x6E, 0xB5, 0x84, 0x1C, 0x7E, 0xA8 },
      237 /* Bin Number */
  },
  {
    /* thawte_Primary_Root_CA */
    { 0x8D, 0x72, 0x2F, 0x81, 0xA9, 0xC1, 0x13, 0xC0, 0x79, 0x1D, 0xF1, 0x36, 0xA2, 0x96, 0x6D, 0xB2,
      0x6C, 0x95, 0x0A, 0x97, 0x1D, 0xB4, 0x6B, 0x41, 0x99, 0xF4, 0xEA, 0x54, 0xB7, 0x8B, 0xFB, 0x9F },
      59 /* Bin Number */
  },
  {
    /* TC_TrustCenter_Class_3_CA_II */
    { 0x8D, 0xA0, 0x84, 0xFC, 0xF9, 0x9C, 0xE0, 0x77, 0x22, 0xF8, 0x9B, 0x32, 0x05, 0x93, 0x98, 0x06,
      0xFA, 0x5C, 0xB8, 0x11, 0xE1, 0xC8, 0x13, 0xF6, 0xA1, 0x08, 0xC7, 0xD3, 0x36, 0xB3, 0x40, 0x8E },
      73 /* Bin Number */
  },
  {
    /* T_RKTRUST_Elektronik_Sertifika_Hizmet_Sa_lay_c_s__H6 */
    { 0x8D, 0xE7, 0x86, 0x55, 0xE1, 0xBE, 0x7F, 0x78, 0x47, 0x80, 0x0B, 0x93, 0xF6, 0x94, 0xD2, 0x1D,
      0x36, 0x8C, 0xC0, 0x6E, 0x03, 0x3E, 0x7F, 0xAB, 0x04, 0xBB, 0x5E, 0xB9, 0x9D, 0xA6, 0xB7, 0x00 },
      167 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_1 */
    { 0x8E, 0xCD, 0xE6, 0x88, 0x4F, 0x3D, 0x87, 0xB1, 0x12, 0x5B, 0xA3, 0x1A, 0xC3, 0xFC, 0xB1, 0x3D,
      0x70, 0x16, 0xDE, 0x7F, 0x57, 0xCC, 0x90, 0x4F, 0xE1, 0xCB, 0x97, 0xC6, 0xAE, 0x98, 0x19, 0x6E },
      183 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_2_G3 */
    { 0x8F, 0xE4, 0xFB, 0x0A, 0xF9, 0x3A, 0x4D, 0x0D, 0x67, 0xDB, 0x0B, 0xEB, 0xB2, 0x3E, 0x37, 0xC7,
      0x1B, 0xF3, 0x25, 0xDC, 0xBC, 0xDD, 0x24, 0x0E, 0xA0, 0x4D, 0xAF, 0x58, 0xB4, 0x7E, 0x18, 0x40 },
      145 /* Bin Number */
  },
  {
    /* T_TeleSec_GlobalRoot_Class_2 */
    { 0x91, 0xE2, 0xF5, 0x78, 0x8D, 0x58, 0x10, 0xEB, 0xA7, 0xBA, 0x58, 0x73, 0x7D, 0xE1, 0x54, 0x8A,
      0x8E, 0xCA, 0xCD, 0x01, 0x45, 0x98, 0xBC, 0x0B, 0x14, 0x3E, 0x04, 0x1B, 0x17, 0x05, 0x25, 0x52 },
      142 /* Bin Number */
  },
  {
    /* CA_Disig */
    { 0x92, 0xBF, 0x51, 0x19, 0xAB, 0xEC, 0xCA, 0xD0, 0xB1, 0x33, 0x2D, 0xC4, 0xE1, 0xD0, 0x5F, 0xBA,
      0x75, 0xB5, 0x67, 0x90, 0x44, 0xEE, 0x0C, 0xA2, 0x6E, 0x93, 0x1F, 0x74, 0x4F, 0x2F, 0x33, 0xCF },
      94 /* Bin Number */
  },
  {
    /* Trustwave_Global_ECC_P256_Certification_Authority */
    { 0x94, 0x5B, 0xBC, 0x82, 0x5E, 0xA5, 0x54, 0xF4, 0x89, 0xD1, 0xFD, 0x51, 0xA7, 0x3D, 0xDF, 0x2E,
      0xA6, 0x24, 0xAC, 0x70, 0x19, 0xA0, 0x52, 0x05, 0x22, 0x5C, 0x22, 0xA7, 0x8C, 0xCF, 0xA8, 0xB4 },
      217 /* Bin Number */
  },
  {
    /* Cybertrust_Global_Root */
    { 0x96, 0x0A, 0xDF, 0x00, 0x63, 0xE9, 0x63, 0x56, 0x75, 0x0C, 0x29, 0x65, 0xDD, 0x0A, 0x08, 0x67,
      0xDA, 0x0B, 0x9C, 0xBD, 0x6E, 0x77, 0x71, 0x4A, 0xEA, 0xFB, 0x23, 0x49, 0xAB, 0x39, 0x3D, 0xA3 },
      77 /* Bin Number */
  },
  {
    /* ISRG_Root_X1 */
    { 0x96, 0xBC, 0xEC, 0x06, 0x26, 0x49, 0x76, 0xF3, 0x74, 0x60, 0x77, 0x9A, 0xCF, 0x28, 0xC5, 0xA7,
      0xCF, 0xE8, 0xA3, 0xC0, 0xAA, 0xE1, 0x1A, 0x8F, 0xFC, 0xEE, 0x05, 0xC0, 0xBD, 0xDF, 0x08, 0xC6 },
      181 /* Bin Number */
  },
  {
    /* Trustwave_Global_Certification_Authority */
    { 0x97, 0x55, 0x20, 0x15, 0xF5, 0xDD, 0xFC, 0x3C, 0x87, 0x88, 0xC0, 0x06, 0x94, 0x45, 0x55, 0x40,
      0x88, 0x94, 0x45, 0x00, 0x84, 0xF1, 0x00, 0x86, 0x70, 0x86, 0xBC, 0x1A, 0x2B, 0xB5, 0x8D, 0xC8 },
      216 /* Bin Number */
  },
  {
    /* T_RKTRUST_Elektronik_Sertifika_Hizmet_Sa_lay_c_s_ */
    { 0x97, 0x8C, 0xD9, 0x66, 0xF2, 0xFA, 0xA0, 0x7B, 0xA7, 0xAA, 0x95, 0x00, 0xD9, 0xC0, 0x2E, 0x9D,
      0x77, 0xF2, 0xCD, 0xAD, 0xA6, 0xAD, 0x6B, 0xA7, 0x4A, 0xF4, 0xB9, 0x1C, 0x66, 0x59, 0x3C, 0x50 },
      129 /* Bin Number */
  },
  {
    /* Buypass_Class_2_Root_CA */
    { 0x9A, 0x11, 0x40, 0x25, 0x19, 0x7C, 0x5B, 0xB9, 0x5D, 0x94, 0xE6, 0x3D, 0x55, 0xCD, 0x43, 0x79,
      0x08, 0x47, 0xB6, 0x46, 0xB2, 0x3C, 0xDF, 0x11, 0xAD, 0xA4, 0xA0, 0x0E, 0xFF, 0x15, 0xFB, 0x48 },
      125 /* Bin Number */
  },
  {
    /* GLOBALTRUST_2020 */
    { 0x9A, 0x29, 0x6A, 0x51, 0x82, 0xD1, 0xD4, 0x51, 0xA2, 0xE3, 0x7F, 0x43, 0x9B, 0x74, 0xDA, 0xAF,
      0xA2, 0x67, 0x52, 0x33, 0x29, 0xF9, 0x0F, 0x9A, 0x0D, 0x20, 0x07, 0xC3, 0x34, 0xE2, 0x3C, 0x9A },
      223 /* Bin Number */
  },
  {
    /* ACCVRAIZ1 */
    { 0x9A, 0x6E, 0xC0, 0x12, 0xE1, 0xA7, 0xDA, 0x9D, 0xBE, 0x34, 0x19, 0x4D, 0x47, 0x8A, 0xD7, 0xC0,
      0xDB, 0x18, 0x22, 0xFB, 0x07, 0x1D, 0xF1, 0x29, 0x81, 0x49, 0x6E, 0xD1, 0x04, 0x38, 0x41, 0x13 },
      138 /* Bin Number */
  },
  {
    /* VeriSign_Class_3_Public_Primary_Certification_Authority___G5 */
    { 0x9A, 0xCF, 0xAB, 0x7E, 0x43, 0xC8, 0xD8, 0x80, 0xD0, 0x6B, 0x26, 0x2A, 0x94, 0xDE, 0xEE, 0xE4,
      0xB4, 0x65, 0x99, 0x89, 0xC3, 0xD0, 0xCA, 0xF1, 0x9B, 0xAF, 0x64, 0x05, 0xE4, 0x1A, 0xB7, 0xDF },
      60 /* Bin Number */
  },
  {
    /* UCA_Global_G2_Root */
    { 0x9B, 0xEA, 0x11, 0xC9, 0x76, 0xFE, 0x01, 0x47, 0x64, 0xC1, 0xBE, 0x56, 0xA6, 0xF9, 0x14, 0xB5,
      0xA5, 0x60, 0x31, 0x7A, 0xBD, 0x99, 0x88, 0x39, 0x33, 0x82, 0xE5, 0x16, 0x1A, 0xA0, 0x49, 0x3C },
      203 /* Bin Number */
  },
  {
    /* GeoTrust_Universal_CA_2 */
    { 0xA0, 0x23, 0x4F, 0x3B, 0xC8, 0x52, 0x7C, 0xA5, 0x62, 0x8E, 0xEC, 0x81, 0xAD, 0x5D, 0x69, 0x89,
      0x5D, 0xA5, 0x68, 0x0D, 0xC9, 0x1D, 0x1C, 0xB8, 0x47, 0x7F, 0x33, 0xF8, 0x78, 0xB9, 0x5B, 0x0B },
      23 /* Bin Number */
  },
  {
    /* Hellenic_Academic_and_Research_Institutions_RootCA_2015 */
    { 0xA0, 0x40, 0x92, 0x9A, 0x02, 0xCE, 0x53, 0xB4, 0xAC, 0xF4, 0xF2, 0xFF, 0xC6, 0x98, 0x1C, 0xE4,
      0x49, 0x6F, 0x75, 0x5E, 0x6D, 0x45, 0xFE, 0x0B, 0x2A, 0x69, 0x2B, 0xCD, 0x52, 0x52, 0x3F, 0x36 },
      174 /* Bin Number */
  },
  {
    /* GeoTrust_Universal_CA */
    { 0xA0, 0x45, 0x9B, 0x9F, 0x63, 0xB2, 0x25, 0x59, 0xF5, 0xFA, 0x5D, 0x4C, 0x6D, 0xB3, 0xF9, 0xF7,
      0x2F, 0xF1, 0x93, 0x42, 0x03, 0x35, 0x78, 0xF0, 0x73, 0xBF, 0x1D, 0x1B, 0x46, 0xCB, 0xB9, 0x12 },
      22 /* Bin Number */
  },
  {
    /* SZAFIR_ROOT_CA2 */
    { 0xA1, 0x33, 0x9D, 0x33, 0x28, 0x1A, 0x0B, 0x56, 0xE5, 0x57, 0xD3, 0xD3, 0x2B, 0x1C, 0xE7, 0xF9,
      0x36, 0x7E, 0xB0, 0x94, 0xBD, 0x5F, 0xA7, 0x2A, 0x7E, 0x50, 0x04, 0xC8, 0xDE, 0xD7, 0xCA, 0xFE },
      172 /* Bin Number */
  },
  {
    /* OU_Security_Communication_EV_RootCA1_O__SECOM_Trust_Systems_CO__LTD___C_JP */
    { 0xA2, 0x2D, 0xBA, 0x68, 0x1E, 0x97, 0x37, 0x6E, 0x2D, 0x39, 0x7D, 0x72, 0x8A, 0xAE, 0x3A, 0x9B,
      0x62, 0x96, 0xB9, 0xFD, 0xBA, 0x60, 0xBC, 0x2E, 0x11, 0xF6, 0x47, 0xF2, 0xC6, 0x75, 0xFB, 0x37 },
      68 /* Bin Number */
  },
  {
    /* thawte_Primary_Root_CA___G2 */
    { 0xA4, 0x31, 0x0D, 0x50, 0xAF, 0x18, 0xA6, 0x44, 0x71, 0x90, 0x37, 0x2A, 0x86, 0xAF, 0xAF, 0x8B,
      0x95, 0x1F, 0xFB, 0x43, 0x1D, 0x83, 0x7F, 0x1E, 0x56, 0x88, 0xB4, 0x59, 0x71, 0xED, 0x15, 0x57 },
      87 /* Bin Number */
  },
  {
    /* QuoVadis_Root_Certification_Authority */
    { 0xA4, 0x5E, 0xDE, 0x3B, 0xBB, 0xF0, 0x9C, 0x8A, 0xE1, 0x5C, 0x72, 0xEF, 0xC0, 0x72, 0x68, 0xD6,
      0x93, 0xA2, 0x1C, 0x99, 0x6F, 0xD5, 0x1E, 0x67, 0xCA, 0x07, 0x94, 0x60, 0xFD, 0x6D, 0x88, 0x73 },
      31 /* Bin Number */
  },
  {
    /* WellsSecure_Public_Root_Certificate_Authority */
    { 0xA7, 0x12, 0x72, 0xAE, 0xAA, 0xA3, 0xCF, 0xE8, 0x72, 0x7F, 0x7F, 0xB3, 0x9F, 0x0F, 0xB3, 0xD1,
      0xE5, 0x42, 0x6E, 0x90, 0x60, 0xB0, 0x6E, 0xE6, 0xF1, 0x3E, 0x9A, 0x3C, 0x58, 0x33, 0xCD, 0x43 },
      65 /* Bin Number */
  },
  {
    /* OU_RSA_Security_2048_V3_O_RSA_Security_Inc */
    { 0xAF, 0x8B, 0x67, 0x62, 0xA1, 0xE5, 0x28, 0x22, 0x81, 0x61, 0xA9, 0x5D, 0x5C, 0x55, 0x9E, 0xE2,
      0x66, 0x27, 0x8F, 0x75, 0xD7, 0x9E, 0x83, 0x01, 0x89, 0xA5, 0x03, 0x50, 0x6A, 0xBD, 0x6B, 0x4C },
      19 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0xB0, 0x85, 0xD7, 0x0B, 0x96, 0x4F, 0x19, 0x1A, 0x73, 0xE4, 0xAF, 0x0D, 0x54, 0xAE, 0x7A, 0x0E,
      0x07, 0xAA, 0xFD, 0xAF, 0x9B, 0x71, 0xDD, 0x08, 0x62, 0x13, 0x8A, 0xB7, 0x32, 0x5A, 0x24, 0xA2 },
      235 /* Bin Number */
  },
  {
    /* E_Tugra_Certification_Authority */
    { 0xB0, 0xBF, 0xD5, 0x2B, 0xB0, 0xD7, 0xD9, 0xBD, 0x92, 0xBF, 0x5D, 0x4D, 0xC1, 0x3D, 0xA2, 0x55,
      0xC0, 0x2C, 0x54, 0x2F, 0x37, 0x83, 0x65, 0xEA, 0x89, 0x39, 0x11, 0xF5, 0x5E, 0x55, 0xF2, 0x3C },
      141 /* Bin Number */
  },
  {
    /* GeoTrust_Primary_Certification_Authority___G3 */
    { 0xB4, 0x78, 0xB8, 0x12, 0x25, 0x0D, 0xF8, 0x78, 0x63, 0x5C, 0x2A, 0xA7, 0xEC, 0x7D, 0x15, 0x5E,
      0xAA, 0x62, 0x5E, 0xE8, 0x29, 0x16, 0xE2, 0xCD, 0x29, 0x43, 0x61, 0x88, 0x6C, 0xD1, 0xFB, 0xD4 },
      86 /* Bin Number */
  },
  {
    /* Deutsche_Telekom_Root_CA_2 */
    { 0xB6, 0x19, 0x1A, 0x50, 0xD0, 0xC3, 0x97, 0x7F, 0x7D, 0xA9, 0x9B, 0xCD, 0xAA, 0xC8, 0x6A, 0x22,
      0x7D, 0xAE, 0xB9, 0x67, 0x9E, 0xC7, 0x0B, 0xA3, 0xB0, 0xC9, 0xD9, 0x22, 0x71, 0xC1, 0x70, 0xD3 },
      75 /* Bin Number */
  },
  {
    /* Certum_Trusted_Network_CA_2 */
    { 0xB6, 0x76, 0xF2, 0xED, 0xDA, 0xE8, 0x77, 0x5C, 0xD3, 0x6C, 0xB0, 0xF6, 0x3C, 0xD1, 0xD4, 0x60,
      0x39, 0x61, 0xF4, 0x9E, 0x62, 0x65, 0xBA, 0x01, 0x3A, 0x2F, 0x03, 0x07, 0xB6, 0xD0, 0xB8, 0x04 },
      173 /* Bin Number */
  },
  {
    /* Buypass_Class_3_CA_1 */
    { 0xB7, 0xB1, 0x2B, 0x17, 0x1F, 0x82, 0x1D, 0xAA, 0x99, 0x0C, 0xD0, 0xFE, 0x50, 0x87, 0xB1, 0x28,
      0x44, 0x8B, 0xA8, 0xE5, 0x18, 0x4F, 0x84, 0xC5, 0x1E, 0x02, 0xB5, 0xC8, 0xFB, 0x96, 0x2B, 0x24 },
      81 /* Bin Number */
  },
  {
    /* OpenTrust_Root_CA_G3 */
    { 0xB7, 0xC3, 0x62, 0x31, 0x70, 0x6E, 0x81, 0x07, 0x8C, 0x36, 0x7C, 0xB8, 0x96, 0x19, 0x8F, 0x1E,
      0x32, 0x08, 0xDD, 0x92, 0x69, 0x49, 0xDD, 0x8F, 0x57, 0x09, 0xA4, 0x10, 0xF7, 0x5B, 0x62, 0x92 },
      180 /* Bin Number */
  },
  {
    /* IGC_A */
    { 0xB9, 0xBE, 0xA7, 0x86, 0x0A, 0x96, 0x2E, 0xA3, 0x61, 0x1D, 0xAB, 0x97, 0xAB, 0x6D, 0xA3, 0xE2,
      0x1C, 0x10, 0x68, 0xB9, 0x7D, 0x55, 0x57, 0x5E, 0xD0, 0xE1, 0x12, 0x79, 0xC1, 0x1C, 0x89, 0x32 },
      67 /* Bin Number */
  },
  {
    /* Hellenic_Academic_and_Research_Institutions_RootCA_2011 */
    { 0xBC, 0x10, 0x4F, 0x15, 0xA4, 0x8B, 0xE7, 0x09, 0xDC, 0xA5, 0x42, 0xA7, 0xE1, 0xD4, 0xB9, 0xDF,
      0x6F, 0x05, 0x45, 0x27, 0xE8, 0x02, 0xEA, 0xA9, 0x2D, 0x59, 0x54, 0x44, 0x25, 0x8A, 0xFE, 0x71 },
      120 /* Bin Number */
  },
  {
    /* emSign_ECC_Root_CA___C3 */
    { 0xBC, 0x4D, 0x80, 0x9B, 0x15, 0x18, 0x9D, 0x78, 0xDB, 0x3E, 0x1D, 0x8C, 0xF4, 0xF9, 0x72, 0x6A,
      0x79, 0x5D, 0xA1, 0x64, 0x3C, 0xA5, 0xF1, 0x35, 0x8E, 0x1D, 0xDB, 0x0E, 0xDC, 0x0D, 0x7E, 0xB3 },
      209 /* Bin Number */
  },
  {
    /* AffirmTrust_Premium_ECC */
    { 0xBD, 0x71, 0xFD, 0xF6, 0xDA, 0x97, 0xE4, 0xCF, 0x62, 0xD1, 0x64, 0x7A, 0xDD, 0x25, 0x81, 0xB0,
      0x7D, 0x79, 0xAD, 0xF8, 0x39, 0x7E, 0xB4, 0xEC, 0xBA, 0x9C, 0x5E, 0x84, 0x88, 0x82, 0x14, 0x23 },
      112 /* Bin Number */
  },
  {
    /* Secure_Certificate_Services */
    { 0xBD, 0x81, 0xCE, 0x3B, 0x4F, 0x65, 0x91, 0xD1, 0x1A, 0x67, 0xB5, 0xFC, 0x7A, 0x47, 0xFD, 0xEF,
      0x25, 0x52, 0x1B, 0xF9, 0xAA, 0x4E, 0x18, 0xB9, 0xE3, 0xDF, 0x2E, 0x34, 0xA7, 0x80, 0x3B, 0xE8 },
      29 /* Bin Number */
  },
  {
    /* SwissSign_Silver_CA___G2 */
    { 0xBE, 0x6C, 0x4D, 0xA2, 0xBB, 0xB9, 0xBA, 0x59, 0xB6, 0xF3, 0x93, 0x97, 0x68, 0x37, 0x42, 0x46,
      0xC3, 0xC0, 0x05, 0x99, 0x3F, 0xA9, 0x8F, 0x02, 0x0D, 0x1D, 0xED, 0xBE, 0xD4, 0x8A, 0x81, 0xD5 },
      57 /* Bin Number */
  },
  {
    /* e_Szigno_Root_CA_2017 */
    { 0xBE, 0xB0, 0x0B, 0x30, 0x83, 0x9B, 0x9B, 0xC3, 0x2C, 0x32, 0xE4, 0x44, 0x79, 0x05, 0x95, 0x06,
      0x41, 0xF2, 0x64, 0x21, 0xB1, 0x5E, 0xD0, 0x89, 0x19, 0x8B, 0x51, 0x8A, 0xE2, 0xEA, 0x1B, 0x99 },
      214 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0xBE, 0xC9, 0x49, 0x11, 0xC2, 0x95, 0x56, 0x76, 0xDB, 0x6C, 0x0A, 0x55, 0x09, 0x86, 0xD7, 0x6E,
      0x3B, 0xA0, 0x05, 0x66, 0x7C, 0x44, 0x2C, 0x97, 0x62, 0xB4, 0xFB, 0xB7, 0x73, 0xDE, 0x22, 0x8C },
      157 /* Bin Number */
  },
  {
    /* SecureSign_RootCA11 */
    { 0xBF, 0x0F, 0xEE, 0xFB, 0x9E, 0x3A, 0x58, 0x1A, 0xD5, 0xF9, 0xE9, 0xDB, 0x75, 0x89, 0x98, 0x57,
      0x43, 0xD2, 0x61, 0x08, 0x5C, 0x4D, 0x31, 0x4F, 0x6F, 0x5D, 0x72, 0x59, 0xAA, 0x42, 0x16, 0x12 },
      97 /* Bin Number */
  },
  {
    /* TWCA_Root_Certification_Authority */
    { 0xBF, 0xD8, 0x8F, 0xE1, 0x10, 0x1C, 0x41, 0xAE, 0x3E, 0x80, 0x1B, 0xF8, 0xBE, 0x56, 0x35, 0x0E,
      0xE9, 0xBA, 0xD1, 0xA6, 0xB9, 0xBD, 0x51, 0x5E, 0xDC, 0x5C, 0x6D, 0x5B, 0x87, 0x11, 0xAC, 0x44 },
      117 /* Bin Number */
  },
  {
    /* GDCA_TrustAUTH_R5_ROOT */
    { 0xBF, 0xFF, 0x8F, 0xD0, 0x44, 0x33, 0x48, 0x7D, 0x6A, 0x8A, 0xA6, 0x0C, 0x1A, 0x29, 0x76, 0x7A,
      0x9F, 0xC2, 0xBB, 0xB0, 0x5E, 0x42, 0x0F, 0x71, 0x3A, 0x13, 0xB9, 0x92, 0x89, 0x1D, 0x38, 0x93 },
      189 /* Bin Number */
  },
  {
    /* OU_ePKI_Root_Certification_Authority_O__Chunghwa_Telecom_Co___Ltd___C_TW */
    { 0xC0, 0xA6, 0xF4, 0xDC, 0x63, 0xA2, 0x4B, 0xFD, 0xCF, 0x54, 0xEF, 0x2A, 0x6A, 0x08, 0x2A, 0x0A,
      0x72, 0xDE, 0x35, 0x80, 0x3E, 0x2F, 0xF5, 0xFF, 0x52, 0x7A, 0xE5, 0xD8, 0x72, 0x06, 0xDF, 0xD5 },
      78 /* Bin Number */
  },
  {
    /* OU_Trustis_FPS_Root_CA_O_Trustis_Limited_C_GB */
    { 0xC1, 0xB4, 0x82, 0x99, 0xAB, 0xA5, 0x20, 0x8F, 0xE9, 0x63, 0x0A, 0xCE, 0x55, 0xCA, 0x68, 0xA0,
      0x3E, 0xDA, 0x5A, 0x51, 0x9C, 0x88, 0x02, 0xA0, 0xD3, 0xA6, 0x73, 0xBE, 0x8F, 0x8E, 0x55, 0x7D },
      122 /* Bin Number */
  },
  {
    /* OU_Go_Daddy_Class_2_Certification_Authority_O__The_Go_Daddy_Group__Inc___C_US */
    { 0xC3, 0x84, 0x6B, 0xF2, 0x4B, 0x9E, 0x93, 0xCA, 0x64, 0x27, 0x4C, 0x0E, 0xC6, 0x7C, 0x1E, 0xCC,
      0x5E, 0x02, 0x4F, 0xFC, 0xAC, 0xD2, 0xD7, 0x40, 0x19, 0x35, 0x0E, 0x81, 0xFE, 0x54, 0x6A, 0xE4 },
      43 /* Bin Number */
  },
  {
    /* GTS_Root_R2 */
    { 0xC4, 0x5D, 0x7B, 0xB0, 0x8E, 0x6D, 0x67, 0xE6, 0x2E, 0x42, 0x35, 0x11, 0x0B, 0x56, 0x4E, 0x5F,
      0x78, 0xFD, 0x92, 0xEF, 0x05, 0x8C, 0x84, 0x0A, 0xEA, 0x4E, 0x64, 0x55, 0xD7, 0x58, 0x5C, 0x60 },
      200 /* Bin Number */
  },
  {
    /* T_RKTRUST_Elektronik_Sertifika_Hizmet_Sa_lay_c_s_ */
    { 0xC4, 0x70, 0xCF, 0x54, 0x7E, 0x23, 0x02, 0xB9, 0x77, 0xFB, 0x29, 0xDD, 0x71, 0xA8, 0x9A, 0x7B,
      0x6C, 0x1F, 0x60, 0x77, 0x7B, 0x03, 0x29, 0xF5, 0x60, 0x17, 0xF3, 0x28, 0xBF, 0x4F, 0x6B, 0xE6 },
      55 /* Bin Number */
  },
  {
    /* Microsoft_RSA_Root_Certificate_Authority_2017 */
    { 0xC7, 0x41, 0xF7, 0x0F, 0x4B, 0x2A, 0x8D, 0x88, 0xBF, 0x2E, 0x71, 0xC1, 0x41, 0x22, 0xEF, 0x53,
      0xEF, 0x10, 0xEB, 0xA0, 0xCF, 0xA5, 0xE6, 0x4C, 0xFA, 0x20, 0xF4, 0x18, 0x85, 0x30, 0x73, 0xE0 },
      213 /* Bin Number */
  },
  {
    /* StartCom_Certification_Authority */
    { 0xC7, 0x66, 0xA9, 0xBE, 0xF2, 0xD4, 0x07, 0x1C, 0x86, 0x3A, 0x31, 0xAA, 0x49, 0x20, 0xE8, 0x13,
      0xB2, 0xD1, 0x98, 0x60, 0x8C, 0xB7, 0xB7, 0xCF, 0xE2, 0x11, 0x43, 0xB8, 0x36, 0xDF, 0x09, 0xEA },
      45 /* Bin Number */
  },
  {
    /* StartCom_Certification_Authority_G2 */
    { 0xC7, 0xBA, 0x65, 0x67, 0xDE, 0x93, 0xA7, 0x98, 0xAE, 0x1F, 0xAA, 0x79, 0x1E, 0x71, 0x2D, 0x37,
      0x8F, 0xAE, 0x1F, 0x93, 0xC4, 0x39, 0x7F, 0xEA, 0x44, 0x1B, 0xB7, 0xCB, 0xE6, 0xFD, 0x59, 0x95 },
      124 /* Bin Number */
  },
  {
    /* GeoTrust_Global_CA_2 */
    { 0xCA, 0x2D, 0x82, 0xA0, 0x86, 0x77, 0x07, 0x2F, 0x8A, 0xB6, 0x76, 0x4F, 0xF0, 0x35, 0x67, 0x6C,
      0xFE, 0x3E, 0x5E, 0x32, 0x5E, 0x01, 0x21, 0x72, 0xDF, 0x3F, 0x92, 0x09, 0x6D, 0xB7, 0x9B, 0x85 },
      21 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0xCA, 0x42, 0xDD, 0x41, 0x74, 0x5F, 0xD0, 0xB8, 0x1E, 0xB9, 0x02, 0x36, 0x2C, 0xF9, 0xD8, 0xBF,
      0x71, 0x9D, 0xA1, 0xBD, 0x1B, 0x1E, 0xFC, 0x94, 0x6F, 0x5B, 0x4C, 0x99, 0xF4, 0x2C, 0x1B, 0x9E },
      7 /* Bin Number */
  },
  {
    /* DigiCert_Global_Root_G2 */
    { 0xCB, 0x3C, 0xCB, 0xB7, 0x60, 0x31, 0xE5, 0xE0, 0x13, 0x8F, 0x8D, 0xD3, 0x9A, 0x23, 0xF9, 0xDE,
      0x47, 0xFF, 0xC3, 0x5E, 0x43, 0xC1, 0x14, 0x4C, 0xEA, 0x27, 0xD4, 0x6A, 0x5A, 0xB1, 0xCB, 0x5F },
      149 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0xCB, 0xB5, 0x22, 0xD7, 0xB7, 0xF1, 0x27, 0xAD, 0x6A, 0x01, 0x13, 0x86, 0x5B, 0xDF, 0x1C, 0xD4,
      0x10, 0x2E, 0x7D, 0x07, 0x59, 0xAF, 0x63, 0x5A, 0x7C, 0xF4, 0x72, 0x0D, 0xC9, 0x63, 0xC5, 0x3B },
      101 /* Bin Number */
  },
  {
    /* GlobalSign_Root_E46 */
    { 0xCB, 0xB9, 0xC4, 0x4D, 0x84, 0xB8, 0x04, 0x3E, 0x10, 0x50, 0xEA, 0x31, 0xA6, 0x9F, 0x51, 0x49,
      0x55, 0xD7, 0xBF, 0xD2, 0xE2, 0xC6, 0xB4, 0x93, 0x01, 0x01, 0x9A, 0xD6, 0x1D, 0x9F, 0x50, 0x58 },
      222 /* Bin Number */
  },
  {
    /* XRamp_Global_Certification_Authority */
    { 0xCE, 0xCD, 0xDC, 0x90, 0x50, 0x99, 0xD8, 0xDA, 0xDF, 0xC5, 0xB1, 0xD2, 0x09, 0xB7, 0x37, 0xCB,
      0xE2, 0xC1, 0x8C, 0xFB, 0x2C, 0x10, 0xC0, 0xFF, 0x0B, 0xCF, 0x0D, 0x32, 0x86, 0xFC, 0x1A, 0xA2 },
      42 /* Bin Number */
  },
  {
    /* Equifax_Secure_eBusiness_CA_1 */
    { 0xCF, 0x56, 0xFF, 0x46, 0xA4, 0xA1, 0x86, 0x10, 0x9D, 0xD9, 0x65, 0x84, 0xB5, 0xEE, 0xB5, 0x8A,
      0x51, 0x0C, 0x42, 0x75, 0xB0, 0xE5, 0xF9, 0x4F, 0x40, 0xBB, 0xAE, 0x86, 0x5E, 0x19, 0xF6, 0x73 },
      13 /* Bin Number */
  },
  {
    /* TrustCor_RootCert_CA_1 */
    { 0xD4, 0x0E, 0x9C, 0x86, 0xCD, 0x8F, 0xE4, 0x68, 0xC1, 0x77, 0x69, 0x59, 0xF4, 0x9E, 0xA7, 0x74,
      0xFA, 0x54, 0x86, 0x84, 0xB6, 0xC4, 0x06, 0xF3, 0x90, 0x92, 0x61, 0xF4, 0xDC, 0xE2, 0x57, 0x5C },
      190 /* Bin Number */
  },
  {
    /* Staat_der_Nederlanden_Root_CA */
    { 0xD4, 0x1D, 0x82, 0x9E, 0x8C, 0x16, 0x59, 0x82, 0x2A, 0xF9, 0x3F, 0xCE, 0x62, 0xBF, 0xFC, 0xDE,
      0x26, 0x4F, 0xC8, 0x4E, 0x8B, 0x95, 0x0C, 0x5F, 0xF2, 0x75, 0xD0, 0x52, 0x35, 0x46, 0x95, 0xA3 },
      36 /* Bin Number */
  },
  {
    /* UCA_Extended_Validation_Root */
    { 0xD4, 0x3A, 0xF9, 0xB3, 0x54, 0x73, 0x75, 0x5C, 0x96, 0x84, 0xFC, 0x06, 0xD7, 0xD8, 0xCB, 0x70,
      0xEE, 0x5C, 0x28, 0xE7, 0x73, 0xFB, 0x29, 0x4E, 0xB4, 0x1E, 0xE7, 0x17, 0x22, 0x92, 0x4D, 0x24 },
      204 /* Bin Number */
  },
  {
    /* Certification_Authority_of_WoSign_G2 */
    { 0xD4, 0x87, 0xA5, 0x6F, 0x83, 0xB0, 0x74, 0x82, 0xE8, 0x5E, 0x96, 0x33, 0x94, 0xC1, 0xEC, 0xC2,
      0xC9, 0xE5, 0x1D, 0x09, 0x03, 0xEE, 0x94, 0x6B, 0x02, 0xC3, 0x01, 0x58, 0x1E, 0xD9, 0x9E, 0x16 },
      170 /* Bin Number */
  },
  {
    /* Certigna_Root_CA */
    { 0xD4, 0x8D, 0x3D, 0x23, 0xEE, 0xDB, 0x50, 0xA4, 0x59, 0xE5, 0x51, 0x97, 0x60, 0x1C, 0x27, 0x77,
      0x4B, 0x9D, 0x7B, 0x18, 0xC9, 0x4D, 0x5A, 0x05, 0x95, 0x11, 0xA1, 0x02, 0x50, 0xB9, 0x31, 0x68 },
      205 /* Bin Number */
  },
  {
    /* CA______ */
    { 0xD6, 0xF0, 0x34, 0xBD, 0x94, 0xAA, 0x23, 0x3F, 0x02, 0x97, 0xEC, 0xA4, 0x24, 0x5B, 0x28, 0x39,
      0x73, 0xE4, 0x47, 0xAA, 0x59, 0x0F, 0x31, 0x0C, 0x77, 0xF4, 0x8F, 0xDF, 0x83, 0x11, 0x22, 0x54 },
      153 /* Bin Number */
  },
  {
    /* AAA_Certificate_Services */
    { 0xD7, 0xA7, 0xA0, 0xFB, 0x5D, 0x7E, 0x27, 0x31, 0xD7, 0x71, 0xE9, 0x48, 0x4E, 0xBC, 0xDE, 0xF7,
      0x1D, 0x5F, 0x0C, 0x3E, 0x0A, 0x29, 0x48, 0x78, 0x2B, 0xC8, 0x3E, 0xE0, 0xEA, 0x69, 0x9E, 0xF4 },
      28 /* Bin Number */
  },
  {
    /* Certum_CA */
    { 0xD8, 0xE0, 0xFE, 0xBC, 0x1D, 0xB2, 0xE3, 0x8D, 0x00, 0x94, 0x0F, 0x37, 0xD2, 0x7D, 0x41, 0x34,
      0x4D, 0x99, 0x3E, 0x73, 0x4B, 0x99, 0xD5, 0x65, 0x6D, 0x97, 0x78, 0xD4, 0xD8, 0x14, 0x36, 0x24 },
      27 /* Bin Number */
  },
  {
    /* GTS_Root_R1 */
    { 0xD9, 0x47, 0x43, 0x2A, 0xBD, 0xE7, 0xB7, 0xFA, 0x90, 0xFC, 0x2E, 0x6B, 0x59, 0x10, 0x1B, 0x12,
      0x80, 0xE0, 0xE1, 0xC7, 0xE4, 0xE4, 0x0F, 0xA3, 0xC6, 0x88, 0x7F, 0xFF, 0x57, 0xA7, 0xF4, 0xCF },
      236 /* Bin Number */
  },
  {
    /* HARICA_TLS_RSA_Root_CA_2021 */
    { 0xD9, 0x5D, 0x0E, 0x8E, 0xDA, 0x79, 0x52, 0x5B, 0xF9, 0xBE, 0xB1, 0x1B, 0x14, 0xD2, 0x10, 0x0D,
      0x32, 0x94, 0x98, 0x5F, 0x0C, 0x62, 0xD9, 0xFA, 0xBD, 0x9C, 0xD9, 0x99, 0xEC, 0xCB, 0x7B, 0x1D },
      228 /* Bin Number */
  },
  {
    /* Swisscom_Root_EV_CA_2 */
    { 0xD9, 0x5F, 0xEA, 0x3C, 0xA4, 0xEE, 0xDC, 0xE7, 0x4C, 0xD7, 0x6E, 0x75, 0xFC, 0x6D, 0x1F, 0xF6,
      0x2C, 0x44, 0x1F, 0x0F, 0xA8, 0xBC, 0x77, 0xF0, 0x34, 0xB1, 0x9E, 0x5D, 0xB2, 0x58, 0x01, 0x5D },
      135 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority___G4 */
    { 0xDB, 0x35, 0x17, 0xD1, 0xF6, 0x73, 0x2A, 0x2D, 0x5A, 0xB9, 0x7C, 0x53, 0x3E, 0xC7, 0x07, 0x79,
      0xEE, 0x32, 0x70, 0xA6, 0x2F, 0xB4, 0xAC, 0x42, 0x38, 0x37, 0x24, 0x60, 0xE6, 0xF0, 0x1E, 0x88 },
      211 /* Bin Number */
  },
  {
    /* TeliaSonera_Root_CA_v1 */
    { 0xDD, 0x69, 0x36, 0xFE, 0x21, 0xF8, 0xF0, 0x77, 0xC1, 0x23, 0xA1, 0xA5, 0x21, 0xC1, 0x22, 0x24,
      0xF7, 0x22, 0x55, 0xB7, 0x3E, 0x03, 0xA7, 0x26, 0x06, 0x93, 0xE8, 0xA2, 0x4B, 0x0F, 0xA3, 0x89 },
      140 /* Bin Number */
  },
  {
    /* StartCom_Certification_Authority */
    { 0xE1, 0x78, 0x90, 0xEE, 0x09, 0xA3, 0xFB, 0xF4, 0xF4, 0x8B, 0x9C, 0x41, 0x4A, 0x17, 0xD6, 0x37,
      0xB7, 0xA5, 0x06, 0x47, 0xE9, 0xBC, 0x75, 0x23, 0x22, 0x72, 0x7F, 0xCC, 0x17, 0x42, 0xA9, 0x11 },
      123 /* Bin Number */
  },
  {
    /* CA_Disig_Root_R2 */
    { 0xE2, 0x3D, 0x4A, 0x03, 0x6D, 0x7B, 0x70, 0xE9, 0xF5, 0x95, 0xB1, 0x42, 0x20, 0x79, 0xD2, 0xB9,
      0x1E, 0xDF, 0xBB, 0x1F, 0xB6, 0x51, 0xA0, 0x63, 0x3E, 0xAA, 0x8A, 0x9D, 0xC5, 0xF8, 0x07, 0x03 },
      137 /* Bin Number */
  },
  {
    /* CNNIC_ROOT */
    { 0xE2, 0x83, 0x93, 0x77, 0x3D, 0xA8, 0x45, 0xA6, 0x79, 0xF2, 0x08, 0x0C, 0xC7, 0xFB, 0x44, 0xA3,
      0xB7, 0xA1, 0xC3, 0x79, 0x2C, 0xB7, 0xEB, 0x77, 0x29, 0xFD, 0xCB, 0x6A, 0x8D, 0x99, 0xAE, 0xA7 },
      84 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_4 */
    { 0xE3, 0x5D, 0x28, 0x41, 0x9E, 0xD0, 0x20, 0x25, 0xCF, 0xA6, 0x90, 0x38, 0xCD, 0x62, 0x39, 0x62,
      0x45, 0x8D, 0xA5, 0xC6, 0x95, 0xFB, 0xDE, 0xA3, 0xC2, 0x2B, 0x0B, 0xFB, 0x25, 0x89, 0x70, 0x92 },
      186 /* Bin Number */
  },
  {
    /* VeriSign_Class_4_Public_Primary_Certification_Authority___G3 */
    { 0xE3, 0x89, 0x36, 0x0D, 0x0F, 0xDB, 0xAE, 0xB3, 0xD2, 0x50, 0x58, 0x4B, 0x47, 0x30, 0x31, 0x4E,
      0x22, 0x2F, 0x39, 0xC1, 0x56, 0xA0, 0x20, 0x14, 0x4E, 0x8D, 0x96, 0x05, 0x61, 0x79, 0x15, 0x06 },
      9 /* Bin Number */
  },
  {
    /* Certigna */
    { 0xE3, 0xB6, 0xA2, 0xDB, 0x2E, 0xD7, 0xCE, 0x48, 0x84, 0x2F, 0x7A, 0xC5, 0x32, 0x41, 0xC7, 0xB7,
      0x1D, 0x54, 0x14, 0x4B, 0xFB, 0x40, 0xC1, 0x1F, 0x3F, 0x1D, 0x0B, 0x42, 0xF5, 0xEE, 0xA1, 0x2D },
      71 /* Bin Number */
  },
  {
    /* T_B_TAK_UEKAE_K_k_Sertifika_Hizmet_Sa_lay_c_s____S_r_m_3 */
    { 0xE4, 0xC7, 0x34, 0x30, 0xD7, 0xA5, 0xB5, 0x09, 0x25, 0xDF, 0x43, 0x37, 0x0A, 0x0D, 0x21, 0x6E,
      0x9A, 0x79, 0xB9, 0xD6, 0xDB, 0x83, 0x73, 0xA0, 0xC6, 0x9E, 0xB1, 0xCC, 0x31, 0xC7, 0xC5, 0x2A },
      79 /* Bin Number */
  },
  {
    /* e_Guven_Kok_Elektronik_Sertifika_Hizmet_Saglayicisi */
    { 0xE6, 0x09, 0x07, 0x84, 0x65, 0xA4, 0x19, 0x78, 0x0C, 0xB6, 0xAC, 0x4C, 0x1C, 0x0B, 0xFB, 0x46,
      0x53, 0xD9, 0xD9, 0xCC, 0x6E, 0xB3, 0x94, 0x6E, 0xB7, 0xF3, 0xD6, 0x99, 0x97, 0xBA, 0xD5, 0x98 },
      100 /* Bin Number */
  },
  {
    /* TC_TrustCenter_Class_2_CA_II */
    { 0xE6, 0xB8, 0xF8, 0x76, 0x64, 0x85, 0xF8, 0x07, 0xAE, 0x7F, 0x8D, 0xAC, 0x16, 0x70, 0x46, 0x1F,
      0x07, 0xC0, 0xA1, 0x3E, 0xEF, 0x3A, 0x1F, 0xF7, 0x17, 0x53, 0x8D, 0x7A, 0xBA, 0xD3, 0x91, 0xB4 },
      72 /* Bin Number */
  },
  {
    /* OU_Security_Communication_RootCA1_O_SECOM_Trust_net_C_JP */
    { 0xE7, 0x5E, 0x72, 0xED, 0x9F, 0x56, 0x0E, 0xEC, 0x6E, 0xB4, 0x80, 0x00, 0x73, 0xA4, 0x3F, 0xC3,
      0xAD, 0x19, 0x19, 0x5A, 0x39, 0x22, 0x82, 0x01, 0x78, 0x95, 0x97, 0x4A, 0x99, 0x02, 0x6B, 0x6C },
      34 /* Bin Number */
  },
  {
    /* USERTrust_RSA_Certification_Authority */
    { 0xE7, 0x93, 0xC9, 0xB0, 0x2F, 0xD8, 0xAA, 0x13, 0xE2, 0x1C, 0x31, 0x22, 0x8A, 0xCC, 0xB0, 0x81,
      0x19, 0x64, 0x3B, 0x74, 0x9C, 0x89, 0x89, 0x64, 0xB1, 0x74, 0x6D, 0x46, 0xC3, 0xD4, 0xCB, 0xD2 },
      155 /* Bin Number */
  },
  {
    /* OU_certSIGN_ROOT_CA_O_certSIGN_C_RO */
    { 0xEA, 0xA9, 0x62, 0xC4, 0xFA, 0x4A, 0x6B, 0xAF, 0xEB, 0xE4, 0x15, 0x19, 0x6D, 0x35, 0x1C, 0xCD,
      0x88, 0x8D, 0x4F, 0x53, 0xF3, 0xFA, 0x8A, 0xE6, 0xD7, 0xC4, 0x66, 0xA9, 0x4E, 0x60, 0x42, 0xBB },
      83 /* Bin Number */
  },
  {
    /* VeriSign_Class_3_Public_Primary_Certification_Authority___G3 */
    { 0xEB, 0x04, 0xCF, 0x5E, 0xB1, 0xF3, 0x9A, 0xFA, 0x76, 0x2F, 0x2B, 0xB1, 0x20, 0xF2, 0x96, 0xCB,
      0xA5, 0x20, 0xC1, 0xB9, 0x7D, 0xB1, 0x58, 0x95, 0x65, 0xB8, 0x1C, 0xB9, 0xA1, 0x7B, 0x72, 0x44 },
      8 /* Bin Number */
  },
  {
    /* OU_AC_RAIZ_FNMT_RCM_O_FNMT_RCM_C_ES */
    { 0xEB, 0xC5, 0x57, 0x0C, 0x29, 0x01, 0x8C, 0x4D, 0x67, 0xB1, 0xAA, 0x12, 0x7B, 0xAF, 0x12, 0xF7,
      0x03, 0xB4, 0x61, 0x1E, 0xBC, 0x17, 0xB7, 0xDA, 0xB5, 0x57, 0x38, 0x94, 0x17, 0x9B, 0x93, 0xFA },
      182 /* Bin Number */
  },
  {
    /* GlobalSign_Root_CA */
    { 0xEB, 0xD4, 0x10, 0x40, 0xE4, 0xBB, 0x3E, 0xC7, 0x42, 0xC9, 0xE3, 0x81, 0xD3, 0x1E, 0xF2, 0xA4,
      0x1A, 0x48, 0xB6, 0x68, 0x5C, 0x96, 0xE7, 0xCE, 0xF3, 0xC1, 0xDF, 0x6C, 0xD4, 0x33, 0x1C, 0x99 },
      6 /* Bin Number */
  },
  {
    /* TC_TrustCenter_Universal_CA_I */
    { 0xEB, 0xF3, 0xC0, 0x2A, 0x87, 0x89, 0xB1, 0xFB, 0x7D, 0x51, 0x19, 0x95, 0xD6, 0x63, 0xB7, 0x29,
      0x06, 0xD9, 0x13, 0xCE, 0x0D, 0x5E, 0x10, 0x56, 0x8A, 0x8A, 0x77, 0xE2, 0x58, 0x61, 0x67, 0xE7 },
      74 /* Bin Number */
  },
  {
    /* Juur_SK */
    { 0xEC, 0xC3, 0xE9, 0xC3, 0x40, 0x75, 0x03, 0xBE, 0xE0, 0x91, 0xAA, 0x95, 0x2F, 0x41, 0x34, 0x8F,
      0xF8, 0x8B, 0xAA, 0x86, 0x3B, 0x22, 0x64, 0xBE, 0xFA, 0xC8, 0x07, 0x90, 0x15, 0x74, 0xE9, 0x39 },
      95 /* Bin Number */
  },
  {
    /* Buypass_Class_3_Root_CA */
    { 0xED, 0xF7, 0xEB, 0xBC, 0xA2, 0x7A, 0x2A, 0x38, 0x4D, 0x38, 0x7B, 0x7D, 0x40, 0x10, 0xC6, 0x66,
      0xE2, 0xED, 0xB4, 0x84, 0x3E, 0x4C, 0x29, 0xB4, 0xAE, 0x1D, 0x5B, 0x93, 0x32, 0xE6, 0xB2, 0x4D },
      126 /* Bin Number */
  },
  {
    /* D_TRUST_Root_Class_3_CA_2_EV_2009 */
    { 0xEE, 0xC5, 0x49, 0x6B, 0x98, 0x8C, 0xE9, 0x86, 0x25, 0xB9, 0x34, 0x09, 0x2E, 0xEC, 0x29, 0x08,
      0xBE, 0xD0, 0xB0, 0xF3, 0x16, 0xC2, 0xD4, 0x73, 0x0C, 0x84, 0xEA, 0xF1, 0xF3, 0xD3, 0x48, 0x81 },
      131 /* Bin Number */
  },
  {
    /* Global_Chambersign_Root */
    { 0xEF, 0x3C, 0xB4, 0x17, 0xFC, 0x8E, 0xBF, 0x6F, 0x97, 0x87, 0x6C, 0x9E, 0x4E, 0xCE, 0x39, 0xDE,
      0x1E, 0xA5, 0xFE, 0x64, 0x91, 0x41, 0xD1, 0x02, 0x8B, 0x7D, 0x11, 0xC0, 0xB2, 0x29, 0x8C, 0xED },
      40 /* Bin Number */
  },
  {
    /* HiPKI_Root_CA___G1 */
    { 0xF0, 0x15, 0xCE, 0x3C, 0xC2, 0x39, 0xBF, 0xEF, 0x06, 0x4B, 0xE9, 0xF1, 0xD2, 0xC4, 0x17, 0xE1,
      0xA0, 0x26, 0x4A, 0x0A, 0x94, 0xBE, 0x1F, 0x0C, 0x8D, 0x12, 0x18, 0x64, 0xEB, 0x69, 0x49, 0xCC },
      234 /* Bin Number */
  },
  {
    /* Swisscom_Root_CA_2 */
    { 0xF0, 0x9B, 0x12, 0x2C, 0x71, 0x14, 0xF4, 0xA0, 0x9B, 0xD4, 0xEA, 0x4F, 0x4A, 0x99, 0xD5, 0x58,
      0xB4, 0x6E, 0x4C, 0x25, 0xCD, 0x81, 0x14, 0x0D, 0x29, 0xC0, 0x56, 0x13, 0x91, 0x4C, 0x38, 0x41 },
      134 /* Bin Number */
  },
  {
    /* SecureTrust_CA */
    { 0xF1, 0xC1, 0xB5, 0x0A, 0xE5, 0xA2, 0x0D, 0xD8, 0x03, 0x0E, 0xC9, 0xF6, 0xBC, 0x24, 0x82, 0x3D,
      0xD3, 0x67, 0xB5, 0x25, 0x57, 0x59, 0xB4, 0xE7, 0x1B, 0x61, 0xFC, 0xE9, 0xF7, 0x37, 0x5D, 0x73 },
      61 /* Bin Number */
  },
  {
    /* Atos_TrustedRoot_2011 */
    { 0xF3, 0x56, 0xBE, 0xA2, 0x44, 0xB7, 0xA9, 0x1E, 0xB3, 0x5D, 0x53, 0xCA, 0x9A, 0xD7, 0x86, 0x4A,
      0xCE, 0x01, 0x8E, 0x2D, 0x35, 0xD5, 0xF8, 0xF9, 0x6D, 0xDF, 0x68, 0xA6, 0xF4, 0x1A, 0xA4, 0x74 },
      143 /* Bin Number */
  },
  {
    /* CA_Disig_Root_R1 */
    { 0xF9, 0x6F, 0x23, 0xF4, 0xC3, 0xE7, 0x9C, 0x07, 0x7A, 0x46, 0x98, 0x8D, 0x5A, 0xF5, 0x90, 0x06,
      0x76, 0xA0, 0xF0, 0x39, 0xCB, 0x64, 0x5D, 0xD1, 0x75, 0x49, 0xB2, 0x16, 0xC8, 0x24, 0x40, 0xCE },
      136 /* Bin Number */
  },
  {
    /* Hongkong_Post_Root_CA_1 */
    { 0xF9, 0xE6, 0x7D, 0x33, 0x6C, 0x51, 0x00, 0x2A, 0xC0, 0x54, 0xC6, 0x32, 0x02, 0x2D, 0x66, 0xDD,
      0xA2, 0xE7, 0xE3, 0xFF, 0xF1, 0x0A, 0xD0, 0x61, 0xED, 0x31, 0xD8, 0xBB, 0xB4, 0x10, 0xCF, 0xB2 },
      96 /* Bin Number */
  },
  {
    /* ANF_Secure_Server_Root_CA */
    { 0xFB, 0x8F, 0xEC, 0x75, 0x91, 0x69, 0xB9, 0x10, 0x6B, 0x1E, 0x51, 0x16, 0x44, 0xC6, 0x18, 0xC5,
      0x13, 0x04, 0x37, 0x3F, 0x6C, 0x06, 0x43, 0x08, 0x8D, 0x8B, 0xEF, 0xFD, 0x1B, 0x99, 0x75, 0x99 },
      224 /* Bin Number */
  },
  {
    /* Certinomis___Autorit__Racine */
    { 0xFC, 0xBF, 0xE2, 0x88, 0x62, 0x06, 0xF7, 0x2B, 0x27, 0x59, 0x3C, 0x8B, 0x07, 0x02, 0x97, 0xE1,
      0x2D, 0x76, 0x9E, 0xD1, 0x0E, 0xD7, 0x93, 0x07, 0x05, 0xA8, 0x09, 0x8E, 0xFF, 0xC1, 0x4D, 0x17 },
      114 /* Bin Number */
  },
  {
    /* T_TeleSec_GlobalRoot_Class_3 */
    { 0xFD, 0x73, 0xDA, 0xD3, 0x1C, 0x64, 0x4F, 0xF1, 0xB4, 0x3B, 0xEF, 0x0C, 0xCD, 0xDA, 0x96, 0x71,
      0x0B, 0x9C, 0xD9, 0x87, 0x5E, 0xCA, 0x7E, 0x31, 0x70, 0x7A, 0xF3, 0xE9, 0x6D, 0x52, 0x2B, 0xBD },
      127 /* Bin Number */
  },
  {
    /* Certum_Trusted_Root_CA */
    { 0xFE, 0x76, 0x96, 0x57, 0x38, 0x55, 0x77, 0x3E, 0x37, 0xA9, 0x5E, 0x7A, 0xD4, 0xD9, 0xCC, 0x96,
      0xC3, 0x01, 0x57, 0xC1, 0x5D, 0x31, 0x76, 0x5B, 0xA9, 0xB1, 0x57, 0x04, 0xE1, 0xAE, 0x78, 0xFD },
      226 /* Bin Number */
  },
  {
    /* GeoTrust_Global_CA */
    { 0xFF, 0x85, 0x6A, 0x2D, 0x25, 0x1D, 0xCD, 0x88, 0xD3, 0x66, 0x56, 0xF4, 0x50, 0x12, 0x67, 0x98,
      0xCF, 0xAB, 0xAA, 0xDE, 0x40, 0x79, 0x9C, 0x72, 0x2D, 0xE4, 0xD2, 0xB5, 0xDB, 0x36, 0xA7, 0x3A },
      20 /* Bin Number */
  },
};

