//@line 38 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"

//@line 40 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
const MOZILLA_CONTENT_PACK = "chrome://help/locale/help.rdf";

//@line 44 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
var helpFileURI = MOZILLA_CONTENT_PACK;

//@line 49 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
function openHelp(topic, contentPack)
{
//@line 53 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
  helpFileURI = contentPack || helpFileURI;

//@line 56 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
  var topWindow = locateHelpWindow(helpFileURI);

  if ( topWindow ) {
//@line 60 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
    topWindow.focus();
    topWindow.displayTopic(topic);
  } else {
//@line 64 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
    const params = Components.classes["@mozilla.org/embedcomp/dialogparam;1"]
                             .createInstance(Components.interfaces.nsIDialogParamBlock);
    params.SetNumberStrings(2);
    params.SetString(0, helpFileURI);
    params.SetString(1, topic);
    const ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                         .getService(Components.interfaces.nsIWindowWatcher);
    ww.openWindow(null, "chrome://help/content/help.xul", "_blank", "chrome,all,alwaysRaised,dialog=no", params);
  }
}

//@line 76 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
function setHelpFileURI(rdfURI)
{
  helpFileURI = rdfURI;
}

//@line 82 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
function locateHelpWindow(contentPack) {
    const windowManagerInterface = Components
        .classes['@mozilla.org/appshell/window-mediator;1'].getService()
        .QueryInterface(Components.interfaces.nsIWindowMediator);
    const iterator = windowManagerInterface.getEnumerator("mozilla:help");
    var topWindow = null;
    var aWindow;

//@line 92 "/cygdrive/d/builds/tinderbox/XR-Trunk/WINNT_5.0_Depend/mozilla/toolkit/components/help/content/contextHelp.js"
    while (iterator.hasMoreElements()) {
        aWindow = iterator.getNext();
        if (aWindow.getHelpFileURI() == contentPack) {
            topWindow = aWindow;
        }
    }
    return topWindow;
}
