/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.xpcom.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.xpcom.internal.XPCOMJavaProxyBase;

public class XPCOMJavaProxy
implements InvocationHandler {
    protected long nativeXPCOMPtr;

    public XPCOMJavaProxy(long l) {
        this.nativeXPCOMPtr = l;
    }

    protected static long getNativeXPCOMInstance(Object object) {
        XPCOMJavaProxy xPCOMJavaProxy = (XPCOMJavaProxy)Proxy.getInvocationHandler(object);
        return xPCOMJavaProxy.nativeXPCOMPtr;
    }

    protected static Object createProxy(Class clazz, long l) {
        return Proxy.newProxyInstance(XPCOMJavaProxy.class.getClassLoader(), new Class[]{clazz, XPCOMJavaProxyBase.class}, (InvocationHandler)new XPCOMJavaProxy(l));
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if (string.equals("hashCode")) {
                return XPCOMJavaProxy.proxyHashCode(object);
            }
            if (string.equals("equals")) {
                return XPCOMJavaProxy.proxyEquals(object, objectArray[0]);
            }
            if (string.equals("toString")) {
                return XPCOMJavaProxy.proxyToString(object);
            }
            System.err.println("WARNING: Unhandled Object method [" + string + "]");
            return null;
        }
        if (method.getDeclaringClass() == XPCOMJavaProxyBase.class) {
            if (string.equals("finalize")) {
                this.finalizeProxy(object);
            } else {
                System.err.println("WARNING: Unhandled XPCOMJavaProxyBase method [" + string + "]");
            }
            return null;
        }
        return XPCOMJavaProxy.callXPCOMMethod(object, string, objectArray);
    }

    protected static Integer proxyHashCode(Object object) {
        return new Integer(System.identityHashCode(object));
    }

    protected static Boolean proxyEquals(Object object, Object object2) {
        return object == object2 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static boolean isXPCOMJavaProxy(Object object) {
        InvocationHandler invocationHandler;
        return Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof XPCOMJavaProxy;
    }

    protected static String proxyToString(Object object) {
        return object.getClass().getInterfaces()[0].getName() + '@' + Integer.toHexString(object.hashCode());
    }

    protected void finalizeProxy(Object object) throws Throwable {
        XPCOMJavaProxy.finalizeProxyNative(object);
        super.finalize();
    }

    protected static native void finalizeProxyNative(Object var0);

    protected static native Object callXPCOMMethod(Object var0, String var1, Object[] var2);
}

