//@line 38 "/cygdrive/c/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/toolkit/mozapps/extensions/content/list.js"

const kXULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
const kDialog = "dialog";

/**
 * Initialize the dialog from the parameters supplied via window.arguments
 * 
 * This dialog must be opened modally, the caller can inspect the user action
 * after the dialog closes by inspecting the value of the |result| parameter
 * on this object which is set to the dlgtype of the button used to close
 * the dialog.
 * 
 * window.arguments[0] is an array of strings to display
 * window.arguments[1] a JS Object with the following properties:
 * 
 * title:    A title string, to be displayed in the title bar of the dialog.
 * message1: A message string, displayed above the addon list
 * message2: A message string, displayed below the addon list
 * message3: A bolded message string, displayed below the addon list
 *           If no value is supplied for the message, it is not displayed.
 * buttons: {
 *  accept: { label: "A Label for the Accept button",
 *            focused: true },
 *  cancel: { label: "A Label for the Cancel button" },
 *  ...
 * },
 *
 * result:  The dlgtype of button that was used to dismiss the dialog. 
 */
function init() {
  // Fill the addons list
  var items = window.arguments[0];
  var addons = document.getElementById("addonsChildren");
  for (var i = 0; i < items.length; ++i) {
    var treeitem = document.createElementNS(kXULNS, "treeitem");
    var treerow  = document.createElementNS(kXULNS, "treerow");
    var treecell = document.createElementNS(kXULNS, "treecell");
    treecell.setAttribute("label", items[i]);
    treerow.appendChild(treecell);
    treeitem.appendChild(treerow);
    addons.appendChild(treeitem);
  }
  
  var de = document.documentElement;
  var params = window.arguments[1];

  // Set the messages
  var messages = ["message1", "message2", "message3"];
  for (var i = 0; i < messages.length; ++i) {
    if (messages[i] in params) {
      var message = document.getElementById(messages[i]);
      message.hidden = false;
      message.appendChild(document.createTextNode(params[messages[i]]));
    }
  }
  
  // Set the window title
  if ("title" in params)
    document.title = params.title;

  // Set up the buttons
  if ("buttons" in params) {
    var buttons = params.buttons;
    var buttonString = "";
    for (var buttonType in buttons)
      buttonString += "," + buttonType;
    dump("*** de.toSource = " + de.localName + "\n");
    de.buttons = buttonString.substr(1);
    for (buttonType in buttons) {
      var button = de.getButton(buttonType);
      button.label = buttons[buttonType].label;
      if (buttons[buttonType].focused)
        button.focus();
      document.addEventListener(kDialog + buttonType, handleButtonCommand, true);
    }
  }
}

/**
 * Watch for the user hitting one of the buttons to dismiss the dialog
 * and report the result back to the caller through the |result| property on
 * the arguments object.
 */
function handleButtonCommand(event) {
  window.arguments[1].result = event.type.substr(kDialog.length);
}
