/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIAccessible.idl
 */

package org.mozilla.xpcom;

/**
 * A cross-platform interface that supports platform-specific 
 * accessibility APIs like MSAA and ATK. Contains the sum of what's needed
 * to support IAccessible as well as ATK's generic accessibility objects.
 * Can also be used by in-process accessibility clients to get information
 * about objects in the accessible tree. The accessible tree is a subset of 
 * nodes in the DOM tree -- such as documents, focusable elements and text.
 * Mozilla creates the implementations of nsIAccessible on demand.
 * See http://www.mozilla.org/projects/ui/accessibility for more information.
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessible extends nsISupports {

  String NS_IACCESSIBLE_IID =
    "{1b9596e8-d7bf-4b99-b032-53a1bf9be1c3}";

  /**
   * Parent node in accessible tree.
   */
  nsIAccessible getParent();

  /**
   * Next sibling in accessible tree
   */
  nsIAccessible getNextSibling();

  /**
   * Previous sibling in accessible tree
   */
  nsIAccessible getPreviousSibling();

  /**
   * First child in accessible tree
   */
  nsIAccessible getFirstChild();

  /**
   * Last child in accessible tree
   */
  nsIAccessible getLastChild();

  /**
   * Array of all this element's children.
   */
  nsIArray getChildren();

  /**
   * Number of accessible children
   */
  int getChildCount();

  /**
   * The 0-based index of this accessible in its parent's list of children,
   * or -1 if this accessible does not have a parent.
   */
  int getIndexInParent();

  /**
   * Accessible name -- the main text equivalent for this node
   */
  String getName();

  /**
   * Accessible name -- the main text equivalent for this node
   */
  void setName(String aName);

  /**
   * Accessible value -- a number or a secondary text equivalent for this node
   * Widgets that use role attribute can force a value using the valuenow attribute
   */
  String getValue();

  /**
   * Accessible description -- long text associated with this node
   */
  String getDescription();

  /**
   * Provides localized string of accesskey name, such as Alt+D.
   * The modifier may be affected by user and platform preferences.
   * Usually alt+letter, or just the letter alone for menu items. 
   */
  String getKeyboardShortcut();

  /**
   * Provides localized string of global keyboard accelerator, such
   * as Ctrl+O for Open file
   */
  String getKeyBinding();

  /**
   * Natural enumerated accessible role for the associated element.
   * The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   * This does not take into account role attribute as the finalRole does.
   */
  long getRole();

  /**
   * Enumerated accessible role. The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   * Widgets can use role attribute to force the final role
   */
  long getFinalRole();

  /**
   * Accessible states -- bit field which describes boolean properties of node. 
   * See the STATE_* constants defined later in this file.
   * Many states are only valid given a certain role attribute that supports them
   */
  long getFinalState();

  /**
   * Extended accessible states -- second bit field describing node
   */
  long getExtState();

  /**
   * True if this element is live in an editor.
   * False if the content is being displayed but not edited. 
   */
  boolean getIsEditable();

  /**
   * Help text associated with node
   */
  String getHelp();

  /**
   * Focused accessible child of node
   */
  nsIAccessible getFocusedChild();

  /**
   * Attributes of accessible
   */
  nsIPersistentProperties getAttributes();

  /**
   * Accessible child which contains the coordinate at (x, y) in screen pixels.
   */
  nsIAccessible getChildAtPoint(int x, int y);

  /**
   * Nth accessible child using zero-based index or last child if index less than zero
   */
  nsIAccessible getChildAt(int aChildIndex);

  /**
   * Accessible node geometrically to the right of this one
   */
  nsIAccessible getAccessibleToRight();

  /**
   * Accessible node geometrically to the left of this one
   */
  nsIAccessible getAccessibleToLeft();

  /**
   * Accessible node geometrically above this one
   */
  nsIAccessible getAccessibleAbove();

  /**
   * Accessible node geometrically below this one
   */
  nsIAccessible getAccessibleBelow();

  /**
   * Accessible node related to this one 
   */
  nsIAccessible getAccessibleRelated(long aRelationType);

  void getBounds(int[] x, int[] y, int[] width, int[] height);

  /**
   * Add or remove this accessible to the current selection
   */
  void setSelected(boolean isSelected);

  /**
   * Extend the current selection from its current accessible anchor node
   * to this accessible
   */
  void extendSelection();

  /**
   * Select this accessible node only
   */
  void takeSelection();

  /**
   * Focus this accessible node,
   * The state STATE_FOCUSABLE indicates whether this node is normally focusable.
   * It is the callers responsibility to determine whether this node is focusable.
   * accTakeFocus on a node that is not normally focusable (such as a table),
   * will still set focus on that node, although normally that will not be visually 
   * indicated in most style sheets.
   */
  void takeFocus();

  /**
   * The number of accessible actions associated with this accessible
   */
  short getNumActions();

  /**
   * The name of the accessible action at the given zero-based index
   */
  String getActionName(short index);

  /**
   * Perform the accessible action at the given zero-based index
   * Action number 0 is the default action
   */
  void doAction(short index);

  /**
   * MSAA State flags - used for bitfield. More than 1 allowed.
   */
  long STATE_UNAVAILABLE = 1L;

  long STATE_SELECTED = 2L;

  long STATE_FOCUSED = 4L;

  long STATE_PRESSED = 8L;

  long STATE_CHECKED = 16L;

  long STATE_MIXED = 32L;

  long STATE_READONLY = 64L;

  long STATE_HOTTRACKED = 128L;

  long STATE_DEFAULT = 256L;

  long STATE_EXPANDED = 512L;

  long STATE_COLLAPSED = 1024L;

  long STATE_BUSY = 2048L;

  long STATE_FLOATING = 4096L;

  long STATE_MARQUEED = 8192L;

  long STATE_ANIMATED = 16384L;

  long STATE_INVISIBLE = 32768L;

  long STATE_OFFSCREEN = 65536L;

  long STATE_SIZEABLE = 131072L;

  long STATE_MOVEABLE = 262144L;

  long STATE_SELFVOICING = 524288L;

  long STATE_FOCUSABLE = 1048576L;

  long STATE_SELECTABLE = 2097152L;

  long STATE_LINKED = 4194304L;

  long STATE_TRAVERSED = 8388608L;

  long STATE_MULTISELECTABLE = 16777216L;

  long STATE_EXTSELECTABLE = 33554432L;

  long STATE_ALERT_LOW = 67108864L;

  long STATE_ALERT_MEDIUM = 134217728L;

  long STATE_ALERT_HIGH = 268435456L;

  long STATE_PROTECTED = 536870912L;

  long STATE_HASPOPUP = 1073741824L;

  long STATE_REQUIRED = 67108864L;

  long STATE_IMPORTANT = 134217728L;

  long STATE_INVALID = 268435456L;

  long STATE_CHECKABLE = 8192L;

  /**
 * Extended state flags (for now non-MSAA, for Java and Gnome/ATK support)
 * "Extended state flags" has seperate value space from "MSAA State flags".
 */
  long EXT_STATE_DEFUNCT = 524288L;

  long EXT_STATE_SELECTABLE_TEXT = 1048576L;

  long EXT_STATE_EDITABLE = 2097152L;

  long EXT_STATE_ACTIVE = 4194304L;

  long EXT_STATE_EXPANDABLE = 8388608L;

  long EXT_STATE_MODAL = 16777216L;

  long EXT_STATE_MULTI_LINE = 33554432L;

  long EXT_STATE_SENSITIVE = 67108864L;

  long EXT_STATE_SHOWING = 268435456L;

  long EXT_STATE_SINGLE_LINE = 536870912L;

  long EXT_STATE_TRANSIENT = 1073741824L;

  long EXT_STATE_VERTICAL = 2147483648L;

  /**
 * Relation Types -- most of these come from ATK's atkrelationtype.h
 * When adding support for relations, make sure to add them to appropriate
 * places in nsAccessibleWrap implementations
 * RELATION_NULL:
 * RELATION_CONTROLLED_BY:    Controlled by one or more target objects.
 * RELATION_CONTROLLER_FOR:   Controller for one or more target objects.
 * RELATION_LABEL_FOR:        Label for one or more target objects.
 * RELATION_LABELLED_BY:      Labelled by one or more target objects.
 * RELATION_MEMBER_OF:        Member of a group of one or more target objects.
 * RELATION_NODE_CHILD_OF:    Cell in a treetable which is displayed because a
 *                            cell in the same col is expanded & identifies it.
 * RELATION_FLOWS_TO:         Has content that flows logically to another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_FLOWS_FROM:       Has content that flows logically from another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_SUBWINDOW_OF:     Subwindow attached to a component but otherwise 
 *                            not connected in the UI hierarchy to that component.
 * RELATION_EMBEDS:           Visually embeds another object's content, i.e.
 *                            this object's content flows around another's content.
 * RELATION_EMBEDDED_BY:      Inverse of RELATION_EMBEDS; this object's content
 *                            is visually embedded in another object.
 * RELATION_POPUP_FOR:        Popup for another object.
 * RELATION_PARENT_WINDOW_OF: Parent window of another object.
 * RELATION_DEFAULT_BUTTON:   Part of a form/dialog with a related default button.
 * RELATION_DESCRIBED_BY:     Described by one or more target objects.
 * RELATION_DESCRIPTION_FOR:  Description for one or more target objects.
 */
  long RELATION_NUL = 0L;

  long RELATION_CONTROLLED_BY = 1L;

  long RELATION_CONTROLLER_FOR = 2L;

  long RELATION_LABEL_FOR = 3L;

  long RELATION_LABELLED_BY = 4L;

  long RELATION_MEMBER_OF = 5L;

  long RELATION_NODE_CHILD_OF = 6L;

  long RELATION_FLOWS_TO = 7L;

  long RELATION_FLOWS_FROM = 8L;

  long RELATION_SUBWINDOW_OF = 9L;

  long RELATION_EMBEDS = 10L;

  long RELATION_EMBEDDED_BY = 11L;

  long RELATION_POPUP_FOR = 12L;

  long RELATION_PARENT_WINDOW_OF = 13L;

  long RELATION_DESCRIBED_BY = 14L;

  long RELATION_DESCRIPTION_FOR = 15L;

  long RELATION_DEFAULT_BUTTON = 16384L;

  long ROLE_NOTHING = 0L;

  long ROLE_TITLEBAR = 1L;

  long ROLE_MENUBAR = 2L;

  long ROLE_SCROLLBAR = 3L;

  long ROLE_GRIP = 4L;

  long ROLE_SOUND = 5L;

  long ROLE_CURSOR = 6L;

  long ROLE_CARET = 7L;

  long ROLE_ALERT = 8L;

  long ROLE_WINDOW = 9L;

  long ROLE_CLIENT = 10L;

  long ROLE_MENUPOPUP = 11L;

  long ROLE_MENUITEM = 12L;

  long ROLE_TOOLTIP = 13L;

  long ROLE_APPLICATION = 14L;

  long ROLE_DOCUMENT = 15L;

  long ROLE_PANE = 16L;

  long ROLE_CHART = 17L;

  long ROLE_DIALOG = 18L;

  long ROLE_BORDER = 19L;

  long ROLE_GROUPING = 20L;

  long ROLE_SEPARATOR = 21L;

  long ROLE_TOOLBAR = 22L;

  long ROLE_STATUSBAR = 23L;

  long ROLE_TABLE = 24L;

  long ROLE_COLUMNHEADER = 25L;

  long ROLE_ROWHEADER = 26L;

  long ROLE_COLUMN = 27L;

  long ROLE_ROW = 28L;

  long ROLE_CELL = 29L;

  long ROLE_LINK = 30L;

  long ROLE_HELPBALLOON = 31L;

  long ROLE_CHARACTER = 32L;

  long ROLE_LIST = 33L;

  long ROLE_LISTITEM = 34L;

  long ROLE_OUTLINE = 35L;

  long ROLE_OUTLINEITEM = 36L;

  long ROLE_PAGETAB = 37L;

  long ROLE_PROPERTYPAGE = 38L;

  long ROLE_INDICATOR = 39L;

  long ROLE_GRAPHIC = 40L;

  long ROLE_STATICTEXT = 41L;

  long ROLE_TEXT_LEAF = 42L;

  long ROLE_PUSHBUTTON = 43L;

  long ROLE_CHECKBUTTON = 44L;

  long ROLE_RADIOBUTTON = 45L;

  long ROLE_COMBOBOX = 46L;

  long ROLE_DROPLIST = 47L;

  long ROLE_PROGRESSBAR = 48L;

  long ROLE_DIAL = 49L;

  long ROLE_HOTKEYFIELD = 50L;

  long ROLE_SLIDER = 51L;

  long ROLE_SPINBUTTON = 52L;

  long ROLE_DIAGRAM = 53L;

  long ROLE_ANIMATION = 54L;

  long ROLE_EQUATION = 55L;

  long ROLE_BUTTONDROPDOWN = 56L;

  long ROLE_BUTTONMENU = 57L;

  long ROLE_BUTTONDROPDOWNGRID = 58L;

  long ROLE_WHITESPACE = 59L;

  long ROLE_PAGETABLIST = 60L;

  long ROLE_CLOCK = 61L;

  long ROLE_SPLITBUTTON = 62L;

  long ROLE_IPADDRESS = 63L;

  long ROLE_ACCEL_LABEL = 64L;

  long ROLE_ARROW = 65L;

  long ROLE_CANVAS = 66L;

  long ROLE_CHECK_MENU_ITEM = 67L;

  long ROLE_COLOR_CHOOSER = 68L;

  long ROLE_DATE_EDITOR = 69L;

  long ROLE_DESKTOP_ICON = 70L;

  long ROLE_DESKTOP_FRAME = 71L;

  long ROLE_DIRECTORY_PANE = 72L;

  long ROLE_FILE_CHOOSER = 73L;

  long ROLE_FONT_CHOOSER = 74L;

  long ROLE_CHROME_WINDOW = 75L;

  long ROLE_GLASS_PANE = 76L;

  long ROLE_HTML_CONTAINER = 77L;

  long ROLE_ICON = 78L;

  long ROLE_LABEL = 79L;

  long ROLE_LAYERED_PANE = 80L;

  long ROLE_OPTION_PANE = 81L;

  long ROLE_PASSWORD_TEXT = 82L;

  long ROLE_POPUP_MENU = 83L;

  long ROLE_RADIO_MENU_ITEM = 84L;

  long ROLE_ROOT_PANE = 85L;

  long ROLE_SCROLL_PANE = 86L;

  long ROLE_SPLIT_PANE = 87L;

  long ROLE_TABLE_COLUMN_HEADER = 88L;

  long ROLE_TABLE_ROW_HEADER = 89L;

  long ROLE_TEAR_OFF_MENU_ITEM = 90L;

  long ROLE_TERMINAL = 91L;

  long ROLE_TEXT_CONTAINER = 92L;

  long ROLE_TOGGLE_BUTTON = 93L;

  long ROLE_TREE_TABLE = 94L;

  long ROLE_VIEWPORT = 95L;

  long ROLE_HEADER = 96L;

  long ROLE_FOOTER = 97L;

  long ROLE_PARAGRAPH = 98L;

  long ROLE_RULER = 99L;

  long ROLE_AUTOCOMPLETE = 100L;

  long ROLE_EDITBAR = 101L;

  long ROLE_ENTRY = 102L;

  long ROLE_CAPTION = 103L;

  long ROLE_DOCUMENT_FRAME = 104L;

  long ROLE_HEADING = 105L;

  long ROLE_PAGE = 106L;

  long ROLE_SECTION = 107L;

  long ROLE_REDUNDANT_OBJECT = 108L;

  long ROLE_FORM = 109L;

  long ROLE_IME = 110L;

  long ROLE_APP_ROOT = 111L;

  long ROLE_PARENT_MENUITEM = 112L;

  long ROLE_LAST_ENTRY = 113L;

  long NAVRELATION_CONTROLLED_BY = 4096L;

  long NAVRELATION_CONTROLLER_FOR = 4097L;

  long NAVRELATION_LABEL_FOR = 4098L;

  long NAVRELATION_LABELLED_BY = 4099L;

  long NAVRELATION_MEMBER_OF = 4100L;

  long NAVRELATION_NODE_CHILD_OF = 4101L;

  long NAVRELATION_FLOWS_TO = 4102L;

  long NAVRELATION_FLOWS_FROM = 4103L;

  long NAVRELATION_SUBWINDOW_OF = 4104L;

  long NAVRELATION_EMBEDS = 4105L;

  long NAVRELATION_EMBEDDED_BY = 4106L;

  long NAVRELATION_POPUP_FOR = 4107L;

  long NAVRELATION_PARENT_WINDOW_OF = 4108L;

  long NAVRELATION_DEFAULT_BUTTON = 4109L;

  long NAVRELATION_DESCRIBED_BY = 4110L;

  long NAVRELATION_DESCRIPTION_FOR = 4111L;

}