/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/accessible/public/nsIAccessibleRetrieval.idl
 */

package org.mozilla.xpcom;

/**
 * An interface for in-process accessibility clients
 * wishing to get an nsIAccessible or nsIAccessNode for
 * a given DOM node.
 * More documentation at:
 *   http://www.mozilla.org/projects/ui/accessibility
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessibleRetrieval extends nsISupports {

  String NS_IACCESSIBLERETRIEVAL_IID =
    "{663ca4a8-d219-4000-925d-d8f66406b626}";

  /**
   * Return an nsIAccessible for a DOM node in pres shell 0.
   * Create a new accessible of the appropriate type if necessary,
   * or use one from the accessibility cache if it already exists.
   * @param aNode The DOM node to get an accessible for.
   * @return The nsIAccessible for the given DOM node.
   */
  nsIAccessible getAccessibleFor(nsIDOMNode aNode);

  /**
   * Return an nsIAccessible for a DOM node in pres shell for this DOM window.
   * Create a new accessible of the appropriate type if necessary,
   * or use one from the accessibility cache if it already exists.
   * @param aNode   The DOM node to get an accessible for.
   * @param aDOMWin The DOM window containing the node.
   * @return The nsIAccessible for the given DOM node.
   */
  nsIAccessible getAccessibleInWindow(nsIDOMNode aNode, nsIDOMWindow aDOMWin);

  /**
   * Return an nsIAccessible for a DOM node in the given weak shell.
   * Create a new accessible of the appropriate type if necessary,
   * or use one from the accessibility cache if it already exists.
   * @param aNode      The DOM node to get an accessible for.
   * @param aPresShell The presentation shell which contains layout info for the DOM node.
   * @return The nsIAccessible for the given DOM node.
   */
  nsIAccessible getAccessibleInWeakShell(nsIDOMNode aNode, nsISupports aPresShell);

  /**
   * Return an nsIAccessible for a DOM node in the given pres shell.
   * Create a new accessible of the appropriate type if necessary,
   * or use one from the accessibility cache if it already exists.
   * @param aNode      The DOM node to get an accessible for.
   * @param aPresShell The presentation shell which contains layout info for the DOM node.
   * @return The nsIAccessible for the given DOM node.
   */
  nsIAccessible getAccessibleInShell(nsIDOMNode aNode, nsISupports aPresShell);

  /**
    * Return an nsIAccessNode for an already created DOM node in the given weak shell.
    * Does not create a new one -- only returns cached access nodes.
    * @param aNode      The DOM node to get an access node for.
    * @param aPresShell The presentation shell which contains layout info for the DOM node.
    * @return The nsIAccessNode for the given DOM node or null if
    *         an access node does not already exist for this DOM node.
    */
  nsIAccessNode getCachedAccessNode(nsIDOMNode aNode, nsISupports aShell);

  /**
    * Return an nsIAccessible for an already created DOM node in the given weak shell.
    * Does not create a new one -- only returns cached accessibles.
    * @param aNode      The DOM node to get an accessible for.
    * @param aPresShell The presentation shell which contains layout info for the DOM node.
    * @return The nsIAccessible for the given DOM node or null if
    *         an accessible does not already exist for this DOM node.
    */
  nsIAccessible getCachedAccessible(nsIDOMNode aNode, nsISupports aShell);

}