/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsINavBookmarksService.idl
 */

package org.mozilla.xpcom;

/**
 * Observer for bookmark changes.
 */
public interface nsINavBookmarkObserver extends nsISupports {

  String NS_INAVBOOKMARKOBSERVER_IID =
    "{224f8162-4da8-45eb-8187-a8ba3a3db8e5}";

  /**
   * Notify this observer that a batch transaction has started.
   * Other notifications will be sent during the batch change,
   * but the observer is guaranteed that onEndUpdateBatch() will be called
   * at the completion of changes.
   */
  void onBeginUpdateBatch();

  /**
   * Notify this observer that a batch transaction has ended.
   */
  void onEndUpdateBatch();

  /**
   * Notify this observer that the bookmark was added.  Called after the actual
   * add took place. The rest of the bookmarks will be shifted down, but no
   * additional notifications will be sent.
   *
   * @param bookmark   The bookmark item that was added.
   * @param folder     The folder that the item was added to.
   * @param index      The item's index in the folder.
   */
  void onItemAdded(nsIURI bookmark, long folder, int index);

  /**
   * Notify this observer that the bookmark was removed.  Called after the
   * actual remove took place. The bookmarks following the index will be
   * shifted up, but no additional notifications will be sent.
   *
   * @param bookmark   The bookmark item will be removed.
   * @param folder     The folder that the item was removed from.
   * @param index      The bookmark's index in the folder.
   */
  void onItemRemoved(nsIURI bookmark, long folder, int index);

  /**
   * Notify this observer that a bookmark's information has changed.  This
   * will be called whenever any attributes like "title" are changed.
   *
   * @param bookmark The bookmark which changed.
   * @param property The property which changed.
   *
   * property = "cleartime" (history was deleted, there is no last visit date):
   *                        value = none
   * property = "title": value = new title
   * property = "favicon": value = new "moz-anno" URL of favicon image
   */
  void onItemChanged(nsIURI bookmark, String property, String value);

  /**
   * Notify that the item was visited. Normally in bookmarks we use the last
   * visit date, and normally the time will be a new visit that will be more
   * recent, but this is not guaranteed. You should check to see if it's
   * actually more recent before using this new time.
   *
   * @see onItemChanged properth = "cleartime" for when all visit dates are
   * deleted for the URI.
   */
  void onItemVisited(nsIURI bookmark, long aVisitID, double time);

  /**
   * Notify this observer that a bookmark has been replaced.
   *
   * @param folder   The folder in which the bookmark was replaced
   * @param item     The item which was replaced
   * @param newItem  The new item which replaced item
   */
  void onItemReplaced(long folder, nsIURI item, nsIURI newItem);

  /**
   * Notify this observer that a bookmark folder has been added.
   *  @param folder     The id of the folder that was added.
   *  @param parent     The id of the folder's parent.
   *  @param index      The folder's index inside its parent.
   */
  void onFolderAdded(long folder, long parent, int index);

  /**
   * Notify this observer that a bookmark folder has been removed.
   *  @param folder     The id of the folder that was removed.
   *  @param parent     The id of the folder's old parent.
   *  @param index      The folder's old index in its parent.
   */
  void onFolderRemoved(long folder, long parent, int index);

  /**
   * Notify this observer that a bookmark folder has been moved.
   *  @param folder     The id of the folder that was moved.
   *  @param oldParent  The id of the folder's old parent.
   *  @param oldIndex   The folder's old index inside oldParent.
   *  @param newParent  The id of the folder's new parent.
   *  @param newIndex   The folder's index inside newParent.
   */
  void onFolderMoved(long folder, long oldParent, int oldIndex, long newParent, int newIndex);

  /**
   * Notify this observer that a bookmark folder's information has changed.
   * This will be called whenever any attributes like "title" are changed.
   *  @param folder     The id of the folder that was changed.
   *  @param property   The property that was changed.
   */
  void onFolderChanged(long folder, String property);

  /**
   * Notify this observer that a separator has been added.
   *  @param parent     The id of the separator's parent.
   *  @param index      The separator's index inside its parent.
   */
  void onSeparatorAdded(long parent, int index);

  /**
   * Notify this observer that a separator has been removed.
   *  @param parent     The id of the separator's parent.
   *  @param index      The separator's old index in its parent.
   */
  void onSeparatorRemoved(long parent, int index);

}