/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsINavHistoryService.idl
 */

package org.mozilla.xpcom;

/**
 * A predefined view adaptor for interfacing results with an nsITree. This
 * object will remove itself from its associated result when the tree has been
 * detached. This prevents circular references. Users should be aware of this,
 * if you want to re-use the same viewer, you will need to keep your own
 * reference to it and re-initialize it when the tree changes. If you use this
 * object, attach it to a result, never attach it to a tree, and forget about
 * it, it will leak!
 */
public interface nsINavHistoryResultTreeViewer extends nsINavHistoryResultViewer {

  String NS_INAVHISTORYRESULTTREEVIEWER_IID =
    "{ecd6ad22-8eb0-4824-8a57-5edad9a08ae6}";

  /**
   * Controls whether duplicate adjacent elements are collapsed into a single
   * item in the tree. This prevents you from seeing multiple entries for
   * things when you have selected to get visits. When you sort by date, the
   * multiple entries will then appear because they will be separated (unless
   * you clicked reload a bunch of times in a row). If you know you'll only
   * ever want one entry per site, you should ask for URIs back instead of
   * visits so it will be more efficient.
   * Default = true
   *
   * Changing this value is somewhat heavyweight since it will force a tree
   * refresh.
   */
  boolean getCollapseDuplicates();

  /**
   * Controls whether duplicate adjacent elements are collapsed into a single
   * item in the tree. This prevents you from seeing multiple entries for
   * things when you have selected to get visits. When you sort by date, the
   * multiple entries will then appear because they will be separated (unless
   * you clicked reload a bunch of times in a row). If you know you'll only
   * ever want one entry per site, you should ask for URIs back instead of
   * visits so it will be more efficient.
   * Default = true
   *
   * Changing this value is somewhat heavyweight since it will force a tree
   * refresh.
   */
  void setCollapseDuplicates(boolean aCollapseDuplicates);

  /**
   * This tells you how many items are in the flattened list of results, i.e.
   * how many rows are in this tree right now. The tree adaptor will also
   * QI to nsITreeView, and this will be the same as nsITreeView.rowCount.
   * This is only valid when a tree is attached, the result will be 0 otherwise.
   */
  long getFlatItemCount();

  /**
   * This allows you to get at the real node for a given row index. This is
   * only valid when a tree is attached.
   */
  nsINavHistoryResultNode nodeForTreeIndex(long aIndex);

  /**
   * Reverse of nodeForFlatIndex, returns the row index for a given result node.
   * Returns INDEX_INVISIBLE if the item is not visible (for example, its
   * parent is collapsed). This is only valid when a tree is attached. The
   * the result will always be INDEX_INVISIBLE if not.
   * 
   * Note: This sounds sort of obvious, but it got me: aNode must be a node
   *       retrieved from the same result that this viewer is for. If you 
   *       execute another query and get a node from a _different_ result, this 
   *       function will always return the index of that node in the tree that
   *       is attached to that result.
   */
  long INDEX_INVISIBLE = 4294967295L;

  long treeIndexForNode(nsINavHistoryResultNode aNode);

}