/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIScriptLoader.idl
 */

package org.mozilla.xpcom;

public interface nsIScriptLoader extends nsISupports {

  String NS_ISCRIPTLOADER_IID =
    "{339a4eb5-dac6-4034-8c43-f4f8c645ce57}";

  /**
   * Initialize loader with a document. The container of this document
   * will be used for getting script evaluation information, including
   * the context in which to do the evaluation. The loader maintains a 
   * strong reference to the document.
   *
   * @param aDocument The document to use as the basis for script
   *        processing.
   */
  void init(nsISupports aDocument);

  /**
   * The loader maintains a strong reference to the document with
   * which it is initialized. This call forces the reference to
   * be dropped.
   */
  void dropDocumentReference();

  /**
   * Add an observer for all scripts loaded through this loader.
   *
   * @param aObserver observer for all script processing.
   */
  void addObserver(nsIScriptLoaderObserver aObserver);

  /**
   * Remove an observer.
   *
   * @param aObserver observer to be removed
   */
  void removeObserver(nsIScriptLoaderObserver aObserver);

  /**
   * Process a script element. This will include both loading the 
   * source of the element if it is not inline and evaluating
   * the script itself.
   *
   * @param aElement The element representing the script to be loaded and
   *        evaluated.
   * @param aObserver An observer for this script load only
   *
   */
  void processScriptElement(nsISupports aElement, nsIScriptLoaderObserver aObserver);

  /**
   * Gets the currently executing script. This is useful if you want to
   * generate a unique key based on the currently executing script.
   */
  nsISupports getCurrentScript();

  /**
   * Whether the loader is enabled or not.
   * When disabled, processing of new script elements is disabled. 
   * Any call to processScriptElement() will fail with a return code of
   * NS_ERROR_NOT_AVAILABLE. Note that this DOES NOT disable
   * currently loading or executing scripts.
   */
  boolean getEnabled();

  /**
   * Whether the loader is enabled or not.
   * When disabled, processing of new script elements is disabled. 
   * Any call to processScriptElement() will fail with a return code of
   * NS_ERROR_NOT_AVAILABLE. Note that this DOES NOT disable
   * currently loading or executing scripts.
   */
  void setEnabled(boolean aEnabled);

}