/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsISHistoryInternal.idl
 */

package org.mozilla.xpcom;

public interface nsISHistoryInternal extends nsISupports {

  String NS_ISHISTORYINTERNAL_IID =
    "{494fac3c-64f4-41b8-b209-b4ada899613b}";

  /**
   * Add a new Entry to the History List
   * @param aEntry - The entry to add
   * @param aPersist - If true this specifies that the entry should persist
   * in the list.  If false, this means that when new entries are added
   * this element will not appear in the session history list.
   */
  void addEntry(nsISHEntry aEntry, boolean aPersist);

  /**
   * Get the root transaction
   */
  nsISHTransaction getRootTransaction();

  /**
   * The toplevel docshell object to which this SHistory object belongs to.
   */
  nsIDocShell getRootDocShell();

  /**
   * The toplevel docshell object to which this SHistory object belongs to.
   */
  void setRootDocShell(nsIDocShell aRootDocShell);

  /** 
   * Update the index maintained by sessionHistory
   */
  void updateIndex();

  /**
   * Replace the nsISHEntry at a particular index
   * @param aIndex - The index at which the entry shoud be replaced
   * @param aReplaceEntry - The replacement entry for the index.
   */
  void replaceEntry(int aIndex, nsISHEntry aReplaceEntry);

  /** 
   * Get handle to the history listener
   */
  nsISHistoryListener getListener();

  /**
   * Evict content viewers until the number of content viewers per tab
   * is no more than gHistoryMaxViewers.  Also, count
   * total number of content viewers globally and evict one if we are over
   * our total max.  This is always called in Show(), after we destroy
   * the previous viewer.
   */
  void evictContentViewers(int previousIndex, int index);

  /**
    * Max number of total cached content viewers.  If the pref
    * browser.sessionhistory.max_total_viewers is negative, then
    * this value is calculated based on the total amount of memory.
    * Otherwise, it comes straight from the pref.
    */
  int getHistoryMaxTotalViewers();

}