/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIBinaryInputStream.idl
 */

package org.mozilla.xpcom;

/**
 * This interface allows consumption of primitive data types from a "binary
 * stream" containing untagged, big-endian binary data, i.e. as produced by an
 * implementation of nsIBinaryOutputStream.  This might be used, for example,
 * to implement network protocols or to read from architecture-neutral disk
 * files, i.e. ones that can be read and written by both big-endian and
 * little-endian platforms.
 *
 * @See nsIBinaryOutputStream
 */
public interface nsIBinaryInputStream extends nsIInputStream {

  String NS_IBINARYINPUTSTREAM_IID =
    "{7b456cb0-8772-11d3-90cf-0040056a906e}";

  void setInputStream(nsIInputStream aInputStream);

  boolean readBoolean();

  short read8();

  int read16();

  long read32();

  double read64();

  float readFloat();

  double readDouble();

  /**
     * Read a NUL-terminated 8-bit char* string from a binary stream.
     */
  String readCString();

  /**
     * Read a NUL-terminated 16-bit PRUnichar* string from a binary stream.
     */
  String readString();

  /**
     * Read an opaque byte array from a binary stream.
     */
  String readBytes(long aLength);

  /**
     * Read an opaque byte array from a binary stream, storing the results
     * as an array of PRUint8s.
     */
  short[] readByteArray(long aLength);

}