/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIAppStartup.idl
 */

package org.mozilla.xpcom;

public interface nsIAppStartup extends nsISupports {

  String NS_IAPPSTARTUP_IID =
    "{e9b0f89b-0529-4d96-98a8-eb5b2b9a8383}";

  /**
     * Create the hidden window.
     */
  void createHiddenWindow();

  /**
     * Runs an application event loop: normally the main event pump which
     * defines the lifetime of the application.
     *
     * @returnCode NS_SUCCESS_RESTART_APP
     *             This return code indicates that the application should be
     *             restarted because quit was called with the eRestart flag.
     */
  void run();

  /**
     * During application startup (and at other times!) we may temporarily
     * encounter a situation where all application windows will be closed
     * but we don't want to take this as a signal to quit the app. Bracket
     * the code where the last window could close with these.
     * (And at application startup, on platforms that don't normally quit
     * when the last window has closed, call Enter once, but not Exit)
     */
  void enterLastWindowClosingSurvivalArea();

  void exitLastWindowClosingSurvivalArea();

  /**
     * The following flags may be passed as the aMode parameter to the quit
     * method.  One and only one of the "Quit" flags must be specified.  The
     * eRestart flag may be bit-wise combined with one of the "Quit" flags to
     * cause the application to restart after it quits.
     */
/**
     * Attempt to quit if all windows are closed.
     */
  long eConsiderQuit = 1L;

  /**
     * Try to close all windows, then quit if successful.
     */
  long eAttemptQuit = 2L;

  /**
     * Quit, damnit!
     */
  long eForceQuit = 3L;

  /**
     * Restart the application after quitting.  The application will be
     * restarted with the same profile and an empty command line.
     */
  long eRestart = 16L;

  /**
     * Exit the event loop, and shut down the app.
     *
     * @param aMode
     *        This parameter modifies how the app is shutdown, and it is
     *        constructed from the constants defined above.
     */
  void quit(long aMode);

}